/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.SQLPSParam;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sqlrunner.Main;
import sqlrunner.flatfileimport.BasicDataType;

public final class SQLPSParamEditor
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private SQLPSParam parameter;
    private JLabel labelName;
    private JComboBox cbType;
    private JTextField textFieldValue;
    static ArrayList<BasicDataType> basicTypes = new ArrayList();
    private JCheckBox jCheckBoxOutParam = null;

    public SQLPSParamEditor(SQLPSParam parameter) {
        this.parameter = parameter;
        if (basicTypes.isEmpty()) {
            basicTypes.add(BasicDataType.DOUBLE);
            basicTypes.add(BasicDataType.CHARACTER);
            basicTypes.add(BasicDataType.DATE);
        }
        this.initComponents();
        if (parameter.getBasicType() != -1) {
            this.setRecommendedType(parameter.getBasicType());
        }
    }

    public void initComponents() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.ipadx = 51;
        gridBagConstraints2.ipady = 3;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 2, 0, 1);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.ipadx = 1;
        gridBagConstraints1.ipady = 1;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.insets = new Insets(0, 2, 0, 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.labelName = new JLabel();
        if (this.parameter.getName() != null) {
            this.labelName.setText(String.valueOf(this.parameter.getIndex()) + ": " + this.parameter.getName());
        } else {
            this.labelName.setText(String.valueOf(this.parameter.getIndex()));
        }
        this.labelName.setBackground(Main.info);
        this.cbType = new JComboBox();
        for (int i = 0; i < basicTypes.size(); ++i) {
            this.cbType.addItem(basicTypes.get(i));
        }
        this.textFieldValue = new JTextField();
        this.add((Component)this.labelName, gridBagConstraints);
        this.add((Component)this.cbType, gridBagConstraints1);
        this.add((Component)this.textFieldValue, gridBagConstraints2);
        this.add((Component)this.getJCheckBoxOutParam(), gridBagConstraints3);
        this.textFieldValue.getDocument().addDocumentListener(this);
    }

    public String getParameterName() {
        return this.parameter.getName();
    }

    public int getBasicType() {
        if (this.cbType.getSelectedItem() != null) {
            return ((BasicDataType)this.cbType.getSelectedItem()).getId();
        }
        return -1;
    }

    public SQLPSParam getParameter() {
        return this.parameter;
    }

    public void setRecommendedValue(String value) {
        this.textFieldValue.setText(value);
    }

    public void setRecommendedOutputState(boolean output) {
        this.jCheckBoxOutParam.setSelected(output);
    }

    public void setRecommendedType(int type) {
        BasicDataType basicType = null;
        for (int i = 0; i < this.cbType.getItemCount(); ++i) {
            basicType = (BasicDataType)this.cbType.getItemAt(i);
            if (basicType.getId() != type) continue;
            this.cbType.setSelectedIndex(i);
            break;
        }
    }

    public String getValueText() {
        return this.textFieldValue.getText();
    }

    public boolean isOutParam() {
        return this.jCheckBoxOutParam.isSelected();
    }

    public void reset() {
        this.textFieldValue.setText(null);
        this.cbType.setSelectedIndex(-1);
    }

    private void test() {
        String text;
        if (this.getBasicType() != BasicDataType.DATE.getId() && (text = this.textFieldValue.getText()) != null && text.length() > 0) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (!Character.isLetter(c)) continue;
                this.setRecommendedType(BasicDataType.CHARACTER.getId());
                break;
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.test();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.test();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.test();
    }

    @Override
    public String toString() {
        return this.labelName.getText();
    }

    private JCheckBox getJCheckBoxOutParam() {
        if (this.jCheckBoxOutParam == null) {
            this.jCheckBoxOutParam = new JCheckBox();
            this.jCheckBoxOutParam.setText("output");
        }
        return this.jCheckBoxOutParam;
    }
}

