/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import dbtools.SQLParser;
import dbtools.SQLStatement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.NumberFormatter;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;
import sqlrunner.AboutDialog;
import sqlrunner.AdminToolChooser;
import sqlrunner.DBLoginDialog;
import sqlrunner.DBMessageDialog;
import sqlrunner.Database;
import sqlrunner.DatabaseMetaDataView;
import sqlrunner.FileInfo;
import sqlrunner.Guid;
import sqlrunner.JToolBarButton;
import sqlrunner.JToolBarToggleButton;
import sqlrunner.LongRunningAction;
import sqlrunner.Main;
import sqlrunner.Messages;
import sqlrunner.SQLFileFilter;
import sqlrunner.SQLPSParamConfigurer;
import sqlrunner.TableSearchDialog;
import sqlrunner.ValueEditor;
import sqlrunner.XmlFileFilter;
import sqlrunner.base64.Base64Viewer;
import sqlrunner.config.PreferencesDialog;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.datamodel.gui.DataModelFrame;
import sqlrunner.editor.CodeCompletionAssistent;
import sqlrunner.editor.ExtEditorKit;
import sqlrunner.editor.ExtEditorPane;
import sqlrunner.editor.ExtEditorTransferHandler;
import sqlrunner.editor.GotoLineDialog;
import sqlrunner.editor.LineHighlightPainter;
import sqlrunner.editor.SearchReplaceDialog;
import sqlrunner.editor.SyntaxContext;
import sqlrunner.editor.SyntaxDocument;
import sqlrunner.editor.SyntaxScanner;
import sqlrunner.editor.TextViewer;
import sqlrunner.export.QueryExportFrame;
import sqlrunner.export.ResultTableExportDialog;
import sqlrunner.fileconverter.TextFileConverterFrame;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.FileImporter;
import sqlrunner.flatfileimport.gui.ImportConfiguratorFrame;
import sqlrunner.generator.SQLCodeGenerator;
import sqlrunner.history.HistoryFrame;
import sqlrunner.regex.RegexTestFrame;
import sqlrunner.resources.ApplicationIcons;
import sqlrunner.resources.images.ApplicationImages;
import sqlrunner.swinghelper.WindowHelper;
import sqlrunner.talend.SchemaImportFrame;
import sqlrunner.talend.SchemaUtil;
import sqlrunner.xml.ExporterFrame;
import sqlrunner.xml.ImporterFrame;

public final class MainFrame
extends JFrame
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)MainFrame.class.getName());
    private static boolean useMonospacedFont = false;
    private final JMenuBar menuBarMain = new JMenuBar();
    private final JMenu menuScript = new JMenu();
    private final JMenu menuEdit = new JMenu();
    private final JMenu menuTools = new JMenu();
    private final JMenu menuHelp = new JMenu();
    private final JMenuItem menuScriptNew = new JMenuItem();
    private final JMenuItem menuScriptOpen = new JMenuItem();
    private final JMenuItem menuScriptSave = new JMenuItem();
    private final JMenuItem menuScriptSaveas = new JMenuItem();
    private final JMenu menuScriptReopen = new JMenu();
    private final JMenuItem menuScriptInfo = new JMenuItem();
    private final JMenuItem menuWindowClose = new JMenuItem();
    private final JMenuItem menuScriptShutdown = new JMenuItem();
    private final JMenuItem menuEditUndo = new JMenuItem();
    private final JMenuItem menuEditRedo = new JMenuItem();
    private final JMenuItem menuEditCut = new JMenuItem();
    private final JMenuItem menuEditCopy = new JMenuItem();
    private final JMenuItem menuEditPaste = new JMenuItem();
    private final JMenuItem menuEditPasteSmart = new JMenuItem();
    private final JMenuItem menuEditCopyToJavaString = new JMenuItem();
    private final JMenuItem menuEditCopyToJavaStringBuffer = new JMenuItem();
    private final JMenuItem menuEditReplace = new JMenuItem();
    private final JMenuItem menuEditConvertToSql = new JMenuItem();
    private final JMenuItem menuEditCommentParams = new JMenuItem();
    private final JMenuItem menuEditRemoveParamComments = new JMenuItem();
    private final JMenuItem menuEditRemoveAllComments = new JMenuItem();
    private final JMenuItem menuToolsBase64Viewer = new JMenuItem();
    private final JMenuItem menuToolsRegexTester = new JMenuItem();
    private final JMenuItem menuToolsTextFileConverter = new JMenuItem();
    private final JMenuItem menuToolsTalendSchemaConverter = new JMenuItem();
    private final JMenuItem menuToolsCreateGuid = new JMenuItem();
    private final JMenuItem menuEditGoto = new JMenuItem();
    private final JMenuItem menuEditTrim = new JMenuItem();
    private final JMenuItem menuEditParse = new JMenuItem();
    private final JMenuItem menuEditDBCfg = new JMenuItem();
    private final JMenuItem menuEditDefCfg = new JMenuItem();
    private final JMenuItem menuEditScanCfg = new JMenuItem();
    private final JMenuItem menuEditAdminCfg = new JMenuItem();
    private final JMenuItem menuEditRestoreCfg = new JMenuItem();
    private final JMenuItem menuEditPreferences = new JMenuItem();
    private final JMenu menuDB = new JMenu();
    private final JMenuItem menuDBOpen = new JMenuItem();
    private final JMenuItem menuDBAbortConnecting = new JMenuItem();
    private final JMenuItem menuDBClose = new JMenuItem();
    private final JMenuItem menuDBRun = new JMenuItem();
    private final JMenuItem menuDBReconnect = new JMenuItem();
    private final JMenuItem menuDBExplain = new JMenuItem();
    private final JMenuItem menuDBStop = new JMenuItem();
    private final JMenuItem menuDBCommit = new JMenuItem();
    private final JMenuItem menuDBRollback = new JMenuItem();
    private final JMenuItem menuDBHistory = new JMenuItem();
    private final JMenuItem menuDBCreateNewRow = new JMenuItem();
    private final JMenuItem menuDBSearchInTable = new JMenuItem();
    private final JMenuItem menuDBExportResultSetAsTalendSchema = new JMenuItem();
    private final JMenu menuDBCSV = new JMenu();
    private final JMenuItem menuDBCsvExportResultTable = new JMenuItem();
    private final JMenuItem menuDBCsvExportDBTable = new JMenuItem();
    private final JMenuItem menuDBCsvImport = new JMenuItem();
    private final JMenu menuDBXML = new JMenu();
    private final JMenuItem menuDBXmlExport = new JMenuItem();
    private final JMenuItem menuDBXmlImport = new JMenuItem();
    private final JCheckBoxMenuItem menuDBDisableParserCheckBox = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem menuDBAutoCommitCheckBox = new JCheckBoxMenuItem();
    private final JMenuItem menuDBInformation = new JMenuItem();
    private final JMenuItem menuDBDatamodel = new JMenuItem();
    private final JCheckBoxMenuItem menuEditSyntaxhighCheckBox = new JCheckBoxMenuItem();
    private final JMenu menuConfig = new JMenu();
    private final JMenuItem menuDBAdmin = new JMenuItem();
    private final JMenuItem menuHelpAbout = new JMenuItem();
    private final JMenuItem menuHomeBrowser = new JMenuItem();
    private final JMenuItem menuHelpBrowser = new JMenuItem();
    private final JMenu menuWindow = new JMenu();
    private final JMenuItem menuWindowNew = new JMenuItem();
    private final JMenuItem menuWindowSetCustomName = new JMenuItem();
    private final JMenuItem menuWindowClearCustomName = new JMenuItem();
    private final JMenuItem menuWindowCloseAllOther = new JMenuItem();
    private final JMenuItem menuWindowArrangeHorizontal = new JMenuItem();
    private final JMenuItem menuWindowArrangeVertical = new JMenuItem();
    private final JMenuItem menuWindowArrangeOverlapped = new JMenuItem();
    private final JMenuItem menuWindowAllToFront = new JMenuItem();
    private final JToolBar mainToolBar = new JToolBar();
    private final JToolBarButton tbButtonNew = new JToolBarButton(ApplicationIcons.NEW_GIF);
    private final JToolBarButton tbButtonOpen = new JToolBarButton(ApplicationIcons.OPEN_GIF);
    private final JToolBarButton tbButtonSave = new JToolBarButton(ApplicationIcons.SAVE_GIF);
    private final JToolBarButton tbButtonDbOpen = new JToolBarButton(ApplicationIcons.DBOPEN_GIF);
    private final JToolBarButton tbButtonDbClose = new JToolBarButton(ApplicationIcons.DBCLOSE_GIF);
    private final JToolBarButton tbButtonDataModel = new JToolBarButton(ApplicationIcons.DATAMODEL_PNG);
    private final JToolBarButton tbButtonHistory = new JToolBarButton(ApplicationIcons.HISTORY_PNG);
    private final JToolBarButton tbButtonCopy = new JToolBarButton(ApplicationIcons.COPY_PNG);
    private final JToolBarButton tbButtonCut = new JToolBarButton(ApplicationIcons.CUT_GIF);
    private final JToolBarButton tbButtonPaste = new JToolBarButton(ApplicationIcons.PASTE_GIF);
    private final JToolBarButton tbButtonUndo = new JToolBarButton(ApplicationIcons.UNDO_GIF);
    private final JToolBarButton tbButtonRedo = new JToolBarButton(ApplicationIcons.REDO_GIF);
    private final JToolBarButton tbButtonEinrueck = new JToolBarButton(ApplicationIcons.EINRUECK_GIF);
    private final JToolBarButton tbButtonAusrueck = new JToolBarButton(ApplicationIcons.AUSRUECK_GIF);
    private final JToolBarButton tbButtonSearch = new JToolBarButton(ApplicationIcons.SEARCH_GIF);
    private final JToolBarButton tbButtonGoto = new JToolBarButton(ApplicationIcons.GOTO_GIF);
    private final JToolBarButton tbButtonRun = new JToolBarButton(ApplicationIcons.START_GIF);
    private final JToolBarButton tbButtonExplain = new JToolBarButton(ApplicationIcons.EXPLAIN_PNG);
    private final JToolBarButton tbButtonStop = new JToolBarButton(ApplicationIcons.STOP_GIF);
    private final JToolBarButton tbButtonCommit = new JToolBarButton(ApplicationIcons.COMMIT_GIF);
    private final JToolBarButton tbButtonRollback = new JToolBarButton(ApplicationIcons.ROLLBACK_GIF);
    private final JToolBarButton tbButtonTableSearch = new JToolBarButton(ApplicationIcons.TABLESEARCH_GIF);
    private final JToolBarButton tbButtonToLowerCase = new JToolBarButton(ApplicationIcons.LOWERCASE_GIF);
    private final JToolBarButton tbButtonToUpperCase = new JToolBarButton(ApplicationIcons.UPPERCASE_GIF);
    private final JToolBarButton tbButtonComments = new JToolBarButton(ApplicationIcons.COMMENTS_GIF);
    private final JToolBarToggleButton tbButtonHighlighter = new JToolBarToggleButton(ApplicationIcons.HIGHLIGHT_PNG);
    private final JToolBarToggleButton tbButtonTableOrientation = new JToolBarToggleButton(ApplicationIcons.TOGGLETABLEORIENTATIONICON_PNG);
    public StatusBar status;
    private GotoLineDialog dlgGo;
    private SearchReplaceDialog dlgSeRe;
    private AboutDialog dlgAbout;
    private ResultTableExportDialog exportResultTableDialog;
    private TableSearchDialog tableSearchDialog;
    private DatabaseMetaDataView metaDataView;
    private AdminToolChooser atc;
    private PreferencesDialog preferencesDialog;
    private DBLoginDialog dbLogin;
    public static HistoryFrame sqlHistory = null;
    public static DataModelFrame dmFrame = null;
    private File currentFile;
    private long currentFileLoaded = 0L;
    private long currentFileLastModified = 0L;
    private int currentTextPos = 0;
    private int currentLineNumber = 0;
    private int currentOffsetInCurrLine = 0;
    private int currentLineStartOffset = 0;
    private int currentLineEndOffset = 0;
    private String currentWord = "";
    private int startPosOfCurrentWord = 0;
    static final int READ_BUFFER_SIZE = 16348;
    private BufferedWriter bwFile;
    private int xLoc;
    private int yLoc;
    private int wide;
    private int high;
    public int dlgOpenSave_Aktion;
    private transient TextChangeListener textChangeListener = null;
    private boolean textChanged = false;
    public boolean linewrap = false;
    private final transient UndoManager undoManager = new UndoManager();
    private final transient UndoHandler undoHandler = new UndoHandler();
    private String tabErsatz;
    private final MenuScriptReopenListener reopenListener = new MenuScriptReopenListener();
    private JSplitPane splitPane = new JSplitPane();
    private ExtEditorPane editor;
    private final JScrollPane editorScrollPane = new JScrollPane();
    private final JScrollPane tableScrollPane = new JScrollPane();
    private JLayeredPane editorLayeredPane;
    private CodeCompletionAssistent syntaxChooser;
    public JTable resultTable = new JTable();
    private transient Database database = null;
    private static String dateFormatMask = "dd.MM.yyyy HH:mm:ss";
    private final Vector<ValueEditor> cellEditorList = new Vector();
    private boolean databaseIsBusy = false;
    private boolean fileLoaderBusy = false;
    private int selectedRowIndex = -1;
    private transient SyntaxScanner lexer = null;
    private boolean startRunOnLoad = false;
    private boolean usedForFKNavigation = false;
    public static final int FK_NAVIGATION_THIS_FRAME = 0;
    public static final int FK_NAVIGATION_NEW_FRAME = 1;
    public static final int FK_NAVIGATION_LAST_FRAME = 2;
    private static int fkNavigationFrameMode = 2;
    public SQLFileFilter sqlFileFilter = new SQLFileFilter();
    static TextViewer textViewer = null;
    private boolean textIsSelected = false;
    private static ResultTableCellRenderer objectTableRenderer = null;
    private static ArrayList<LongRunningAction> listOfLongRunningActions = new ArrayList();
    private int frameIndex = 0;
    private static int lastFrameIndex = 0;
    private String windowName = null;
    private String customWindowName = null;
    private Timer runTimer;
    private long runTimerStartTime = 0L;
    private static final Color productiveBackground = new Color(255, 240, 240);
    private boolean tableIsInIntervalSelectionMode = false;
    private ConnectThread connectThread;
    private Action stopConnectAction = new AbstractAction(Messages.getString("MainFrame.stopConnecting")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.stopConnecting();
        }
    };
    private Thread executerThread;
    private long lastMessageFrom = 0L;
    private Action defaultEnterAction;
    private Action defaultCaretUpAction;
    private Action defaultCaretDownAction;
    private Action actionCopyTableContent = new AbstractAction(Messages.getString("MainFrame.menucopy")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            TransferHandler th = MainFrame.this.resultTable.getTransferHandler();
            if (th != null) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                th.exportToClipboard(MainFrame.this.resultTable, cb, 1);
            }
        }
    };
    private Action actionInsertNewTableLineAsCopy = new AbstractAction(Messages.getString("MainFrame.tablecontextmenucreatenewlineascopy")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this.database.getNewRowIndex() == -1) {
                if (MainFrame.this.database.insertRowInTableAsCopy()) {
                    MainFrame.this.menuDBCreateNewRow.setEnabled(false);
                    MainFrame.this.resultTable.setRowSelectionInterval(MainFrame.this.database.getNewRowIndex(), MainFrame.this.database.getNewRowIndex());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this.tableScrollPane.getVerticalScrollBar().setValue(MainFrame.this.tableScrollPane.getVerticalScrollBar().getMaximum());
                        }
                    });
                } else {
                    MainFrame.this.showInfoMessage(Messages.getString("MainFrame.112"), Messages.getString("MainFrame.113"));
                }
            }
        }
    };
    private Action actionDeleteRowInTable = new AbstractAction(Messages.getString("MainFrame.tablecontextmenudeletedataset")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = MainFrame.this.resultTable.getSelectedRows();
            if (rows != null && rows.length > 0) {
                int answer = 0;
                if (rows.length > 1) {
                    answer = JOptionPane.showConfirmDialog(MainFrame.this, Messages.getString("MainFrame.askForMoreRowToDelete1") + " " + rows.length + " " + Messages.getString("MainFrame.askForMoreRowToDelete2"), "Delete", 2);
                }
                if (answer == 0) {
                    MainFrame.this.database.deleteDataset(MainFrame.this.resultTable.getSelectedRows());
                }
            }
        }
    };

    public MainFrame(int xLoc, int yLoc, int wide, int high) {
        this.xLoc = xLoc;
        this.yLoc = yLoc;
        this.wide = wide;
        this.high = high;
        this.enableEvents(64L);
        logger.debug((Object)"MainFrame opening");
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.initComponents();
                if (sqlHistory == null) {
                    sqlHistory = new HistoryFrame();
                }
                WindowHelper.checkAndCorrectWindowBounds(this);
            } else {
                final MainFrame self = this;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.initComponents();
                        if (sqlHistory == null) {
                            sqlHistory = new HistoryFrame();
                        }
                        WindowHelper.checkAndCorrectWindowBounds(self);
                    }
                });
            }
            useMonospacedFont = Boolean.valueOf(Main.getUserProperty("MONOSPACED_TABLECELL_FONT", "false"));
        }
        catch (Exception e) {
            logger.error((Object)("exception: " + e), (Throwable)e);
            Main.panic("Error in Constructor of MainFrame");
        }
        this.frameIndex = lastFrameIndex++;
        if (this.frameIndex > 0) {
            this.updateEditorKeymap();
        }
    }

    public static boolean useMonospacedTableCellFont() {
        return useMonospacedFont;
    }

    public static void setUseMonospacedTableCellFont(boolean useit) {
        useMonospacedFont = useit;
        Main.setUserProperty("MONOSPACED_TABLECELL_FONT", String.valueOf(useit));
    }

    public Database getDatabase() {
        return this.database;
    }

    public SyntaxScanner getSyntaxScanner() {
        return this.lexer;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public long getCurrentFileLastModified() {
        return this.currentFileLastModified;
    }

    public long getCurrentFileLoaded() {
        return this.currentFileLoaded;
    }

    void setDividerLocation(int location) {
        this.splitPane.setDividerLocation(location);
    }

    public int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    public boolean isCloseActionDisabled() {
        return listOfLongRunningActions.size() > 0;
    }

    public void setCreateNewRowEnabled(boolean enable) {
        if (this.menuDBCreateNewRow != null) {
            this.menuDBCreateNewRow.setEnabled(enable);
        }
    }

    public boolean isCreateNewRowEnabled() {
        if (this.menuDBCreateNewRow != null) {
            return this.menuDBCreateNewRow.isEnabled();
        }
        return false;
    }

    private void initMenu() {
        this.setMenuMnemonic();
        this.setMenuShortcut();
        this.menuScript.setText(Messages.getString("MainFrame.menufile"));
        this.menuScriptNew.setText(Messages.getString("MainFrame.menufilenew"));
        this.menuScriptNew.setActionCommand("new");
        this.menuScriptNew.addActionListener(this);
        this.menuScriptOpen.setText(Messages.getString("MainFrame.menufileopen"));
        this.menuScriptOpen.setActionCommand("open");
        this.menuScriptOpen.addActionListener(this);
        this.menuScriptReopen.setText(Messages.getString("MainFrame.menufilereopen"));
        this.menuScriptSave.setText(Messages.getString("MainFrame.menufilesave"));
        this.menuScriptSave.setActionCommand("save");
        this.menuScriptSave.addActionListener(this);
        this.menuScriptSaveas.setText(Messages.getString("MainFrame.menufilesaveas"));
        this.menuScriptSaveas.setActionCommand("saveas");
        this.menuScriptSaveas.addActionListener(this);
        this.menuScriptInfo.setText(Messages.getString("MainFrame.menufileinfo"));
        this.menuScriptInfo.setActionCommand("fileinfo");
        this.menuScriptInfo.addActionListener(this);
        this.menuScriptShutdown.setText(Messages.getString("MainFrame.menuexit"));
        this.menuScriptShutdown.setActionCommand("shutdown");
        this.menuScriptShutdown.addActionListener(this);
        this.menuDB.setText(Messages.getString("MainFrame.menudatabase"));
        this.menuConfig.setText(Messages.getString("MainFrame.menuconfigfiles"));
        this.menuScript.add(this.menuScriptNew);
        this.menuScript.add(this.menuScriptOpen);
        this.menuScript.add(this.menuScriptReopen);
        this.menuScript.add(this.menuScriptSave);
        this.menuScript.add(this.menuScriptSaveas);
        this.menuScript.addSeparator();
        this.menuScript.add(this.menuScriptInfo);
        this.menuScript.addSeparator();
        this.menuScript.add(this.menuScriptShutdown);
        this.createReopenItems();
        this.menuDBOpen.setText(Messages.getString("MainFrame.menudbopen"));
        this.menuDBOpen.setActionCommand("opendb");
        this.menuDBOpen.addActionListener(this);
        this.menuDBReconnect.setText("Reconnect");
        this.menuDBReconnect.setActionCommand("reconnect");
        this.menuDBReconnect.addActionListener(this);
        this.menuDBAbortConnecting.setAction(this.stopConnectAction);
        this.menuDBClose.setText(Messages.getString("MainFrame.menudbclose"));
        this.menuDBClose.setActionCommand("closedb");
        this.menuDBClose.addActionListener(this);
        this.menuDBRun.setText("Start");
        this.menuDBRun.setActionCommand("run");
        this.menuDBRun.addActionListener(this);
        this.menuDBExplain.setText("Explain");
        this.menuDBExplain.setActionCommand("explain");
        this.menuDBExplain.addActionListener(this);
        this.menuDBExplain.setEnabled(false);
        this.menuDBStop.setText("Stop");
        this.menuDBStop.setActionCommand("stop");
        this.menuDBStop.addActionListener(this);
        this.menuDBCommit.setText("commit");
        this.menuDBCommit.setActionCommand("commit");
        this.menuDBCommit.addActionListener(this);
        this.menuDBRollback.setText("rollback");
        this.menuDBRollback.setActionCommand("rollback");
        this.menuDBRollback.addActionListener(this);
        this.menuDBDisableParserCheckBox.setText(Messages.getString("MainFrame.menudbsendasonestat"));
        this.menuDBDisableParserCheckBox.setActionCommand("parseroff");
        this.menuDBDisableParserCheckBox.addActionListener(this);
        this.menuDBHistory.setText(Messages.getString("MainFrame.menudbhistory"));
        this.menuDBHistory.setActionCommand("history");
        this.menuDBHistory.addActionListener(this);
        this.menuDBCreateNewRow.setText(Messages.getString("MainFrame.menuinsertnewdataset"));
        this.menuDBCreateNewRow.setActionCommand("table_insert_row");
        this.menuDBCreateNewRow.addActionListener(this);
        this.menuDBSearchInTable.setText(Messages.getString("MainFrame.menudbsearchintable"));
        this.menuDBSearchInTable.setActionCommand("tablesearch");
        this.menuDBSearchInTable.addActionListener(this);
        this.menuDBCSV.setText(Messages.getString("MainFrame.menucsvexport"));
        this.menuDBCsvExportResultTable.setText(Messages.getString("MainFrame.menudbexportresulttable"));
        this.menuDBCsvExportResultTable.addActionListener(this);
        this.menuDBCsvExportResultTable.setActionCommand("exportresult");
        this.menuDBCsvExportDBTable.setText(Messages.getString("MainFrame.menuexportquery"));
        this.menuDBCsvExportDBTable.addActionListener(this);
        this.menuDBCsvExportDBTable.setActionCommand("exportdb");
        this.menuDBCsvImport.setText(Messages.getString("MainFrame.menucsvimport"));
        this.menuDBCsvImport.addActionListener(this);
        this.menuDBCsvImport.setActionCommand("importdata");
        this.menuDBXML.setText("XML Export/Import");
        this.menuDBXmlExport.setText(Messages.getString("MainFrame.menuxmlexport"));
        this.menuDBXmlExport.setActionCommand("xml_export");
        this.menuDBXmlExport.addActionListener(this);
        this.menuDBExportResultSetAsTalendSchema.setText(Messages.getString("MainFrame.exportTalendSchema"));
        this.menuDBExportResultSetAsTalendSchema.setActionCommand("export_talend_schema");
        this.menuDBExportResultSetAsTalendSchema.addActionListener(this);
        this.menuDBXmlImport.setText(Messages.getString("MainFrame.menuxmlimport"));
        this.menuDBXmlImport.setActionCommand("xml_import");
        this.menuDBXmlImport.addActionListener(this);
        this.menuDBAutoCommitCheckBox.setText(Messages.getString("MainFrame.menuautocommit"));
        if (Main.getUserProperty("AUTO_COMMIT", "true").equals("true")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"auto commit = true");
            }
            this.menuDBAutoCommitCheckBox.setSelected(true);
            this.menuDBCommit.setEnabled(false);
            this.menuDBRollback.setEnabled(false);
        } else {
            this.menuDBAutoCommitCheckBox.setSelected(false);
        }
        this.menuDBAutoCommitCheckBox.setActionCommand("autocommit");
        this.menuDBAutoCommitCheckBox.addActionListener(this);
        this.menuDBAdmin.setText(Messages.getString("MainFrame.menuadminsql"));
        this.menuDBAdmin.setActionCommand("admin");
        this.menuDBAdmin.addActionListener(this);
        this.menuDBInformation.setText(Messages.getString("MainFrame.menumetainfos"));
        this.menuDBInformation.setActionCommand("metainfo");
        this.menuDBInformation.addActionListener(this);
        this.menuDB.add(this.menuDBOpen);
        this.menuDB.add(this.menuDBReconnect);
        this.menuDB.add(this.menuDBAbortConnecting);
        this.menuDB.add(this.menuDBClose);
        this.menuDB.addSeparator();
        this.menuDB.add(this.menuDBRun);
        this.menuDB.add(this.menuDBExplain);
        this.menuDB.add(this.menuDBStop);
        this.menuDB.add(this.menuDBDisableParserCheckBox);
        this.menuDB.add(this.menuDBHistory);
        this.menuDB.addSeparator();
        this.menuDB.add(this.menuDBCommit);
        this.menuDB.add(this.menuDBRollback);
        this.menuDB.add(this.menuDBAutoCommitCheckBox);
        this.menuDB.addSeparator();
        this.menuDB.add(this.menuDBCreateNewRow);
        this.menuDB.add(this.menuDBSearchInTable);
        this.menuDB.addSeparator();
        this.menuDB.add(this.menuDBCSV);
        this.menuDBCSV.add(this.menuDBCsvExportResultTable);
        this.menuDBCSV.add(this.menuDBCsvExportDBTable);
        this.menuDBCSV.add(this.menuDBCsvImport);
        this.menuDB.add(this.menuDBXML);
        this.menuDBXML.add(this.menuDBXmlExport);
        this.menuDBXML.add(this.menuDBExportResultSetAsTalendSchema);
        this.menuDBXML.add(this.menuDBXmlImport);
        this.menuDB.addSeparator();
        this.menuDB.add(this.menuDBAdmin);
        this.menuDB.add(this.menuDBInformation);
        if (Main.getDefaultProperty("DISABLE_DATAMODEL", "false").equals("false")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"datamodel enabled");
            }
            this.menuDBDatamodel.setText(Messages.getString("MainFrame.menudatamodel"));
            this.menuDBDatamodel.setActionCommand("datamodel");
            this.menuDBDatamodel.addActionListener(this);
            this.menuDB.add(this.menuDBDatamodel);
        }
        this.menuEdit.setText(Messages.getString("MainFrame.menuedit"));
        this.menuEditUndo.setText(Messages.getString("MainFrame.menuundo"));
        this.menuEditUndo.setEnabled(false);
        this.menuEditUndo.setActionCommand("undo");
        this.menuEditUndo.addActionListener(this);
        this.menuEditRedo.setText(Messages.getString("MainFrame.menuredo"));
        this.menuEditRedo.setEnabled(false);
        this.menuEditRedo.setActionCommand("redo");
        this.menuEditRedo.addActionListener(this);
        this.menuEditCut.setText(Messages.getString("MainFrame.menucut"));
        this.menuEditCut.setActionCommand("cut");
        this.menuEditCut.addActionListener(this);
        this.menuEditCopy.setText(Messages.getString("MainFrame.menucopy"));
        this.menuEditCopy.setActionCommand("copy");
        this.menuEditCopy.addActionListener(this);
        this.menuEditCopyToJavaString.setText(Messages.getString("MainFrame.menuconvtostring"));
        this.menuEditCopyToJavaString.setActionCommand("toJavaString");
        this.menuEditCopyToJavaString.addActionListener(this);
        this.menuEditCopyToJavaStringBuffer.setText(Messages.getString("MainFrame.menuconvtostringbuffer"));
        this.menuEditCopyToJavaStringBuffer.setActionCommand("toJavaStringBuffer");
        this.menuEditCopyToJavaStringBuffer.addActionListener(this);
        this.menuEditConvertToSql.setText(Messages.getString("MainFrame.menuconvtosql"));
        this.menuEditConvertToSql.setActionCommand("toSQL");
        this.menuEditConvertToSql.addActionListener(this);
        this.menuEditCommentParams.setText(Messages.getString("MainFrame.menubuildparamnum"));
        this.menuEditCommentParams.setActionCommand("commentParams");
        this.menuEditCommentParams.addActionListener(this);
        this.menuEditRemoveParamComments.setText(Messages.getString("MainFrame.menuremoveparamnum"));
        this.menuEditRemoveParamComments.setActionCommand("removeParamComments");
        this.menuEditRemoveParamComments.addActionListener(this);
        this.menuEditRemoveAllComments.setText(Messages.getString("MainFrame.menuremoveallcomments"));
        this.menuEditRemoveAllComments.setActionCommand("removeAllComments");
        this.menuEditRemoveAllComments.addActionListener(this);
        this.menuEditPaste.setText(Messages.getString("MainFrame.menupaste"));
        this.menuEditPaste.setActionCommand("paste");
        this.menuEditPaste.addActionListener(this);
        this.menuEditPasteSmart.setText(Messages.getString("MainFrame.menupastesmart"));
        this.menuEditPasteSmart.setActionCommand("paste_smart");
        this.menuEditPasteSmart.addActionListener(this);
        this.menuEditParse.setText(Messages.getString("MainFrame.menuseparate"));
        this.menuEditParse.setActionCommand("parse");
        this.menuEditParse.addActionListener(this);
        this.menuEditReplace.setText(Messages.getString("MainFrame.menusearchandreplace"));
        this.menuEditReplace.setActionCommand("search");
        this.menuEditReplace.addActionListener(this);
        this.menuEditGoto.setText(Messages.getString("MainFrame.menugotoline"));
        this.menuEditGoto.setActionCommand("goto");
        this.menuEditGoto.addActionListener(this);
        this.menuEditTrim.setText(Messages.getString("MainFrame.menutrimsource"));
        this.menuEditTrim.setActionCommand("trim");
        this.menuEditTrim.addActionListener(this);
        this.menuEditSyntaxhighCheckBox.setText(Messages.getString("MainFrame.menusyntaxhighlight"));
        this.menuEditSyntaxhighCheckBox.setActionCommand("syntaxhigh");
        this.menuEditSyntaxhighCheckBox.addActionListener(this);
        if (Main.getDefaultProperty("SYNTAX_HIGHLIGHT_ENABLED", "true").equals("false")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"syntax highlighting disabled");
            }
            this.menuEditSyntaxhighCheckBox.setSelected(false);
            this.menuEditSyntaxhighCheckBox.setEnabled(false);
            this.lexer = null;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"syntax highlighting enabled");
            }
            this.lexer = new SyntaxScanner();
            if (Main.getUserProperty("SYNTAX_HIGHLIGHT", "true").equals("true")) {
                this.menuEditSyntaxhighCheckBox.setSelected(true);
            } else {
                this.menuEditSyntaxhighCheckBox.setSelected(false);
            }
        }
        this.menuEditDefCfg.setText(Messages.getString("MainFrame.menueditconfeditorandgui"));
        this.menuEditDefCfg.setActionCommand("defcfg");
        this.menuEditDefCfg.addActionListener(this);
        this.menuEditScanCfg.setText(Messages.getString("MainFrame.menueditsyntaxhighlighting"));
        this.menuEditScanCfg.setActionCommand("scancfg");
        this.menuEditScanCfg.addActionListener(this);
        this.menuEditDBCfg.setText(Messages.getString("MainFrame.menueditconfdbtypes"));
        this.menuEditDBCfg.setActionCommand("dbcfg");
        this.menuEditDBCfg.addActionListener(this);
        this.menuEditAdminCfg.setText(Messages.getString("MainFrame.menueditconfadminsql"));
        this.menuEditAdminCfg.setActionCommand("admincfg");
        this.menuEditAdminCfg.addActionListener(this);
        this.menuEditPreferences.setText(Messages.getString("MainFrame.menupreferences"));
        this.menuEditPreferences.setActionCommand("preferences");
        this.menuEditPreferences.addActionListener(this);
        this.menuConfig.add(this.menuEditDefCfg);
        this.menuConfig.add(this.menuEditDBCfg);
        this.menuConfig.add(this.menuEditAdminCfg);
        this.menuEditRestoreCfg.setText(Messages.getString("MainFrame.menucreateconfnew"));
        this.menuEditRestoreCfg.setActionCommand("restorecfg");
        this.menuEditRestoreCfg.addActionListener(this);
        this.menuEdit.add(this.menuEditUndo);
        this.menuEdit.add(this.menuEditRedo);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditCut);
        this.menuEdit.add(this.menuEditCopy);
        this.menuEdit.add(this.menuEditPaste);
        this.menuEdit.add(this.menuEditPasteSmart);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditCopyToJavaString);
        this.menuEdit.add(this.menuEditCopyToJavaStringBuffer);
        this.menuEdit.add(this.menuEditConvertToSql);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditCommentParams);
        this.menuEdit.add(this.menuEditRemoveParamComments);
        this.menuEdit.add(this.menuEditRemoveAllComments);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditParse);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditReplace);
        this.menuEdit.add(this.menuEditGoto);
        this.menuEdit.add(this.menuEditTrim);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditSyntaxhighCheckBox);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuConfig);
        this.menuEdit.add(this.menuEditRestoreCfg);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditPreferences);
        this.menuToolsCreateGuid.setText(Messages.getString("MainFrame.menucreateguid"));
        this.menuToolsCreateGuid.setActionCommand("createguid");
        this.menuToolsCreateGuid.addActionListener(this);
        this.menuToolsBase64Viewer.setText(Messages.getString("MainFrame.menubase64"));
        this.menuToolsBase64Viewer.setActionCommand("base64");
        this.menuToolsBase64Viewer.addActionListener(this);
        this.menuToolsRegexTester.setText(Messages.getString("MainFrame.menuRegex"));
        this.menuToolsRegexTester.setActionCommand("regex");
        this.menuToolsRegexTester.addActionListener(this);
        this.menuTools.setText(Messages.getString("MainFrame.menutools"));
        this.menuToolsTextFileConverter.setText(Messages.getString("MainFrame.textFileConverter"));
        this.menuToolsTextFileConverter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.openTextFileConverterFrame();
            }
        });
        this.menuToolsTalendSchemaConverter.setText(Messages.getString("MainFrame.talendSchemaConverter"));
        this.menuToolsTalendSchemaConverter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.openTalendSchemaConverterFrame();
            }
        });
        this.menuTools.add(this.menuToolsCreateGuid);
        this.menuTools.add(this.menuToolsBase64Viewer);
        this.menuTools.add(this.menuToolsRegexTester);
        this.menuTools.add(this.menuToolsTextFileConverter);
        this.menuTools.add(this.menuToolsTalendSchemaConverter);
        this.menuWindow.setText(Messages.getString("MainFrame.menuwindow"));
        this.menuWindow.setEnabled(true);
        this.menuWindow.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                MainFrame.this.setupWindowMenu();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.menuWindowNew.setText(Messages.getString("MainFrame.menunewwindow"));
        this.menuWindowNew.setActionCommand("window_new");
        this.menuWindowNew.addActionListener(this);
        this.menuWindowSetCustomName.setText(Messages.getString("MainFrame.customWindowName"));
        this.menuWindowSetCustomName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = JOptionPane.showInputDialog("Titel", (Object)MainFrame.this.windowName);
                if (text != null) {
                    logger.info((Object)("Set custom window name=" + text));
                    MainFrame.this.customWindowName = text.trim();
                }
                MainFrame.this.setupWindowTitle();
            }
        });
        this.menuWindowClearCustomName.setText(Messages.getString("MainFrame.clearCustomWindowName"));
        this.menuWindowClearCustomName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.customWindowName = null;
                MainFrame.this.setupWindowTitle();
            }
        });
        this.menuWindowCloseAllOther.setText(Messages.getString("MainFrame.menucloseallotherwindows"));
        this.menuWindowCloseAllOther.setActionCommand("window_close_all_other");
        this.menuWindowCloseAllOther.addActionListener(this);
        this.menuWindowArrangeOverlapped.setText(Messages.getString("MainFrame.menuoverlapwindows"));
        this.menuWindowArrangeOverlapped.setActionCommand("window_overlapped");
        this.menuWindowArrangeOverlapped.addActionListener(this);
        this.menuWindowArrangeHorizontal.setText(Messages.getString("MainFrame.menuarrangehorizontal"));
        this.menuWindowArrangeHorizontal.setActionCommand("window_horizontal");
        this.menuWindowArrangeHorizontal.addActionListener(this);
        this.menuWindowArrangeVertical.setText(Messages.getString("MainFrame.menuarrangevertical"));
        this.menuWindowArrangeVertical.setActionCommand("window_vertical");
        this.menuWindowArrangeVertical.addActionListener(this);
        this.menuWindowAllToFront.setText(Messages.getString("MainFrame.bringAllToFront"));
        this.menuWindowAllToFront.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.bringAllMainFramesToFront(MainFrame.this);
            }
        });
        this.menuWindowClose.setText(Messages.getString("MainFrame.menuclosewindow"));
        this.menuWindowClose.setActionCommand("close");
        this.menuWindowClose.addActionListener(this);
        this.menuHelp.setText(Messages.getString("MainFrame.menuhelp"));
        this.menuHelpAbout.setText(Messages.getString("MainFrame.menuinfo"));
        this.menuHelpAbout.setActionCommand("about");
        this.menuHelpAbout.addActionListener(this);
        this.menuHelp.add(this.menuHelpAbout);
        if (Desktop.isDesktopSupported()) {
            this.menuHomeBrowser.setText(Messages.getString("MainFrame.homebrowser"));
            this.menuHomeBrowser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.openHomePage();
                }
            });
            this.menuHelp.add(this.menuHomeBrowser);
            this.menuHelpBrowser.setText(Messages.getString("MainFrame.helpbrowser"));
            this.menuHelpBrowser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.openHelpPage();
                }
            });
            this.menuHelp.add(this.menuHelpBrowser);
        }
        this.menuBarMain.add(this.menuScript);
        this.menuBarMain.add(this.menuDB);
        this.menuBarMain.add(this.menuEdit);
        this.menuBarMain.add(this.menuTools);
        this.menuBarMain.add(this.menuWindow);
        this.menuBarMain.add(this.menuHelp);
        this.setJMenuBar(this.menuBarMain);
        this.menuBarMain.setRequestFocusEnabled(false);
        this.menuBarMain.setFocusable(false);
    }

    private void openHelpPage() {
        Desktop desktop = Desktop.getDesktop();
        String url = "http://www.jan-lolling.de/sqlrunner/help/SQLRunner.html";
        URI uri = null;
        try {
            uri = new URI(url);
            desktop.browse(uri);
        }
        catch (URISyntaxException e) {
            logger.warn((Object)("openHelpPage:" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn((Object)("openHelpPage:" + e.getMessage()), (Throwable)e);
        }
    }

    private void openHomePage() {
        Desktop desktop = Desktop.getDesktop();
        String url = "http://www.jan-lolling.de/Home/SQLRunner.html";
        URI uri = null;
        try {
            uri = new URI(url);
            desktop.browse(uri);
        }
        catch (URISyntaxException e) {
            logger.warn((Object)("openHelpPage:" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn((Object)("openHelpPage:" + e.getMessage()), (Throwable)e);
        }
    }

    private void initToolbar() {
        this.tbButtonNew.setToolTipText(this.menuScriptNew.getText());
        this.tbButtonNew.setActionCommand(this.menuScriptNew.getActionCommand());
        this.tbButtonNew.addActionListener(this);
        this.tbButtonOpen.setToolTipText(this.menuScriptOpen.getText());
        this.tbButtonOpen.setActionCommand(this.menuScriptOpen.getActionCommand());
        this.tbButtonOpen.addActionListener(this);
        this.tbButtonSave.setEnabled(false);
        this.tbButtonSave.setToolTipText(this.menuScriptSave.getText());
        this.tbButtonSave.setActionCommand(this.menuScriptSave.getActionCommand());
        this.tbButtonSave.addActionListener(this);
        this.tbButtonDbOpen.setActionCommand(this.menuDBOpen.getActionCommand());
        this.tbButtonDbOpen.addActionListener(this);
        this.tbButtonDbOpen.setToolTipText(this.menuDBOpen.getText());
        this.tbButtonDbClose.setActionCommand(this.menuDBClose.getActionCommand());
        this.tbButtonDbClose.addActionListener(this);
        this.tbButtonDbClose.setToolTipText(this.menuDBClose.getText());
        this.tbButtonDataModel.setActionCommand(this.menuDBDatamodel.getActionCommand());
        this.tbButtonDataModel.addActionListener(this);
        this.tbButtonDataModel.setToolTipText(this.menuDBDatamodel.getText());
        this.tbButtonHistory.setActionCommand(this.menuDBHistory.getActionCommand());
        this.tbButtonHistory.addActionListener(this);
        this.tbButtonHistory.setToolTipText(this.menuDBHistory.getText());
        this.tbButtonCut.setToolTipText(this.menuEditCut.getText());
        this.tbButtonCut.setActionCommand(this.menuEditCut.getActionCommand());
        this.tbButtonCut.addActionListener(this);
        this.tbButtonCopy.setToolTipText(this.menuEditCopy.getText());
        this.tbButtonCopy.setActionCommand(this.menuEditCopy.getActionCommand());
        this.tbButtonCopy.addActionListener(this);
        this.tbButtonPaste.setToolTipText(this.menuEditPaste.getText());
        this.tbButtonPaste.setActionCommand(this.menuEditPaste.getActionCommand());
        this.tbButtonPaste.addActionListener(this);
        this.tbButtonUndo.setEnabled(false);
        this.tbButtonUndo.setToolTipText(this.menuEditUndo.getText());
        this.tbButtonUndo.setActionCommand(this.menuEditUndo.getActionCommand());
        this.tbButtonUndo.addActionListener(this);
        this.tbButtonRedo.setEnabled(false);
        this.tbButtonRedo.setToolTipText(this.menuEditRedo.getText());
        this.tbButtonRedo.setActionCommand(this.menuEditRedo.getActionCommand());
        this.tbButtonRedo.addActionListener(this);
        this.tbButtonEinrueck.setToolTipText(Messages.getString("MainFrame.tbindentblockright"));
        this.tbButtonEinrueck.setActionCommand("einrueck");
        this.tbButtonEinrueck.addActionListener(this);
        this.tbButtonAusrueck.setToolTipText(Messages.getString("MainFrame.tbindentblockleft"));
        this.tbButtonAusrueck.setActionCommand("ausrueck");
        this.tbButtonAusrueck.addActionListener(this);
        this.tbButtonSearch.setToolTipText(this.menuEditReplace.getText());
        this.tbButtonSearch.setActionCommand(this.menuEditReplace.getActionCommand());
        this.tbButtonSearch.addActionListener(this);
        this.tbButtonGoto.setToolTipText(this.menuEditGoto.getText());
        this.tbButtonGoto.setActionCommand(this.menuEditGoto.getActionCommand());
        this.tbButtonGoto.addActionListener(this);
        this.tbButtonRun.setToolTipText(this.menuDBRun.getText());
        this.tbButtonRun.setActionCommand(this.menuDBRun.getActionCommand());
        this.tbButtonRun.addActionListener(this);
        this.tbButtonExplain.setToolTipText(this.menuDBExplain.getText());
        this.tbButtonExplain.setActionCommand(this.menuDBExplain.getActionCommand());
        this.tbButtonExplain.addActionListener(this);
        this.tbButtonExplain.setEnabled(false);
        this.tbButtonStop.setToolTipText(this.menuDBStop.getText());
        this.tbButtonStop.setActionCommand(this.menuDBStop.getActionCommand());
        this.tbButtonStop.addActionListener(this);
        this.tbButtonCommit.setToolTipText(this.menuDBCommit.getText());
        this.tbButtonCommit.setActionCommand(this.menuDBCommit.getActionCommand());
        this.tbButtonCommit.addActionListener(this);
        this.tbButtonRollback.setToolTipText(this.menuDBRollback.getText());
        this.tbButtonRollback.setActionCommand(this.menuDBRollback.getActionCommand());
        this.tbButtonRollback.addActionListener(this);
        this.tbButtonTableSearch.setToolTipText(this.menuDBSearchInTable.getText());
        this.tbButtonTableSearch.setActionCommand(this.menuDBSearchInTable.getActionCommand());
        this.tbButtonTableSearch.addActionListener(this);
        this.tbButtonToUpperCase.setToolTipText(Messages.getString("MainFrame.tbtouppercase"));
        this.tbButtonToUpperCase.setActionCommand("to_uppercase");
        this.tbButtonToUpperCase.addActionListener(this);
        this.tbButtonToUpperCase.setEnabled(false);
        this.tbButtonToLowerCase.setToolTipText(Messages.getString("MainFrame.tbtolowercase"));
        this.tbButtonToLowerCase.setActionCommand("to_lowercase");
        this.tbButtonToLowerCase.addActionListener(this);
        this.tbButtonToLowerCase.setEnabled(false);
        this.tbButtonComments.setEnabled(false);
        this.tbButtonComments.setActionCommand("comment");
        this.tbButtonComments.addActionListener(this);
        this.tbButtonComments.setToolTipText(Messages.getString("MainFrame.tbtogglelinecomment"));
        this.tbButtonHighlighter.setSelected(Main.getUserProperty("HIGHLIGHT_WORD_UNDER_CARET", "true").equals("true"));
        this.tbButtonHighlighter.setToolTipText(Messages.getString("MainFrame.tbhighlightidentifier"));
        this.tbButtonHighlighter.addActionListener(this);
        this.tbButtonHighlighter.setActionCommand("highlight");
        this.tbButtonTableOrientation.setSelected(Main.getUserProperty("TABLE_ORIENTATION", "h").equals("v"));
        this.tbButtonTableOrientation.setToolTipText(Messages.getString("MainFrame.toggleTableOrientation"));
        this.tbButtonTableOrientation.addActionListener(this);
        this.tbButtonTableOrientation.setActionCommand("toggle_vertical");
        this.mainToolBar.setRollover(true);
        this.mainToolBar.setFocusable(false);
        this.mainToolBar.add(this.tbButtonDbOpen);
        this.mainToolBar.add(this.tbButtonDbClose);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonDataModel);
        this.mainToolBar.add(this.tbButtonHistory);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonRun);
        this.mainToolBar.add(this.tbButtonExplain);
        this.mainToolBar.add(this.tbButtonStop);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonCommit);
        this.mainToolBar.add(this.tbButtonRollback);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonTableSearch);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonTableOrientation);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonNew);
        this.mainToolBar.add(this.tbButtonOpen);
        this.mainToolBar.add(this.tbButtonSave);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonCut);
        this.mainToolBar.add(this.tbButtonCopy);
        this.mainToolBar.add(this.tbButtonPaste);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonUndo);
        this.mainToolBar.add(this.tbButtonRedo);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonSearch);
        this.mainToolBar.add(this.tbButtonGoto);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonEinrueck);
        this.mainToolBar.add(this.tbButtonAusrueck);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonToLowerCase);
        this.mainToolBar.add(this.tbButtonToUpperCase);
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.tbButtonComments);
        this.mainToolBar.add(this.tbButtonHighlighter);
        this.mainToolBar.setRollover(true);
        this.mainToolBar.setFloatable(false);
    }

    private void initComponents() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"initComponents start");
        }
        MainFrame.setDateFormatMask(Main.getUserProperty("DATE_FORMAT", "dd.MM.yyyy HH:mm:ss"));
        this.setIconImage(ApplicationImages.SQLRUNNER_PNG);
        if (WindowHelper.isWindowPositioningEnabled()) {
            this.setBounds(this.xLoc, this.yLoc, this.wide, this.high);
        } else {
            this.setSize(this.wide, this.high);
        }
        dmFrame = DataModelFrame.getDataModelFrame();
        this.resultTable.setBackground(Main.info);
        this.tabErsatz = this.createTabReplacement();
        this.initMenu();
        this.initToolbar();
        this.status = new StatusBar();
        this.editor = this.getExtEditor();
        this.editor.setFont(Main.textFont);
        this.textChangeListener = new TextChangeListener(this.editor);
        this.editor.addCaretListener(this.textChangeListener);
        this.setTextSaveEnabled(false);
        this.setupWindowTitle();
        Document doc = this.editor.getDocument();
        doc.addDocumentListener(this.textChangeListener);
        doc.addUndoableEditListener(this.undoHandler);
        this.undoManager.discardAllEdits();
        this.updateUndoRedoEnabled();
        this.textIsSelected(false);
        this.prepareTable();
        this.tableScrollPane.setViewportView(this.resultTable);
        this.splitPane.setOrientation(0);
        this.splitPane.setTopComponent(this.getLayeredEditorPane());
        this.splitPane.setDividerSize(10);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(Integer.parseInt(Main.getUserProperty("DIVIDER_LOCATION", "100")));
        this.splitPane.setBottomComponent(this.tableScrollPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainToolBar, "North");
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)this.status, "South");
        this.getContentPane().validate();
        this.setFocusToEditor();
        this.setGuiToConnected(false);
        this.setTableSearchEnabled(false);
        if (this.database != null) {
            this.database.setVerticalView(Main.getUserProperty("TABLE_ORIENTATION", "h").equals("v"));
        }
    }

    private JLayeredPane getLayeredEditorPane() {
        if (this.editorLayeredPane == null) {
            this.editorLayeredPane = new JLayeredPane();
            BorderLayout bl = new BorderLayout();
            this.editorLayeredPane.setLayout(bl);
            this.editorScrollPane.setViewportView(this.editor);
            this.editorLayeredPane.setLayer(this.editorScrollPane, JLayeredPane.DEFAULT_LAYER);
            this.editorLayeredPane.setLayer(this.getSyntaxChooser(), JLayeredPane.MODAL_LAYER);
            this.editorLayeredPane.add(this.editorScrollPane);
            this.editorLayeredPane.add((Component)this.getSyntaxChooser(), 1);
            this.editorLayeredPane.getLayout().removeLayoutComponent(this.getSyntaxChooser());
            this.editorLayeredPane.validate();
            bl.addLayoutComponent(this.editorScrollPane, "Center");
        }
        return this.editorLayeredPane;
    }

    public void setProductive(boolean productive) {
        this.editor.setBackground(productive ? productiveBackground : Color.WHITE);
    }

    public void setupEditorFont() {
        this.editor.setFont(Main.textFont);
        if (this.lexer != null) {
            this.lexer.setupChangedTextFont();
        }
        SyntaxContext.setupTextFont();
        this.repaint();
    }

    private void setFocusToEditor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MainFrame.this.editor.requestFocus();
            }
        });
    }

    public void closeDMFrame() {
        if (dmFrame != null) {
            Main.refreshUserProperties(this);
            dmFrame.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
        }
        super.setVisible(visible);
        if (visible && logger.isDebugEnabled()) {
            logger.debug((Object)"MainFrame is visible");
        }
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        if (this.atc != null) {
            SwingUtilities.updateComponentTreeUI(this.atc);
        }
        if (this.exportResultTableDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.exportResultTableDialog);
        }
        if (this.metaDataView != null) {
            SwingUtilities.updateComponentTreeUI(this.metaDataView);
        }
        if (this.dbLogin != null) {
            SwingUtilities.updateComponentTreeUI(this.dbLogin);
        }
        if (this.preferencesDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.preferencesDialog);
        }
        if (this.dlgSeRe != null) {
            SwingUtilities.updateComponentTreeUI(this.dlgSeRe);
        }
        if (this.tableSearchDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.tableSearchDialog);
        }
        if (this.dlgGo != null) {
            SwingUtilities.updateComponentTreeUI(this.dlgGo);
        }
        if (this.dlgAbout != null) {
            SwingUtilities.updateComponentTreeUI(this.dlgAbout);
        }
        this.updateEditorKeymap();
    }

    private void setTableSelectionToIntervalMode(boolean intervalMode) {
        if (intervalMode != this.tableIsInIntervalSelectionMode) {
            this.tableIsInIntervalSelectionMode = intervalMode;
            int row = this.resultTable.getSelectedRow();
            int col = this.resultTable.getSelectedColumn();
            if (intervalMode) {
                this.resultTable.setSelectionMode(2);
                this.resultTable.setColumnSelectionAllowed(true);
                if (row != -1 && col != -1) {
                    this.resultTable.changeSelection(row, col, false, false);
                }
            } else {
                this.resultTable.setSelectionMode(0);
                this.resultTable.setColumnSelectionAllowed(false);
                if (row != -1) {
                    this.resultTable.setRowSelectionInterval(row, row);
                }
            }
        }
    }

    public void prepareTable() {
        this.resultTable.setSelectionMode(0);
        this.resultTable.getSelectionModel().addListSelectionListener(this);
        this.resultTable.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        TableMouseListener ml = new TableMouseListener();
        this.resultTable.addMouseListener(ml);
        this.resultTable.addMouseMotionListener(ml);
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.getTableHeader().setReorderingAllowed(false);
        this.resultTable.setToolTipText(null);
        this.resultTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiers() == 1) {
                    MainFrame.this.setTableSelectionToIntervalMode(true);
                } else if (e.getModifiers() == 0) {
                    MainFrame.this.setTableSelectionToIntervalMode(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.resultTable.registerKeyboardAction(this, "table_edit_cell", KeyStroke.getKeyStroke(10, 0), 0);
        this.resultTable.registerKeyboardAction(this, "table_insert_row", KeyStroke.getKeyStroke(73, 8), 0);
        this.resultTable.registerKeyboardAction(this, "table_insert_row_cancel", KeyStroke.getKeyStroke(27, 0), 0);
        this.resultTable.registerKeyboardAction(this, "db_insert_row", KeyStroke.getKeyStroke(83, 8), 0);
        this.resultTable.registerKeyboardAction(this, "toggle_vertical", KeyStroke.getKeyStroke(86, 8), 0);
        this.prepareTableRenderer();
    }

    public void prepareTableRenderer() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"prepareTableRenderer");
        }
        objectTableRenderer = new ResultTableCellRenderer();
        objectTableRenderer.setDateFormatMask(MainFrame.getDateFormatMask());
        this.resultTable.setDefaultRenderer(java.sql.Date.class, objectTableRenderer);
        this.resultTable.setDefaultRenderer(Time.class, objectTableRenderer);
        this.resultTable.setDefaultRenderer(Timestamp.class, objectTableRenderer);
        this.resultTable.setDefaultRenderer(String.class, objectTableRenderer);
        this.resultTable.setDefaultRenderer(Object.class, objectTableRenderer);
        this.resultTable.setDefaultRenderer(Boolean.class, objectTableRenderer);
    }

    public void setupWindowTitle() {
        if (this.customWindowName != null) {
            this.windowName = this.customWindowName;
            StringBuilder title = new StringBuilder(100);
            title.append(this.customWindowName);
            title.append(" - SQLRunner");
            this.setTitle(title.toString());
        } else if (this.database != null && this.database.getDatabaseSession().isConnected()) {
            StringBuilder title = new StringBuilder(100);
            title.append("DB: ");
            title.append(this.database.getDatabaseSession().getConnectionDescription().toString());
            if (this.currentFile != null) {
                title.append(Messages.getString("MainFrame.fragmenttitlefile"));
                title.append(this.currentFile.getName());
            }
            this.windowName = title.toString();
            title.append(" - SQLRunner");
            this.setTitle(title.toString());
        } else if (this.currentFile != null) {
            StringBuilder title = new StringBuilder(100);
            title.append(Messages.getString("MainFrame.file"));
            title.append(this.currentFile.getName());
            this.windowName = title.toString();
            title.append(" - SQLRunner");
            this.setTitle(title.toString());
        } else {
            this.windowName = "not used";
            this.setTitle("SQLRunner");
        }
    }

    private void moveSplitPaneDividerToButtom() {
        this.splitPane.setDividerLocation(1000);
    }

    private void moveSplitPaneDividerToMiddle() {
        this.splitPane.setDividerLocation(this.splitPane.getMaximumDividerLocation() / 2);
    }

    public void ensureResultTableIsVisible() {
        if (SwingUtilities.isEventDispatchThread()) {
            int dividerPos = this.splitPane.getDividerLocation();
            if (dividerPos > this.splitPane.getMaximumDividerLocation() - 20) {
                this.moveSplitPaneDividerToMiddle();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int dividerPos = MainFrame.this.splitPane.getDividerLocation();
                    if (dividerPos > MainFrame.this.splitPane.getMaximumDividerLocation() - 20) {
                        MainFrame.this.moveSplitPaneDividerToMiddle();
                    }
                }
            });
        }
    }

    public void handleFile(String filePath) {
        if (filePath != null) {
            filePath = filePath.trim();
            this.handleFile(new File(filePath));
        }
    }

    public void handleFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        String filename = file.getName();
        logger.info((Object)("handleFile: " + file));
        if (filename.toLowerCase().endsWith(".sql")) {
            this.loadFileInDocument(true, file.getAbsolutePath());
        } else if (filename.toLowerCase().endsWith(".importconfig")) {
            this.openCSVImportDialog(file);
        } else {
            FileImporter fi = new FileImporter();
            if (fi.isDataFile(file)) {
                this.openCSVImportDialog(file);
            } else {
                logger.warn((Object)("unknown file type in file " + file));
            }
        }
    }

    public void loadAndRun(String filename) {
        this.loadFileInDocument(false, filename);
        this.runScript();
    }

    private void setMenuMnemonic() {
        if (Main.getDefaultProperty("USE_MENU_MNEMONIC", "false").equals("true")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"MainFrame.useMnemonic: use menu-mnemonics");
            }
            this.menuScript.setMnemonic('D');
            this.menuDB.setMnemonic('a');
            this.menuEdit.setMnemonic('B');
            this.menuWindow.setMnemonic('F');
            this.menuHelp.setMnemonic('H');
            this.menuWindowNew.setMnemonic('N');
        }
    }

    private void setMenuShortcut() {
        if (Main.getDefaultProperty("USE_MENU_SHORTCUT", "true").equals("true")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"MainFrame.useShortcut: use menu shortcuts");
            }
            Toolkit tkLocal = Toolkit.getDefaultToolkit();
            this.menuScriptNew.setAccelerator(KeyStroke.getKeyStroke(78, tkLocal.getMenuShortcutKeyMask()));
            this.menuScriptOpen.setAccelerator(KeyStroke.getKeyStroke(79, tkLocal.getMenuShortcutKeyMask()));
            this.menuScriptSave.setAccelerator(KeyStroke.getKeyStroke(83, tkLocal.getMenuShortcutKeyMask()));
            this.menuScriptInfo.setAccelerator(KeyStroke.getKeyStroke(73, tkLocal.getMenuShortcutKeyMask()));
            this.menuScriptShutdown.setAccelerator(KeyStroke.getKeyStroke(81, tkLocal.getMenuShortcutKeyMask()));
            this.menuEditUndo.setAccelerator(KeyStroke.getKeyStroke(90, tkLocal.getMenuShortcutKeyMask()));
            this.menuEditRedo.setAccelerator(KeyStroke.getKeyStroke(89, tkLocal.getMenuShortcutKeyMask()));
            this.menuEditCut.setAccelerator(KeyStroke.getKeyStroke(88, tkLocal.getMenuShortcutKeyMask()));
            this.menuEditCopy.setAccelerator(KeyStroke.getKeyStroke(67, tkLocal.getMenuShortcutKeyMask()));
            this.menuEditPaste.setAccelerator(KeyStroke.getKeyStroke(86, tkLocal.getMenuShortcutKeyMask()));
            this.menuEditReplace.setAccelerator(KeyStroke.getKeyStroke(70, tkLocal.getMenuShortcutKeyMask()));
            this.menuEditGoto.setAccelerator(KeyStroke.getKeyStroke(71, tkLocal.getMenuShortcutKeyMask()));
            this.menuDBRun.setAccelerator(KeyStroke.getKeyStroke(116, 0));
            this.menuDBStop.setAccelerator(KeyStroke.getKeyStroke(116, tkLocal.getMenuShortcutKeyMask()));
            this.menuDBHistory.setAccelerator(KeyStroke.getKeyStroke(115, 0));
            this.menuDBOpen.setAccelerator(KeyStroke.getKeyStroke(68, tkLocal.getMenuShortcutKeyMask()));
            this.menuDBClose.setAccelerator(KeyStroke.getKeyStroke(69, tkLocal.getMenuShortcutKeyMask()));
            this.menuDBAdmin.setAccelerator(KeyStroke.getKeyStroke(114, 0));
            this.menuDBCommit.setAccelerator(KeyStroke.getKeyStroke(67, 8));
            this.menuDBRollback.setAccelerator(KeyStroke.getKeyStroke(82, 8));
            this.menuDBCreateNewRow.setAccelerator(KeyStroke.getKeyStroke(73, 8));
            this.menuDBSearchInTable.setAccelerator(KeyStroke.getKeyStroke(70, 8));
            this.menuDBDatamodel.setAccelerator(KeyStroke.getKeyStroke(113, 0));
            this.menuWindowNew.setAccelerator(KeyStroke.getKeyStroke(78, 8 | tkLocal.getMenuShortcutKeyMask()));
            if (System.getProperty("os.name").toLowerCase().trim().startsWith("mac")) {
                this.menuWindowClose.setAccelerator(KeyStroke.getKeyStroke(87, tkLocal.getMenuShortcutKeyMask()));
                this.menuScriptSaveas.setAccelerator(KeyStroke.getKeyStroke(83, 1 | tkLocal.getMenuShortcutKeyMask()));
                this.menuEditPreferences.setAccelerator(KeyStroke.getKeyStroke(44, tkLocal.getMenuShortcutKeyMask()));
            }
        }
    }

    private ExtEditorPane getExtEditor() {
        if (this.editor == null) {
            this.editor = new ExtEditorPane(this);
            ExtEditorKit kit = new ExtEditorKit(this);
            this.editor.setEditorKitForContentType("text/sql", kit);
            this.editor.getCaret().setBlinkRate(500);
            this.editor.setContentType("text/sql");
            if (this.lexer != null) {
                this.lexer.setEditor(this.editor);
            }
            EditorMouseListener ml = new EditorMouseListener();
            this.editor.addMouseListener(ml);
            this.editor.addMouseMotionListener(ml);
            this.editor.setDragEnabled(true);
            this.editor.setTransferHandler(new ExtEditorTransferHandler());
        }
        return this.editor;
    }

    private void setupNewDocumentWithListenersAndUndoRedo() {
        Document doc = this.editor.getEditorKit().createDefaultDocument();
        doc.addDocumentListener(this.textChangeListener);
        doc.addUndoableEditListener(this.undoHandler);
        this.editor.setDocument(doc);
        this.undoManager.discardAllEdits();
        this.updateUndoRedoEnabled();
        this.setTextSaveEnabled(false);
        this.status.message.setText("");
        this.currentFile = null;
    }

    public void setTextSaveEnabled(boolean enabled) {
        if (enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setTextSaveEnabled: setze changed-Flag auf true");
            }
            this.textChanged = true;
            this.tbButtonSave.setEnabled(true);
            this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setTextSaveEnabled: setze changed-Flag auf false");
            }
            this.textChanged = false;
            this.tbButtonSave.setEnabled(false);
            this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
        }
    }

    private void textIsSelected(boolean selected) {
        this.tbButtonCopy.setEnabled(selected);
        this.tbButtonCut.setEnabled(selected);
        this.tbButtonEinrueck.setEnabled(selected);
        this.tbButtonAusrueck.setEnabled(selected);
        this.tbButtonToLowerCase.setEnabled(selected);
        this.tbButtonToUpperCase.setEnabled(selected);
        this.tbButtonComments.setEnabled(selected);
        this.textIsSelected = selected;
    }

    public boolean isTextSelected() {
        return this.textIsSelected;
    }

    public boolean isTextChanged() {
        return this.editor.getDocument().getLength() == 0 ? false : this.textChanged;
    }

    @Override
    protected void processWindowEvent(WindowEvent winEvent) {
        switch (winEvent.getID()) {
            case 201: {
                if (!this.close()) break;
                super.processWindowEvent(winEvent);
                break;
            }
            case 205: {
                if (dmFrame != null && this.database != null) {
                    dmFrame.setMainFrame(this);
                }
                if (sqlHistory != null) {
                    sqlHistory.setMainFrame(this);
                }
                WindowHelper.checkAndCorrectWindowBounds(this);
            }
            default: {
                super.processWindowEvent(winEvent);
            }
        }
    }

    public static void addLongRunningAction(LongRunningAction action) {
        if (!listOfLongRunningActions.contains(action)) {
            listOfLongRunningActions.add(action);
        }
    }

    public static void removeLongRunningAction(LongRunningAction action) {
        listOfLongRunningActions.remove(action);
    }

    private void setupWindowDefaultMenuItems() {
        this.menuWindow.removeAll();
        this.menuWindow.add(this.menuWindowNew);
        this.menuWindow.add(this.menuWindowSetCustomName);
        this.menuWindow.add(this.menuWindowClearCustomName);
        this.menuWindow.addSeparator();
        this.menuWindow.add(this.menuWindowArrangeOverlapped);
        this.menuWindow.add(this.menuWindowArrangeHorizontal);
        this.menuWindow.add(this.menuWindowArrangeVertical);
        this.menuWindow.add(this.menuWindowAllToFront);
        this.menuWindow.addSeparator();
        this.menuWindow.add(this.menuWindowClose);
        this.menuWindow.add(this.menuWindowCloseAllOther);
    }

    private static void bringAllMainFramesToFront(MainFrame current) {
        for (MainFrame mf : Main.getWindowList()) {
            if (mf == current) continue;
            mf.setVisible(true);
            mf.setState(0);
            mf.toFront();
        }
    }

    private void setupWindowMainFrameMenuItems() {
        boolean firstLoop = true;
        for (final MainFrame mf : Main.getWindowList()) {
            if (mf == this) continue;
            if (firstLoop) {
                this.menuWindow.addSeparator();
                firstLoop = false;
            }
            JMenuItem mi = new JMenuItem(mf.getMenuWindowLabelText());
            String text = this.getText();
            if (text.length() > 0) {
                mi.setToolTipText(text);
            }
            mi.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    mf.setVisible(true);
                    mf.setState(0);
                    mf.toFront();
                }
            });
            if (mf.isBusy()) {
                mi.setIcon(ApplicationIcons.START_GIF);
            }
            this.menuWindow.add(mi);
        }
        SwingUtilities.updateComponentTreeUI(this.menuWindow);
    }

    public void setupWindowMenu() {
        this.setupWindowDefaultMenuItems();
        this.setupWindowMainFrameMenuItems();
        SwingUtilities.updateComponentTreeUI(this.menuWindow);
    }

    public void createReopenItems() {
        block5: {
            try {
                this.menuScriptReopen.removeAll();
                boolean hasItems = false;
                int max = Integer.parseInt(Main.getDefaultProperty("MAX_FILES_ENTRIES", "10"));
                for (int i = 0; i < max; ++i) {
                    String fileName = Main.getUserProperty("FILE_" + i);
                    if (fileName == null || fileName.length() <= 0) continue;
                    JMenuItem item = new JMenuItem(fileName);
                    item.setActionCommand(item.getText());
                    this.menuScriptReopen.add(item);
                    item.addActionListener(this.reopenListener);
                    hasItems = true;
                }
                if (hasItems) {
                    this.menuScriptReopen.addSeparator();
                    JMenuItem item = new JMenuItem(Messages.getString("MainFrame.clearfilelist"));
                    item.setActionCommand("clear_file_list");
                    item.addActionListener(this);
                    this.menuScriptReopen.add(item);
                } else {
                    JMenuItem item = new JMenuItem(Messages.getString("MainFrame.empty"));
                    this.menuScriptReopen.add(item);
                }
                this.validate();
            }
            catch (AccessControlException ae) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)("createReopenItems: " + ae.getMessage()));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            if (this.database.isVerticalView()) {
                this.selectedRowIndex = this.database.convertFromVerticalToLogicalRowIndex(lsm.getMinSelectionIndex());
            } else {
                this.selectedRowIndex = lsm.getMinSelectionIndex();
                int[] selectedRows = this.resultTable.getSelectedRows();
                int[] selectedColumns = this.resultTable.getSelectedColumns();
                if (selectedRows.length > 0 && selectedColumns.length > 0) {
                    if (logger.isDebugEnabled() && !e.getValueIsAdjusting()) {
                        StringBuilder message = new StringBuilder();
                        message.append("rows=" + (selectedRows[0] + 1) + ":" + (selectedRows[selectedRows.length - 1] + 1));
                        message.append(" cols=" + (selectedColumns[0] + 1) + ":" + (selectedColumns[selectedColumns.length - 1] + 1));
                        logger.debug((Object)message.toString());
                    }
                    if (selectedColumns.length == 1 && selectedRows.length > 1) {
                        double sum = this.database.calculateColumnValueSum(selectedRows, selectedColumns[0]);
                        this.setStatusMessage("sum=" + sum + " count rows=" + selectedRows.length);
                    } else if (selectedColumns.length > 1 && selectedRows.length == 1) {
                        double sum = this.database.calculateRowValueSum(selectedRows[0], selectedColumns);
                        this.setStatusMessage("sum=" + sum + " count columns=" + selectedColumns.length);
                    }
                }
            }
            this.status.tablePos.setText(String.valueOf(this.selectedRowIndex + 1));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("new")) {
            this.menuScriptNew_actionPerformed();
        } else if (e.getActionCommand().equals("open")) {
            this.menuScriptOpen_actionPerformed();
        } else if (e.getActionCommand().equals("clear_file_list")) {
            Main.removeAllFileProps();
        } else if (e.getActionCommand().equals("save")) {
            this.menuScriptSave_actionPerformed();
        } else if (e.getActionCommand().equals("saveas")) {
            this.menuScriptSaveas_actionPerformed();
        } else if (e.getActionCommand().equals("close")) {
            this.close();
        } else if (e.getActionCommand().equals("shutdown")) {
            Main.shutdown();
        } else if (e.getActionCommand().equals("fileinfo")) {
            this.menuScriptInfo_actionPerformed();
        } else if (e.getActionCommand().equals("opendb")) {
            this.menuDBOpen_actionPerformed();
        } else if (e.getActionCommand().equals("reconnect")) {
            this.startReconnect();
        } else if (e.getActionCommand().equals("closedb")) {
            this.startDisconnect();
        } else if (e.getActionCommand().equals("undo")) {
            this.menuEditUndo_actionPerformed();
        } else if (e.getActionCommand().equals("redo")) {
            this.menuEditRedo_actionPerformed();
        } else if (e.getActionCommand().equals("cut")) {
            this.menuEditCut_actionPerformed();
        } else if (e.getActionCommand().equals("copy")) {
            this.menuEditCopy_actionPerformed();
        } else if (e.getActionCommand().equals("paste")) {
            this.menuEditPaste_actionPerformed();
        } else if (e.getActionCommand().equals("paste_smart")) {
            this.menuEditPasteSmart_actionPerformed();
        } else if (e.getActionCommand().equals("to_lowercase")) {
            new ExtEditorKit.ToLowerCase().actionPerformed(new ActionEvent(this.editor, 9997, e.getActionCommand()));
        } else if (e.getActionCommand().equals("to_uppercase")) {
            new ExtEditorKit.ToUpperCase().actionPerformed(new ActionEvent(this.editor, 9996, e.getActionCommand()));
        } else if (e.getActionCommand().equals("comment")) {
            new ExtEditorKit.ToggleLineComment().actionPerformed(new ActionEvent(this.editor, 9995, e.getActionCommand()));
        } else if (e.getActionCommand().equals("preferences")) {
            this.menuEditPreferences_actionPerformed();
        } else if (e.getActionCommand().equals("einrueck")) {
            new ExtEditorKit.MoveOut().actionPerformed(new ActionEvent(this.editor, 9998, e.getActionCommand()));
        } else if (e.getActionCommand().equals("ausrueck")) {
            new ExtEditorKit.MoveBack().actionPerformed(new ActionEvent(this.editor, 9999, e.getActionCommand()));
        } else if (e.getActionCommand().equals("trim")) {
            new ExtEditorKit.Trim().actionPerformed(new ActionEvent(this.editor, 9999, e.getActionCommand()));
        } else if (e.getActionCommand().equals("search")) {
            this.menuEditReplace_actionPerformed();
        } else if (e.getActionCommand().equals("tablesearch")) {
            this.menuDBSearchInTable_actionPerformed();
        } else if (e.getActionCommand().equals("goto")) {
            this.menuEditGoto_actionPerformed();
        } else if (e.getActionCommand().equals("syntaxhigh")) {
            this.menuEditSyntaxhighCheckBox_actionPerformed();
        } else if (e.getActionCommand().equals("run")) {
            this.runScript();
        } else if (e.getActionCommand().equals("explain")) {
            this.runExplain();
        } else if (e.getActionCommand().equals("parse")) {
            this.menuEditParse_actionPerformed();
        } else if (e.getActionCommand().equals("history")) {
            this.menuDBHistory_actionPerformed();
        } else if (e.getActionCommand().equals("about")) {
            this.menuHelpAbout_actionPerformed();
        } else if (e.getActionCommand().equals("defcfg")) {
            this.loadFileInDocument(true, Main.getCfgFileName());
        } else if (e.getActionCommand().equals("dbcfg")) {
            this.loadFileInDocument(true, Main.getDbCfgFileName());
        } else if (e.getActionCommand().equals("admincfg")) {
            this.loadFileInDocument(true, Main.getAdminCfgFileName());
        } else if (e.getActionCommand().equals("restorecfg")) {
            this.menuEditRestoreCfg_actionPerformed();
        } else if (e.getActionCommand().equals("autocommit")) {
            this.menuDBAutoCommitCheckBox_actionPerformed();
        } else if (e.getActionCommand().equals("stop")) {
            this.cancelStatement();
        } else if (e.getActionCommand().equals("admin")) {
            this.menuDBAdmin_actionPerformed();
        } else if (e.getActionCommand().equals("insert")) {
            this.menuEditInsertInsertStat_actionPerformed();
        } else if (e.getActionCommand().equals("select")) {
            this.menuEditInsertSelectStat_actionPerformed();
        } else if (e.getActionCommand().equals("tablename")) {
            this.menuEditInsertTablename_actionPerformed();
        } else if (e.getActionCommand().equals("exportresult")) {
            this.menuDBExportResultTable_actionPerformed();
        } else if (e.getActionCommand().equals("exportdb")) {
            this.menuDBExportDBTable_actionPerformed();
        } else if (e.getActionCommand().equals("importdata")) {
            this.openCSVImportDialog(null);
        } else if (e.getActionCommand().equals("xml_export")) {
            this.menuDBXmlExport_actionPerformed();
        } else if (e.getActionCommand().equals("xml_import")) {
            this.menuDBXmlImport_actionPerformed();
        } else if (e.getActionCommand().equals("table_edit_cell")) {
            this.returnKeyPressedOnTable();
        } else if (e.getActionCommand().equals("table_delete_content")) {
            if (!this.databaseIsBusy) {
                if (this.selectedRowIndex != this.database.getNewRowIndex()) {
                    this.database.deleteValue(this.resultTable.getSelectedRow(), this.resultTable.getSelectedColumn());
                } else {
                    this.database.setValueAt(null, this.resultTable.getSelectedRow(), this.resultTable.getSelectedColumn());
                }
            }
        } else if (e.getActionCommand().equals("table_insert_row")) {
            if (this.database.getNewRowIndex() == -1) {
                if (this.database.insertRowInTable()) {
                    this.menuDBCreateNewRow.setEnabled(false);
                    this.resultTable.setRowSelectionInterval(this.database.getNewRowIndex(), this.database.getNewRowIndex());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this.tableScrollPane.getVerticalScrollBar().setValue(MainFrame.this.tableScrollPane.getVerticalScrollBar().getMaximum());
                        }
                    });
                } else {
                    this.showInfoMessage(Messages.getString("MainFrame.messageinsertonlyinexistingtable"), Messages.getString("MainFrame.messagetitleinsertline"));
                }
            }
        } else if (e.getActionCommand().equals("table_insert_row_cancel")) {
            if (this.selectedRowIndex == this.database.getNewRowIndex()) {
                this.database.removeNewRow();
                this.menuDBCreateNewRow.setEnabled(true);
            }
        } else if (e.getActionCommand().equals("db_insert_row")) {
            if (this.selectedRowIndex == this.database.getNewRowIndex()) {
                this.database.insertNewRowInDB();
            }
        } else if (e.getActionCommand().equals("commit")) {
            this.commit();
        } else if (e.getActionCommand().equals("rollback")) {
            this.rollback();
        } else if (e.getActionCommand().equals("table_col_pk_toggle")) {
            this.togglePk();
        } else if (e.getActionCommand().equals("window_new")) {
            Main.createInstance(this);
        } else if (e.getActionCommand().equals("window_close_all_other")) {
            Main.closeAllOther(this);
        } else if (e.getActionCommand().equals("window_horizontal")) {
            Main.arrangeWindowsHorizontal();
        } else if (e.getActionCommand().equals("window_vertical")) {
            Main.arrangeWindowsVertical();
        } else if (e.getActionCommand().equals("window_overlapped")) {
            Main.arrangeWindowsOverlapped(this);
        } else if (e.getActionCommand().equals("metainfo")) {
            this.showMetaInfoDialog();
        } else if (e.getActionCommand().equals("datamodel")) {
            this.menuDBDatamodel_actionPerformed();
        } else if (e.getActionCommand().startsWith("sek@")) {
            int p0 = e.getActionCommand().indexOf(".");
            int p1 = e.getActionCommand().indexOf("$");
            String tableColumn = e.getActionCommand().substring(4, p1);
            p0 = e.getActionCommand().indexOf("|");
            int row = Integer.parseInt(e.getActionCommand().substring(p1 + 1, p0));
            int col = Integer.parseInt(e.getActionCommand().substring(p0 + 1, e.getActionCommand().length()));
            if (MainFrame.getFkNavigationFrameMode() == 1) {
                MainFrame newFrame = Main.createInstance(this);
                newFrame.start(this.database.createSelectForReferencingTable(tableColumn, row, col));
            } else if (MainFrame.getFkNavigationFrameMode() == 0) {
                this.start(this.database.createSelectForReferencingTable(tableColumn, row, col));
            } else if (MainFrame.getFkNavigationFrameMode() == 2) {
                MainFrame lastFrame = Main.getFrameForFKNavigation(this);
                lastFrame.start(this.database.createSelectForReferencingTable(tableColumn, row, col));
            }
        } else if (e.getActionCommand().startsWith("sik@")) {
            int p0 = e.getActionCommand().indexOf("|");
            int row = Integer.parseInt(e.getActionCommand().substring(4, p0));
            int col = Integer.parseInt(e.getActionCommand().substring(p0 + 1, e.getActionCommand().length()));
            if (MainFrame.getFkNavigationFrameMode() == 1) {
                MainFrame newFrame = Main.createInstance(this);
                newFrame.start(this.database.createSelectForReferencedTable(row, col));
            } else if (MainFrame.getFkNavigationFrameMode() == 0) {
                this.start(this.database.createSelectForReferencedTable(row, col));
            } else if (MainFrame.getFkNavigationFrameMode() == 2) {
                MainFrame lastFrame = Main.getFrameForFKNavigation(this);
                lastFrame.start(this.database.createSelectForReferencedTable(row, col));
            }
        } else if (e.getActionCommand().startsWith("sai_")) {
            int col = Integer.parseInt(e.getActionCommand().substring(4, e.getActionCommand().length()));
            SorterThread sorter = new SorterThread();
            sorter.setColumnIndex(col);
            sorter.setFrame(this);
            sorter.start();
        } else if (e.getActionCommand().startsWith("saea_")) {
            int col = Integer.parseInt(e.getActionCommand().substring(5, e.getActionCommand().length()));
            this.database.sortByNewSelect(col);
        } else if (e.getActionCommand().startsWith("saee_")) {
            int col = Integer.parseInt(e.getActionCommand().substring(5, e.getActionCommand().length()));
            this.setScriptTextAsNewDocument(this.database.createSQLWithOrderBy(col));
            this.setTextSaveEnabled(false);
        } else if (e.getActionCommand().equals("toJavaString")) {
            this.menuEditConvertSqlToJavaString_actionPerformed();
        } else if (e.getActionCommand().equals("toJavaStringBuffer")) {
            this.menuEditConvertSqlToJavaStringBuffer_actionPerformed();
        } else if (e.getActionCommand().equals("toSQL")) {
            this.menuEditConvertJavaToSql_actionPerformed();
        } else if (e.getActionCommand().equals("commentParams")) {
            this.menuEditCommentParams_actionPerformed();
        } else if (e.getActionCommand().equals("removeParamComments")) {
            this.menuEditRemoveParamComments_actionPerformed();
        } else if (e.getActionCommand().equals("removeAllComments")) {
            this.menuEditRemoveAllComments_actionPerformed();
        } else if (e.getActionCommand().equals("createguid")) {
            new TextViewer(this, false, "new GUID", Guid.nextGuid(), true);
        } else if (e.getActionCommand().equals("base64")) {
            this.openBase64Viewer();
        } else if (e.getActionCommand().equals("regex")) {
            this.openRegexTester();
        } else if (e.getActionCommand().equals("open_file_in_new_window")) {
            this.openCurrentSelectedFileNameInNewWindow();
        } else if (e.getActionCommand().equals("ask_open_file_in_new_window")) {
            this.askForOpenCurrentSelectedFileInNewWindows();
        } else if (e.getActionCommand().equals("highlight")) {
            this.toggleWordHighlight();
        } else if (e.getActionCommand().equals("toggle_vertical")) {
            this.toggleTableViewOrientation();
        } else if (e.getActionCommand().equals("helper_to_date")) {
            this.insertToDateCode();
        } else if (e.getActionCommand().equals("helper_to_sum")) {
            this.insertSumCode();
        } else if (e.getActionCommand().equals("helper_to_max")) {
            this.insertMaxCode();
        } else if (e.getActionCommand().equals("export_talend_schema")) {
            this.exportResultTableAsTalendSchema();
        } else {
            logger.warn((Object)("unknown action " + e.getActionCommand()));
        }
    }

    private void insertToDateCode() {
        this.insertOrReplaceText("to_date('','dd.MM.yyyy')");
        this.setCaretPos(this.getCaretPos() - 15);
    }

    private void insertSumCode() {
        String column = this.editor.getSelectedText();
        if (column != null && !column.isEmpty()) {
            this.insertOrReplaceText("sum(" + column + ") as " + column);
        }
    }

    private void insertMaxCode() {
        String column = this.editor.getSelectedText();
        if (column != null && !column.isEmpty()) {
            this.insertOrReplaceText("max(" + column + ") as " + column);
        }
    }

    private void returnKeyPressedOnTable() {
        if (this.resultTable.getSelectedColumn() == 0 && this.database.isVerticalView()) {
            this.insertOrReplaceText(this.database.getColumnNameByLogicalColIndex(this.database.convertFromVerticalToLogicalColIndex(this.resultTable.getSelectedRow())));
        } else {
            this.showEditor(this.resultTable.getSelectedRow(), this.resultTable.getSelectedColumn());
        }
    }

    private void openBase64Viewer() {
        Base64Viewer base64Viewer = new Base64Viewer();
        WindowHelper.locateWindowAtMiddle(this, base64Viewer);
    }

    private void openRegexTester() {
        RegexTestFrame testFrame = new RegexTestFrame();
        WindowHelper.locateWindowAtMiddle(this, testFrame);
    }

    private void commit() {
        this.tbButtonCommit.setEnabled(false);
        this.tbButtonRollback.setEnabled(false);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LongRunningAction lra = new LongRunningAction(){

                    @Override
                    public String getName() {
                        return "Commit";
                    }

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public boolean canBeCanceled() {
                        return false;
                    }
                };
                MainFrame.addLongRunningAction(lra);
                try {
                    if (MainFrame.this.database.getDatabaseSession().commit()) {
                        MainFrame.this.status.message.setText(Messages.getString("MainFrame.114"));
                    } else {
                        MainFrame.this.showDBMessageWithoutContinueAction(MainFrame.this.database.getDatabaseSession().getLastErrorMessage(), "commit");
                    }
                    MainFrame.this.tbButtonCommit.setEnabled(true);
                    MainFrame.this.tbButtonRollback.setEnabled(true);
                }
                finally {
                    MainFrame.removeLongRunningAction(lra);
                }
            }
        }.start();
    }

    private void rollback() {
        this.tbButtonCommit.setEnabled(false);
        this.tbButtonRollback.setEnabled(false);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LongRunningAction lra = new LongRunningAction(){

                    @Override
                    public String getName() {
                        return "Rollback";
                    }

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public boolean canBeCanceled() {
                        return false;
                    }
                };
                MainFrame.addLongRunningAction(lra);
                try {
                    if (MainFrame.this.database.getDatabaseSession().rollback()) {
                        MainFrame.this.status.message.setText(Messages.getString("MainFrame.115"));
                    } else {
                        MainFrame.this.showDBMessageWithoutContinueAction(MainFrame.this.database.getDatabaseSession().getLastErrorMessage(), "rollback");
                    }
                    MainFrame.this.tbButtonCommit.setEnabled(true);
                    MainFrame.this.tbButtonRollback.setEnabled(true);
                }
                finally {
                    MainFrame.removeLongRunningAction(lra);
                }
            }
        }.start();
    }

    private void showMetaInfoDialog() {
        if (this.metaDataView == null) {
            this.metaDataView = new DatabaseMetaDataView(this.database.getDatabaseMetaData());
            WindowHelper.locateWindowAtMiddle(this, this.metaDataView);
        } else {
            this.metaDataView.setDatabaseMetaData(this.database.getDatabaseMetaData());
        }
        this.metaDataView.setVisible(true);
        this.metaDataView.setState(0);
        this.metaDataView.toFront();
    }

    private void toggleWordHighlight() {
        if (this.tbButtonHighlighter.isSelected()) {
            this.findCurrentWord();
            this.highlightCurrentWord();
        } else {
            this.lexer.setHighlightedWord(null);
        }
        this.editor.repaint();
        Main.setUserProperty("HIGHLIGHT_WORD_UNDER_CARET", String.valueOf(this.tbButtonHighlighter.isSelected()));
    }

    private void toggleTableViewOrientation() {
        if (this.database != null) {
            int viewRowIndex = this.resultTable.getSelectedRow();
            int viewColIndex = this.resultTable.getSelectedColumn();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("toggleTableViewOrientation() - viewRowIndex=" + viewRowIndex + ", viewColIndex=" + viewColIndex));
            }
            if (this.database.isVerticalView()) {
                Main.setUserProperty("TABLE_ORIENTATION", "h");
                this.tbButtonTableOrientation.setSelected(false);
                this.resultTable.setAutoResizeMode(0);
                this.database.setVerticalView(false);
                if (viewRowIndex != -1 && viewColIndex != -1) {
                    int horizontalViewRowIndex = this.database.convertFromVerticalToLogicalRowIndex(viewRowIndex);
                    int horizontalViewColIndex = this.database.convertFromVerticalToLogicalColIndex(viewRowIndex);
                    this.selectTableCell(horizontalViewRowIndex, horizontalViewColIndex);
                }
            } else {
                Main.setUserProperty("TABLE_ORIENTATION", "v");
                this.tbButtonTableOrientation.setSelected(true);
                this.resultTable.setAutoResizeMode(3);
                this.database.setVerticalView(true);
                if (viewRowIndex != -1 && viewColIndex != -1) {
                    this.selectTableCell(viewRowIndex, viewColIndex);
                }
            }
        }
    }

    public void selectTableCell(int logicalRow, int logicalCol) {
        if (this.database != null) {
            if (this.database.isVerticalView()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("selectTableCell(logicalRow=" + logicalRow + ", logicalCol=" + logicalCol + ") in verticalMode"));
                }
                int verticalViewRowIndex = this.database.convertFromLogicalToVerticalRowSelection(logicalRow) + logicalCol;
                this.resultTable.changeSelection(verticalViewRowIndex, 1, false, false);
                this.scrollTableToCell(verticalViewRowIndex);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("selectTableCell(logicalRow=" + logicalRow + ", logicalCol=" + logicalCol + ") in horizontalMode"));
                }
                this.resultTable.changeSelection(logicalRow, logicalCol, false, false);
                this.scrollTableToCell(logicalRow);
            }
        }
    }

    private void openCurrentSelectedFileNameInNewWindow() {
        MainFrame newFrame = Main.createInstance(this);
        String selectedText = this.editor.getSelectedText();
        if (selectedText != null && !(selectedText = selectedText.trim()).toLowerCase().endsWith(".sql")) {
            selectedText = selectedText + ".sql";
        }
        String path = this.getCurrentDirectory();
        String filePathAndName = selectedText;
        if (path != null) {
            filePathAndName = path + Main.FILE_SEPARATOR + filePathAndName;
        }
        newFrame.loadFileInDocument(false, filePathAndName);
    }

    public String getCurrentDirectory() {
        if (this.currentFile != null) {
            return this.currentFile.getParent();
        }
        return Main.getUserProperty("SCRIPT_DIR", System.getProperty("user.home"));
    }

    private void askForOpenCurrentSelectedFileInNewWindows() {
        MainFrame newFrame = Main.createInstance(this);
        String selectedText = this.editor.getSelectedText();
        if (selectedText != null && !(selectedText = selectedText.trim()).toLowerCase().endsWith(".sql")) {
            selectedText = selectedText + ".sql";
        }
        String path = null;
        if (this.currentFile != null) {
            path = this.currentFile.getParent();
        }
        String fileName = selectedText;
        newFrame.openFileDialog(path, fileName);
    }

    private void togglePk() {
        int columnIndex = this.database.isVerticalView() ? this.database.convertFromVerticalToLogicalColIndex(this.resultTable.getSelectedRow()) : this.resultTable.getSelectedColumn();
        this.togglePk(columnIndex);
    }

    private void togglePk(int logicalColumnIndex) {
        if (this.database.getColumnTypename(logicalColumnIndex).equals("CLOB") || this.database.getColumnTypename(logicalColumnIndex).equals("BLOB") || this.database.getColumnTypename(logicalColumnIndex).indexOf("UNKNOWN") != -1 || this.database.getColumnTypename(logicalColumnIndex).equals("LONGVARCHAR") || this.database.getColumnTypename(logicalColumnIndex).equals("LONGVARBINARY")) {
            this.showErrorMessage(Messages.getString("MainFrame.118"), Messages.getString("MainFrame.119"));
        } else {
            this.database.togglePrimaryKey(logicalColumnIndex);
            if (this.database.isVerticalView()) {
                this.resultTable.repaint();
            } else {
                this.resultTable.getTableHeader().repaint();
            }
        }
    }

    public void scrollTableToCell(int row) {
        final int y = row * this.resultTable.getRowHeight();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.tableScrollPane.getVerticalScrollBar().setValue(y);
            }
        });
    }

    public void loadFileInDocument(boolean askForSave, String filePath) {
        int answer;
        if (filePath == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        File f = new File(filePath);
        MainFrame mf = Main.findMainFrameByFile(f);
        if (mf != null && mf != this && (answer = JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.fileAlreadyLoaded"), Messages.getString("MainFrame.loadFile"), 0)) == 0) {
            mf.toFront();
            return;
        }
        answer = askForSave && this.isTextChanged() ? JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.120"), Messages.getString("MainFrame.121"), 1, 1) : 1;
        switch (answer) {
            case 0: {
                if (this.currentFile == null) {
                    this.saveAsScriptFile();
                } else {
                    this.saveScriptFile();
                }
            }
            case 1: {
                this.editor.setDocument(this.editor.getEditorKit().createDefaultDocument());
                this.currentFile = null;
                if (filePath.startsWith("file:/")) {
                    try {
                        filePath = filePath.trim();
                        URI uri = URI.create(filePath);
                        this.currentFile = new File(uri);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("LoadFileInDocument (create URI=" + filePath + ") failed: " + e.getMessage()), (Throwable)e);
                        this.showErrorMessage("create file URI " + filePath + " failed " + e.getMessage(), "load file");
                        return;
                    }
                } else {
                    this.currentFile = new File(filePath);
                }
                this.setupWindowTitle();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MainFrame.loadFileToDocument: start loader with " + this.currentFile.getPath()));
                }
                Main.setUserProperty("SCRIPT_DIR", f.getParentFile().toString());
                this.currentFileLastModified = this.currentFile.lastModified();
                this.currentFileLoaded = System.currentTimeMillis();
                FileLoader loader = new FileLoader(this.currentFile, this.editor);
                loader.start();
                this.moveSplitPaneDividerToButtom();
                this.getRootPane().putClientProperty("Window.documentFile", this.currentFile);
                break;
            }
        }
    }

    private boolean saveAsScriptFile() {
        boolean ok = false;
        try {
            JFileChooser chooser = new JFileChooser();
            if (this.currentFile != null) {
                if (this.currentFile.getParentFile() != null) {
                    chooser.setCurrentDirectory(this.currentFile.getParentFile());
                    chooser.setSelectedFile(this.currentFile);
                }
            } else {
                String directory = Main.getUserProperty("SCRIPT_DIR", System.getProperty("user.home"));
                chooser.setCurrentDirectory(new File(directory));
            }
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Messages.getString("MainFrame.122"));
            chooser.addChoosableFileFilter(this.sqlFileFilter);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                if (chooser.getFileFilter() == this.sqlFileFilter && !f.getName().toLowerCase().endsWith(".sql")) {
                    f = new File(f.getAbsolutePath() + ".sql");
                }
                Main.setUserProperty("SCRIPT_DIR", f.getParentFile().toString());
                this.currentFile = f;
                ok = this.saveScriptFile();
            }
        }
        catch (AccessControlException ae) {
            this.status.message.setText(Messages.getString("MainFrame.123"));
            this.currentFile = null;
        }
        return ok;
    }

    private boolean saveScriptFile() {
        int answer;
        boolean ok = false;
        long lastModifiedOfStoredFile = Main.getLastModified(this.currentFile);
        if (lastModifiedOfStoredFile > 0L && lastModifiedOfStoredFile > this.currentFileLoaded && this.currentFileLoaded > 0L && (answer = JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.fileisnewer"), Messages.getString("MainFrame.122"), 0)) == 1) {
            return false;
        }
        int caretPos = this.editor.getCaretPosition();
        this.editor.select(caretPos, caretPos);
        this.editor.setEditable(false);
        Document doc = this.editor.getDocument();
        try {
            this.undoManager.discardAllEdits();
            this.updateUndoRedoEnabled();
            this.setupWindowTitle();
            File bak = null;
            if (this.currentFile.exists() && Main.getDefaultProperty("CREATE_BACKUP_FILES", "false").equals("true")) {
                bak = new File(this.currentFile.getPath() + ".bak");
                if (bak.exists()) {
                    if (bak.delete()) {
                        if (this.currentFile.renameTo(bak)) {
                            logger.error((Object)"couldn't rename to bak");
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("MainFrame.saveScriptFile: delete old backup " + bak + Messages.getString("MainFrame.126")));
                        }
                        JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.127") + bak + Messages.getString("MainFrame.128") + Messages.getString("MainFrame.129"), Messages.getString("MainFrame.130"), -1, 2);
                        bak = null;
                    }
                } else if (!this.currentFile.renameTo(bak)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("saveScriptFile: error while renaming original file:" + this.currentFile.getPath() + "saveScriptFile:" + bak.getPath()));
                    }
                    JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.133") + bak + Messages.getString("MainFrame.134"), Messages.getString("MainFrame.135"), -1, 2);
                    bak = null;
                }
            } else {
                bak = this.currentFile;
            }
            this.bwFile = Main.currentCharSet != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFile), Main.currentCharSet)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.currentFile)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("save file: " + this.currentFile.getPath()));
            }
            StringBuffer text = new StringBuffer(doc.getText(0, doc.getLength()));
            try {
                int pos = 0;
                while ((pos = text.indexOf("\n", pos)) != -1) {
                    text.replace(pos, pos + 1, Main.currentLineSeparator);
                    pos += Main.currentLineSeparator.length();
                }
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            this.bwFile.write(text.toString());
            this.bwFile.close();
            this.currentFileLoaded = this.currentFileLastModified = System.currentTimeMillis();
            this.bwFile = null;
            ok = true;
            if (bak == null) {
                this.status.message.setText(Messages.getString("MainFrame.136") + this.currentFile.getName() + Messages.getString("MainFrame.137") + Messages.getString("MainFrame.138"));
            } else if (Main.getDefaultProperty("CREATE_BACKUP_FILES", "false").equals("true")) {
                this.status.message.setText(Messages.getString("MainFrame.139") + this.currentFile.getName() + Messages.getString("MainFrame.140") + Messages.getString("MainFrame.141"));
            } else {
                this.status.message.setText(Messages.getString("MainFrame.142") + this.currentFile.getName() + Messages.getString("MainFrame.143") + Messages.getString("MainFrame.144"));
            }
            if (this.currentFile.getName().endsWith(".cfg")) {
                this.showInfoMessage(Messages.getString("MainFrame.145"), Messages.getString("MainFrame.146"));
            } else {
                Main.addFileProp(this.currentFile);
            }
            this.setTextSaveEnabled(false);
        }
        catch (BadLocationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("saveScriptFile: " + e.toString()));
            }
            this.status.message.setText(Messages.getString("MainFrame.147") + this.currentFile.getPath());
        }
        catch (IOException e) {
            logger.warn((Object)("saveScriptFile: " + e.toString()));
            this.status.message.setText(Messages.getString("MainFrame.148") + this.currentFile.getPath());
        }
        catch (AccessControlException ae) {
            logger.warn((Object)("saveScriptFile: " + ae.getMessage()));
            this.status.message.setText(Messages.getString("MainFrame.149"));
        }
        this.editor.setEditable(true);
        return ok;
    }

    private boolean menuScriptNew_actionPerformed() {
        boolean newDocCreated = false;
        int answer = this.isTextChanged() ? JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.150"), Messages.getString("MainFrame.151"), 1, 1) : 1;
        switch (answer) {
            case 0: {
                if (this.currentFile == null) {
                    this.saveAsScriptFile();
                } else {
                    this.saveScriptFile();
                }
            }
            case 1: {
                this.setupNewDocumentWithListenersAndUndoRedo();
                this.setupWindowTitle();
                this.status.message.setText(Messages.getString("MainFrame.152"));
                newDocCreated = true;
                this.currentFileLoaded = 0L;
                break;
            }
            default: {
                newDocCreated = false;
            }
        }
        return newDocCreated;
    }

    private void menuScriptOpen_actionPerformed() {
        int answer = this.isTextChanged() ? JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.153"), Messages.getString("MainFrame.154"), 1, 1) : 1;
        if (this.currentFile != null) {
            switch (answer) {
                case 0: {
                    this.saveScriptFile();
                    break;
                }
                case 1: {
                    this.setTextSaveEnabled(false);
                }
            }
        }
        if (answer != 2 && answer != -1) {
            if (this.currentFile != null && this.currentFile.getPath() != null) {
                this.openFileDialog(this.currentFile.getPath(), this.currentFile.getName());
            } else {
                this.openFileDialog(null, null);
            }
        }
    }

    public void openFileDialog(String directoryName, String selectFileName) {
        JFileChooser chooser = new JFileChooser();
        if (directoryName != null) {
            chooser.setCurrentDirectory(new File(directoryName));
        } else {
            String directory = Main.getUserProperty("SCRIPT_DIR", System.getProperty("user.home"));
            chooser.setCurrentDirectory(new File(directory));
        }
        if (selectFileName != null) {
            chooser.setSelectedFile(new File(selectFileName));
        }
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("MainFrame.155"));
        chooser.addChoosableFileFilter(this.sqlFileFilter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            this.loadFileInDocument(false, f.getAbsolutePath());
        }
    }

    private void menuScriptSave_actionPerformed() {
        if (this.currentFile != null) {
            this.saveScriptFile();
        } else {
            this.saveAsScriptFile();
        }
    }

    private void menuScriptSaveas_actionPerformed() {
        this.saveAsScriptFile();
    }

    private void menuScriptInfo_actionPerformed() {
        new FileInfo(this);
    }

    public boolean isConnectedAndReady() {
        boolean isReady = false;
        if (this.database != null && this.database.getDatabaseSession().isConnected() && !this.isDatabaseBusy()) {
            isReady = true;
        }
        return isReady;
    }

    public boolean close() {
        boolean exitEnabled;
        block10: {
            exitEnabled = false;
            int answer = this.isCloseActionDisabled() ? JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.wantAbort"), Messages.getString("MainFrame.close"), 0, 1) : 0;
            block0 : switch (answer) {
                case 1: {
                    break;
                }
                case 0: {
                    if (this.isTextChanged()) {
                        Object[] options = new Object[]{Messages.getString("MainFrame.yes"), Messages.getString("MainFrame.no"), Messages.getString("MainFrame.none"), Messages.getString("MainFrame.cancel")};
                        answer = JOptionPane.showOptionDialog(this, Messages.getString("MainFrame.savebefore"), Messages.getString("MainFrame.close"), 1, 1, null, options, options[1]);
                    } else {
                        answer = 1;
                    }
                    switch (answer) {
                        case 0: {
                            if (!this.saveAsScriptFile()) break block10;
                        }
                        case 1: 
                        case 2: {
                            exitEnabled = true;
                            this.closeWithoutQuestion();
                            break block0;
                        }
                    }
                }
            }
        }
        return exitEnabled;
    }

    public void closeWithoutQuestion() {
        if (this.database != null && this.database.getDatabaseSession().isConnected()) {
            if (dmFrame != null) {
                dmFrame.removeSQLDataModel(this.database.getSQLDataModel());
            }
            final Database oldDatebase = this.database;
            this.database = null;
            Thread closeThread = new Thread(){

                @Override
                public void run() {
                    oldDatebase.close();
                }
            };
            closeThread.start();
        }
        if (this.atc != null) {
            this.atc.dispose();
        }
        if (this.exportResultTableDialog != null) {
            this.exportResultTableDialog.dispose();
        }
        if (this.metaDataView != null) {
            this.metaDataView.dispose();
        }
        if (this.dbLogin != null) {
            this.dbLogin.dispose();
        }
        if (this.preferencesDialog != null) {
            this.preferencesDialog.dispose();
        }
        if (this.dlgSeRe != null) {
            this.dlgSeRe.dispose();
        }
        if (this.tableSearchDialog != null) {
            this.tableSearchDialog.dispose();
        }
        if (this.dlgGo != null) {
            this.dlgGo.dispose();
        }
        if (this.dlgAbout != null) {
            this.dlgAbout.dispose();
        }
        Main.close(this);
    }

    private void menuDBAdmin_actionPerformed() {
        if (this.atc == null) {
            this.atc = new AdminToolChooser(this);
        }
        this.atc.setVisible(true);
        this.atc.setState(0);
        this.atc.toFront();
        this.atc.fillList();
    }

    private void menuDBExportResultTable_actionPerformed() {
        if (this.database != null && this.database.size() > 0) {
            if (this.exportResultTableDialog == null) {
                this.exportResultTableDialog = new ResultTableExportDialog(this);
            }
            this.exportResultTableDialog.setVisible(true);
            WindowHelper.locateWindowAtMiddle(this, this.exportResultTableDialog);
        } else {
            this.showInfoMessage(Messages.getString("MainFrame.164"), Messages.getString("MainFrame.165"));
        }
    }

    private void menuDBExportDBTable_actionPerformed() {
        QueryExportFrame frame = new QueryExportFrame(this);
        frame.setVisible(true);
        WindowHelper.locateWindowAtMiddle(this, frame);
    }

    private void openCSVImportDialog(File file) {
        ImportConfiguratorFrame configurator = new ImportConfiguratorFrame(this.database);
        configurator.setVisible(true);
        WindowHelper.locateWindowAtMiddle(this, configurator);
        if (file != null) {
            configurator.handleFile(file);
        }
    }

    private void menuDBXmlExport_actionPerformed() {
        new ExporterFrame(this.database.getDatabaseSession().getConnectionDescription(), this);
    }

    private void menuDBXmlImport_actionPerformed() {
        new ImporterFrame(this);
    }

    private void menuDBSearchInTable_actionPerformed() {
        if (this.tableSearchDialog == null) {
            this.tableSearchDialog = new TableSearchDialog(this);
        }
        WindowHelper.locateWindowAtMiddle(this, this.tableSearchDialog);
        this.tableSearchDialog.setVisible(true);
        this.tableSearchDialog.setState(0);
        this.tableSearchDialog.toFront();
    }

    public void startConnect(ConnectionDescription cd) {
        int timeout;
        this.status.message.setText(Messages.getString("MainFrame.166"));
        this.database = new Database(this.resultTable, this);
        this.status.setTablename(null);
        this.database.setConnectionDescription(cd);
        this.database.setVerticalView(this.tbButtonTableOrientation.isSelected());
        this.setProductive(cd.isProductive());
        this.setGuiToConnected(false);
        try {
            timeout = Integer.parseInt(Main.getDefaultProperty("CONNECT_TIMEOUT", "5000"));
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)("MainFrame.connect: ERROR by parsing default CONNECT_TIMEOUT-value:" + Main.getDefaultProperty("CONNECT_TIMEOUT")));
            timeout = 5000;
        }
        DatabaseSession.setTimeout(timeout);
        this.stopConnecting();
        this.connectThread = new ConnectThread();
        this.connectThread.start();
    }

    private void stopConnecting() {
        if (this.connectThread != null && this.connectThread.isAlive()) {
            this.setStatusMessage("Cancel connecting...");
            this.connectThread.interrupt();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.connectThread.isAlive()) {
                this.connectThread.stop();
            }
            this.setGuiToConnected(false);
            this.setStatusMessage("Connecting cancelled");
        }
    }

    private void menuDBOpen_actionPerformed() {
        if (Main.startUpCd != null) {
            this.startConnect(Main.startUpCd);
        } else {
            this.openLoginDialog(null);
        }
    }

    public void openLoginDialog(ConnectionDescription initialCd) {
        if (this.dbLogin == null) {
            this.dbLogin = new DBLoginDialog(this, Messages.getString("MainFrame.167"));
        }
        if (initialCd != null) {
            this.dbLogin.setInitialConnectionDescription(initialCd);
        }
        this.dbLogin.setVisible(true);
        this.editor.requestFocus();
        if (this.dbLogin.getReturnAction() == 0) {
            this.startConnect(this.dbLogin.getConnectionDescription());
        }
    }

    private void setConnectInProgress() {
        this.menuDBAbortConnecting.setEnabled(true);
        this.menuDBOpen.setEnabled(false);
        this.menuDBReconnect.setEnabled(false);
        this.menuDBClose.setEnabled(false);
        this.tbButtonDbOpen.setEnabled(false);
        this.tbButtonDbClose.setEnabled(false);
    }

    private void updateExplainState(boolean sqlEnabled) {
        if (sqlEnabled && this.database != null && this.database.isConnected()) {
            boolean canExplain = this.database.getDatabaseExtension().hasExplainFeature();
            this.tbButtonExplain.setEnabled(canExplain);
            this.menuDBExplain.setEnabled(canExplain);
        } else {
            this.tbButtonExplain.setEnabled(false);
            this.menuDBExplain.setEnabled(false);
        }
    }

    public boolean isConnected() {
        boolean ok = false;
        if (this.database != null && this.database.getDatabaseSession() != null && this.database.getDatabaseSession().isConnected()) {
            ok = true;
        }
        return ok;
    }

    private void doConnect() {
        this.disposeAllViewer();
        if (this.database.loadDriver()) {
            this.setConnectInProgress();
            if (this.database.connect()) {
                DataModelFrame.getDataModelFrame().addSQLDatamodel(this.database.getSQLDataModel());
                if (!this.database.getDatabaseSession().setAutoCommit(this.menuDBAutoCommitCheckBox.isSelected())) {
                    this.showInfoMessage(this.database.getDatabaseSession().getLastErrorMessage(), "auto-commit");
                    if (this.menuDBAutoCommitCheckBox.isSelected()) {
                        this.menuDBAutoCommitCheckBox.setSelected(false);
                    } else {
                        this.menuDBAutoCommitCheckBox.setSelected(true);
                    }
                }
                this.setStatusMessage(Messages.getString("MainFrame.168"));
                this.status.infoAction.setText("CONN");
                this.setGuiToConnected(true);
                this.setTableSearchEnabled(true);
                if (this.atc != null) {
                    this.atc.fillList();
                }
            } else {
                this.showDBMessageWithoutContinueAction(this.database.getDatabaseSession().getLastErrorMessage(), Messages.getString("MainFrame.169"));
                this.status.message.setText(Messages.getString("MainFrame.170"));
                this.setGuiToConnected(false);
            }
        } else {
            this.showDBMessageWithoutContinueAction(this.database.getDatabaseSession().getLastErrorMessage(), Messages.getString("MainFrame.171"));
            this.status.message.setText(Messages.getString("MainFrame.172"));
        }
        this.setupWindowTitle();
        if (dmFrame != null && dmFrame.isVisible() && dmFrame.getModelCount() == 1) {
            dmFrame.setMainFrame(this);
            dmFrame.selectCurrentSchema();
        }
    }

    private void startRunTimer() {
        this.runTimerStartTime = System.currentTimeMillis();
        this.runTimer = new Timer(500, new ActionListener(){
            private NumberFormatter nf = new NumberFormatter();

            @Override
            public void actionPerformed(ActionEvent e) {
                long seconds = (System.currentTimeMillis() - MainFrame.this.runTimerStartTime) / 1000L;
                try {
                    MainFrame.this.status.tablePos.setText(this.nf.valueToString(seconds) + "s");
                }
                catch (ParseException e1) {
                    logger.error((Object)e1);
                }
            }
        });
        this.runTimer.start();
    }

    private void stopRunTimer() {
        if (this.runTimer != null) {
            this.runTimer.stop();
        }
    }

    public void start(String sql) {
        this.start(sql, false);
    }

    public void start(String sql, boolean hideText) {
        if (hideText) {
            if (this.database != null) {
                this.database.executeStatement(new SQLStatement(sql));
            }
        } else {
            this.setScriptTextAsNewDocument(sql);
            this.setTextSaveEnabled(false);
            if (this.isConnected() && this.menuDBRun.isEnabled()) {
                this.runScript();
            } else {
                this.startRunOnLoad = true;
            }
        }
    }

    public void cancelStatement() {
        this.setDatabaseBusyFiltered(true, "Aborting...");
        this.tbButtonStop.setEnabled(false);
        Thread cancelThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (MainFrame.this.executerThread != null) {
                    MainFrame.this.executerThread.interrupt();
                }
                MainFrame.this.setDatabaseBusyFiltered(false, "Aborted");
            }
        });
        cancelThread.setDaemon(true);
        cancelThread.start();
    }

    public void setUseForFKNavigation(boolean useForFKNavigation) {
        this.usedForFKNavigation = useForFKNavigation;
    }

    public boolean isUsedForFKNavigation() {
        return this.usedForFKNavigation;
    }

    public void setTableSearchEnabled(boolean enabled) {
        this.menuDBSearchInTable.setEnabled(enabled);
        this.tbButtonTableSearch.setEnabled(enabled);
    }

    private void menuEditParse_actionPerformed() {
        SQLParser parser = new SQLParser(this.getText(), this.menuDBDisableParserCheckBox.isSelected());
        for (int i = 0; i < parser.getStatements().size(); ++i) {
            sqlHistory.addBatch(parser.getStatements().get(i), false);
        }
        sqlHistory.setFreezed(true);
    }

    private void runExplain() {
        String text = this.editor.getSelectedText();
        if (text == null || text.trim().length() < 2) {
            text = this.getText();
        }
        if (text.trim().length() > 1) {
            this.runScript(this.database.getDatabaseExtension().getExplainSQL(text), true, 0);
        } else {
            logger.warn((Object)"No text found to parse and explain");
        }
    }

    private void runScript() {
        String text = this.editor.getSelectedText();
        int textOffset = 0;
        if (text == null || text.trim().length() < 2) {
            text = this.getText();
        } else {
            textOffset = this.editor.getSelectionStart();
        }
        this.runScript(text, false, textOffset);
    }

    private void runScript(final String text, final boolean noMetaData, final int textOffset) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("runScript text=" + text));
        }
        if (text.trim().length() > 1) {
            this.executerThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SQLParser parser = new SQLParser();
                    parser.disableParser(MainFrame.this.menuDBDisableParserCheckBox.isSelected());
                    MainFrame.this.setDatabaseBusy(true, "Parse script...");
                    parser.parseScript(text, textOffset);
                    MainFrame.this.setDatabaseBusy(true, "Configure script...");
                    if (parser.getStatements().size() == 0) {
                        MainFrame.this.setDatabaseBusy(false, "Execute script ends not successful: No statements found");
                        return;
                    }
                    boolean setupSuccessful = false;
                    for (int i = 0; i < parser.getStatements().size(); ++i) {
                        SQLStatement stat = parser.getStatements().get(i);
                        if (stat.isPrepared()) {
                            SQLPSParamConfigurer configurer = new SQLPSParamConfigurer(MainFrame.this, stat);
                            WindowHelper.checkAndCorrectWindowBounds(configurer);
                            configurer.setVisible(true);
                            boolean bl = setupSuccessful = configurer.getReturnCode() == 0;
                            if (setupSuccessful) continue;
                            break;
                        }
                        setupSuccessful = true;
                    }
                    if (setupSuccessful) {
                        MainFrame.this.setDatabaseBusy(true, "Execute script...");
                        MainFrame.this.startRunTimer();
                        try {
                            int preferredWidth = MainFrame.this.tableScrollPane.getWidth() - 10;
                            MainFrame.this.database.setPreferredColumnWidthSum(preferredWidth);
                            MainFrame.this.database.executeScript(parser, noMetaData);
                        }
                        finally {
                            MainFrame.this.stopRunTimer();
                        }
                    } else {
                        MainFrame.this.setDatabaseBusy(false, "Execute script ends not successful");
                    }
                }

                @Override
                public void interrupt() {
                    super.interrupt();
                    MainFrame.this.database.cancel();
                }
            };
            this.executerThread.start();
        } else {
            logger.warn((Object)"No text found to parse and run");
        }
    }

    public String getSelectedText() {
        return this.editor.getSelectedText();
    }

    private void menuDBHistory_actionPerformed() {
        WindowHelper.locateWindowAtRightSideWithin(this, sqlHistory, 0);
        sqlHistory.setVisible(true);
        sqlHistory.setState(0);
        sqlHistory.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDisconnect() {
        block7: {
            try {
                if (this.database == null) break block7;
                if (dmFrame != null) {
                    try {
                        dmFrame.removeSQLDataModel(this.database.getSQLDataModel());
                    }
                    catch (Throwable t) {
                        logger.error((Object)("removeSQLDataModel failed: " + t.getMessage()), t);
                    }
                }
                final Database oldDatabase = this.database;
                Thread closeThread = new Thread(){

                    @Override
                    public void run() {
                        if (oldDatabase.close()) {
                            MainFrame.this.status.message.setText(Messages.getString("MainFrame.173"));
                            MainFrame.this.status.infoAction.setText("DISC");
                        } else {
                            MainFrame.this.showDBMessage(MainFrame.this.database.getDatabaseSession().getLastErrorMessage(), Messages.getString("MainFrame.174"));
                            MainFrame.this.status.message.setText(Messages.getString("MainFrame.175"));
                            MainFrame.this.status.infoAction.setText("DISC");
                        }
                    }
                };
                closeThread.start();
                if (this.atc != null) {
                    this.atc.clearList();
                }
            }
            finally {
                this.setGuiToConnected(false);
                this.setupWindowTitle();
            }
        }
    }

    protected void startReconnect() {
        if (this.database != null) {
            this.setGuiToConnected(false);
            final Database db = this.database;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    db.close();
                    if (db.connect()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainFrame.this.setGuiToConnected(true);
                            }
                        });
                    }
                }
            };
            thread.start();
        }
        this.setupWindowTitle();
    }

    private void menuDBDatamodel_actionPerformed() {
        dmFrame.setVisible(true);
        dmFrame.setState(0);
        dmFrame.toFront();
        Rectangle r = WindowHelper.getCurrentScreenBounds(this);
        System.out.println(r);
        WindowHelper.locateAtRightSideOfScreen(r, dmFrame);
        dmFrame.setMainFrame(this);
        dmFrame.selectCurrentSchema();
    }

    public ConnectionDescription getCurrentConnectionDescription() {
        if (this.database != null && this.database.getDatabaseSession() != null) {
            return this.database.getDatabaseSession().getConnectionDescription();
        }
        return null;
    }

    public SQLDataModel getCurrentDataModel() {
        if (this.database != null) {
            return this.database.getDataModel();
        }
        return null;
    }

    private void menuEditUndo_actionPerformed() {
        this.undoManager.undo();
        this.updateUndoRedoEnabled();
    }

    private void menuEditRedo_actionPerformed() {
        this.undoManager.redo();
        this.updateUndoRedoEnabled();
    }

    private void menuEditCut_actionPerformed() {
        this.editor.cut();
    }

    private void menuEditCopy_actionPerformed() {
        this.editor.copy();
    }

    private void menuEditConvertSqlToJavaString_actionPerformed() {
        String javaCode = SQLCodeGenerator.convertSqlToJavaString(this.getText());
        if (textViewer == null) {
            textViewer = new TextViewer(this, Messages.getString("MainFrame.176"), javaCode, true);
        } else {
            textViewer.setText(javaCode);
            textViewer.selectAllText();
        }
        textViewer.setToolTipText(Messages.getString("MainFrame.177"));
        textViewer.setVisible(true);
        textViewer.toFront();
    }

    private void menuEditConvertSqlToJavaStringBuffer_actionPerformed() {
        String stringBufferVarName = Main.getUserProperty("STRINGBUFFER_NAME", "sql");
        stringBufferVarName = JOptionPane.showInputDialog(this, Messages.getString("MainFrame.179"), stringBufferVarName);
        if (stringBufferVarName != null) {
            Main.setUserProperty("STRINGBUFFER_NAME", stringBufferVarName);
            String javaCode = SQLCodeGenerator.convertSqlToJavaStringBuffer(this.getText(), stringBufferVarName);
            if (textViewer == null) {
                textViewer = new TextViewer(this, Messages.getString("MainFrame.180"), javaCode, true);
            } else {
                textViewer.setText(javaCode);
                textViewer.selectAllText();
            }
            textViewer.setToolTipText(Messages.getString("MainFrame.181"));
            textViewer.setVisible(true);
            textViewer.toFront();
        }
    }

    private void menuEditCommentParams_actionPerformed() {
        this.editor.setText(SQLParser.commentPSParameter(this.editor.getText()));
    }

    private void menuEditRemoveParamComments_actionPerformed() {
        this.editor.setText(SQLParser.removePSComments(this.editor.getText()));
    }

    private void menuEditRemoveAllComments_actionPerformed() {
        this.editor.setText(SQLParser.removeAllComments(this.editor.getText()));
    }

    private void menuEditConvertJavaToSql_actionPerformed() {
        this.setTextSaveEnabled(false);
        this.setScriptTextAsNewDocument(SQLCodeGenerator.convertJavaToSqlCode(this.editor.getText()));
    }

    private void menuEditPaste_actionPerformed() {
        try {
            this.editor.paste();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Failed to paste content", 0);
            logger.error((Object)("Failed to paste content: " + e.getMessage()), (Throwable)e);
        }
    }

    private void menuEditPasteSmart_actionPerformed() {
        try {
            Clipboard clipboard = this.getClipboard();
            String text = (String)clipboard.getData(DataFlavor.stringFlavor);
            if (text != null && !text.isEmpty()) {
                this.editor.copyTextIntoLinesSmart(text);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Failed to paste content", 0);
            logger.error((Object)("Failed to paste content: " + e.getMessage()), (Throwable)e);
        }
    }

    private Clipboard getClipboard() {
        Clipboard c = null;
        try {
            c = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            logger.warn((Object)("Clipboard is not accessable:" + e.getMessage()));
        }
        return c;
    }

    private void menuEditInsertInsertStat_actionPerformed() {
        String s = this.database.createInsertStatementText();
        if (s != null) {
            this.insertOrReplaceText(s);
        } else {
            this.showInfoMessage(Messages.getString("MainFrame.182"), Messages.getString("MainFrame.183"));
        }
    }

    private void menuEditInsertSelectStat_actionPerformed() {
        String s = this.database.createSelectStatementText();
        if (s != null) {
            this.insertOrReplaceText(s);
        } else {
            this.showInfoMessage(Messages.getString("MainFrame.184"), Messages.getString("MainFrame.185"));
        }
    }

    private void menuEditInsertTablename_actionPerformed() {
        if (this.database != null && this.database.getTableName() != null) {
            this.insertOrReplaceText(this.database.getTableName());
        }
    }

    private void menuEditReplace_actionPerformed() {
        if (this.dlgSeRe == null) {
            this.dlgSeRe = new SearchReplaceDialog(this, false, this.editor);
        }
        WindowHelper.locateWindowAtMiddle(this, this.dlgSeRe);
        this.dlgSeRe.setVisible(true);
    }

    private void menuEditGoto_actionPerformed() {
        if (this.dlgGo == null) {
            this.dlgGo = new GotoLineDialog((Frame)this, Messages.getString("MainFrame.186"), this.editor);
        }
        WindowHelper.locateWindowAtMiddle(this, this.dlgGo);
        this.dlgGo.setVisible(true);
    }

    private void menuEditSyntaxhighCheckBox_actionPerformed() {
        if (this.lexer != null) {
            if (this.menuEditSyntaxhighCheckBox.isSelected()) {
                this.lexer.setEnabled(true);
                Main.setUserProperty("SYNTAX_HIGHLIGHT", "true");
            } else {
                this.lexer.setEnabled(false);
                Main.setUserProperty("SYNTAX_HIGHLIGHT", "false");
            }
        }
        this.editor.repaint();
    }

    private void menuEditRestoreCfg_actionPerformed() {
        int answer = JOptionPane.showConfirmDialog(this, Messages.getString("MainFrame.187"), Messages.getString("MainFrame.188"), 0, 1);
        switch (answer) {
            case 0: {
                Main.createDefaultAdminCfgFile();
                Main.createDefaultDbCfgFile();
                Main.createDefaultHLCfgFile();
                Main.createDefaultProp();
                this.showInfoMessage(Messages.getString("MainFrame.189"), Messages.getString("MainFrame.190"));
            }
        }
    }

    private void menuEditPreferences_actionPerformed() {
        if (this.preferencesDialog != null) {
            this.preferencesDialog.dispose();
            this.preferencesDialog = null;
        }
        this.preferencesDialog = new PreferencesDialog(this);
        WindowHelper.locateWindowAtMiddle(this, this.preferencesDialog);
        this.preferencesDialog.setVisible(true);
    }

    public void openPreferencesDialog() {
        this.menuEditPreferences_actionPerformed();
    }

    private void menuDBAutoCommitCheckBox_actionPerformed() {
        if (this.menuDBAutoCommitCheckBox.isSelected()) {
            Main.setUserProperty("AUTO_COMMIT", "true");
            this.enableCommitRollback(false);
        } else {
            Main.setUserProperty("AUTO_COMMIT", "false");
            this.enableCommitRollback(true);
        }
        if (this.database != null && this.database.getDatabaseSession().isConnected()) {
            this.database.getDatabaseSession().setAutoCommit(this.menuDBAutoCommitCheckBox.isSelected());
        }
    }

    private void menuHelpAbout_actionPerformed() {
        if (this.dlgAbout != null) {
            this.dlgAbout.dispose();
            this.dlgAbout = null;
        }
        this.dlgAbout = new AboutDialog(this);
        WindowHelper.locateWindowAtMiddle(this, this.dlgAbout);
        this.dlgAbout.setModal(false);
        this.dlgAbout.setVisible(true);
        this.repaint();
    }

    public void openAboutDialog() {
        this.menuHelpAbout_actionPerformed();
    }

    private String createTabReplacement() {
        StringBuffer tabErsatz_loc = new StringBuffer();
        int a = Integer.parseInt(Main.getDefaultProperty(Messages.getString("MainFrame.196"), "4"));
        for (int i = 0; i < a; ++i) {
            tabErsatz_loc.append(" ");
        }
        return tabErsatz_loc.toString();
    }

    public void showInfoMessage(String message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    public void showErrorMessage(String message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    public void showWarningMessage(String message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 2);
    }

    public int showDBMessage(String message, String title) {
        DBMessageDialog md = new DBMessageDialog(this, message, title);
        int returnCode = md.getReturnCode();
        md.cancel();
        return returnCode;
    }

    public int showDBMessageWithoutContinueAction(String message, String title) {
        DBMessageDialog md = new DBMessageDialog(this, message, title, false);
        int returnCode = md.getReturnCode();
        md.cancel();
        return returnCode;
    }

    public String showInputDialog(String message, String title, String initValue) {
        return (String)JOptionPane.showInputDialog(this, message, title, 1, null, null, initValue);
    }

    private String findCurrentWord() {
        this.currentWord = "";
        String line = "";
        if (this.currentLineEndOffset > this.currentLineStartOffset) {
            try {
                line = this.editor.getText(this.currentLineStartOffset, this.currentLineEndOffset - this.currentLineStartOffset - 1);
            }
            catch (BadLocationException e) {
                logger.error((Object)("findCurrentWord failed:" + e.getMessage()), (Throwable)e);
            }
        }
        int findStartPos = this.currentOffsetInCurrLine;
        if (line.length() > 0) {
            int endIndex;
            int startIndex;
            block10: {
                startIndex = findStartPos;
                if (startIndex > 0) {
                    char c;
                    while (Character.isJavaIdentifierPart(c = line.charAt(--startIndex))) {
                        if (startIndex != 0) continue;
                        break block10;
                    }
                    ++startIndex;
                }
            }
            if ((endIndex = findStartPos) < line.length()) {
                char c;
                while (Character.isJavaIdentifierPart(c = line.charAt(endIndex)) && ++endIndex != line.length()) {
                }
            }
            if (startIndex < endIndex) {
                this.startPosOfCurrentWord = startIndex + this.currentLineStartOffset;
                this.currentWord = line.substring(startIndex, endIndex);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("findCurrentWord word:<" + this.currentWord + "> findStartPos:" + findStartPos));
                }
            }
        }
        return this.currentWord;
    }

    private String getText(int lineNumber) {
        int endIndex;
        Document doc = this.editor.getDocument();
        Element root = doc.getDefaultRootElement();
        Element currElem = root.getElement(lineNumber);
        int startIndex = currElem.getStartOffset();
        if (startIndex < (endIndex = currElem.getEndOffset())) {
            try {
                return this.editor.getText(startIndex, endIndex - startIndex - 1);
            }
            catch (BadLocationException e) {
                logger.error((Object)("selectCurrentBlock failed: " + e.getMessage()), (Throwable)e);
            }
        }
        return "";
    }

    private void selectCurrentBlock() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("selectCurrentBlock start in line number " + this.currentLineNumber));
        }
        int cp = this.currentLineNumber;
        while (true) {
            String currentLineText;
            if ((currentLineText = this.getText(cp)).trim().isEmpty()) {
                ++cp;
                break;
            }
            if (cp <= 0) break;
            --cp;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("selectCurrentBlock found start line number: " + cp));
        }
        int startElementIndex = cp;
        Document doc = this.editor.getDocument();
        Element root = doc.getDefaultRootElement();
        int elementCount = root.getElementCount();
        for (cp = this.currentLineNumber; cp < elementCount; ++cp) {
            String currentLineText = this.getText(cp);
            if (!currentLineText.trim().isEmpty()) continue;
            --cp;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("selectCurrentBlock found end line number: " + cp));
        }
        int endElementIndex = cp;
        Element e = root.getElement(startElementIndex);
        if (e != null) {
            int startSelectPos = e.getStartOffset();
            if (endElementIndex == elementCount) {
                --endElementIndex;
            }
            int endSelectionPos = root.getElement(endElementIndex).getEndOffset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("selectCurrentBlock select " + startSelectPos + ":" + endSelectionPos));
            }
            this.editor.select(startSelectPos, endSelectionPos - 1);
        }
    }

    private String getWordAtPos(String text, int findStartPos) {
        String word = "";
        char c = text.charAt(findStartPos);
        if (Character.isLowerCase(c) || Character.isUpperCase(c) || Character.isDigit(c) || c == '_') {
            int searchIndex;
            int endIndex;
            int startIndex;
            block8: {
                block7: {
                    startIndex = -1;
                    endIndex = -1;
                    searchIndex = findStartPos;
                    while (Character.isUpperCase(c = text.charAt(searchIndex)) || Character.isLowerCase(c) || Character.isDigit(c) || c == '_') {
                        if (searchIndex > 0) {
                            --searchIndex;
                            continue;
                        }
                        break block7;
                    }
                    ++searchIndex;
                }
                startIndex = searchIndex;
                searchIndex = findStartPos;
                while (Character.isUpperCase(c = text.charAt(searchIndex)) || Character.isLowerCase(c) || Character.isDigit(c) || c == '_') {
                    if (searchIndex < text.length() - 1) {
                        ++searchIndex;
                        continue;
                    }
                    break block8;
                }
                --searchIndex;
            }
            endIndex = searchIndex;
            if (startIndex >= 0 && startIndex <= endIndex) {
                word = text.substring(startIndex, endIndex + 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("findCurrentWord word:" + this.currentWord + " findStartPos:" + findStartPos));
                }
            }
        }
        return word;
    }

    private void highlightCurrentWord() {
        if (!this.currentWord.isEmpty()) {
            this.lexer.setHighlightedWord(this.currentWord);
            this.editor.repaint();
        }
        if (this.syntaxChooser != null) {
            this.syntaxChooser.setSearchTerm(this.currentWord);
        }
    }

    private void updateUndoRedoEnabled() {
        if (this.undoManager.canUndo()) {
            this.tbButtonUndo.setEnabled(true);
            this.menuEditUndo.setEnabled(true);
        } else {
            this.tbButtonUndo.setEnabled(false);
            this.menuEditUndo.setEnabled(false);
        }
        if (this.undoManager.canRedo()) {
            this.tbButtonRedo.setEnabled(true);
            this.menuEditRedo.setEnabled(true);
        } else {
            this.tbButtonRedo.setEnabled(false);
            this.menuEditRedo.setEnabled(false);
        }
    }

    public void setGuiToConnected(boolean enable) {
        this.tbButtonRun.setEnabled(enable);
        this.menuDBRun.setEnabled(enable);
        this.menuDBAdmin.setEnabled(enable);
        this.menuDBOpen.setEnabled(!enable);
        this.menuDBReconnect.setEnabled(enable);
        this.menuDBClose.setEnabled(enable);
        this.tbButtonDbOpen.setEnabled(!enable);
        this.tbButtonDbClose.setEnabled(enable);
        this.menuDBCsvExportDBTable.setEnabled(enable);
        this.menuDBCreateNewRow.setEnabled(enable);
        this.menuDBInformation.setEnabled(enable);
        this.menuDBDatamodel.setEnabled(enable);
        this.menuDBXML.setEnabled(enable);
        this.menuDBAbortConnecting.setEnabled(false);
        this.enableMetadataOps(enable);
        this.updateExplainState(enable);
        if (this.database != null && !this.database.getDatabaseSession().isAutoCommit()) {
            this.enableCommitRollback(true);
        } else {
            this.enableCommitRollback(false);
        }
        if (enable) {
            this.menuDBAutoCommitCheckBox.setSelected(this.database.getDatabaseSession().isAutoCommit());
            this.status.infoAction.setText("CONN");
            this.status.infoAction.setToolTipText(Messages.getString("MainFrame.infoactiontooltipconnectedwith") + this.database.getDatabaseSession().getUrl() + Messages.getString("MainFrame.infoactionas") + this.database.getDatabaseSession().getUser());
        } else {
            this.enableCommitRollback(false);
            this.menuDBStop.setEnabled(enable);
            this.tbButtonStop.setEnabled(enable);
            this.status.infoAction.setToolTipText(Messages.getString("MainFrame.infoactionnotconnected"));
        }
    }

    public void enableMetadataOps(boolean enabled) {
        this.menuDBDatamodel.setEnabled(enabled);
    }

    public boolean isDatabaseBusy() {
        return this.databaseIsBusy;
    }

    public final boolean isFileLoaderBusy() {
        return this.fileLoaderBusy;
    }

    public final boolean isBusy() {
        return this.databaseIsBusy || this.fileLoaderBusy;
    }

    public void setDatabaseBusyFiltered(boolean busy, String message) {
        if (!busy || System.currentTimeMillis() - this.lastMessageFrom > 1000L) {
            this.lastMessageFrom = System.currentTimeMillis();
            this.setDatabaseBusy(busy, message);
        }
    }

    public void setDatabaseBusy(final boolean busy, final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetDatabaseBusy(busy, message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.doSetDatabaseBusy(busy, message);
                }
            });
        }
    }

    public void setStatusMessage(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.status.setMessage(message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.status.setMessage(message);
                }
            });
        }
    }

    private void doSetDatabaseBusy(boolean busy, String message) {
        if (message != null) {
            this.status.message.setText(message);
        }
        if (!busy || this.databaseIsBusy != busy) {
            if (busy) {
                this.status.infoAction.setBackground(Color.red);
            } else {
                this.status.infoAction.setBackground(Color.lightGray);
            }
            this.setCellEditorUpdateEnabled(!busy);
            this.tbButtonRun.setEnabled(!busy);
            this.menuDBRun.setEnabled(!busy);
            if (busy) {
                this.menuDBExplain.setEnabled(false);
                this.tbButtonExplain.setEnabled(false);
            } else {
                this.updateExplainState(true);
            }
            this.menuDBStop.setEnabled(busy);
            this.tbButtonStop.setEnabled(busy);
            this.menuDBAdmin.setEnabled(!busy);
            this.menuDBCsvExportResultTable.setEnabled(!busy);
            if (!busy && this.database != null && !this.database.getDatabaseSession().isAutoCommit()) {
                this.enableCommitRollback(true);
            } else {
                this.enableCommitRollback(false);
            }
            this.menuDBInformation.setEnabled(!busy);
            this.menuDBAutoCommitCheckBox.setEnabled(!busy);
            this.databaseIsBusy = busy;
        }
    }

    private void enableCommitRollback(boolean enable) {
        if (this.database != null) {
            this.menuDBCommit.setEnabled(enable);
            this.menuDBRollback.setEnabled(enable);
            this.tbButtonCommit.setEnabled(enable);
            this.tbButtonRollback.setEnabled(enable);
        } else {
            this.menuDBCommit.setEnabled(false);
            this.menuDBRollback.setEnabled(false);
            this.tbButtonCommit.setEnabled(false);
            this.tbButtonRollback.setEnabled(false);
        }
    }

    public void setScriptTextAsNewDocument(String text) {
        this.menuScriptNew_actionPerformed();
        try {
            this.editor.getDocument().insertString(0, text, null);
        }
        catch (BadLocationException ble) {
            logger.warn((Object)("exception: " + ble));
        }
    }

    public void insertOrReplaceText(String text) {
        if (text != null) {
            try {
                text = text.replace('\r', ' ');
                if (this.editor.getSelectedText() != null) {
                    this.editor.replaceSelection(text);
                } else {
                    this.editor.getDocument().insertString(this.editor.getCaretPosition(), text, null);
                }
            }
            catch (BadLocationException ble) {
                logger.warn((Object)("exception: " + ble));
            }
        }
    }

    public void insertFormattedBreak() {
        ExtEditorKit.insertFormattedBreak(this.editor);
    }

    public void setScriptText(String text) {
        if (text != null) {
            if (this.currentFile != null) {
                if (this.menuScriptNew_actionPerformed()) {
                    text = text.replace('\r', ' ');
                    this.editor.setText(text);
                    this.setTextSaveEnabled(false);
                }
            } else {
                text = text.replace('\r', ' ');
                this.editor.setText(text);
                this.setTextSaveEnabled(false);
            }
        }
    }

    public String getText() {
        try {
            return this.editor.getDocument().getText(0, this.editor.getDocument().getLength()).trim();
        }
        catch (BadLocationException ble) {
            logger.warn((Object)("exception: " + ble));
            return null;
        }
    }

    public Document getDocument() {
        return this.editor.getDocument();
    }

    public int getTextLength() {
        return this.editor.getDocument().getLength();
    }

    public void setCaretPos(int pos) {
        this.editor.setCaretPosition(pos);
    }

    public int getCaretPos() {
        return this.editor.getCaretPosition();
    }

    public void disposeAllViewer() {
        for (int i = 0; i < this.cellEditorList.size(); ++i) {
            ValueEditor cv = this.cellEditorList.elementAt(i);
            if (cv == null) continue;
            cv.dispose();
        }
        this.cellEditorList.removeAllElements();
    }

    void showEditor(int row, int col) {
        if (row != -1 && col != -1) {
            boolean isOpen = false;
            for (int i = 0; i < this.cellEditorList.size(); ++i) {
                ValueEditor cellEditor = this.cellEditorList.elementAt(i);
                if (cellEditor.getRowIndex() != row || cellEditor.getColumnIndex() != col || !cellEditor.isVisible()) continue;
                cellEditor.setState(0);
                cellEditor.toFront();
                isOpen = true;
                break;
            }
            if (!isOpen) {
                ValueEditor cellEditor = new ValueEditor(this.databaseIsBusy, row == this.database.getNewRowIndex(), this);
                if (this.database.isVerticalView()) {
                    cellEditor.setObject(this.database.getValueAt(row, col), this.database.convertFromVerticalToLogicalRowIndex(row), this.database.convertFromVerticalToLogicalColIndex(row));
                } else {
                    cellEditor.setObject(this.database.getValueAt(row, col), row, col);
                }
                cellEditor.setTitle(Messages.getString("MainFrame.celleditortitlefield") + this.database.getColumnName(col) + Messages.getString("MainFrame.celleditortitleinline") + String.valueOf(row + 1));
                boolean updateDisabled = row == this.database.getNewRowIndex() && this.database.getColumnBasicType(col) == BasicDataType.BINARY.getId();
                cellEditor.setUpdateEnabled(!updateDisabled);
                this.cellEditorList.addElement(cellEditor);
            }
        }
    }

    private void setCellEditorUpdateEnabled(boolean enable) {
        for (int i = 0; i < this.cellEditorList.size(); ++i) {
            ValueEditor cellEditor = this.cellEditorList.elementAt(i);
            if (cellEditor == null) continue;
            cellEditor.setUpdateEnabled(enable);
        }
    }

    private String getMenuWindowLabelText() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.getFrameIndex());
        sb.append(") ");
        sb.append(this.windowName);
        String scriptText = this.getText().replace('\n', ' ');
        if (scriptText.length() > 0) {
            sb.append(" | ");
            int length = scriptText.length();
            if (length > 30) {
                sb.append(scriptText.substring(0, 30));
                sb.append("...");
            } else {
                sb.append(scriptText);
            }
        }
        return sb.toString();
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    private void createEditorContextMenu(MouseEvent me) {
        this.createEditorContextMenu(me.getX(), me.getY());
    }

    private void createEditorContextMenu() {
        try {
            Rectangle r = this.editor.modelToView(this.currentTextPos);
            this.createEditorContextMenu(r.x, r.y);
        }
        catch (BadLocationException e) {
            logger.error((Object)("createEditorContextMenu failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private void showSyntaxChooser() {
        try {
            int runoutY;
            this.updateEditorKeyMapForShowingSyntaxChooser();
            Rectangle r = this.editor.modelToView(this.currentTextPos);
            int verticalValue = this.editorScrollPane.getVerticalScrollBar().getValue();
            int horizontalValue = this.editorScrollPane.getHorizontalScrollBar().getValue();
            int compX = r.x - horizontalValue;
            int compY = r.y - verticalValue;
            int compWidth = 300;
            int compHeight = 300;
            logger.debug((Object)("showSyntaxChooser at position " + r.x + ":" + r.y + " [" + compX + ":" + compY + "]"));
            int runoutX = compX + compWidth - this.editor.getWidth();
            if (runoutX > 0) {
                compX -= runoutX;
            }
            if ((runoutY = compY + compHeight - this.editor.getHeight()) > 0 && (compHeight -= runoutY) < 80) {
                compHeight = 80;
            }
            this.getSyntaxChooser().setBounds(compX, compY + 20, compWidth, compHeight);
            this.getSyntaxChooser().reset();
            this.getSyntaxChooser().setVisible(true);
            if (this.database != null && this.database.isConnected()) {
                SQLDataModel dataModel = this.database.getDataModel();
                if (this.isDotAtCurrentPos()) {
                    String wordBeforeDot = this.getWordBeforeDot();
                    SQLSchema schema = dataModel.getSchema(wordBeforeDot);
                    if (schema != null) {
                        this.getSyntaxChooser().addItems(schema.getTables());
                        this.getSyntaxChooser().addItems(schema.getProcedures());
                    }
                } else {
                    SQLSchema schema = dataModel.getCurrentSQLSchema();
                    if (schema != null) {
                        this.getSyntaxChooser().addItems(schema.getTables());
                        this.getSyntaxChooser().addItems(schema.getProcedures());
                    }
                    this.getSyntaxChooser().addItems(dataModel.getSchemas());
                    this.getSyntaxChooser().addItems(this.lexer.getLongKeywords());
                }
            } else {
                this.getSyntaxChooser().addItems(this.lexer.getLongKeywords());
            }
            this.findCurrentWord();
            this.getSyntaxChooser().setSearchTerm(this.currentWord);
        }
        catch (BadLocationException e) {
            logger.error((Object)("showSyntaxChooser failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private boolean isDotAtCurrentPos() {
        try {
            String text;
            if (this.currentTextPos > 0 && (text = this.editor.getDocument().getText(this.currentTextPos - 1, 1)).endsWith(".")) {
                return true;
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)e);
        }
        return false;
    }

    private String getWordBeforeDot() {
        String word = "";
        String text = null;
        try {
            text = this.editor.getDocument().getText(0, this.editor.getDocument().getLength());
            word = this.getWordAtPos(text, this.currentTextPos - 2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getWordBeforeDot returns: " + word));
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)e);
        }
        return word;
    }

    private void updateEditorKeyMapForShowingSyntaxChooser() {
        Keymap map = this.editor.getKeymap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
        this.defaultEnterAction = map.getAction(enter);
        map.addActionForKeyStroke(enter, new AbstractAction("enter"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.insertSyntaxChooserText();
                MainFrame.this.closeSyntaxChooser();
            }
        });
        KeyStroke caretUp = KeyStroke.getKeyStroke(38, 0, false);
        this.defaultCaretUpAction = map.getAction(caretUp);
        map.addActionForKeyStroke(caretUp, new AbstractAction("caretUp"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.getSyntaxChooser().selectUp();
            }
        });
        KeyStroke caretDown = KeyStroke.getKeyStroke(40, 0, false);
        this.defaultCaretDownAction = map.getAction(caretDown);
        map.addActionForKeyStroke(caretDown, new AbstractAction("caretDown"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.getSyntaxChooser().selectDown();
            }
        });
    }

    public void insertSyntaxChooserText() {
        Object item = this.getSyntaxChooser().getSeletedItem();
        String text = "";
        if (item instanceof String) {
            text = (String)item;
        } else if (item instanceof SQLObject) {
            text = ((SQLObject)item).getName();
        }
        if (this.currentWord.isEmpty()) {
            this.startPosOfCurrentWord = this.currentTextPos;
        }
        if (!text.isEmpty()) {
            try {
                this.editor.getDocument().remove(this.startPosOfCurrentWord, this.currentWord.length());
                this.editor.getDocument().insertString(this.startPosOfCurrentWord, text, null);
            }
            catch (BadLocationException e) {
                logger.error((Object)e);
            }
        }
    }

    private void updateEditorKeyMapRestoreToDefault() {
        Keymap map = this.editor.getKeymap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
        if (this.defaultEnterAction != null) {
            map.addActionForKeyStroke(enter, this.defaultEnterAction);
        } else {
            map.removeKeyStrokeBinding(enter);
        }
        KeyStroke caretUp = KeyStroke.getKeyStroke(38, 0, false);
        if (this.defaultCaretUpAction != null) {
            map.addActionForKeyStroke(caretUp, this.defaultCaretUpAction);
        } else {
            map.removeKeyStrokeBinding(caretUp);
        }
        KeyStroke caretDown = KeyStroke.getKeyStroke(40, 0, false);
        if (this.defaultCaretDownAction != null) {
            map.addActionForKeyStroke(caretDown, this.defaultCaretDownAction);
        } else {
            map.removeKeyStrokeBinding(caretDown);
        }
    }

    private void updateEditorKeymap() {
        Keymap map = JTextComponent.addKeymap("Standard", this.editor.getKeymap());
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
        ExtEditorKit.InsertFormatedBreak insertFormatedBreak = new ExtEditorKit.InsertFormatedBreak();
        map.addActionForKeyStroke(enter, insertFormatedBreak);
        KeyStroke tabspace = KeyStroke.getKeyStroke(9, 0, false);
        ExtEditorKit.InsertTab insertTab = new ExtEditorKit.InsertTab();
        map.addActionForKeyStroke(tabspace, insertTab);
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1, false);
        ExtEditorKit.MoveBackTab moveBackTab = new ExtEditorKit.MoveBackTab();
        map.addActionForKeyStroke(shiftTab, moveBackTab);
        KeyStroke home = KeyStroke.getKeyStroke(36, 0, false);
        ExtEditorKit.GotoLineStart gotoLineStart = new ExtEditorKit.GotoLineStart();
        map.addActionForKeyStroke(home, gotoLineStart);
        KeyStroke end = KeyStroke.getKeyStroke(35, 0, false);
        ExtEditorKit.GotoLineEnd gotoLineEnd = new ExtEditorKit.GotoLineEnd();
        map.addActionForKeyStroke(end, gotoLineEnd);
        KeyStroke shiftHome = KeyStroke.getKeyStroke(36, 1, false);
        ExtEditorKit.SelectUntilLineStart selectUntilLineStart = new ExtEditorKit.SelectUntilLineStart();
        map.addActionForKeyStroke(shiftHome, selectUntilLineStart);
        KeyStroke shiftEnd = KeyStroke.getKeyStroke(35, 1, false);
        ExtEditorKit.SelectUntilLineEnd selectUntilLineEnd = new ExtEditorKit.SelectUntilLineEnd();
        map.addActionForKeyStroke(shiftEnd, selectUntilLineEnd);
        KeyStroke f12 = KeyStroke.getKeyStroke(123, 0, false);
        ExtEditorKit.ToggleLineComment toggleLineComment = new ExtEditorKit.ToggleLineComment();
        map.addActionForKeyStroke(f12, toggleLineComment);
        KeyStroke ctrl7 = KeyStroke.getKeyStroke(55, 2, false);
        map.addActionForKeyStroke(ctrl7, toggleLineComment);
        KeyStroke crtlhome = KeyStroke.getKeyStroke(36, 2, false);
        ExtEditorKit.GotoDocTop gotoDocTop = new ExtEditorKit.GotoDocTop();
        map.addActionForKeyStroke(crtlhome, gotoDocTop);
        KeyStroke crtlEnd = KeyStroke.getKeyStroke(35, 2, false);
        ExtEditorKit.GotoDocEnd gotoDocEnd = new ExtEditorKit.GotoDocEnd();
        map.addActionForKeyStroke(crtlEnd, gotoDocEnd);
        KeyStroke shiftCrtlHome = KeyStroke.getKeyStroke(36, 3, false);
        ExtEditorKit.SelectUntilDocTop selectUntilDocTop = new ExtEditorKit.SelectUntilDocTop();
        map.addActionForKeyStroke(shiftCrtlHome, selectUntilDocTop);
        KeyStroke shiftCrtlEnd = KeyStroke.getKeyStroke(35, 3, false);
        ExtEditorKit.SelectUntilDocEnd selectUntilDocEnd = new ExtEditorKit.SelectUntilDocEnd();
        map.addActionForKeyStroke(shiftCrtlEnd, selectUntilDocEnd);
        KeyStroke shiftCrtlA = KeyStroke.getKeyStroke(65, 3, false);
        map.addActionForKeyStroke(shiftCrtlA, new AbstractAction("selectCurrentBlock"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.selectCurrentBlock();
            }
        });
        KeyStroke ins = KeyStroke.getKeyStroke(155, 0, false);
        ExtEditorKit.SetStatusOverWriteAction setStatusOverWriteAction = new ExtEditorKit.SetStatusOverWriteAction();
        map.addActionForKeyStroke(ins, setStatusOverWriteAction);
        KeyStroke ctrlL = KeyStroke.getKeyStroke(76, 2, false);
        ExtEditorKit.MoveOut moveOut = new ExtEditorKit.MoveOut();
        map.addActionForKeyStroke(ctrlL, moveOut);
        KeyStroke ctrlJ = KeyStroke.getKeyStroke(74, 2, false);
        ExtEditorKit.MoveBack moveBack = new ExtEditorKit.MoveBack();
        map.addActionForKeyStroke(ctrlJ, moveBack);
        KeyStroke altU = KeyStroke.getKeyStroke(85, 8, false);
        ExtEditorKit.ToUpperCase toUpperCase = new ExtEditorKit.ToUpperCase();
        map.addActionForKeyStroke(altU, toUpperCase);
        KeyStroke altL = KeyStroke.getKeyStroke(76, 8, false);
        ExtEditorKit.ToLowerCase toLowerCase = new ExtEditorKit.ToLowerCase();
        map.addActionForKeyStroke(altL, toLowerCase);
        map.setDefaultAction(new ExtEditorKit.OverWriteDefaultKeyTyped());
        KeyStroke shiftF10 = KeyStroke.getKeyStroke(121, 1, false);
        map.addActionForKeyStroke(shiftF10, new AbstractAction("contextMenu"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.createEditorContextMenu();
            }
        });
        KeyStroke ctrlSpace = KeyStroke.getKeyStroke(32, 2, false);
        map.addActionForKeyStroke(ctrlSpace, new AbstractAction("syntaxChooser"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MainFrame.this.getSyntaxChooser().isVisible()) {
                    MainFrame.this.showSyntaxChooser();
                }
            }
        });
        KeyStroke ctrlEnter = KeyStroke.getKeyStroke(10, 2, false);
        map.addActionForKeyStroke(ctrlEnter, new AbstractAction("runBlock"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.database != null && MainFrame.this.database.isConnected()) {
                    int start = MainFrame.this.editor.getSelectionStart();
                    int end = MainFrame.this.editor.getSelectionEnd();
                    if (end - start < 3) {
                        MainFrame.this.selectCurrentBlock();
                    }
                    MainFrame.this.runScript();
                }
            }
        });
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0, false);
        map.addActionForKeyStroke(esc, new AbstractAction("ESC"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.closeSyntaxChooser();
            }
        });
        this.editor.setKeymap(map);
        if (logger.isDebugEnabled()) {
            this.logoutEditorKeyBindung();
        }
    }

    private void logoutEditorKeyBindung() {
        Keymap map = this.editor.getKeymap();
        Action[] actions = map.getBoundActions();
        KeyStroke[] keys = map.getBoundKeyStrokes();
        logger.debug((Object)"MainFrame.updateKeymap: list of additional text actions:");
        for (int i = 0; i < actions.length; ++i) {
            logger.debug((Object)("- name:" + actions[i].getValue("Name") + ", enabled:" + actions[i].isEnabled() + ", key:" + keys[i].toString()));
        }
    }

    public void closeSyntaxChooser() {
        if (this.syntaxChooser != null) {
            this.syntaxChooser.setVisible(false);
            this.editor.requestFocusInWindow();
        }
        this.updateEditorKeyMapRestoreToDefault();
    }

    private CodeCompletionAssistent getSyntaxChooser() {
        if (this.syntaxChooser == null) {
            this.syntaxChooser = new CodeCompletionAssistent(this);
            this.syntaxChooser.setVisible(false);
        }
        return this.syntaxChooser;
    }

    private void createEditorContextMenu(int x, int y) {
        if (!this.editor.hasFocus()) {
            this.editor.requestFocusInWindow();
        }
        String selectedText = this.editor.getSelectedText();
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = null;
        if (selectedText != null) {
            mi = new JMenuItem(Messages.getString("MainFrame.editorcontextmenuopeninnewwindow"));
            mi.setActionCommand("open_file_in_new_window");
            mi.addActionListener(this);
            popup.add(mi);
            mi = new JMenuItem(Messages.getString("MainFrame.editorcontextmenuopeninnewwindowandask"));
            mi.setActionCommand("ask_open_file_in_new_window");
            mi.addActionListener(this);
            popup.add(mi);
            popup.addSeparator();
            mi = new JMenuItem(Messages.getString("MainFrame.editorcontextmenucut"));
            mi.setActionCommand("cut");
            mi.addActionListener(this);
            popup.add(mi);
            mi = new JMenuItem(Messages.getString("MainFrame.editorcontextmenucopy"));
            mi.setActionCommand("copy");
            mi.addActionListener(this);
            popup.add(mi);
        }
        mi = new JMenuItem(Messages.getString("MainFrame.editcontextmenupaste"));
        mi.setActionCommand("paste");
        mi.addActionListener(this);
        popup.add(mi);
        popup.addSeparator();
        mi = new JMenuItem();
        mi.setText("to_date(...)");
        mi.setActionCommand("helper_to_date");
        mi.addActionListener(this);
        popup.add(mi);
        mi = new JMenuItem();
        mi.setText("sum(column) as column");
        mi.setActionCommand("helper_to_sum");
        mi.addActionListener(this);
        popup.add(mi);
        mi = new JMenuItem();
        mi.setText("max(column) as column");
        mi.setActionCommand("helper_to_max");
        mi.addActionListener(this);
        popup.add(mi);
        Dimension popupSize = popup.getPreferredSize();
        int yLoc_loc = 0;
        int xLoc_loc = 0;
        int absMouseYPos = y - this.editorScrollPane.getVerticalScrollBar().getValue();
        yLoc_loc = absMouseYPos + popupSize.height > this.editorScrollPane.getHeight() ? y - popupSize.height : y;
        int absMouseXPos = x - this.editorScrollPane.getHorizontalScrollBar().getValue();
        xLoc_loc = absMouseXPos + popupSize.width > this.getSize().width ? x - popupSize.width : x;
        if (xLoc_loc < 0) {
            xLoc_loc = 0;
        }
        popup.show(this.editor, xLoc_loc, yLoc_loc);
    }

    private void createTableContextMenu(MouseEvent e) {
        int mouseXPos = e.getX();
        int mouseYPos = e.getY();
        if (!this.resultTable.hasFocus()) {
            this.resultTable.requestFocus();
        }
        int row = this.resultTable.rowAtPoint(new Point(mouseXPos, mouseYPos));
        final int col = this.resultTable.columnAtPoint(new Point(mouseXPos, mouseYPos));
        if (this.database.isVerticalView() && col == 0) {
            this.createTableHeaderContextMenu(e);
        } else {
            int selectedRows = this.resultTable.getSelectedRowCount();
            if (row != -1 && col != -1 && selectedRows < 2) {
                this.resultTable.changeSelection(row, col, false, false);
            }
            if (this.resultTable.getSelectedRow() != -1) {
                JPopupMenu popup = new JPopupMenu();
                JMenu menue = null;
                JMenuItem mi = null;
                if (selectedRows == 1) {
                    mi = new JMenuItem(Messages.getString("MainFrame.tablecontextmenuopenfield"));
                    mi.setActionCommand("table_edit_cell");
                    mi.addActionListener(this);
                    mi.setFont(new Font(mi.getFont().getFamily(), 1, mi.getFont().getSize()));
                    popup.add(mi);
                    popup.addSeparator();
                }
                if (!this.databaseIsBusy && !this.database.isVerticalView()) {
                    if (selectedRows == 1) {
                        mi = new JMenuItem(Messages.getString("MainFrame.tablecontextmenudeletefield"));
                        mi.setActionCommand("table_delete_content");
                        mi.addActionListener(this);
                        popup.add(mi);
                        popup.addSeparator();
                    }
                    if (this.selectedRowIndex != this.database.getNewRowIndex()) {
                        mi = new JMenuItem();
                        mi.setAction(this.actionDeleteRowInTable);
                        popup.add(mi);
                        popup.addSeparator();
                        mi = new JMenuItem();
                        mi.setAction(this.actionCopyTableContent);
                        popup.add(mi);
                    }
                    if (this.database.isReferencingColumn(col) && selectedRows == 1) {
                        popup.addSeparator();
                        mi = new JMenuItem(Messages.getString("MainFrame.showreferenceddataset") + this.database.getReferencedColumn(col));
                        mi.setActionCommand("sik@" + String.valueOf(row) + "|" + String.valueOf(col));
                        mi.addActionListener(this);
                        popup.add(mi);
                    }
                    if (this.database.isReferencedColumn(col) && selectedRows == 1) {
                        String[] refColumns = this.database.getReferencingColumns(col);
                        popup.addSeparator();
                        menue = new JMenu(Messages.getString("MainFrame.showreferencingdatasets"));
                        popup.add(menue);
                        for (int i = 0; i < refColumns.length; ++i) {
                            mi = new JMenuItem(refColumns[i]);
                            mi.setActionCommand("sek@" + mi.getText() + "$" + String.valueOf(row) + "|" + String.valueOf(col));
                            mi.addActionListener(this);
                            menue.add(mi);
                        }
                    }
                    if (selectedRows < 2) {
                        if (this.selectedRowIndex == this.database.getNewRowIndex()) {
                            popup.addSeparator();
                            mi = new JMenuItem(Messages.getString("MainFrame.tablecontextappendnewlineindatabsde"));
                            mi.setActionCommand("db_insert_row");
                            mi.addActionListener(this);
                            popup.add(mi);
                            mi = new JMenuItem(Messages.getString("MainFrame.tablecontextmenuremovenewline"));
                            mi.setActionCommand("table_insert_row_cancel");
                            mi.addActionListener(this);
                            popup.add(mi);
                        } else if (this.database.getNewRowIndex() == -1) {
                            popup.addSeparator();
                            mi = new JMenuItem(Messages.getString("MainFrame.tablecontextmenucreatenewline"));
                            mi.setActionCommand("table_insert_row");
                            mi.addActionListener(this);
                            popup.add(mi);
                            mi = new JMenuItem();
                            mi.setAction(this.actionInsertNewTableLineAsCopy);
                            popup.add(mi);
                        }
                        mi = new JMenuItem();
                        mi.setText(Messages.getString("MainFrame.selectAllRows"));
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MainFrame.this.selectAllRowsForColumn(col);
                            }
                        });
                        popup.add(mi);
                    }
                }
                Dimension popupSize = popup.getPreferredSize();
                int absMouseYPos = mouseYPos - this.tableScrollPane.getVerticalScrollBar().getValue();
                int yLoc_loc = absMouseYPos + popupSize.height > this.tableScrollPane.getHeight() ? mouseYPos - popupSize.height : mouseYPos;
                int absMouseXPos = mouseXPos - this.tableScrollPane.getHorizontalScrollBar().getValue();
                int xLoc_loc = absMouseXPos + popupSize.width > this.getSize().width ? mouseXPos - popupSize.width : mouseXPos;
                if (xLoc_loc < 0) {
                    xLoc_loc = 0;
                }
                popup.show(this.resultTable, xLoc_loc, yLoc_loc);
            }
        }
    }

    private void selectAllRowsForColumn(int col) {
        this.setTableSelectionToIntervalMode(true);
        this.resultTable.changeSelection(0, col, false, false);
        this.resultTable.changeSelection(this.resultTable.getRowCount() - 1, col, false, true);
    }

    private void createTableHeaderContextMenu(MouseEvent e) {
        int mouseXPos = e.getX();
        int mouseYPos = e.getY();
        final int col = this.database.isVerticalView() ? this.database.convertFromVerticalToLogicalColIndex(this.resultTable.rowAtPoint(new Point(mouseXPos, mouseYPos))) : this.resultTable.columnAtPoint(new Point(mouseXPos, mouseYPos));
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem(Messages.getString("MainFrame.togglecolumnaspk"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.togglePk(col);
            }
        });
        popup.add(mi);
        if (this.database.enabledForSorting(col)) {
            popup.addSeparator();
            mi = new JMenuItem(Messages.getString("MainFrame.sortbycolumnintern"));
            mi.setActionCommand("sai_" + String.valueOf(col));
            mi.addActionListener(this);
            popup.add(mi);
            mi = new JMenuItem(Messages.getString("MainFrame.sortbythiscolumnnewselect"));
            mi.setActionCommand("saea_" + String.valueOf(col));
            mi.addActionListener(this);
            popup.add(mi);
            mi = new JMenuItem(Messages.getString("MainFrame.255"));
            mi.setActionCommand("saee_" + String.valueOf(col));
            mi.addActionListener(this);
            popup.add(mi);
        }
        mi = new JMenuItem();
        mi.setText("Select All Rows");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.selectAllRowsForColumn(col);
            }
        });
        popup.add(mi);
        Dimension popupSize = popup.getPreferredSize();
        int absMouseXPos = mouseXPos - this.tableScrollPane.getHorizontalScrollBar().getValue();
        int xLoc_loc = absMouseXPos + popupSize.width > this.getSize().width ? mouseXPos - popupSize.width : mouseXPos;
        if (xLoc_loc < 0) {
            xLoc_loc = 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MainFrame: create table header context menue at " + xLoc_loc + ":" + mouseYPos));
        }
        popup.show((Component)e.getSource(), xLoc_loc, mouseYPos);
    }

    public static void setDateFormatMask(String dateFormatMask) {
        MainFrame.dateFormatMask = dateFormatMask;
    }

    public static String getDateFormatMask() {
        return dateFormatMask;
    }

    public static void setFkNavigationFrameMode(int fkNavigationFrameMode) {
        MainFrame.fkNavigationFrameMode = fkNavigationFrameMode;
    }

    public static int getFkNavigationFrameMode() {
        return fkNavigationFrameMode;
    }

    private void openTextFileConverterFrame() {
        TextFileConverterFrame conv = new TextFileConverterFrame();
        conv.setVisible(true);
        WindowHelper.locateWindowAtMiddle(this, conv);
    }

    private void openTalendSchemaConverterFrame() {
        SchemaImportFrame conv = new SchemaImportFrame();
        conv.setVisible(true);
        WindowHelper.locateWindowAtMiddle(this, conv);
    }

    private void exportResultTableAsTalendSchema() {
        SQLTable table = null;
        try {
            table = this.database.getSQLTableFromCurrentQuery();
        }
        catch (SQLException e) {
            logger.error((Object)("Get metadata from current query failed:" + e.getMessage()), (Throwable)e);
            JOptionPane.showMessageDialog(this, "Get metadata from current query failed:" + e.getMessage());
        }
        if (table != null) {
            File f;
            JFileChooser chooser = new JFileChooser();
            String lastDir = Main.getUserProperty("talend.schema.xml.dir");
            if (lastDir != null) {
                File f2 = new File(lastDir, table.getName() + ".xml");
                chooser.setCurrentDirectory(f2.getParentFile());
                chooser.setSelectedFile(f2);
            } else {
                String directory = Main.getUserProperty("SCRIPT_DIR", System.getProperty("user.home"));
                f = new File(directory, table.getName() + ".xml");
                chooser.setCurrentDirectory(f.getParentFile());
                chooser.setSelectedFile(f);
            }
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Messages.getString("MainFrame.122"));
            chooser.addChoosableFileFilter(new XmlFileFilter());
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                f = chooser.getSelectedFile();
                if (!f.getName().toLowerCase().endsWith(".xml")) {
                    f = new File(f.getAbsolutePath() + ".xml");
                }
                Main.setUserProperty("talend.schema.xml.dir", f.getParentFile().getAbsolutePath());
                SchemaUtil util = new SchemaUtil();
                try {
                    util.writeSchemaFile(f, table);
                }
                catch (IOException e1) {
                    logger.error((Object)("writeSchemaFile f=" + f.getAbsolutePath() + " failed: " + e1.getMessage()), (Throwable)e1);
                    JOptionPane.showMessageDialog(this, "writeSchemaFile f=" + f.getAbsolutePath() + " failed: " + e1.getMessage());
                }
            }
        }
    }

    private class ResultTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Color colorOdd = new Color(240, 255, 240);
        private final Color colorEven = new Color(255, 255, 225);
        private final Color greyOdd = new Color(235, 235, 235);
        private final Color greyEven = new Color(240, 240, 240);
        private final Color colorHeader = new Color(220, 220, 220);
        private static final String STAR_SPACE = "* ";
        private String dateFormatMask = null;
        private Font monospacedFont;
        private Font defaultFont;

        public ResultTableCellRenderer() {
            this.setOpaque(true);
            this.monospacedFont = new Font("Monospaced", 0, this.getFont().getSize());
        }

        public void setDateFormatMask(String mask) {
            this.dateFormatMask = mask;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String content = null;
            if (value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormatMask);
                content = sdf.format((Date)value);
            } else {
                content = value != null ? value.toString() : null;
            }
            if (this.defaultFont == null) {
                this.defaultFont = table.getFont();
            }
            if (useMonospacedFont) {
                this.setFont(this.monospacedFont);
            } else {
                this.setFont(this.defaultFont);
            }
            if (row == MainFrame.this.database.getNewRowIndex()) {
                this.setText(STAR_SPACE + (content != null ? content : ""));
            } else {
                this.setText(content != null ? content : "");
            }
            if (isSelected) {
                if (MainFrame.this.database.isVerticalView() && column == 0) {
                    if (MainFrame.this.database.isPrimaryKey(MainFrame.this.database.convertFromVerticalToLogicalColIndex(row))) {
                        this.setBackground(Color.yellow);
                    } else {
                        this.setBackground(this.colorHeader);
                    }
                    this.setForeground(Color.black);
                } else if (hasFocus) {
                    this.setForeground(Color.black);
                    this.setBackground(Color.white);
                } else {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                }
            } else {
                int x = 0;
                if (MainFrame.this.database.isVerticalView()) {
                    if (column == 0) {
                        if (MainFrame.this.database.isPrimaryKey(MainFrame.this.database.convertFromVerticalToLogicalColIndex(row))) {
                            this.setBackground(Color.yellow);
                        } else {
                            this.setBackground(this.colorHeader);
                        }
                        this.setForeground(Color.black);
                    } else {
                        int verticalRowIndex = row / MainFrame.this.database.getLogicalColumnCount();
                        this.setForeground(table.getForeground());
                        x = verticalRowIndex >> 1;
                        if (content != null) {
                            if (x << 1 != verticalRowIndex) {
                                this.setBackground(this.colorOdd);
                            } else {
                                this.setBackground(this.colorEven);
                            }
                        } else if (x << 1 != verticalRowIndex) {
                            this.setBackground(this.greyOdd);
                        } else {
                            this.setBackground(this.greyEven);
                        }
                    }
                } else {
                    this.setForeground(table.getForeground());
                    x = row >> 1;
                    if (content != null) {
                        if (x << 1 != row) {
                            this.setBackground(this.colorOdd);
                        } else {
                            this.setBackground(this.colorEven);
                        }
                    } else if (x << 1 != row) {
                        this.setBackground(this.greyOdd);
                    } else {
                        this.setBackground(this.greyEven);
                    }
                }
            }
            if (hasFocus) {
                if (MainFrame.this.database.isVerticalView() && column == 0) {
                    this.setBorder(BorderFactory.createRaisedBevelBorder());
                } else {
                    this.setBorder(BorderFactory.createLineBorder(Color.black));
                }
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    private final class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (!MainFrame.this.database.isVerticalView() && me.isPopupTrigger()) {
                MainFrame.this.createTableHeaderContextMenu(me);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (!MainFrame.this.database.isVerticalView()) {
                if (me.isPopupTrigger()) {
                    MainFrame.this.createTableHeaderContextMenu(me);
                } else {
                    this.processTogglePkClick(me);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (!MainFrame.this.database.isVerticalView() && !me.isControlDown() && me.getClickCount() == 2) {
                this.fireDoubleClickPerformed(me);
            }
        }

        private void processTogglePkClick(MouseEvent me) {
            if (me.isControlDown()) {
                int columnIndex = ((JTableHeader)me.getSource()).columnAtPoint(me.getPoint());
                if (MainFrame.this.database.getColumnTypename(columnIndex).equals("CLOB") || MainFrame.this.database.getColumnTypename(columnIndex).equals("BLOB") || MainFrame.this.database.getColumnTypename(columnIndex).indexOf("UNKNOWN") != -1 || MainFrame.this.database.getColumnTypename(columnIndex).equals("LONGVARCHAR") || MainFrame.this.database.getColumnTypename(columnIndex).equals("LONGVARBINARY")) {
                    MainFrame.this.showErrorMessage(Messages.getString("MainFrame.errorfiledtypenotuserfuleforpk"), Messages.getString("MainFrame.errormessageinvalidfieldtypeforpktitle"));
                } else {
                    MainFrame.this.database.togglePrimaryKey(columnIndex);
                    ((JTableHeader)me.getSource()).repaint();
                }
            }
        }

        protected void fireDoubleClickPerformed(MouseEvent me) {
            MainFrame.this.insertOrReplaceText(MainFrame.this.database.getColumnName(((JTableHeader)me.getSource()).columnAtPoint(me.getPoint())));
        }
    }

    private final class TableMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean draggStarted = false;

        private TableMouseListener() {
        }

        protected void fireDoubleClickPerformed(MouseEvent me) {
            int row = MainFrame.this.resultTable.getSelectedRow();
            if (row != -1) {
                if (MainFrame.this.database.isVerticalView()) {
                    int col = MainFrame.this.resultTable.getSelectedColumn();
                    if (col > 0) {
                        MainFrame.this.showEditor(row, col);
                    } else {
                        MainFrame.this.insertOrReplaceText(MainFrame.this.database.getColumnNameByLogicalColIndex(MainFrame.this.database.convertFromVerticalToLogicalColIndex(row)));
                    }
                } else {
                    MainFrame.this.showEditor(row, MainFrame.this.resultTable.getSelectedColumn());
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (MainFrame.this.database.isShowingResultSet() && me.isPopupTrigger()) {
                MainFrame.this.createTableContextMenu(me);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.draggStarted = false;
            if (MainFrame.this.database.isShowingResultSet() && me.isPopupTrigger()) {
                MainFrame.this.createTableContextMenu(me);
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2 && !me.isPopupTrigger()) {
                this.fireDoubleClickPerformed(me);
            } else if (me.getModifiers() == 16) {
                MainFrame.this.setTableSelectionToIntervalMode(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (!this.draggStarted) {
                MainFrame.this.resultTable.clearSelection();
                MainFrame.this.setTableSelectionToIntervalMode(true);
                this.draggStarted = true;
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
        }
    }

    private final class EditorMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private EditorMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (MainFrame.this.textChangeListener != null) {
                MainFrame.this.textChangeListener.setEnableLineHighlighting(false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                MainFrame.this.createEditorContextMenu(me);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                MainFrame.this.createEditorContextMenu(me);
            }
            if (MainFrame.this.textChangeListener != null) {
                MainFrame.this.textChangeListener.setEnableLineHighlighting(true);
            }
        }
    }

    private class MenuScriptReopenListener
    implements ActionListener {
        private MenuScriptReopenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.loadFileInDocument(true, e.getActionCommand());
        }
    }

    private final class UndoHandler
    implements UndoableEditListener {
        public boolean valid = true;

        private UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (this.valid) {
                MainFrame.this.undoManager.addEdit(e.getEdit());
                MainFrame.this.updateUndoRedoEnabled();
            }
        }
    }

    private final class TextChangeListener
    implements DocumentListener,
    CaretListener {
        private JTextComponent editor;
        private Highlighter.Highlight openBracketHighLightInfo;
        private Highlighter.Highlight closeBracketHighLightInfo;
        private Highlighter.Highlight markBracketHighLightInfo;
        private Highlighter.Highlight lineHighLightInfo;
        private DefaultHighlighter.DefaultHighlightPainter highlightPainterBracketOK = new DefaultHighlighter.DefaultHighlightPainter(Color.lightGray);
        private DefaultHighlighter.DefaultHighlightPainter highlightPainterBracketMark = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 255, 230));
        private DefaultHighlighter.DefaultHighlightPainter highlightPainterBracketMissing = new DefaultHighlighter.DefaultHighlightPainter(Color.red);
        private Highlighter.HighlightPainter highlightPainterLine = new LineHighlightPainter(null);
        private boolean enableLineHighlighting = true;

        TextChangeListener(JTextComponent editor) {
            this.editor = editor;
        }

        public void setEnableLineHighlighting(boolean enabled) {
            this.enableLineHighlighting = enabled;
            if (!enabled) {
                this.removeLineHighlight();
            }
        }

        @Override
        public final void caretUpdate(CaretEvent e) {
            Document doc = this.editor.getDocument();
            Element root = doc.getDefaultRootElement();
            MainFrame.this.currentTextPos = e.getDot();
            MainFrame.this.currentLineNumber = root.getElementIndex(MainFrame.this.currentTextPos);
            Element currElem = root.getElement(MainFrame.this.currentLineNumber);
            MainFrame.this.currentLineStartOffset = currElem.getStartOffset();
            MainFrame.this.currentLineEndOffset = currElem.getEndOffset();
            MainFrame.this.currentOffsetInCurrLine = MainFrame.this.currentTextPos - currElem.getStartOffset();
            MainFrame.this.status.textPos.setText(String.valueOf(MainFrame.this.currentLineNumber + 1) + ":" + String.valueOf(MainFrame.this.currentOffsetInCurrLine + 1) + " / " + (MainFrame.this.currentTextPos + 1));
            MainFrame.this.status.revalidate();
            if (MainFrame.this.getSyntaxChooser().isVisible() || MainFrame.this.tbButtonHighlighter.isSelected()) {
                MainFrame.this.findCurrentWord();
            }
            if (MainFrame.this.syntaxChooser != null) {
                MainFrame.this.syntaxChooser.setSearchTerm(MainFrame.this.currentWord);
            }
            if (MainFrame.this.tbButtonHighlighter.isSelected()) {
                MainFrame.this.highlightCurrentWord();
            }
            int sizeSelectedText = Math.abs(this.editor.getSelectionStart() - this.editor.getSelectionEnd());
            int startLineNumber = root.getElementIndex(this.editor.getSelectionStart());
            int selectedLines = Math.abs(MainFrame.this.currentLineNumber - startLineNumber);
            if (sizeSelectedText > 0 && MainFrame.this.currentOffsetInCurrLine > 0) {
                ++selectedLines;
            }
            this.removeLineHighlight();
            if (sizeSelectedText > 0 || e.getDot() != e.getMark()) {
                MainFrame.this.textIsSelected(true);
                MainFrame.this.status.message.setText(" " + sizeSelectedText + Messages.getString("MainFrame.statuscharsselected") + " / " + selectedLines + Messages.getString("MainFrame.statuslinesselected"));
            } else {
                MainFrame.this.textIsSelected(false);
                this.removeBracketHighlighting();
                try {
                    String text = doc.getText(0, doc.getLength());
                    int[] bracketPositions = SQLParser.findOppositeParenthese(MainFrame.this.currentTextPos, text);
                    this.setBracketHighLighting(bracketPositions);
                    if (Main.isLineHighlightingEnabled() && this.enableLineHighlighting) {
                        this.setLineHighlight(currElem.getStartOffset(), currElem.getEndOffset());
                    }
                }
                catch (BadLocationException e1) {
                    logger.warn((Object)("exception: " + e1));
                }
            }
        }

        private void removeBracketHighlighting() {
            if (this.openBracketHighLightInfo != null) {
                this.editor.getHighlighter().removeHighlight(this.openBracketHighLightInfo);
            }
            if (this.closeBracketHighLightInfo != null) {
                this.editor.getHighlighter().removeHighlight(this.closeBracketHighLightInfo);
            }
            if (this.markBracketHighLightInfo != null) {
                this.editor.getHighlighter().removeHighlight(this.markBracketHighLightInfo);
            }
        }

        private void setBracketHighLighting(int[] positions) throws BadLocationException {
            if (positions[0] != -1) {
                if (positions[1] != -1) {
                    this.openBracketHighLightInfo = (Highlighter.Highlight)this.editor.getHighlighter().addHighlight(positions[0], positions[0] + 1, this.highlightPainterBracketOK);
                    this.closeBracketHighLightInfo = (Highlighter.Highlight)this.editor.getHighlighter().addHighlight(positions[1], positions[1] + 1, this.highlightPainterBracketOK);
                    if (Main.isBracketContentHighlightingEnabled()) {
                        this.markBracketHighLightInfo = (Highlighter.Highlight)this.editor.getHighlighter().addHighlight(positions[0] + 1, positions[1] - 1, this.highlightPainterBracketMark);
                    }
                } else {
                    this.openBracketHighLightInfo = (Highlighter.Highlight)this.editor.getHighlighter().addHighlight(positions[0], positions[0] + 1, this.highlightPainterBracketMissing);
                }
            } else if (positions[1] != -1) {
                this.closeBracketHighLightInfo = (Highlighter.Highlight)this.editor.getHighlighter().addHighlight(positions[1], positions[1] + 1, this.highlightPainterBracketMissing);
            }
        }

        private void removeLineHighlight() {
            if (this.lineHighLightInfo != null) {
                this.editor.getHighlighter().removeHighlight(this.lineHighLightInfo);
                this.editor.repaint();
            }
        }

        private void setLineHighlight(int start, int end) throws BadLocationException {
            this.lineHighLightInfo = (Highlighter.Highlight)this.editor.getHighlighter().addHighlight(start, end, this.highlightPainterLine);
        }

        private void test() {
            if (!MainFrame.this.isTextChanged()) {
                MainFrame.this.setTextSaveEnabled(true);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.test();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.test();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.test();
        }
    }

    private final class FileLoader
    extends Thread {
        private Document doc;
        private File f;
        static final char CR = '\r';
        static final char LF = '\n';
        static final char LSEP = '\u2028';
        static final char PSEP = '\u2029';
        static final char NL = '\u0085';

        FileLoader(File f, JTextComponent textComp) {
            this.f = f;
            this.doc = textComp.getDocument();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MainFrame.this.fileLoaderBusy = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    MainFrame.this.editor.setEditable(false);
                    MainFrame.this.status.message.setText(Messages.getString("MainFrame.200") + FileLoader.this.f.getName() + " ");
                }
            });
            if (MainFrame.this.textChangeListener != null) {
                MainFrame.this.textChangeListener.setEnableLineHighlighting(false);
            }
            boolean lexerTemporarilyDisabled = false;
            if (MainFrame.this.lexer != null && MainFrame.this.lexer.isEnabled()) {
                MainFrame.this.lexer.setEnabled(false);
                lexerTemporarilyDisabled = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"MainFrame.FileLoader: set editor not editable");
            }
            boolean tabReplace = Main.getDefaultProperty("TAB_REPLACE_WITH_SPACE", "false").equals("true");
            if (logger.isDebugEnabled()) {
                if (tabReplace) {
                    logger.debug((Object)("FileLoader: TABs will be replaced " + Main.getDefaultProperty("TAB_SPACE_MAPPING", "3") + Messages.getString("MainFrame.208")));
                } else {
                    logger.debug((Object)"MainFrame.FileLoader: TABs will be read transparent");
                }
            }
            long t0 = 0L;
            if (logger.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                logger.debug((Object)"MainFrame.FileLoader: load ...");
            }
            BufferedReader in = null;
            try {
                int nch;
                in = Main.currentCharSet != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.f), Main.currentCharSet)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.f)));
                int c0 = 32;
                int countTabs = 0;
                char[] buffer = new char[16348];
                StringBuilder sb = new StringBuilder(buffer.length);
                while ((nch = in.read(buffer, 0, buffer.length)) != -1) {
                    for (int i = 0; i < nch; ++i) {
                        int c = buffer[i];
                        if (c == 8232 || c == 8233 || c == 133) {
                            buffer[i] = 10;
                        } else if (c == 10) {
                            buffer[i] = c0 == 13 ? 0 : 10;
                        } else if (c == 13) {
                            buffer[i] = 10;
                        }
                        c0 = c;
                    }
                    sb.setLength(0);
                    if (tabReplace) {
                        int nextSearchStartPos = 0;
                        boolean fertig = false;
                        while (!fertig) {
                            int tabIndex = -1;
                            for (int ti = nextSearchStartPos; ti < nch; ++ti) {
                                if (buffer[ti] != '\t') continue;
                                tabIndex = ti;
                                break;
                            }
                            if (tabIndex == -1) {
                                this.copy(sb, buffer, nextSearchStartPos, nch - nextSearchStartPos);
                                fertig = true;
                                continue;
                            }
                            this.copy(sb, buffer, nextSearchStartPos, tabIndex - nextSearchStartPos);
                            sb.append(MainFrame.this.tabErsatz);
                            nextSearchStartPos = tabIndex + 1;
                            ++countTabs;
                        }
                    } else {
                        this.copy(sb, buffer, 0, nch);
                    }
                    this.doc.insertString(this.doc.getLength(), sb.toString(), null);
                }
                sb = null;
                if (logger.isDebugEnabled()) {
                    long t1 = System.currentTimeMillis() - t0;
                    logger.debug((Object)("Load file finished: time: " + t1 + " ms, doc-size: " + this.doc.getLength() + ". " + countTabs + " TABs were replaced."));
                }
                MainFrame.this.status.message.setText(Messages.getString("MainFrame.statusfile_") + MainFrame.this.currentFile.getName() + Messages.getString("MainFrame.statusfileloaded"));
                MainFrame.this.status.repaint();
                if (!(MainFrame.this.currentFile.getName().endsWith("default.cfg") || MainFrame.this.currentFile.getName().endsWith("dbadmin.cfg") || MainFrame.this.currentFile.getName().endsWith("dbtypes.cfg") || MainFrame.this.currentFile.getName().endsWith("wordfile.txt"))) {
                    if (MainFrame.this.currentFile.getName().endsWith("highlighter.cfg")) {
                    } else {
                        Main.addFileProp(MainFrame.this.currentFile);
                    }
                }
            }
            catch (IOException e) {
                logger.warn((Object)("FileLoader: Datei " + MainFrame.this.currentFile.getPath() + " nicht vorhanden, wird beim Speichern neu angelegt"));
                MainFrame.this.status.message.setText(Messages.getString("MainFrame.statusfile_") + MainFrame.this.currentFile.getPath() + Messages.getString("MainFrame.statusfilenotfound") + Messages.getString("MainFrame.statusfilewillbenewcreated"));
            }
            catch (BadLocationException e) {
                logger.warn((Object)"FileLoader: Fehler beim Laden des Dokuments");
                MainFrame.this.status.message.setText(Messages.getString("MainFrame.statusfile_") + MainFrame.this.currentFile.getPath() + Messages.getString("MainFrame.statusfilenotcorrectloaded"));
            }
            catch (AccessControlException ae) {
                logger.warn((Object)("FileLoader: " + ae.getMessage()));
                MainFrame.this.status.message.setText(Messages.getString("MainFrame.statusnoaccestofilesystem"));
                MainFrame.this.currentFile = null;
                MainFrame.this.setupWindowTitle();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.warn((Object)("Cannot close reader " + e.getMessage()), (Throwable)e);
                    }
                    in = null;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.setTextSaveEnabled(false);
                    MainFrame.this.undoManager.discardAllEdits();
                    MainFrame.this.updateUndoRedoEnabled();
                    MainFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                    MainFrame.this.editor.setCaretPosition(0);
                    MainFrame.this.setFocusToEditor();
                    MainFrame.this.editor.setEditable(true);
                }
            });
            if (MainFrame.this.lexer != null && lexerTemporarilyDisabled) {
                MainFrame.this.lexer.setEnabled(true);
                ((SyntaxDocument)this.doc).updateCommentAttributes();
            }
            MainFrame.this.fileLoaderBusy = false;
            this.doc.addDocumentListener(MainFrame.this.textChangeListener);
            this.doc.addUndoableEditListener(MainFrame.this.undoHandler);
            if (MainFrame.this.textChangeListener != null) {
                MainFrame.this.textChangeListener.setEnableLineHighlighting(true);
            }
        }

        private void copy(StringBuilder sb, char[] buffer, int startPos, int length) {
            for (int i = startPos; i < startPos + length; ++i) {
                char c = buffer[i];
                if (c <= '\u0000') continue;
                sb.append(c);
            }
        }
    }

    public static final class StatusBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final BoxLayout box = new BoxLayout(this, 0);
        private JLabel message = new FixedLabel();
        private JLabel tablePos = new FixedLabel();
        private JLabel textPos = new FixedLabel();
        private JLabel infoOverWrite = new FixedLabel("INS");
        private JLabel infoAction = new FixedLabel();
        private JLabel tableName = new FixedLabel();
        static final int LINE_NUM_WIDTH = 100;
        static final int TEXTPOS_WIDTH = 100;
        static final int INFO_OVERWRITE_WIDTH = 30;
        static final int INFO_ACTION_WIDTH = 50;
        static final int STATUS_HEIGHT = 25;
        static final int TABLENAME_WIDTH = 100;

        public StatusBar() {
            this.setLayout(this.box);
            this.message.setBorder(BorderFactory.createLoweredBevelBorder());
            this.message.setForeground(Color.black);
            this.tablePos.setPreferredSize(new Dimension(100, 25));
            this.tablePos.setBorder(BorderFactory.createLoweredBevelBorder());
            this.tablePos.setOpaque(true);
            this.tablePos.setHorizontalAlignment(0);
            this.tablePos.setToolTipText(Messages.getString("MainFrame.193"));
            this.textPos.setPreferredSize(new Dimension(100, 25));
            this.textPos.setBorder(BorderFactory.createLoweredBevelBorder());
            this.textPos.setOpaque(true);
            this.textPos.setHorizontalAlignment(0);
            this.textPos.setToolTipText(Messages.getString("MainFrame.194"));
            this.infoOverWrite.setPreferredSize(new Dimension(30, 25));
            this.infoOverWrite.setBorder(BorderFactory.createLoweredBevelBorder());
            this.infoAction.setPreferredSize(new Dimension(50, 25));
            this.infoAction.setOpaque(true);
            this.infoAction.setText("DISC");
            this.infoAction.setBorder(BorderFactory.createLoweredBevelBorder());
            this.tablePos.setForeground(Color.black);
            this.textPos.setForeground(Color.black);
            this.infoOverWrite.setForeground(Color.black);
            this.infoAction.setForeground(Color.black);
            this.tableName.setBackground(Main.info);
            this.tableName.setForeground(Color.black);
            this.tableName.setOpaque(true);
            this.tableName.setBorder(BorderFactory.createLoweredBevelBorder());
            this.tableName.setPreferredSize(new Dimension(100, 25));
            this.add(this.message);
            this.add(this.tableName);
            this.add(this.tablePos);
            this.add(this.textPos);
            this.add(this.infoOverWrite);
            this.add(this.infoAction);
            this.message.addPropertyChangeListener(new MeldungPropertyChangeListener());
        }

        private void setMessage(String text) {
            this.message.setText(text);
        }

        public JLabel getMessageComp() {
            return this.message;
        }

        public void setTablename(String name) {
            this.tableName.setText(name);
            this.tableName.setToolTipText(name);
        }

        public void setTableRowIndex(int index) {
            this.tablePos.setText(String.valueOf(index));
        }

        public void setInfoAction(String text, Color c) {
            if (text != null) {
                this.infoAction.setText(text);
            }
            if (c != null) {
                this.infoAction.setBackground(c);
            }
        }

        public void setTextModeOverWrite(boolean overwrite) {
            this.infoOverWrite.setText(overwrite ? "OW" : "INS");
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int meldungBreite = this.getWidth() - 100 - 100 - 30 - 50 - 100;
            this.message.setPreferredSize(new Dimension(meldungBreite, 25));
            this.remove(this.message);
            this.add(this.message, null, 0);
            this.doLayout();
        }

        class MeldungPropertyChangeListener
        implements PropertyChangeListener {
            MeldungPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StatusBar.this.message.setToolTipText(StatusBar.this.message.getText());
            }
        }

        static final class FixedLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;

            public FixedLabel(String text) {
                super(text);
            }

            public FixedLabel() {
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        }
    }

    private final class ConnectThread
    extends Thread {
        private ConnectThread() {
        }

        @Override
        public void run() {
            MainFrame.this.doConnect();
            try {
                ConnectThread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (MainFrame.this.startRunOnLoad) {
                MainFrame.this.startRunOnLoad = false;
                if (MainFrame.this.isConnected() && MainFrame.this.menuDBRun.isEnabled()) {
                    MainFrame.this.runScript();
                }
            }
        }
    }

    private final class SorterThread
    extends Thread {
        private int col;
        private JFrame frame;

        private SorterThread() {
        }

        public void setColumnIndex(int col_loc) {
            this.col = col_loc;
        }

        public void setFrame(JFrame frame_loc) {
            this.frame = frame_loc;
        }

        @Override
        public void run() {
            MainFrame.this.setDatabaseBusyFiltered(true, Messages.getString("MainFrame.116") + MainFrame.this.database.getColumnName(this.col) + " ...");
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
            MainFrame.this.database.sortVector(this.col);
            MainFrame.this.setDatabaseBusyFiltered(false, Messages.getString("MainFrame.117"));
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

