/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import sqlrunner.Main;
import sqlrunner.Messages;
import sqlrunner.swinghelper.WindowHelper;

public class DBMessageDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JPanel jPanelText = new JPanel();
    private final JPanel jPanelButtons = new JPanel();
    private final JScrollPane jScrollPaneText = new JScrollPane();
    private final JTextArea textArea = new JTextArea();
    private final JButton buttonContinue = new JButton();
    private final JButton buttonCancel = new JButton();
    private final JCheckBox checkBoxIgnoreErrors = new JCheckBox();
    public static final int CONTINUE = 0;
    public static final int INGORE_ERRORS = 1;
    public static final int CANCEL = 2;
    private int returnCode = -1;

    public DBMessageDialog(JFrame parent, String message, String title) {
        super(parent, title, true);
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            this.pack();
            WindowHelper.locateWindowAtMiddle(parent, this);
            this.textArea.setText(message);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DBMessageDialog(JFrame parent, String message, String title, boolean enableContinue) {
        super(parent, title, true);
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            this.pack();
            Dimension screen = this.getToolkit().getScreenSize();
            int x = (screen.width >> 1) - (this.getSize().width >> 1);
            int y = (screen.height >> 1) - (this.getSize().height >> 1);
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
            this.buttonContinue.setEnabled(enableContinue);
            this.checkBoxIgnoreErrors.setEnabled(enableContinue);
            this.textArea.setText(message);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initComponents() throws Exception {
        int width = Integer.parseInt(Main.getUserProperty("DB_MESSAGE_WIDTH", "300"));
        int height = Integer.parseInt(Main.getUserProperty("DB_MESSAGE_HEIGHT", "200"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.jPanelText.setPreferredSize(new Dimension(width, height));
        this.jPanelButtons.setPreferredSize(new Dimension(300, 75));
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jPanelText.setLayout(new BorderLayout());
        this.textArea.setLineWrap(true);
        this.textArea.setBackground(new Color(255, 255, 223));
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Dialog", 0, 14));
        this.buttonContinue.setText(Messages.getString("DBMessageDialog.continue"));
        this.buttonContinue.addActionListener(this);
        this.buttonCancel.setText(Messages.getString("DBMessageDialog.cancel"));
        this.buttonCancel.addActionListener(this);
        this.checkBoxIgnoreErrors.setText(Messages.getString("DBMessageDialog.ignorenexterrors"));
        this.getContentPane().add((Component)this.jPanelText, "Center");
        this.jPanelText.add((Component)this.jScrollPaneText, "Center");
        this.jPanelButtons.add((Component)this.buttonContinue, gridBagConstraints);
        this.jPanelButtons.add((Component)this.checkBoxIgnoreErrors, gridBagConstraints1);
        this.jPanelButtons.add((Component)this.buttonCancel, gridBagConstraints2);
        this.jScrollPaneText.getViewport().add((Component)this.textArea, null);
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.getRootPane().setDefaultButton(this.buttonCancel);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.returnCode = 2;
            this.setVisible(false);
        } else if (e.getKeyCode() == 10) {
            this.returnCode = this.checkBoxIgnoreErrors.isSelected() ? 1 : 0;
            this.setVisible(false);
        }
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonContinue) {
            this.returnCode = this.checkBoxIgnoreErrors.isSelected() ? 1 : 0;
        } else if (e.getSource() == this.buttonCancel) {
            this.returnCode = 2;
        }
        this.setVisible(false);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.jPanelText.getSize().width > 300 && this.jPanelText.getSize().height > 200) {
            Main.setUserProperty("DB_MESSAGE_WIDTH", String.valueOf(this.jPanelText.getSize().width));
            Main.setUserProperty("DB_MESSAGE_HEIGHT", String.valueOf(this.jPanelText.getSize().height));
        } else {
            Main.setUserProperty("DB_MESSAGE_WIDTH", "300");
            Main.setUserProperty("DB_MESSAGE_HEIGHT", "200");
        }
    }
}

