/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.ConnectionDescription;
import dbtools.DatabaseType;
import dbtools.URLElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.Messages;
import sqlrunner.TextViewer;
import sqlrunner.swinghelper.WindowHelper;
import sqlrunner.text.StringReplacer;

public final class DBLoginDialog
extends JDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)DBLoginDialog.class.getName());
    private JButton buttonLogin;
    private JButton buttonSave;
    private JButton buttonDel;
    private JButton buttonClose;
    private JButton buttonNew;
    private JButton buttonSort;
    private JScrollPane jScrollPaneConnectionList;
    private DefaultListModel listModel;
    private JList list;
    private JComboBox comboBoxType;
    private ConnectionDescription desc;
    private Object[] selectedListValues;
    private ConnectionDescription selectedDesc;
    public static final int LOGIN_ACTION_PERFORMED = 0;
    public static final int CANCEL_ACTION_PERFORMED = 1;
    private int returnCode;
    private JScrollPane jScrollPaneInputFields;
    private JPanel panelElements;
    private List<URLComponent> urlComponents;
    private JCheckBox cbStorePasswd;
    private boolean inChooseFromListTransaction = false;
    private JTextField textFieldProperties;
    private JTextField textFieldComment;
    private JCheckBox checkBoxProductive;
    private JCheckBox checkBoxShowComment;
    private JCheckBox checkBoxExtendsUrlWidthProperties;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPaneInitSQL = null;
    private JTextArea jTextAreaInitSQL = null;
    private JCheckBox jCheckBoxRunInitSQL = null;
    private JTextField jTextFieldFetchSize = null;

    public DBLoginDialog(MainFrame mainFrame, String title) {
        super(mainFrame, title, true);
        this.enableEvents(64L);
        try {
            this.initComponents();
            this.loadConnectionList();
            this.pack();
            WindowHelper.locateWindowAtMiddle(mainFrame, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.cancel();
        } else if (e.getKeyCode() == 10) {
            this.buttonLogin_actionPerformed();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                this.cancel();
            }
        }
        super.processWindowEvent(e);
    }

    private void initComponents() throws Exception {
        this.setContentPane(this.getJContentPane());
        if (this.list.getModel().getSize() > 0) {
            this.list.requestFocus();
            this.list.setSelectedIndex(0);
        } else {
            this.createURLComponents((DatabaseType)this.comboBoxType.getSelectedItem());
        }
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.buttonLogin);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.list.getModel().getSize() > 0) {
            this.list.requestFocus();
            this.list.setSelectedIndex(0);
        }
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void loadComboBoxType() {
        for (int i = 0; i < ConnectionDescription.getDatabaseTypes().size(); ++i) {
            this.comboBoxType.addItem(ConnectionDescription.getDatabaseTypes().get(i));
        }
    }

    private boolean loadConnectionList() {
        boolean ok;
        block4: {
            ok = false;
            try {
                File iniFile = new File(Main.getFileNameForConnectionList());
                if (iniFile.exists()) {
                    String line;
                    BufferedReader fr = new BufferedReader(new FileReader(iniFile));
                    this.listModel.removeAllElements();
                    while ((line = fr.readLine()) != null) {
                        this.listModel.addElement(new ConnectionDescription(line));
                    }
                    this.list.setModel(this.listModel);
                    fr.close();
                    ok = true;
                }
            }
            catch (Exception ioe) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)("DBLogin.loadList: " + ioe.toString()));
            }
        }
        return ok;
    }

    private boolean saveList() {
        boolean ok = false;
        try {
            File iniFile = new File(Main.getFileNameForConnectionList());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DBLoginDialog.saveList: in Datei: " + Main.getFileNameForConnectionList() + "..."));
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(iniFile));
            for (int i = 0; i < this.listModel.size(); ++i) {
                bw.write(((ConnectionDescription)this.listModel.getElementAt(i)).getParamStr());
                bw.newLine();
            }
            bw.flush();
            bw.close();
            ok = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getString("DBLoginDialog.readydot"));
            }
        }
        catch (Exception ioe) {
            logger.warn((Object)("DBLogin.saveList: " + ioe.toString() + "exception: " + ioe));
        }
        return ok;
    }

    public void cancel() {
        this.returnCode = 1;
        this.setVisible(false);
    }

    public ConnectionDescription getConnectionDescription() {
        return this.desc;
    }

    private void buttonLogin_actionPerformed() {
        DatabaseType dt = (DatabaseType)this.comboBoxType.getSelectedItem();
        this.desc = new ConnectionDescription();
        this.fillConnectionDescription(this.desc, dt);
        this.addToListModel(this.desc);
        this.saveList();
        this.returnCode = 0;
        this.setVisible(false);
    }

    private void buttonSave_actionPerformed() {
        DatabaseType dt = (DatabaseType)this.comboBoxType.getSelectedItem();
        this.desc = (ConnectionDescription)this.list.getSelectedValue();
        if (this.desc != null) {
            this.fillConnectionDescription(this.desc, dt);
            this.list.repaint();
        }
    }

    private void fillConnectionDescription(ConnectionDescription desc, DatabaseType dt) {
        desc.setDatabaseType(dt);
        desc.setURLElements(this.getURLElementsFromComponents());
        desc.setStorePasswdEnabled(this.cbStorePasswd.isSelected());
        desc.setProductive(this.getProductive());
        desc.setComment(this.getCommentText());
        desc.setDefaultFetchSize(this.getDefaultFetchSize());
        desc.setInitSQL(this.getInitSQL());
        desc.setPropertiesString(this.getPropertiesText());
        desc.createURL();
    }

    public void setInitialConnectionDescription(ConnectionDescription cd) {
        this.fillFormular(cd);
        this.list.clearSelection();
    }

    private void addToListModel(ConnectionDescription desc_loc) {
        for (int i = 0; i < this.listModel.size(); ++i) {
            if (!((ConnectionDescription)this.listModel.elementAt(i)).equals(desc_loc)) continue;
            this.listModel.removeElementAt(i);
        }
        this.listModel.insertElementAt(desc_loc, 0);
    }

    private void buttonDel_actionPerformed() {
        if (this.selectedListValues != null) {
            for (int i = this.selectedListValues.length - 1; i >= 0; --i) {
                this.listModel.removeElement(this.selectedListValues[i]);
            }
        }
    }

    private void buttonSort_actionPerformed() {
        ArrayList<ConnectionDescription> listItems = new ArrayList<ConnectionDescription>();
        int n = this.listModel.getSize();
        for (int i = 0; i < n; ++i) {
            ConnectionDescription listItem = (ConnectionDescription)this.listModel.elementAt(i);
            if (listItem == null) continue;
            listItems.add(listItem);
        }
        Collections.sort(listItems, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s1 = o1.toString().toLowerCase();
                String s2 = o2.toString().toLowerCase();
                return s1.compareTo(s2);
            }
        });
        this.listModel.clear();
        for (ConnectionDescription listItem : listItems) {
            this.listModel.addElement(listItem);
        }
    }

    private void buttonClose_actionPerformed() {
        this.desc = null;
        this.saveList();
        this.cancel();
    }

    public int getReturnAction() {
        return this.returnCode;
    }

    public void disposeDialog() {
        this.dispose();
    }

    private void showSelectedConnectionDescPropertiesInTextWindow() {
        if (this.selectedDesc != null) {
            new TextViewer(this, Messages.getString("DBLoginDialog.propertiesforconnection"), this.selectedDesc.getDatabasePropertyString());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.selectedListValues = this.list.getSelectedValues();
        if (this.selectedListValues != null && this.selectedListValues.length == 1) {
            this.selectedDesc = (ConnectionDescription)this.list.getSelectedValue();
            this.fillFormular(this.selectedDesc);
        }
    }

    private void fillFormular(ConnectionDescription descNew) {
        if (descNew != null) {
            this.desc = descNew;
            this.inChooseFromListTransaction = true;
            this.comboBoxType.setSelectedItem(this.desc.getDatabaseType());
            if (this.desc != null) {
                this.createURLComponents(this.desc);
                this.textFieldComment.setText(this.desc.getComment());
                this.textFieldProperties.setText(this.desc.getPropertiesString());
                int value = this.desc.getDefaultFetchSize();
                if (value != -1) {
                    this.jTextFieldFetchSize.setText(String.valueOf(value));
                } else {
                    this.jTextFieldFetchSize.setText(null);
                }
                if (this.desc.getInitSQL() != null) {
                    StringReplacer sr = new StringReplacer(this.desc.getInitSQL());
                    sr.replace(";", ";\n");
                    this.jTextAreaInitSQL.setText(sr.getResultText().trim());
                } else {
                    this.jTextAreaInitSQL.setText(null);
                }
                this.checkBoxProductive.setSelected(this.desc.isProductive());
            }
            this.inChooseFromListTransaction = false;
        }
    }

    private void list_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.list.getSelectedIndex() != -1) {
            this.listModel.removeElement(this.list.getSelectedValue());
        }
    }

    private void createListContextMenu(int mouseXPos, int mouseYPos) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem(Messages.getString("DBLoginDialog.showpropertiesinwindow"));
        mi.setActionCommand("showPropertiesInTextWindow");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBLoginDialog.this.showSelectedConnectionDescPropertiesInTextWindow();
            }
        });
        popup.add(mi);
        Dimension popupSize = popup.getPreferredSize();
        int yLoc = mouseYPos;
        int absMouseXPos = mouseXPos - this.jScrollPaneConnectionList.getHorizontalScrollBar().getValue() + this.getLocation().x;
        int xLoc = absMouseXPos + popupSize.width > this.getToolkit().getScreenSize().width ? mouseXPos - popupSize.width : mouseXPos;
        popup.show(this.list, xLoc, yLoc);
    }

    private void comboBoxType_itemStateChanged() {
        if (!this.inChooseFromListTransaction) {
            this.list.clearSelection();
            this.textFieldComment.setText(null);
            this.textFieldProperties.setText(null);
            this.jTextAreaInitSQL.setText(null);
            this.createURLComponents((DatabaseType)this.comboBoxType.getSelectedItem());
        }
    }

    private void createURLComponents(DatabaseType dt) {
        if (dt != null) {
            int rows = dt.getURLElements().size();
            int remainder = rows % 2;
            rows = (rows >> 1) + remainder;
            this.urlComponents = new ArrayList<URLComponent>();
            JPanel panel = this.getPanelElements();
            panel.removeAll();
            panel.setLayout(new GridLayout(rows, 2, 0, 0));
            for (int i = 0; i < dt.getURLElements().size(); ++i) {
                URLElement element = dt.getURLElements().get(i);
                URLComponent comp = new URLComponent(element);
                this.urlComponents.add(comp);
                if (element.getName().equalsIgnoreCase("USER")) {
                    panel.add((Component)comp, 0);
                    continue;
                }
                if (element.getName().equalsIgnoreCase("PASSWORD")) {
                    panel.add((Component)comp, 1);
                    continue;
                }
                panel.add(comp);
            }
            this.checkBoxProductive.setSelected(false);
            this.jScrollPaneInputFields.validate();
            this.jScrollPaneInputFields.repaint();
        }
    }

    private void createURLComponents(ConnectionDescription desc_loc) {
        if (desc_loc != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DBLoginDialog.createURLComponents from Description:" + desc_loc));
            }
            int rows = desc_loc.getURLElements().size();
            int remainder = rows % 2;
            rows = (rows >> 1) + remainder;
            this.urlComponents = new ArrayList<URLComponent>();
            JPanel panel = this.getPanelElements();
            panel.removeAll();
            panel.setLayout(new GridLayout(rows, 2, 0, 0));
            for (int i = 0; i < desc_loc.getURLElements().size(); ++i) {
                URLElement element = desc_loc.getURLElements().get(i);
                URLComponent comp = new URLComponent(element);
                this.urlComponents.add(comp);
                if (element.getName().equalsIgnoreCase("USER")) {
                    panel.add((Component)comp, 0);
                } else if (element.getName().equalsIgnoreCase("PASSWORD")) {
                    panel.add((Component)comp, 1);
                } else {
                    panel.add(comp);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("add URLComponent:" + comp));
            }
            this.jScrollPaneInputFields.validate();
            this.jScrollPaneInputFields.repaint();
        }
    }

    private ArrayList<URLElement> getURLElementsFromComponents() {
        ArrayList<URLElement> urlElements = new ArrayList<URLElement>();
        for (int i = 0; i < this.urlComponents.size(); ++i) {
            URLComponent urlComponent = this.urlComponents.get(i);
            urlElements.add(new URLElement(urlComponent.getLabelText(), urlComponent.getValue()));
        }
        return urlElements;
    }

    public String getCommentText() {
        if (this.textFieldComment.getText() == null || this.textFieldComment.getText().trim().length() == 0) {
            return "";
        }
        String comment = this.textFieldComment.getText();
        if (comment.indexOf(124) != -1) {
            return comment.replace('|', ' ');
        }
        return comment;
    }

    private int getDefaultFetchSize() {
        if (this.jTextFieldFetchSize.getText() == null || this.jTextFieldFetchSize.getText().trim().length() == 0) {
            return -1;
        }
        return Integer.parseInt(this.jTextFieldFetchSize.getText());
    }

    private String getInitSQL() {
        if (this.jTextAreaInitSQL.getText() == null || this.jTextAreaInitSQL.getText().trim().length() == 0) {
            return "";
        }
        StringReplacer sr = new StringReplacer(this.jTextAreaInitSQL.getText());
        sr.replace("\n", "");
        return sr.getResultText();
    }

    private boolean getProductive() {
        return this.checkBoxProductive.isSelected();
    }

    private String getPropertiesText() {
        if (this.textFieldProperties.getText() == null || this.textFieldProperties.getText().trim().length() == 0) {
            return "";
        }
        return this.textFieldProperties.getText();
    }

    private void checkBoxShowComment_itemStateChanged() {
        ConnectionDescription.setShowCommentAsDefault(this.checkBoxShowComment.isSelected());
        this.list.repaint();
        if (this.checkBoxShowComment.isSelected()) {
            Main.setUserProperty("LOGIN_SHOW_COMMENT", "true");
        } else {
            Main.setUserProperty("LOGIN_SHOW_COMMENT", "false");
        }
    }

    private void checkBoxExtendsUrlWidthProperties_itemStateChanged() {
        ConnectionDescription.setExtendsUrlWithProperties(this.checkBoxExtendsUrlWidthProperties.isSelected());
        this.list.repaint();
        if (this.checkBoxExtendsUrlWidthProperties.isSelected()) {
            Main.setUserProperty("LOGIN_PROPERTIES_IN_URL", "true");
        } else {
            Main.setUserProperty("LOGIN_PROPERTIES_IN_URL", "false");
        }
    }

    private void checkBoxRunInitSQL_itemStateChanged() {
        ConnectionDescription.setRunInitialSQLOnConnect(this.jCheckBoxRunInitSQL.isSelected());
        if (this.jCheckBoxRunInitSQL.isSelected()) {
            Main.setUserProperty("RUN_INIT_SQL", "true");
        } else {
            Main.setUserProperty("RUN_INIT_SQL", "false");
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.createPanelListConnections(), "Center");
            this.jContentPane.add((Component)this.createPanelConnectionDetails(), "North");
            this.jContentPane.add((Component)this.createPanelButtons(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getPanelElements() {
        if (this.panelElements == null) {
            this.panelElements = new JPanel();
        }
        return this.panelElements;
    }

    private JPanel createPanelAdditionConnectionDetails() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setMinimumSize(new Dimension(200, 75));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridy = 0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.anchor = 13;
        gbc.gridx = 0;
        JLabel label = new JLabel();
        label.setHorizontalAlignment(4);
        label.setText("Properties");
        p.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 0, 2, 0);
        this.textFieldProperties = new JTextField();
        this.textFieldProperties.setBackground(Main.info);
        this.textFieldProperties.setToolTipText("key1=value1;key2=value2...");
        p.add((Component)this.textFieldProperties, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridy = 0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.anchor = 17;
        gbc.gridx = 2;
        this.checkBoxExtendsUrlWidthProperties = new JCheckBox();
        this.checkBoxExtendsUrlWidthProperties.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DBLoginDialog.this.checkBoxExtendsUrlWidthProperties_itemStateChanged();
            }
        });
        this.checkBoxExtendsUrlWidthProperties.setText(Messages.getString("DBLoginDialog.embeddinurl"));
        this.checkBoxExtendsUrlWidthProperties.setSelected(Main.getUserProperty("LOGIN_PROPERTIES_IN_URL", "false").equals("true"));
        p.add((Component)this.checkBoxExtendsUrlWidthProperties, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridy = 2;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.anchor = 13;
        gbc.gridx = 0;
        label = new JLabel();
        label.setHorizontalAlignment(4);
        label.setText(Messages.getString("DBLoginDialog.comment"));
        p.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 0, 2, 0);
        this.textFieldComment = new JTextField();
        this.textFieldComment.setBackground(Main.info);
        this.textFieldComment.setToolTipText(Messages.getString("DBLoginDialog.tooltipcleartextforconnection"));
        p.add((Component)this.textFieldComment, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridy = 2;
        gbc.ipadx = 0;
        gbc.ipady = -4;
        gbc.anchor = 17;
        gbc.gridx = 2;
        this.checkBoxShowComment = new JCheckBox();
        this.checkBoxShowComment.setText(Messages.getString("DBLoginDialog.showinlist"));
        this.checkBoxShowComment.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getID() == 701) {
                    DBLoginDialog.this.checkBoxShowComment_itemStateChanged();
                }
            }
        });
        this.checkBoxShowComment.setSelected(Main.getUserProperty("LOGIN_SHOW_COMMENT", "false").equals("true"));
        p.add((Component)this.checkBoxShowComment, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridy = 3;
        label = new JLabel();
        label.setText("initial SQL");
        p.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 1;
        p.add((Component)this.getJScrollPaneInitSQL(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridy = 3;
        p.add((Component)this.getJCheckBoxRunInitSQL(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        label = new JLabel();
        label.setText("fetchsize");
        p.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 0, 0, 0);
        gbc.gridx = 1;
        p.add((Component)this.getJTextFieldFetchSize(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridx = 2;
        gbc.anchor = 17;
        p.add((Component)this.getCheckBoxProductive(), gbc);
        return p;
    }

    private JPanel createPanelConnectionType() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setPreferredSize(new Dimension(503, 35));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 5, 10, 0);
        gbc.gridx = 0;
        JLabel label = new JLabel();
        label.setForeground(Color.black);
        label.setText(Messages.getString("DBLoginDialog.type"));
        label.setHorizontalTextPosition(11);
        label.setHorizontalAlignment(4);
        p.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 10, 5);
        p.add((Component)this.getComboBoxTypes(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 0, 10, 5);
        gbc.gridx = 2;
        p.add((Component)this.getJButtonNew(), gbc);
        return p;
    }

    private JComboBox getComboBoxTypes() {
        if (this.comboBoxType == null) {
            this.comboBoxType = new JComboBox();
            this.loadComboBoxType();
            this.comboBoxType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getID() == 701) {
                        DBLoginDialog.this.comboBoxType_itemStateChanged();
                    }
                }
            });
        }
        return this.comboBoxType;
    }

    private JButton getJButtonNew() {
        if (this.buttonNew == null) {
            this.buttonNew = new JButton();
            this.buttonNew.setText(Messages.getString("DBLoginDialog.new"));
            this.buttonNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBLoginDialog.this.comboBoxType_itemStateChanged();
                }
            });
        }
        return this.buttonNew;
    }

    private JPanel createPanelConnectionDetails() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setPreferredSize(new Dimension(650, 300));
        p.setMinimumSize(p.getPreferredSize());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.ipadx = 0;
        gbc.fill = 2;
        gbc.gridy = 0;
        p.add((Component)this.createPanelConnectionType(), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        this.jScrollPaneInputFields = new JScrollPane();
        this.jScrollPaneInputFields.setPreferredSize(new Dimension(200, 100));
        this.jScrollPaneInputFields.setViewportView(this.getPanelElements());
        p.add((Component)this.jScrollPaneInputFields, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.ipadx = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.gridy = 2;
        p.add((Component)this.createPanelAdditionConnectionDetails(), gbc);
        return p;
    }

    private JList getListConnections() {
        if (this.list == null) {
            this.listModel = new DefaultListModel();
            this.list = new JList(this.listModel);
            this.list.setFont(new Font("Dialog", 0, 12));
            this.list.addListSelectionListener(this);
            this.list.setBackground(Main.info);
            this.list.setSelectionMode(2);
            this.list.addMouseListener(new ListMouseListener());
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    DBLoginDialog.this.list_keyPressed(e);
                }
            });
        }
        return this.list;
    }

    private JPanel createPanelListConnections() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setPreferredSize(new Dimension(650, 200));
        p.setMinimumSize(new Dimension(650, 50));
        this.jScrollPaneConnectionList = new JScrollPane();
        this.jScrollPaneConnectionList.setViewportView(this.getListConnections());
        p.add((Component)this.jScrollPaneConnectionList, null);
        return p;
    }

    private JPanel createPanelButtons() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        p.add((Component)this.getJButtonLogin(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.cbStorePasswd = new JCheckBox();
        this.cbStorePasswd.setText(Messages.getString("DBLoginDialog.savepasswort"));
        this.cbStorePasswd.setSelected(true);
        p.add((Component)this.cbStorePasswd, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        p.add((Component)this.getJButtonSave(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        p.add((Component)this.getJButtonDel(), gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy = 0;
        gbc.gridx = 4;
        p.add((Component)this.getJButtonClose(), gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy = 0;
        gbc.gridx = 5;
        p.add((Component)this.getJButtonSort(), gbc);
        return p;
    }

    private JButton getJButtonLogin() {
        if (this.buttonLogin == null) {
            this.buttonLogin = new JButton();
            this.buttonLogin.setText(Messages.getString("DBLoginDialog.login"));
            this.buttonLogin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBLoginDialog.this.buttonLogin_actionPerformed();
                }
            });
        }
        return this.buttonLogin;
    }

    private JButton getJButtonSave() {
        if (this.buttonSave == null) {
            this.buttonSave = new JButton();
            this.buttonSave.setText(Messages.getString("DBLoginDialog.apply"));
            this.buttonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBLoginDialog.this.buttonSave_actionPerformed();
                }
            });
        }
        return this.buttonSave;
    }

    private JButton getJButtonDel() {
        if (this.buttonDel == null) {
            this.buttonDel = new JButton();
            this.buttonDel.setText(Messages.getString("DBLoginDialog.delete"));
            this.buttonDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBLoginDialog.this.buttonDel_actionPerformed();
                }
            });
        }
        return this.buttonDel;
    }

    private JButton getJButtonClose() {
        if (this.buttonClose == null) {
            this.buttonClose = new JButton();
            this.buttonClose.setText(Messages.getString("DBLoginDialog.close"));
            this.buttonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBLoginDialog.this.buttonClose_actionPerformed();
                }
            });
        }
        return this.buttonClose;
    }

    private JButton getJButtonSort() {
        if (this.buttonSort == null) {
            this.buttonSort = new JButton();
            this.buttonSort = new JButton();
            this.buttonSort.setText(Messages.getString("DBLoginDialog.sort"));
            this.buttonSort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBLoginDialog.this.buttonSort_actionPerformed();
                }
            });
        }
        return this.buttonSort;
    }

    private JScrollPane getJScrollPaneInitSQL() {
        if (this.jScrollPaneInitSQL == null) {
            this.jScrollPaneInitSQL = new JScrollPane();
            this.jScrollPaneInitSQL.setPreferredSize(new Dimension(10, 50));
            this.jScrollPaneInitSQL.setViewportView(this.getJTextAreaInitSQL());
        }
        return this.jScrollPaneInitSQL;
    }

    private JTextArea getJTextAreaInitSQL() {
        if (this.jTextAreaInitSQL == null) {
            this.jTextAreaInitSQL = new JTextArea();
        }
        return this.jTextAreaInitSQL;
    }

    private JCheckBox getJCheckBoxRunInitSQL() {
        if (this.jCheckBoxRunInitSQL == null) {
            this.jCheckBoxRunInitSQL = new JCheckBox();
            this.jCheckBoxRunInitSQL.setText(Messages.getString("DBLoginDialog.execute"));
            this.jCheckBoxRunInitSQL.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getID() == 701) {
                        DBLoginDialog.this.checkBoxRunInitSQL_itemStateChanged();
                    }
                }
            });
            this.jCheckBoxRunInitSQL.setSelected(Main.getUserProperty("RUN_INIT_SQL", "false").equals("true"));
        }
        return this.jCheckBoxRunInitSQL;
    }

    private JCheckBox getCheckBoxProductive() {
        if (this.checkBoxProductive == null) {
            this.checkBoxProductive = new JCheckBox();
            this.checkBoxProductive.setText(Messages.getString("DBLoginDialog.productive"));
        }
        return this.checkBoxProductive;
    }

    private JTextField getJTextFieldFetchSize() {
        if (this.jTextFieldFetchSize == null) {
            this.jTextFieldFetchSize = new JTextField();
            this.jTextFieldFetchSize.setBackground(new Color(250, 250, 220));
        }
        return this.jTextFieldFetchSize;
    }

    private final class URLComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel label = new JLabel();
        private JTextField textField;
        private JPasswordField passwdField;
        private boolean isPasswordField = false;

        URLComponent(URLElement element) {
            this.setLayout(new BoxLayout(this, 0));
            this.label.setFont(new Font("Dialog", 0, 11));
            this.label.setForeground(Color.black);
            this.label.setText(element.getName());
            this.label.setToolTipText(element.getName());
            this.label.setHorizontalAlignment(4);
            this.label.setPreferredSize(new Dimension(90, 22));
            this.label.setMaximumSize(new Dimension(90, 22));
            this.label.setMinimumSize(new Dimension(90, 22));
            this.add(this.label);
            if (element.getName().equalsIgnoreCase("PASSWORD")) {
                this.passwdField = new JPasswordField();
                this.passwdField.setBackground(Main.info);
                this.passwdField.setPreferredSize(new Dimension(200, 22));
                this.passwdField.setMaximumSize(new Dimension(200, 22));
                this.passwdField.setMinimumSize(new Dimension(200, 22));
                this.passwdField.setText(element.getValue());
                this.add(this.passwdField);
                this.isPasswordField = true;
            } else {
                this.textField = new JTextField();
                this.textField.setBackground(Main.info);
                this.textField.setText(element.getValue());
                this.textField.setPreferredSize(new Dimension(200, 22));
                this.textField.setMaximumSize(new Dimension(200, 22));
                this.textField.setMinimumSize(new Dimension(200, 22));
                this.add(this.textField);
            }
        }

        String getLabelText() {
            return this.label.getText();
        }

        String getValue() {
            if (this.isPasswordField) {
                return String.valueOf(this.passwdField.getPassword());
            }
            return this.textField.getText().trim();
        }

        @Override
        public String toString() {
            return this.getClass().getName() + " label=" + this.getLabelText() + " value=" + this.getValue();
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (!me.isPopupTrigger() && me.getClickCount() == 2) {
                this.fireDoubleClickPerformed(me);
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                DBLoginDialog.this.createListContextMenu(me.getX(), me.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                DBLoginDialog.this.createListContextMenu(me.getX(), me.getY());
            }
        }

        protected void fireDoubleClickPerformed(MouseEvent me) {
            DBLoginDialog.this.buttonLogin_actionPerformed();
        }
    }
}

