/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.SQLParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sqlrunner.AdminSQLConfigDialog;
import sqlrunner.AdminStatement;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.Messages;
import sqlrunner.resources.ApplicationIcons;
import sqlrunner.swinghelper.WindowHelper;

public class AdminToolChooser
extends JFrame
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private final JPanel panelList = new JPanel();
    private final JPanel panelControl = new JPanel();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final DefaultListModel model = new DefaultListModel();
    private final JList list = new JList(this.model);
    private final JButton buttonRun = new JButton();
    private final JButton buttonEdit = new JButton();
    private transient AdminStatement as;
    private transient AdminSQLConfigDialog ascd;
    private MainFrame mainFrame;

    public AdminToolChooser(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.jbInit();
            this.pack();
            WindowHelper.locateWindowAtMiddle(mainFrame, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void jbInit() throws Exception {
        this.setTitle(Messages.getString("AdminToolChooser.title"));
        this.getRootPane().setDefaultButton(this.buttonRun);
        this.panelList.setPreferredSize(new Dimension(400, 350));
        this.panelList.setLayout(new BorderLayout());
        this.buttonRun.setMnemonic('A');
        this.buttonRun.setText(Messages.getString("AdminToolChooser.buttonRun"));
        this.buttonRun.addActionListener(this);
        this.buttonEdit.setText(Messages.getString("AdminToolChooser.copytoscriptwindow"));
        this.buttonEdit.addActionListener(this);
        this.getContentPane().add((Component)this.panelList, "Center");
        this.getContentPane().add((Component)this.panelControl, "South");
        this.panelList.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
        this.panelControl.add((Component)this.buttonRun, null);
        this.panelControl.add((Component)this.buttonEdit, null);
        this.list.setFont(new Font("Dialog", 0, 12));
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new ListMouseListener());
        this.list.setEnabled(true);
        this.list.setBackground(Main.info);
        this.list.setCellRenderer(new ATListCellRenderer());
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent winEvent) {
        switch (winEvent.getID()) {
            case 201: {
                this.setVisible(false);
                break;
            }
            default: {
                super.processWindowEvent(winEvent);
            }
        }
    }

    public void fillList() {
        this.clearList();
        int dbtype = this.mainFrame.getDatabase().getDatabaseSession().getConnectionDescription().getDatabaseType().getAdminOptionID();
        for (int i = 0; i < AdminStatement.adminSQLs.size(); ++i) {
            AdminStatement astat = AdminStatement.adminSQLs.elementAt(i);
            if (astat.getDbType() != dbtype && astat.getDbType() != 0) continue;
            this.model.addElement(astat);
        }
    }

    public void clearList() {
        this.model.removeAllElements();
        this.as = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonRun) {
            this.buttonRun_actionPerformed();
        } else if (e.getSource() == this.buttonEdit && this.as != null) {
            this.mainFrame.toFront();
            this.mainFrame.setScriptText(this.as.getSQL());
        }
    }

    private void buttonRun_actionPerformed() {
        if (this.as != null) {
            if (this.as.getCommand() == 'A') {
                SQLParser parser = new SQLParser(this.as.getSQL(), true);
                this.mainFrame.toFront();
                this.mainFrame.getDatabase().executeScript(parser, false);
            } else if (this.as.getCommand() == 'E') {
                this.ascd = new AdminSQLConfigDialog(this, this.as.getComment(), this.as.getSQL());
                if (this.ascd.getReturnCode() == 0) {
                    SQLParser parser = new SQLParser(this.ascd.getSQL(), true);
                    this.mainFrame.toFront();
                    this.mainFrame.getDatabase().executeScript(parser, false);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.as = (AdminStatement)this.list.getSelectedValue();
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (!me.isControlDown() && me.getClickCount() == 2) {
                this.fireDoubleClickPerformed(me);
            }
        }

        protected void fireDoubleClickPerformed(MouseEvent me) {
            AdminToolChooser.this.buttonRun_actionPerformed();
        }
    }

    private static class ATListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        ATListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            AdminStatement as_loc = (AdminStatement)value;
            this.setText(as_loc.getComment());
            if (as_loc.getCommand() == 'A') {
                this.setIcon(ApplicationIcons.ADMINRUN_PNG);
            } else if (as_loc.getCommand() == 'E') {
                this.setIcon(ApplicationIcons.ADMINEDIT_PNG);
            } else {
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setComponentOrientation(list.getComponentOrientation());
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }
}

