/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import sqlrunner.swinghelper.WindowHelper;

public final class AdminSQLConfigDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JPanel jPanel1 = new JPanel();
    private final JScrollPane jScrollPaneValues = new JScrollPane();
    private final JPanel jPanelButtons = new JPanel();
    private final JButton buttonCancel = new JButton();
    private final JButton buttonOk = new JButton();
    private final JPanel panelParameters = new JPanel(){
        private static final long serialVersionUID = 1L;
        Insets insets = new Insets(0, 4, 0, 0);

        @Override
        public Insets getInsets() {
            return this.insets;
        }
    };
    private StringBuffer sql;
    private String sqltemplate;
    private static final String START_LIMITER = "{";
    private static final String END_LIMITER = "}";
    private Vector<ParameterInput> parameters = new Vector();
    static final int OK = 0;
    static final int CANCEL = 1;
    private int returnCode = 1;

    public AdminSQLConfigDialog(JFrame parent, String comment, String sqltemplate) {
        super(parent, comment, true);
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.jbInit();
            this.pack();
            Dimension screen = this.getToolkit().getScreenSize();
            int x = (screen.width >> 1) - (this.getSize().width >> 1);
            int y = (screen.height >> 1) - (this.getSize().height >> 1);
            this.setLocation(x, y);
            this.setSQLTemplate(sqltemplate);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void jbInit() throws Exception {
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.buttonCancel.setText("Abbrechen");
        this.buttonCancel.addActionListener(this);
        this.buttonOk.setText("OK");
        this.buttonOk.addActionListener(this);
        this.jPanel1.setPreferredSize(new Dimension(300, 200));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.panelParameters.setBackground(SystemColor.control);
        this.jPanel1.add(this.jScrollPaneValues);
        this.panelParameters.setLayout(new BoxLayout(this.panelParameters, 1));
        this.jScrollPaneValues.setViewportView(this.panelParameters);
        this.jPanelButtons.add((Component)this.buttonOk, null);
        this.jPanelButtons.add((Component)this.buttonCancel, null);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.getContentPane().add((Component)this.jPanelButtons, "South");
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.dispose();
        }
    }

    private void addParameterInput(String name, int p0, int p1) {
        ParameterInput pi = new ParameterInput(name, p0, p1);
        this.parameters.addElement(pi);
        this.panelParameters.add(pi);
    }

    public void setSQLTemplate(String sqltemplate_loc) {
        this.sqltemplate = sqltemplate_loc;
        this.sql = new StringBuffer();
        this.parameters = new Vector();
        boolean fertig = false;
        int p1 = 0;
        while (!fertig) {
            int p0 = sqltemplate_loc.indexOf(START_LIMITER, p1);
            if (p0 != -1) {
                p1 = sqltemplate_loc.indexOf(END_LIMITER, p0);
                if (p1 == -1) continue;
                this.addParameterInput(sqltemplate_loc.substring(p0 + 1, p1), p0, p1 + 1);
                p1 = p0 + 1;
                continue;
            }
            fertig = true;
        }
    }

    public String getSQL() {
        ParameterInput pi0 = null;
        if (this.parameters.size() > 0) {
            pi0 = this.parameters.elementAt(0);
            this.sql.append(this.sqltemplate.substring(0, pi0.getStartIndex()));
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            pi0 = this.parameters.elementAt(i);
            this.sql.append(pi0.getValue());
            if (i + 1 >= this.parameters.size()) continue;
            ParameterInput pi1 = this.parameters.elementAt(i + 1);
            this.sql.append(this.sqltemplate.substring(pi0.getEndIndex(), pi1.getStartIndex()));
        }
        if (pi0 != null) {
            this.sql.append(this.sqltemplate.substring(pi0.getEndIndex(), this.sqltemplate.length()));
        }
        return this.sql.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancel) {
            this.returnCode = 1;
            this.dispose();
        } else if (e.getSource() == this.buttonOk) {
            this.returnCode = 0;
            this.dispose();
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    static class ParameterInput
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel label;
        private JTextField textField;
        private int p0;
        private int p1;

        ParameterInput(String paramName, int p0, int p1) {
            this.p0 = p0;
            this.p1 = p1;
            this.setLayout(null);
            this.label = new JLabel();
            this.label.setForeground(Color.black);
            this.label.setHorizontalAlignment(4);
            this.label.setBounds(2, 2, 100, 25);
            this.label.setText(paramName);
            this.label.setToolTipText(paramName);
            this.textField = new JTextField();
            this.textField.setBounds(106, 2, 160, 25);
            this.textField.setBackground(SystemColor.info);
            this.add(this.label);
            this.add(this.textField);
            this.setPreferredSize(new Dimension(4 + this.label.getBounds().width + this.textField.getBounds().width, 29));
        }

        public String getParamName() {
            return this.label.getText();
        }

        public int getStartIndex() {
            return this.p0;
        }

        public int getEndIndex() {
            return this.p1;
        }

        public String getValue() {
            return this.textField.getText().trim();
        }
    }
}

