/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.DatabaseSessionPoolInfoPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.Messages;
import sqlrunner.log4jpanel.Log4JPanel;
import sqlrunner.log4jpanel.LogPanel;
import sqlrunner.swinghelper.WindowHelper;

public final class AboutDialog
extends JDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(AboutDialog.class);
    private static final long serialVersionUID = 1L;
    private JButton buttonCancel;
    private long freeMem;
    private long totalMem;
    private transient Runtime rt = null;
    private JPanel jPanelInfo;
    private JLabel jLabelRAMfree;
    private JLabel jLabelRAMtotal;
    private Timer updateTimer;
    private JPanel jContentPane = null;
    private DatabaseSessionPoolInfoPanel poolInfoPanel;
    private JTabbedPane jTabbedPane = null;

    public AboutDialog() {
        this.getRootPane().putClientProperty("Window.style", "small");
        this.initComponents();
    }

    public AboutDialog(JFrame parent) {
        super(parent);
        this.enableEvents(64L);
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.rt = Runtime.getRuntime();
            this.initComponents();
            this.pack();
        }
        catch (Exception e) {
            System.err.println("AboutDialog: error in constructor");
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("cancel")) {
            this.cancel();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (visible) {
            this.updateTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog.this.refreshMemoryView();
                }
            });
            this.updateTimer.setRepeats(true);
            this.updateTimer.setInitialDelay(2000);
            this.updateTimer.start();
            this.poolInfoPanel.startRefreshing();
        } else {
            if (this.updateTimer != null && this.updateTimer.isRunning()) {
                this.updateTimer.stop();
                this.updateTimer = null;
            }
            this.poolInfoPanel.stopRefreshing();
        }
        super.setVisible(visible);
    }

    private void initComponents() {
        this.setContentPane(this.getJContentPane());
        this.setTitle("Info");
        this.getRootPane().setDefaultButton(this.getJButtonClose());
        this.setPreferredSize(new Dimension(600, 500));
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                this.cancel();
                break;
            }
            case 205: {
                this.refreshMemoryView();
            }
        }
        super.processWindowEvent(e);
    }

    private String loadTextResource(String fname) throws IOException {
        String ret = null;
        try {
            InputStream is = this.getClass().getResourceAsStream("/" + fname);
            if (is != null) {
                InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                StringBuffer sb = new StringBuffer();
                char[] buffer = new char[1024];
                int length = 0;
                while ((length = isr.read(buffer)) > 0) {
                    sb.append(buffer, 0, length);
                }
                isr.close();
                is.close();
                ret = sb.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("loadTextResource: failed: " + e.getMessage()), (Throwable)e);
        }
        return ret;
    }

    void cancel() {
        this.updateTimer.stop();
        this.updateTimer = null;
        this.dispose();
    }

    private void refreshMemoryView() {
        this.totalMem = this.rt.totalMemory() / 1024L;
        this.freeMem = this.rt.freeMemory() / 1024L;
        this.jLabelRAMfree.setText(this.freeMem + "k");
        this.jLabelRAMtotal.setText(this.totalMem + "k");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.jContentPane.add((Component)this.getJTabbedPane(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.getJButtonClose(), gbc);
        }
        return this.jContentPane;
    }

    private JButton getJButtonClose() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new JButton();
            this.buttonCancel.setText(Messages.getString("AboutDialog.close"));
            this.buttonCancel.setActionCommand("cancel");
            this.buttonCancel.addActionListener(this);
        }
        return this.buttonCancel;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.add(Messages.getString("AboutDialog.info"), this.getJPanelInfo());
            this.jTabbedPane.add(Messages.getString("AboutDialog.releasenotes"), this.getScrollPaneReleaseNotes());
            this.jTabbedPane.add(Messages.getString("AboutDialog.systemproperties"), this.getScrollPaneSystemProperties());
            this.jTabbedPane.add(Messages.getString("AboutDialog.uidefaults"), this.getScrollPaneLnFProperties());
            this.jTabbedPane.add(Messages.getString("AboutDialog.poolinfo"), this.getDatabasePoolInfoPanel());
            this.jTabbedPane.add(Messages.getString("AboutDialog.loginfo"), LogPanel.getInstance());
            this.jTabbedPane.add(Messages.getString("AboutDialog.log4j"), new Log4JPanel());
        }
        return this.jTabbedPane;
    }

    private JPanel getDatabasePoolInfoPanel() {
        if (this.poolInfoPanel == null) {
            this.poolInfoPanel = new DatabaseSessionPoolInfoPanel();
        }
        return this.poolInfoPanel;
    }

    private JScrollPane getScrollPaneSystemProperties() {
        JScrollPane sp = new JScrollPane();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        TreeMap<Object, Object> propTreeMap = new TreeMap<Object, Object>(System.getProperties());
        for (Map.Entry<Object, Object> entry : propTreeMap.entrySet()) {
            jTextArea.append((String)entry.getKey() + "=" + (String)entry.getValue() + "\n");
        }
        sp.setViewportView(jTextArea);
        jTextArea.setCaretPosition(0);
        return sp;
    }

    private JScrollPane getScrollPaneLnFProperties() {
        JScrollPane sp = new JScrollPane();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        try {
            UIDefaults uid = UIManager.getDefaults();
            TreeMap propTreeMap = new TreeMap();
            for (Map.Entry entry : uid.entrySet()) {
                propTreeMap.put(entry.getKey().toString(), entry.getValue());
            }
            for (Map.Entry entry : propTreeMap.entrySet()) {
                jTextArea.append((String)entry.getKey() + "=" + entry.getValue() + "\n");
            }
        }
        catch (Exception e) {
            logger.error((Object)("show l&f defaults failed:" + e.getMessage()), (Throwable)e);
        }
        sp.setViewportView(jTextArea);
        jTextArea.setCaretPosition(0);
        return sp;
    }

    private JScrollPane getScrollPaneReleaseNotes() {
        JScrollPane jScrollPane = new JScrollPane();
        JTextArea jTextAreaReleaseNotes = new JTextArea();
        jTextAreaReleaseNotes.setEditable(false);
        try {
            jTextAreaReleaseNotes.setText(this.loadTextResource("ReleaseNotes.txt"));
        }
        catch (IOException ex) {
            logger.error((Object)("loading releasenotes text failed: " + ex.getMessage()), (Throwable)ex);
        }
        jTextAreaReleaseNotes.setCaretPosition(0);
        jScrollPane.setViewportView(jTextAreaReleaseNotes);
        return jScrollPane;
    }

    private JPanel getJPanelInfo() {
        if (this.jPanelInfo == null) {
            this.jPanelInfo = new JPanel();
            this.jPanelInfo.setBorder(BorderFactory.createEtchedBorder());
            this.jPanelInfo.setLayout(new GridBagLayout());
            int y = 0;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            JLabel jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.version"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Main.VERSION);
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.author"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText("Jan Lolling");
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.ramfree"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jLabelRAMfree = new JLabel();
            this.jPanelInfo.add((Component)this.jLabelRAMfree, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.ramtotal"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jLabelRAMtotal = new JLabel();
            this.jPanelInfo.add((Component)this.jLabelRAMtotal, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.javaversion"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(System.getProperty("java.version"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.screensize"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            StringBuilder text = new StringBuilder();
            text.append(WindowHelper.getAllScreenWidth());
            text.append(" x ");
            text.append(WindowHelper.getAllScreenHeight());
            if (WindowHelper.getScreenCount() > 1) {
                Rectangle[] screens;
                text.append(" ( ");
                for (Rectangle r : screens = WindowHelper.getScreensBounds()) {
                    text.append("[");
                    text.append(r.x);
                    text.append(",");
                    text.append(r.y);
                    text.append(",");
                    text.append(r.width);
                    text.append(",");
                    text.append(r.height);
                    text.append("] ");
                }
                text.append(")");
            }
            jLabel.setText(text.toString());
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = ++y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.codebase"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Main.getCodebase());
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.configdir"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Main.getWorkDirectory());
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("AboutDialog.processinfo"));
            this.jPanelInfo.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = y;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(ManagementFactory.getRuntimeMXBean().getName());
            this.jPanelInfo.add((Component)jLabel, gbc);
        }
        return this.jPanelInfo;
    }
}

