/*
 * Decompiled with CFR 0.152.
 */
package dbtools;

import dbtools.URLElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DatabaseType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String name;
    private String driverClassName;
    private String urlTemplate;
    private int adminOptionID = -1;
    private List<URLElement> urlElements;
    private boolean userDataInUrl = false;

    public DatabaseType(int id, String name, String driverClassName, String urlTemplate) {
        this.id = id;
        this.name = name;
        this.driverClassName = driverClassName;
        this.urlTemplate = urlTemplate;
        this.urlElements = this.getURLElements(urlTemplate);
    }

    public DatabaseType(String paramStr) {
        this.parseParamStr(paramStr);
        this.urlElements = this.getURLElements(this.urlTemplate);
    }

    private void parseParamStr(String param) {
        int i1 = param.indexOf(124);
        this.id = Integer.parseInt(param.substring(0, i1).trim());
        int i2 = param.indexOf(124, i1 + 1);
        this.name = param.substring(i1 + 1, i2);
        int i3 = param.indexOf(124, i2 + 1);
        this.driverClassName = param.substring(i2 + 1, i3).trim();
        int i4 = param.indexOf(124, i3 + 1);
        if (i4 > i3) {
            this.urlTemplate = param.substring(i3 + 1, i4).trim();
            this.adminOptionID = Integer.parseInt(param.substring(i4 + 1, param.length()).trim());
        } else {
            this.urlTemplate = param.substring(i3 + 1, param.length()).trim();
            this.adminOptionID = 0;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public List<URLElement> getURLElements() {
        return this.urlElements;
    }

    public List<URLElement> cloneURLElementList() {
        ArrayList<URLElement> list = new ArrayList<URLElement>(this.urlElements.size());
        for (URLElement elem : this.urlElements) {
            list.add(elem);
        }
        return list;
    }

    public URLElement getURLElementAt(int index) {
        if (index < this.urlElements.size()) {
            return this.urlElements.get(index);
        }
        return null;
    }

    public int getURLElementeCount() {
        return this.urlElements.size();
    }

    public int getAdminOptionID() {
        return this.adminOptionID;
    }

    public String toString() {
        return this.name;
    }

    public boolean isUserDataInUrl() {
        return this.userDataInUrl;
    }

    private List<URLElement> getURLElements(String urlTemplate_loc) {
        boolean fertig = false;
        Vector<URLElement> elements = new Vector<URLElement>();
        int p0 = -1;
        int p1 = -1;
        int p2 = -1;
        while (!fertig) {
            p0 = urlTemplate_loc.indexOf(37, p1 + 1);
            p1 = urlTemplate_loc.indexOf(37, p0 + 1);
            if (p0 != -1 && p1 != -1) {
                URLElement element = new URLElement();
                String temp = urlTemplate_loc.substring(p0 + 1, p1);
                if (temp.equalsIgnoreCase("USER") || temp.equalsIgnoreCase("PASSWORD")) {
                    this.userDataInUrl = true;
                }
                if ((p2 = temp.indexOf(61)) != -1) {
                    element.setName(temp.substring(0, p2));
                    element.setValue(temp.substring(p2 + 1, temp.length()));
                } else {
                    element.setName(temp);
                }
                elements.addElement(element);
                continue;
            }
            fertig = true;
        }
        if (!this.userDataInUrl) {
            elements.addElement(new URLElement("USER", null));
            elements.addElement(new URLElement("PASSWORD", null));
        }
        return elements;
    }
}

