/*
 * Decompiled with CFR 0.152.
 */
package dbtools;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import dbtools.DatabaseSessionPoolInfo;
import dbtools.HandlingException;
import java.lang.management.ManagementFactory;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class DatabaseSessionPool {
    private static final Logger logger = Logger.getLogger(DatabaseSessionPool.class);
    private static final Vector<DatabaseSession> pool = new Vector();
    private static String lastErrorMessage = null;
    private static final Object monitor = new Object();
    private static final ConnectionMap connDescMap = new ConnectionMap();
    private static final HashMap<String, HashMap<String, String>> sessionStatementMap = new HashMap();
    private static final HashMap<String, String> testSQLs = new HashMap();
    public static final String UNIVERSAL_TEST_SQL = "select * from dual";
    private static boolean checkInProcess = false;
    private static volatile Timer timer = null;
    private static CheckPoolTask checkPoolTask = null;
    private static final HashMap<String, String> aliasConnectionClassMap = new HashMap();
    private static int maxIdleTime = 60;
    private static int checkPoolCyclusTime = 60;
    private static String lastPoolCheckMessage = null;
    private static long lastOccuranceOfPoolCheckMessage = 0L;
    private static long lastOccuranceOfPoolCheck = 0L;

    private DatabaseSessionPool() {
    }

    public static void addAppender(Appender appender) {
        if (!logger.isAttached(appender)) {
            logger.addAppender(appender);
        }
    }

    public static void removeAppender(Appender appender) {
        if (logger.isAttached(appender)) {
            logger.removeAppender(appender);
        }
    }

    public static void removeAllAppenders() {
        logger.removeAllAppenders();
    }

    private static void error(String message, Exception e) {
        if (message == null) {
            message = "undeclared error";
        }
        lastErrorMessage = message;
        if (e != null) {
            logger.error((Object)message, (Throwable)e);
        } else {
            logger.error((Object)message);
        }
    }

    private static void error(String message) {
        DatabaseSessionPool.error(message, null);
    }

    public static void setTestSQL(String aliasName, String testSql) {
        testSQLs.put(aliasName, testSql);
    }

    public static void setMaxIdleTime(int idleTime) {
        maxIdleTime = idleTime;
    }

    public static int getMaxIdleTime() {
        return maxIdleTime;
    }

    public static boolean existDatabaseSession(String alias) {
        return DatabaseSessionPool.getConnectionDescriptionFromMap(alias) != null;
    }

    public static void definePreparedStatementSQL(String sessionAlias, String statementAlias, String sql) {
        HashMap<String, String> statMap = sessionStatementMap.get(sessionAlias);
        if (statMap == null) {
            statMap = new HashMap();
            sessionStatementMap.put(sessionAlias, statMap);
        }
        statMap.put(statementAlias, sql);
    }

    public static int createSessions(Properties properties, boolean autoCommit, String dbName) {
        if (dbName == null) {
            throw new IllegalArgumentException("dbName cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        return DatabaseSessionPool.createSessions(properties.getProperty("URL", "").trim(), properties.getProperty("DRIVER", "").trim(), properties.getProperty("USER", "").trim(), properties.getProperty("PASSWORD", "").trim(), autoCommit, Integer.parseInt(properties.getProperty("FETCHSIZE", "-1")), Integer.parseInt(properties.getProperty("INITIAL_SESSION_COUNT", "1")), dbName, properties.getProperty("DB_API_CLASS"));
    }

    public static int createSessions(ConnectionDescription cd, int countSessions, String dbName, Class<? extends DatabaseSession> sourceClass) {
        return DatabaseSessionPool.createSessions(cd, countSessions, dbName, sourceClass.getName());
    }

    public static int createSessions(String url, String driver, String user, String passwd, boolean autoCommit, int fetchSize, int count, String sessionAliasName) {
        return DatabaseSessionPool.createSessions(url, driver, user, passwd, autoCommit, fetchSize, count, sessionAliasName, DatabaseSession.class.getName());
    }

    public static int createSessions(String url, String driver, String user, String passwd, boolean autoCommit, int fetchSize, int count, String sessionAliasName, String className) {
        ConnectionDescription cd = new ConnectionDescription();
        cd.setUser(user);
        cd.setUrl(url);
        cd.setDriverClassName(driver);
        cd.setPasswd(passwd);
        cd.setAutoCommit(autoCommit);
        cd.setDefaultFetchSize(fetchSize);
        return DatabaseSessionPool.createSessions(cd, count, sessionAliasName, className);
    }

    public static int createSessions(ConnectionDescription cd, int count, String sessionAliasName) {
        return DatabaseSessionPool.createSessions(cd, count, sessionAliasName, DatabaseSession.class);
    }

    public static int createSession(String sourceAlias, String newAlias, String className) {
        if (sourceAlias == null) {
            throw new IllegalArgumentException("sourceAlias cannot be null");
        }
        if (newAlias == null) {
            throw new IllegalArgumentException("newAlias cannot be null");
        }
        if (sourceAlias.equalsIgnoreCase(newAlias)) {
            throw new IllegalArgumentException("sourceAlias cannot be equal to newAlias");
        }
        if (DatabaseSessionPool.existDatabaseSession(newAlias)) {
            throw new IllegalStateException("connection with new alias " + newAlias + " already exists");
        }
        ConnectionDescription cd = DatabaseSessionPool.getConnectionDescription(sourceAlias);
        if (cd != null) {
            return DatabaseSessionPool.createSessions(cd, 1, newAlias, className);
        }
        return -1;
    }

    public static int createSessions(ConnectionDescription cd, int count, String sessionAliasName, String className) {
        if (sessionAliasName == null) {
            lastErrorMessage = "ERROR: failed to create DatabaseSession: no alias given !";
            DatabaseSessionPool.error(lastErrorMessage);
            return -1;
        }
        int counter = 0;
        if (className == null) {
            className = DatabaseSession.class.getName();
        }
        aliasConnectionClassMap.put(sessionAliasName.toLowerCase(), className);
        for (int i = 0; i < count; ++i) {
            DatabaseSession session = null;
            try {
                session = (DatabaseSession)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                lastErrorMessage = "ERROR: instantiation (initial) of DatabaseSession subclass " + className + " for alias " + sessionAliasName + " failed:" + e.toString();
                DatabaseSessionPool.error(lastErrorMessage, e);
            }
            if (session == null) continue;
            session.setAliasName(sessionAliasName);
            session.setConnectionDescription(cd);
            logger.info((Object)("DatabaseSessionPool: create (initial) " + session.toString() + "... "));
            if (session.loadDriver() && session.connect()) {
                if (!DatabaseSessionPool.prepareStatements(session)) continue;
                logger.info((Object)"READY.");
                session.setPooled(true);
                pool.addElement(session);
                ++counter;
                DatabaseSessionPool.addConnectionDescriptionToMap(sessionAliasName, cd);
                continue;
            }
            DatabaseSessionPool.error("ERROR: load driver + connect: " + session.getLastErrorMessage());
            break;
        }
        return counter;
    }

    private static void addConnectionDescriptionToMap(String alias, ConnectionDescription cd) {
        connDescMap.put(alias, cd);
    }

    private static ConnectionDescription getConnectionDescriptionFromMap(String alias) {
        return connDescMap.get(alias);
    }

    public static int createSessions(String jndiDataSourceName, int count, boolean autoCommit, String className) {
        if (jndiDataSourceName == null) {
            DatabaseSessionPool.error("failed to create DatabaseSession: no jndiDataSourceName given !");
            return -1;
        }
        int counter = 0;
        if (className == null) {
            className = DatabaseSession.class.getName();
        }
        aliasConnectionClassMap.put(jndiDataSourceName.toLowerCase(), className);
        for (int i = 0; i < count; ++i) {
            DatabaseSession session = null;
            try {
                session = (DatabaseSession)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                DatabaseSessionPool.error("ERROR: instantiation (initial) of DatabaseSession subclass " + className + " for jndiDataSourceName " + jndiDataSourceName + " failed:" + e.toString(), e);
            }
            if (session == null) continue;
            ConnectionDescription cd = new ConnectionDescription();
            cd.setJndiDataSourceName(jndiDataSourceName);
            cd.setAutoCommit(autoCommit);
            DatabaseSessionPool.addConnectionDescriptionToMap(jndiDataSourceName, cd);
            session.setAliasName(jndiDataSourceName);
            session.setConnectionDescription(cd);
            logger.info((Object)("DatabaseSessionPool: create (initial) " + session.getClass().getName() + " id=" + session.getSessionID() + " jndiDataSourceName=" + jndiDataSourceName + " alias=" + session.getAliasName() + "... "));
            if (session.loadDriver() && session.connect()) {
                if (DatabaseSessionPool.prepareStatements(session)) {
                    logger.info((Object)"READY.");
                    session.setPooled(true);
                    pool.addElement(session);
                    ++counter;
                    continue;
                }
                DatabaseSessionPool.error("prepare statements failed:" + session.getLastErrorMessage());
                counter = -1;
                break;
            }
            DatabaseSessionPool.error("connecting failed: " + session.getLastErrorMessage());
            counter = -1;
            break;
        }
        return counter;
    }

    public static void close() {
        logger.info((Object)"DatabaseSessionPool: removing all sessions");
        DatabaseSessionPool.stopCheckPoolThread();
        int n = pool.size();
        for (int i = 0; i < n; ++i) {
            DatabaseSession session = pool.get(i);
            try {
                session.close();
                continue;
            }
            catch (HandlingException e) {
                logger.warn((Object)"session was already in use !");
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)"session was already in use !");
            }
        }
        pool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias cannot be null");
        }
        logger.info((Object)("DatabaseSessionPool: removing all sessions for alias=" + alias));
        for (int i = 0; i < pool.size(); ++i) {
            DatabaseSession session = pool.get(0);
            if (!alias.equals(session.getAliasName())) continue;
            try {
                session.occupy();
            }
            catch (HandlingException he) {
                logger.warn((Object)("session " + session + " will be teminated !"));
            }
            finally {
                session.close();
            }
            pool.remove(session);
            --i;
        }
    }

    static void killSession(int sessionId) {
        DatabaseSession session = DatabaseSessionPool.getDatabaseSession(sessionId);
        pool.remove(session);
        session.close();
    }

    public static boolean isConnectionUsed(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias cannot be null");
        }
        boolean used = false;
        DatabaseSession session = null;
        for (int i = 0; i < pool.size(); ++i) {
            session = pool.elementAt(i);
            if (session.isReady() || !session.isSuccessful() || !session.getAliasName().equalsIgnoreCase(alias)) continue;
            used = true;
            break;
        }
        return used;
    }

    public static boolean isConnectionUsed() {
        boolean used = false;
        DatabaseSession session = null;
        for (int i = 0; i < pool.size(); ++i) {
            session = pool.elementAt(i);
            if (session.isReady() || !session.isSuccessful()) continue;
            used = true;
            break;
        }
        return used;
    }

    public static void startCheckPoolThread(int refreshTimeInSeconds) {
        if (refreshTimeInSeconds > 0 || maxIdleTime < refreshTimeInSeconds) {
            checkPoolCyclusTime = refreshTimeInSeconds;
            DatabaseSessionPool.stopCheckPoolThread();
            timer = new Timer(true);
            checkPoolTask = new CheckPoolTask();
            timer.schedule((TimerTask)checkPoolTask, 1000L, (long)(checkPoolCyclusTime * 1000));
            logger.info((Object)("DatabaseSessionPool: start pool check all " + checkPoolCyclusTime + "s, check max idle time=" + maxIdleTime + "s."));
        } else {
            logger.warn((Object)"DatabaseSessionPool: start pool check failed: invalid cyclus time or invalid max idle time !");
        }
    }

    public static boolean isPoolCheckThreadRunning() {
        return timer != null;
    }

    public static void startCheckPoolThread() {
        if (checkPoolCyclusTime > 0) {
            DatabaseSessionPool.stopCheckPoolThread();
            timer = new Timer(true);
            checkPoolTask = new CheckPoolTask();
            timer.schedule((TimerTask)checkPoolTask, 1000L, (long)(checkPoolCyclusTime * 1000));
            logger.info((Object)("DatabaseSessionPool: start pool check all " + checkPoolCyclusTime + "s, check max idle time=" + maxIdleTime + "s."));
        } else {
            logger.warn((Object)"checkPoolCyclusTime has invalid value (must be greater 0)");
        }
    }

    public static int getCheckPoolCyclusTime() {
        return checkPoolCyclusTime;
    }

    public static void setCheckPoolCyclusTime(int secondsBetweenChecks) {
        checkPoolCyclusTime = secondsBetweenChecks;
    }

    public static long getPoolCheckScheduledExecutionTime() {
        if (checkPoolTask != null) {
            return checkPoolTask.scheduledExecutionTime();
        }
        return 0L;
    }

    public static void stopCheckPoolThread() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }

    public static long getLastOccuranceOfPoolCheckMessage() {
        return lastOccuranceOfPoolCheckMessage;
    }

    public static long getLastOccuranceOfPoolCheck() {
        return lastOccuranceOfPoolCheck;
    }

    public static String getLastPoolCheckMessage() {
        return lastPoolCheckMessage;
    }

    public static boolean checkSession(DatabaseSession session) {
        boolean inValid = false;
        String testSql = testSQLs.get(session.getAliasName());
        if (testSql == null) {
            testSql = UNIVERSAL_TEST_SQL;
        }
        ResultSet rs = session.executeQuery(testSql);
        if (session.isSuccessful()) {
            try {
                rs.close();
            }
            catch (Exception e) {
                inValid = true;
                logger.warn((Object)("ERROR: checkPool: db alias:" + session.getAliasName() + ", test statement: " + testSql + " execution failed (handling with result set):" + e.toString()));
            }
        } else {
            inValid = true;
            logger.warn((Object)("ERROR: checkPool: db alias:" + session.getAliasName() + ", test statement: " + testSql + " execution failed (executing sql):" + session.getLastErrorMessage()));
        }
        return inValid;
    }

    public static String getErrorMessage() {
        return lastErrorMessage;
    }

    public static DatabaseSession getDatabaseSession(String aliasName) {
        return DatabaseSessionPool.getDatabaseSession(aliasName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseSession getDatabaseSession(String aliasName, Class<? extends DatabaseSession> alternativeClass) {
        if (aliasName == null) {
            throw new IllegalArgumentException("aliasName cannot be null");
        }
        DatabaseSession session = null;
        do {
            String alternativeAliasName = null;
            alternativeAliasName = alternativeClass != null ? aliasName + "_" + alternativeClass.getName() : aliasName;
            int sessionCount = 0;
            for (int i = 0; i < pool.size(); ++i) {
                Object object = monitor;
                synchronized (object) {
                    session = pool.elementAt(i);
                    if (alternativeAliasName.equals(session.getAliasName())) {
                        ++sessionCount;
                        if (session.isReady()) {
                            session.occupy();
                            break;
                        }
                        session = null;
                    } else {
                        session = null;
                    }
                    continue;
                }
            }
            if (session != null) continue;
            ConnectionDescription cd = DatabaseSessionPool.getConnectionDescriptionFromMap(aliasName);
            if (cd != null) {
                if (cd.getMaxCountSessions() != 0 && sessionCount >= cd.getMaxCountSessions()) continue;
                String className = null;
                try {
                    if (alternativeClass != null) {
                        className = alternativeClass.getName();
                        if (!aliasConnectionClassMap.containsKey(alternativeAliasName.toLowerCase())) {
                            aliasConnectionClassMap.put(alternativeAliasName.toLowerCase(), alternativeClass.getName());
                        }
                    } else {
                        className = aliasConnectionClassMap.get(aliasName.toLowerCase());
                        if (className == null) {
                            className = DatabaseSession.class.getName();
                        }
                    }
                    session = (DatabaseSession)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    DatabaseSessionPool.error("instantiation (add) of DatabaseSession subclass " + className + " for alias=" + alternativeAliasName + " failed:" + e.toString());
                    break;
                }
                if (session == null) continue;
                session.setConnectionDescription(cd);
                session.setAliasName(alternativeAliasName);
                if (session.loadDriver() && session.connect()) {
                    if (!DatabaseSessionPool.prepareStatements(session)) continue;
                    logger.info((Object)("DatabaseSessionPool: add (ondemand) " + session.toString()));
                    session.setPooled(true);
                    session.occupy();
                    pool.addElement(session);
                    continue;
                }
                DatabaseSessionPool.error("failed to add DatabaseSession (alias=" + alternativeAliasName + "):" + session.getLastErrorMessage());
                break;
            }
            DatabaseSessionPool.error("getDatabaseSession: unknown db-alias=" + alternativeAliasName);
            break;
        } while (session == null);
        if (session != null && session.isConnected() && session.isSuccessful()) {
            return session;
        }
        return null;
    }

    static DatabaseSession getDatabaseSession(int id) {
        DatabaseSession session = null;
        for (int i = 0; i < pool.size() && (session = pool.elementAt(i)).getSessionID() != id; ++i) {
            session = null;
        }
        return session;
    }

    public static ConnectionDescription getConnectionDescription(String alias) {
        return DatabaseSessionPool.getConnectionDescriptionFromMap(alias);
    }

    public static void release(DatabaseSession session) {
        if (!session.isSuccessful()) {
            lastErrorMessage = session.getLastErrorMessage();
            pool.remove(session);
            session.close();
        }
        session.release();
    }

    public static void close(DatabaseSession session) {
        session.release();
        lastErrorMessage = session.getLastErrorMessage();
        pool.remove(session);
        session.close();
    }

    public static boolean prepareStatements(DatabaseSession session) {
        boolean ok = true;
        HashMap<String, String> statMap = sessionStatementMap.get(session.getAliasName());
        if (statMap != null && !statMap.isEmpty()) {
            Map.Entry<String, String> entry2 = null;
            for (Map.Entry<String, String> entry2 : statMap.entrySet()) {
                if (session.isReady()) {
                    session.occupy();
                    if (session.createPreparedStatement(entry2.getKey(), entry2.getValue())) {
                        session.release();
                        continue;
                    }
                    ok = false;
                    DatabaseSessionPool.error("DatabaseSessionPool.prepareStatements for session (id=" + session.getSessionID() + " sessionAlias=" + session.getAliasName() + ") and statementAlias=" + entry2.getKey() + " failed: " + session.getLastErrorMessage());
                    continue;
                }
                ok = false;
            }
        } else {
            ok = true;
        }
        return ok;
    }

    static Vector<DatabaseSession> getPool() {
        return pool;
    }

    public static void addConnectionDescription(String alias, String cryptedParameter) throws Exception {
        ConnectionDescription cd = ConnectionDescription.create(alias, cryptedParameter);
        DatabaseSessionPool.addConnectionDescription(alias, cd);
    }

    public static void addConnectionDescription(String alias, String driverClassName, String url, String user, String password, int maxConnections, int fetchSize, boolean autoCommit) {
        ConnectionDescription cd = new ConnectionDescription();
        cd.setDriverClassName(driverClassName);
        cd.setUrl(url);
        cd.setUser(user);
        cd.setPasswd(password);
        cd.setMaxCountSessions(maxConnections);
        cd.setDefaultFetchSize(fetchSize);
        cd.setAutoCommit(autoCommit);
        DatabaseSessionPool.addConnectionDescription(alias, cd);
    }

    public static void addConnectionDescription(String alias, ConnectionDescription connDesc) {
        if (DatabaseSessionPool.existDatabaseSession(alias)) {
            throw new IllegalStateException("alias " + alias + " already exists !");
        }
        connDescMap.put(alias, connDesc);
        logger.info((Object)("add connection alias=" + alias + " with " + connDesc.toString()));
    }

    public static void removeAllConnectionDescriptions() {
        connDescMap.clear();
        logger.info((Object)"remove all connection descriptions");
    }

    public static void removeConnectionDescription(String alias) {
        connDescMap.remove(alias);
        logger.info((Object)("remove connection description for alias=" + alias));
    }

    public static boolean hasConfigurations() {
        return !connDescMap.isEmpty();
    }

    public static String[] getAllAliases() {
        String[] aliasArray = new String[connDescMap.size()];
        int i = 0;
        for (String alias : connDescMap.keySet()) {
            aliasArray[i] = alias.toLowerCase();
            ++i;
        }
        return aliasArray;
    }

    public static String[] getSessionsStatus() {
        String[] statusArray = new String[DatabaseSessionPool.getPoolSize()];
        int n = DatabaseSessionPool.getPoolSize();
        for (int i = 0; i < n; ++i) {
            DatabaseSession session = pool.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append(session.toString());
            sb.append(" in use=");
            sb.append(session.isOccupied());
            sb.append(" successful=");
            sb.append(session.isSuccessful());
            statusArray[i] = sb.toString();
        }
        return statusArray;
    }

    public static int getPoolSize() {
        return pool.size();
    }

    public static void registerAtPlatformJMXServer() throws Exception {
        if (System.getProperty("com.sun.management.jmxremote") == null) {
            logger.warn((Object)"System property: com.sun.management.jmxremote is not set, probably current VM is not enabled for JMX.");
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        DatabaseSessionPool.registerAtJMXServer(mbs);
    }

    public static void registerAtJMXServer(MBeanServer mbs) throws Exception {
        ObjectName beanName = new ObjectName(DatabaseSessionPoolInfo.class.getPackage().getName() + ":type=" + DatabaseSessionPoolInfo.class.getSimpleName());
        DatabaseSessionPoolInfo poolBean = new DatabaseSessionPoolInfo();
        if (!mbs.isRegistered(beanName)) {
            mbs.registerMBean(poolBean, beanName);
        }
    }

    private static class ConnectionMap
    extends HashMap<String, ConnectionDescription> {
        private static final long serialVersionUID = 1L;

        private ConnectionMap() {
        }

        @Override
        public ConnectionDescription put(String key, ConnectionDescription cd) {
            return super.put(key.toLowerCase(), cd);
        }

        @Override
        public ConnectionDescription remove(Object key) {
            return (ConnectionDescription)super.remove(key.toString().toLowerCase());
        }

        @Override
        public ConnectionDescription get(Object key) {
            return (ConnectionDescription)super.get(key.toString().toLowerCase());
        }
    }

    private static class CheckPoolTask
    extends TimerTask {
        private static final Logger logger = Logger.getLogger(CheckPoolTask.class);

        private CheckPoolTask() {
        }

        @Override
        public void run() {
            if (!checkInProcess) {
                int i;
                checkInProcess = true;
                Vector<DatabaseSession> wrongSessions = new Vector<DatabaseSession>();
                Vector<DatabaseSession> idleSessions = new Vector<DatabaseSession>();
                int countRemovedDamaged = 0;
                int countReset = 0;
                DatabaseSession session = null;
                for (int i2 = 0; i2 < pool.size(); ++i2) {
                    session = (DatabaseSession)pool.elementAt(i2);
                    if (session.isReady()) {
                        session.occupy(false);
                        if (session.getIdleTime() > (long)maxIdleTime) {
                            pool.remove(session);
                            --i2;
                            idleSessions.addElement(session);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("DatabaseSessionPool: mark session as idle: " + session.toString()));
                            continue;
                        }
                        session.release();
                    }
                    if (session.isOccupied()) continue;
                    session.occupy(false);
                    if (session.isSuccessful()) {
                        if (session.getIdleTime() > (long)checkPoolCyclusTime) {
                            if (DatabaseSessionPool.checkSession(session)) {
                                pool.removeElement(session);
                                wrongSessions.addElement(session);
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug((Object)("DatabaseSessionPool: mark session as wrong because test SQL failed: " + session.toString()));
                                continue;
                            }
                            session.release();
                            continue;
                        }
                        session.release();
                        continue;
                    }
                    if (DatabaseSessionPool.checkSession(session)) {
                        pool.removeElement(session);
                        wrongSessions.addElement(session);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("DatabaseSessionPool: mark damaged session as wrong because test SQL failed: " + session.toString()));
                        continue;
                    }
                    ++countReset;
                    session.resetErrorStatus();
                    session.release();
                }
                int countRemovedIdle = 0;
                for (i = 0; i < idleSessions.size(); ++i) {
                    session = (DatabaseSession)idleSessions.get(i);
                    session.setPooled(false);
                    session.close();
                    ++countRemovedIdle;
                }
                idleSessions.clear();
                for (i = 0; i < wrongSessions.size(); ++i) {
                    session = (DatabaseSession)wrongSessions.get(i);
                    ++countRemovedDamaged;
                    session.setPooled(false);
                    session.close();
                }
                wrongSessions.clear();
                if (countRemovedDamaged > 0 || countRemovedIdle > 0 || countReset > 0) {
                    lastPoolCheckMessage = "INFO: checkPool: removed damaged:" + countRemovedDamaged + ", removed idle:" + countRemovedIdle + ", reset:" + countReset + ",  current pool size:" + pool.size();
                    logger.info((Object)lastPoolCheckMessage);
                    lastOccuranceOfPoolCheckMessage = System.currentTimeMillis();
                }
                lastOccuranceOfPoolCheck = System.currentTimeMillis();
                checkInProcess = false;
            }
        }
    }
}

