/*
 * Decompiled with CFR 0.152.
 */
package dbtools;

import dbtools.CallableStatementDefinition;
import dbtools.ConnectionDescription;
import dbtools.HandlingException;
import dbtools.PreparedStatementDefinition;
import dbtools.SQLParser;
import dbtools.SQLStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DatabaseSession {
    private static Logger staticLogger = Logger.getLogger(DatabaseSession.class);
    private Logger currentLogger = staticLogger;
    private static int lastSessionID = -1;
    private int sessionID;
    public static final int NORMAL = 0;
    public static final int WARNINGS = 1;
    public static final int FATALS = 2;
    private int errorCode = 0;
    protected boolean isConnected = false;
    protected boolean success = false;
    protected boolean isPooled = false;
    protected Connection conn;
    private Statement currentOpenStatement;
    protected String lastErrorMessage;
    protected ConnectionDescription desc;
    protected String linesep = System.getProperty("line.separator");
    private boolean isQuery;
    protected boolean free = true;
    protected String aliasName;
    private final HashMap<String, PreparedStatement> psMap = new HashMap();
    private long connectedTimestamp = 0L;
    private long lastOccupiedTimestamp = 0L;
    private long lastUsedTimestamp = 0L;
    private long lastErrorTimestamp = 0L;
    private long countUsage = 0L;
    private boolean isCommitted = true;
    private Exception lastException;
    protected String lastSQL;
    private ArrayList<PreparedStatementDefinition> preparedStatementDefinitions;
    private boolean driverLoaded = false;
    private boolean connectInProgress = false;

    public DatabaseSession() {
        this.createSessionID();
        this.desc = new ConnectionDescription();
    }

    public DatabaseSession(ConnectionDescription desc) {
        this.desc = desc;
        this.createSessionID();
        if (this.loadDriver()) {
            this.connect();
        }
    }

    public void setLogger(Logger extLogger) {
        if (extLogger == null) {
            throw new IllegalArgumentException("extLogger cannot be null");
        }
        this.currentLogger = extLogger;
    }

    public Logger getLogger() {
        return this.currentLogger;
    }

    public void resetLoggerToStaticClassLogger() {
        this.currentLogger = staticLogger;
    }

    protected void setPooled(boolean isPooledSession) {
        this.isPooled = isPooledSession;
    }

    public boolean isPooled() {
        return this.isPooled;
    }

    public final void checkUsage(boolean isDataModificationAction) {
        if (this.isPooled) {
            if (this.free) {
                throw new HandlingException(this.getClass().getName() + ".checkUsage session is not occupied !");
            }
            if (!this.isConnected) {
                throw new HandlingException(this.getClass().getName() + ".checkUsage session is not connected !");
            }
            if (isDataModificationAction && !this.desc.getAutoCommit()) {
                this.isCommitted = false;
            }
        }
        this.lastUsedTimestamp = System.currentTimeMillis();
    }

    public long getIdleTime() {
        if (this.lastOccupiedTimestamp == 0L) {
            return (System.currentTimeMillis() - this.connectedTimestamp) / 1000L;
        }
        return (System.currentTimeMillis() - this.lastOccupiedTimestamp) / 1000L;
    }

    public void setDebug(boolean debug_loc) {
        if (debug_loc) {
            this.currentLogger.setLevel(Level.DEBUG);
        } else {
            this.currentLogger.setLevel(Level.INFO);
        }
    }

    protected void release() {
        if (this.free) {
            throw new HandlingException(this.getClass().getName() + ".release failed: Session is already released !");
        }
        this.isCommitted = false;
        if (false && !this.desc.getAutoCommit()) {
            this.commit();
            this.error("release WARNING: Session was not committed - now already done !");
        }
        this.free = true;
    }

    protected void occupy(boolean changeTimeStamp) {
        if (!this.free) {
            throw new HandlingException("alias=" + this.getAliasName() + " occupy failed: Session is already in use !");
        }
        this.free = false;
        if (changeTimeStamp) {
            this.lastOccupiedTimestamp = System.currentTimeMillis();
            this.countUsage = this.countUsage < Long.MAX_VALUE ? ++this.countUsage : 0L;
        }
    }

    protected void occupy() {
        this.occupy(true);
    }

    public boolean isReady() {
        return this.free && this.success && this.isConnected;
    }

    public void error(String message) {
        this.success = false;
        this.lastErrorMessage = "alias=" + this.getAliasName() + ":" + message;
        this.currentLogger.error((Object)this.lastErrorMessage);
        this.lastErrorTimestamp = System.currentTimeMillis();
    }

    public void error(String message, Throwable e) {
        SQLException sqle;
        this.success = false;
        this.lastErrorMessage = message;
        if (e instanceof Exception) {
            this.lastException = (Exception)e;
        }
        this.currentLogger.error((Object)this.lastErrorMessage, e);
        this.lastErrorTimestamp = System.currentTimeMillis();
        if (e instanceof SQLException && (sqle = (SQLException)e).getNextException() != null) {
            this.lastErrorMessage = this.lastErrorMessage + "\nNext exception:" + sqle.getNextException().getMessage();
            this.currentLogger.error((Object)sqle.getNextException().getMessage(), (Throwable)sqle.getNextException());
        }
    }

    public void error(Exception exception) {
        SQLException sqle;
        this.success = false;
        this.lastException = exception;
        this.lastErrorMessage = exception.getMessage();
        this.currentLogger.error((Object)this.lastErrorMessage, (Throwable)exception);
        this.lastErrorTimestamp = System.currentTimeMillis();
        if (exception instanceof SQLException && (sqle = (SQLException)exception).getNextException() != null) {
            this.lastErrorMessage = this.lastErrorMessage + "\nNext exception:" + sqle.getMessage();
            this.currentLogger.error((Object)sqle.getNextException().getMessage(), (Throwable)sqle.getNextException());
        }
    }

    public void warn(String message) {
        this.lastErrorMessage = "alias=" + this.getAliasName() + ":" + message;
        this.currentLogger.warn((Object)this.lastErrorMessage);
        this.lastErrorTimestamp = System.currentTimeMillis();
    }

    public void warn(String message, Exception e) {
        this.lastErrorMessage = "alias=" + this.getAliasName() + ":" + message;
        this.currentLogger.warn((Object)this.lastErrorMessage, (Throwable)e);
        this.lastErrorTimestamp = System.currentTimeMillis();
    }

    public void status(String message) {
        this.currentLogger.info((Object)("alias=" + this.getAliasName() + ":" + message));
    }

    public boolean isOccupied() {
        return !this.free;
    }

    public long getLastOccupiedTimestamp() {
        return this.lastOccupiedTimestamp;
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public long getCountUsage() {
        return this.countUsage;
    }

    public void setAliasName(String name) {
        this.aliasName = name;
    }

    public String getAliasName() {
        if (this.aliasName != null) {
            return this.aliasName;
        }
        if (this.getConnectionDescription() != null) {
            return this.getConnectionDescription().getUniqueId();
        }
        return null;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public long getConnectedTimestamp() {
        return this.connectedTimestamp;
    }

    public void setConnectionDescription(ConnectionDescription desc_loc) {
        this.desc = desc_loc;
    }

    public ConnectionDescription getConnectionDescription() {
        return this.desc;
    }

    public boolean loadDriver() {
        this.driverLoaded = false;
        if (this.desc != null) {
            if (this.desc.getJndiDataSourceName() != null) {
                this.driverLoaded = true;
            } else if (this.desc.getDriverClassName() != null) {
                this.driverLoaded = this.registerDriver(this.desc.getDriverClassName());
            } else {
                this.lastException = new NullPointerException("driver-class-name is null");
                this.error("loadDriver failed: driver-class-name is null !");
            }
        } else {
            this.lastException = new NullPointerException("decription is null");
            this.error("loadDriver failed: description is null !");
        }
        return this.driverLoaded;
    }

    public boolean isDriverLoaded() {
        return this.driverLoaded;
    }

    private boolean registerDriver(String driverClassName) {
        boolean ok = false;
        try {
            Class.forName(driverClassName);
            ok = true;
            this.success = true;
        }
        catch (ClassNotFoundException cnfe) {
            this.lastException = cnfe;
            this.error("registerDriver " + driverClassName + " failed: driver not available: " + cnfe.getMessage(), cnfe);
        }
        return ok;
    }

    public static void setTimeout(int timeout) {
        DriverManager.setLoginTimeout(timeout);
    }

    public static int getTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public boolean connect() {
        this.connectInProgress = true;
        if (this.desc != null) {
            boolean ok = false;
            try {
                if (!this.driverLoaded) {
                    this.loadDriver();
                }
                Properties properties = null;
                if (this.desc.getPasswd() == null) {
                    this.warn("connect (using DriverManager): no password provided !");
                }
                if (this.desc.getPropertiesString() != null && this.desc.getPropertiesString().length() > 0 && !ConnectionDescription.isExtendsUrlWithProperties()) {
                    properties = new Properties();
                    StringTokenizer st = new StringTokenizer(this.desc.getPropertiesString(), ";");
                    String token = null;
                    String key = null;
                    String value = null;
                    int pos = 0;
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        pos = token.indexOf(61);
                        if (pos == -1) continue;
                        key = token.substring(0, pos).trim();
                        value = token.substring(pos + 1).trim();
                        if (key.length() <= 0 || value.length() <= 0) continue;
                        properties.put(key, value);
                    }
                }
                if (properties != null && !properties.isEmpty()) {
                    properties.put("user", this.desc.getUser());
                    properties.put("password", this.desc.getPasswd());
                }
                this.conn = this.desc.getPropertiesString() != null && this.desc.getPropertiesString().length() > 0 && ConnectionDescription.isExtendsUrlWithProperties() ? DriverManager.getConnection(this.desc.getUrl() + "?" + this.desc.getPropertiesString(), this.desc.getUser(), this.desc.getPasswd()) : (properties != null ? DriverManager.getConnection(this.desc.getUrl(), properties) : (ConnectionDescription.isUserInfoInUrl() ? DriverManager.getConnection(this.desc.getUrl()) : DriverManager.getConnection(this.desc.getUrl(), this.desc.getUser(), this.desc.getPasswd())));
                ok = true;
                this.connectedTimestamp = System.currentTimeMillis();
            }
            catch (Throwable ex) {
                this.error("connect (using DriverManager) failed: " + ex.getMessage(), ex);
                ok = false;
            }
            if (this.conn != null) {
                try {
                    this.conn.setAutoCommit(this.desc.getAutoCommit());
                }
                catch (SQLException sqle) {
                    this.warn("connect setAutoCommit failed: " + sqle.getMessage());
                }
                if (ConnectionDescription.isRunInitialSQLOnConnect()) {
                    ok = this.runInitSQL();
                } else {
                    this.success = ok;
                }
            }
            this.isConnected = ok;
            this.connectInProgress = false;
            return ok;
        }
        this.connectInProgress = false;
        return false;
    }

    public boolean isConnectInProgress() {
        return this.connectInProgress;
    }

    private boolean runInitSQL() {
        String initSQL;
        boolean ok = true;
        if (this.desc != null && (initSQL = this.desc.getInitSQL()) != null) {
            SQLParser parser = new SQLParser(initSQL);
            SQLStatement initStat = null;
            for (int i = 0; i < parser.getStatementCount(); ++i) {
                initStat = parser.getStatementAt(i);
                this.execute(initStat.getSQL());
                if (this.isSuccessful()) continue;
                ok = false;
            }
        }
        return ok;
    }

    public boolean cancelStatement() {
        this.checkUsage(false);
        try {
            if (this.currentOpenStatement != null) {
                Statement toCancelStatement = this.currentOpenStatement;
                this.currentOpenStatement = null;
                toCancelStatement.cancel();
                toCancelStatement.close();
            }
        }
        catch (SQLException sqle) {
            this.lastException = sqle;
            this.error("cancelStatement (cancel) failed: " + sqle.getMessage(), sqle);
        }
        try {
            this.conn.clearWarnings();
            this.success = true;
        }
        catch (SQLException sqle) {
            this.lastException = sqle;
            this.error("cancelStatement (clear warnings) failed: " + sqle.getMessage(), sqle);
        }
        return this.success;
    }

    public boolean setAutoCommit(boolean enableAutoCommit) {
        this.checkUsage(false);
        boolean ok = true;
        this.desc.setAutoCommit(enableAutoCommit);
        if (this.isConnected) {
            try {
                this.conn.setAutoCommit(this.desc.getAutoCommit());
            }
            catch (SQLException sqle) {
                this.lastException = sqle;
                this.error("setAutoCommit failed: " + sqle.getMessage(), sqle);
                ok = false;
            }
        }
        return ok;
    }

    public boolean isAutoCommit() {
        boolean isAutoCommit = false;
        if (this.isConnected) {
            try {
                isAutoCommit = this.conn.getAutoCommit();
            }
            catch (SQLException sqle) {
                this.lastException = sqle;
                this.error("isAutoCommit failed: " + sqle.getMessage(), sqle);
            }
        } else {
            isAutoCommit = this.desc.getAutoCommit();
        }
        return isAutoCommit;
    }

    public boolean commit() {
        this.checkUsage(false);
        if (this.currentLogger.isDebugEnabled()) {
            this.currentLogger.debug((Object)"commit()");
        }
        boolean ok = false;
        try {
            if (!this.conn.getAutoCommit()) {
                this.conn.commit();
            }
            ok = true;
            this.success = true;
            this.isCommitted = true;
        }
        catch (SQLException sqle) {
            this.lastException = sqle;
            this.error("commit failed: " + sqle.getMessage(), sqle);
        }
        return ok;
    }

    void commitUnchecked() {
        this.warn(" id=" + this.sessionID + " perform commit unckecked !");
        try {
            this.conn.commit();
            this.success = true;
            this.isCommitted = true;
        }
        catch (SQLException sqle) {
            this.lastException = sqle;
            this.error("commit failed: " + sqle.getMessage(), sqle);
        }
    }

    public boolean rollback() {
        this.checkUsage(false);
        if (this.currentLogger.isDebugEnabled()) {
            this.currentLogger.debug((Object)"rollback()");
        }
        boolean ok = false;
        try {
            if (!this.conn.getAutoCommit()) {
                this.conn.rollback();
            }
            ok = true;
            this.success = true;
            this.isCommitted = true;
        }
        catch (SQLException sqle) {
            this.lastException = sqle;
            this.error("rollback failed: " + sqle.getMessage(), sqle);
        }
        return ok;
    }

    public boolean close() {
        if (this.currentLogger.isDebugEnabled()) {
            this.currentLogger.debug((Object)"close()");
        }
        this.resetErrorStatus();
        if (this.isConnected) {
            try {
                if (this.currentOpenStatement != null) {
                    this.currentOpenStatement.close();
                    this.currentOpenStatement = null;
                }
            }
            catch (SQLException sqle) {
                this.lastException = sqle;
                this.error("close: close current statement failed: " + sqle.getMessage(), sqle);
            }
            try {
                if (!this.psMap.isEmpty()) {
                    for (String psName : this.psMap.keySet()) {
                        PreparedStatement ps = this.psMap.get(psName);
                        if (ps == null) continue;
                        ps.close();
                    }
                }
                if (this.preparedStatementDefinitions != null && !this.preparedStatementDefinitions.isEmpty()) {
                    PreparedStatement ps = null;
                    Iterator<PreparedStatementDefinition> it = this.preparedStatementDefinitions.iterator();
                    while (it.hasNext()) {
                        ps = it.next().getPreparedStatement();
                        if (ps == null) continue;
                        ps.close();
                    }
                }
            }
            catch (SQLException sqle) {
                this.lastException = sqle;
                this.error("close: close prepared statements failed: " + sqle.getMessage(), sqle);
            }
            try {
                this.conn.close();
                this.isConnected = false;
            }
            catch (SQLException sqle) {
                this.lastException = sqle;
                this.error("close: close connection failed: " + sqle.getMessage(), sqle);
            }
        }
        return this.isSuccessful();
    }

    public Statement createStatement() {
        return this.createStatement(-1);
    }

    public Statement createStatement(int fetchSize) {
        this.checkUsage(false);
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
            if (fetchSize != -1) {
                stat.setFetchSize(fetchSize);
            } else if (this.desc.getDefaultFetchSize() != -1) {
                stat.setFetchSize(this.desc.getDefaultFetchSize());
            }
        }
        catch (SQLException e) {
            this.error("createStatement fetchSize=" + fetchSize + " failed: " + e.getMessage(), e);
        }
        return stat;
    }

    public PreparedStatement createPreparedStatement(String sql) throws SQLException {
        return this.createPreparedStatement(sql, -1);
    }

    public PreparedStatement createPreparedStatement(String sql, int fetchSize) throws SQLException {
        this.checkUsage(false);
        if (sql == null || sql.trim().length() == 0) {
            throw new IllegalArgumentException("sql cannot be null or empty");
        }
        this.lastSQL = "create prepared statement " + sql;
        this.success = false;
        PreparedStatement ps = this.conn.prepareStatement(sql);
        if (ps != null) {
            if (fetchSize != -1) {
                ps.setFetchSize(fetchSize);
            } else if (this.desc.getDefaultFetchSize() != -1) {
                ps.setFetchSize(this.desc.getDefaultFetchSize());
            }
            this.psMap.put(sql, ps);
        }
        this.success = true;
        return ps;
    }

    public void createPreparedStatement(PreparedStatementDefinition psDef) throws SQLException {
        this.createPreparedStatement(psDef, true, -1);
    }

    public void createPreparedStatement(PreparedStatementDefinition psDef, boolean enableCache) throws SQLException {
        this.createPreparedStatement(psDef, enableCache, -1);
    }

    public void createPreparedStatement(PreparedStatementDefinition psDef, boolean enableCache, int fetchSize) throws SQLException {
        this.checkUsage(false);
        this.success = false;
        if (psDef instanceof CallableStatementDefinition) {
            this.createCallableStatement((CallableStatementDefinition)psDef);
        } else {
            if (psDef.getSQL() == null || psDef.getSQL().trim().length() == 0) {
                throw new IllegalArgumentException("sql cannot be null or empty");
            }
            if (psDef.getPreparedStatement() == null) {
                if (psDef.getSQL() == null || psDef.getSQL().trim().length() == 0) {
                    throw new IllegalArgumentException("sql cannot be null or empty");
                }
                PreparedStatement ps = this.conn.prepareStatement(psDef.getSQL());
                if (ps == null) {
                    throw new SQLException("unable to create statement " + psDef.getSQL());
                }
                if (fetchSize != -1) {
                    ps.setFetchSize(fetchSize);
                } else if (this.desc.getDefaultFetchSize() != -1) {
                    ps.setFetchSize(this.desc.getDefaultFetchSize());
                }
                psDef.setPreparedStatement(ps);
                this.success = true;
                if (enableCache) {
                    if (this.preparedStatementDefinitions == null) {
                        this.preparedStatementDefinitions = new ArrayList();
                    }
                    this.preparedStatementDefinitions.add(psDef);
                }
            } else {
                PreparedStatement ps = this.conn.prepareStatement(psDef.getSQL());
                if (ps == null) {
                    throw new SQLException("unable to create statement " + psDef.getSQL());
                }
                if (fetchSize != -1) {
                    ps.setFetchSize(fetchSize);
                } else if (this.desc.getDefaultFetchSize() != -1) {
                    ps.setFetchSize(this.desc.getDefaultFetchSize());
                }
                psDef.setPreparedStatement(ps);
                this.success = true;
            }
        }
    }

    protected void closePreparedStatement(PreparedStatementDefinition psdef) throws SQLException {
        if (psdef.getPreparedStatement() != null) {
            psdef.getPreparedStatement().close();
        }
    }

    public void createCallableStatement(CallableStatementDefinition csDef) throws SQLException {
        this.createCallableStatement(csDef, -1);
    }

    public void createCallableStatement(CallableStatementDefinition csDef, int fetchSize) throws SQLException {
        this.checkUsage(false);
        this.success = false;
        if (csDef.getSQL() == null || csDef.getSQL().trim().length() == 0) {
            throw new IllegalArgumentException("sql cannot be null or empty");
        }
        if (csDef.getCallableStatement() == null) {
            CallableStatement cs = this.conn.prepareCall(csDef.getSQL());
            if (cs == null) {
                throw new SQLException("unable to create statement " + csDef.getSQL());
            }
            if (fetchSize != -1) {
                cs.setFetchSize(fetchSize);
            } else if (this.desc.getDefaultFetchSize() != -1) {
                cs.setFetchSize(this.desc.getDefaultFetchSize());
            }
            csDef.setCallableStatement(cs);
            if (this.preparedStatementDefinitions == null) {
                this.preparedStatementDefinitions = new ArrayList();
            }
            this.preparedStatementDefinitions.add(csDef);
            this.success = true;
        } else {
            CallableStatement cs = this.conn.prepareCall(csDef.getSQL());
            if (cs == null) {
                throw new SQLException("unable to create statement " + csDef.getSQL());
            }
            if (fetchSize != -1) {
                cs.setFetchSize(fetchSize);
            } else if (this.desc.getDefaultFetchSize() != -1) {
                cs.setFetchSize(this.desc.getDefaultFetchSize());
            }
            csDef.setCallableStatement(cs);
            this.success = true;
        }
    }

    public CallableStatement createCallableStatement(String sql) throws SQLException {
        return this.createCallableStatement(sql, -1);
    }

    public CallableStatement createCallableStatement(String sql, int fetchSize) throws SQLException {
        this.checkUsage(false);
        this.success = false;
        if (sql == null || sql.trim().length() == 0) {
            throw new IllegalArgumentException("sql cannot be null or empty");
        }
        this.lastSQL = "create callable statement " + sql;
        CallableStatement cs = this.conn.prepareCall(sql);
        if (cs != null) {
            if (fetchSize != -1) {
                cs.setFetchSize(fetchSize);
            } else if (this.desc.getDefaultFetchSize() != -1) {
                cs.setFetchSize(this.desc.getDefaultFetchSize());
            }
        }
        this.success = true;
        return cs;
    }

    public final boolean createPreparedStatement(String name, String sql) {
        return this.createPreparedStatement(name, sql, -1);
    }

    public final boolean createPreparedStatement(String name, String sql, int fetchSize) {
        this.checkUsage(false);
        boolean ok = false;
        if (sql == null || sql.trim().length() == 0) {
            throw new IllegalArgumentException("sql cannot be null or empty");
        }
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        if (this.psMap.get(name) == null) {
            try {
                PreparedStatement ps = this.conn.prepareStatement(sql);
                if (ps != null) {
                    if (fetchSize != -1) {
                        ps.setFetchSize(fetchSize);
                    } else if (this.desc.getDefaultFetchSize() != -1) {
                        ps.setFetchSize(this.desc.getDefaultFetchSize());
                    }
                    this.psMap.put(name, ps);
                    this.success = true;
                    ok = true;
                }
            }
            catch (SQLException sqle) {
                this.lastException = sqle;
                this.error("createPreparedStatement name=" + name + " failed: " + sqle.getMessage(), sqle);
            }
        } else {
            this.lastException = null;
            this.error("createPreparedStatement failed: attempt to overwrite existing prepared statement name=" + name);
        }
        return ok;
    }

    public final boolean createCallableStatement(String name, String sql) {
        return this.createCallableStatement(name, sql, -1);
    }

    public final boolean createCallableStatement(String name, String sql, int fetchSize) {
        this.checkUsage(false);
        boolean ok = false;
        if (sql == null || sql.trim().length() == 0) {
            throw new IllegalArgumentException("sql cannot be null or empty");
        }
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        try {
            CallableStatement cs = this.conn.prepareCall(sql);
            if (cs != null) {
                if (fetchSize != -1) {
                    cs.setFetchSize(fetchSize);
                } else if (this.desc.getDefaultFetchSize() != -1) {
                    cs.setFetchSize(this.desc.getDefaultFetchSize());
                }
                this.psMap.put(name, cs);
                this.success = true;
                ok = true;
            }
        }
        catch (SQLException sqle) {
            this.lastException = sqle;
            this.error("createCallableStatement name=" + name + " failed: " + sqle.getMessage(), sqle);
        }
        return ok;
    }

    public final PreparedStatement getPreparedStatement(String name) {
        this.checkUsage(false);
        this.lastSQL = "use prepared statement " + name;
        return this.psMap.get(name);
    }

    public final ResultSet getCurrentResultSet() {
        this.checkUsage(false);
        ResultSet rs = null;
        try {
            rs = this.currentOpenStatement.getResultSet();
            this.success = true;
        }
        catch (SQLException sqle) {
            this.lastException = sqle;
            this.error("getCurrentResultSet failed: " + sqle.getMessage(), sqle);
        }
        return rs;
    }

    public final boolean lastStatementWasAQuery() {
        return this.isQuery;
    }

    public final Connection getConnection() {
        this.checkUsage(false);
        return this.conn;
    }

    public final String getUrl() {
        return this.desc.getUrl();
    }

    public final String getDriverClassName() {
        return this.desc.getDriverClassName();
    }

    public final String getUser() {
        return this.desc.getUser();
    }

    public final String getPassword() {
        return this.desc.getPasswd();
    }

    public final void setUser(String user) {
        this.desc.setUser(user);
    }

    public final void setPasswd(String passwd) {
        this.desc.setPasswd(passwd);
    }

    public final void setUrl(String url) {
        this.desc.setUrl(url);
    }

    public final void setFetchSize(int fetchSize) {
        this.desc.setDefaultFetchSize(fetchSize);
    }

    public final void setDriverClassName(String driverClassName) {
        this.desc.setDriverClassName(driverClassName);
    }

    private void setCurrentOpenStatement(Statement stat) {
        this.closeCurrentOpenStatement();
        this.currentOpenStatement = stat;
    }

    public void closeCurrentOpenStatement() {
        if (this.currentOpenStatement != null) {
            if (this.currentLogger.isDebugEnabled()) {
                this.currentLogger.debug((Object)"closeCurrentOpenStatement");
            }
            try {
                this.currentOpenStatement.close();
            }
            catch (SQLException e) {
                this.currentLogger.warn((Object)("close previous statement failed: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public final synchronized ResultSet executeQuery(String sql) {
        return this.executeQuery(sql, this.desc.getDefaultFetchSize());
    }

    public final synchronized ResultSet executeQuery(String sql, int fetchSize) {
        this.checkUsage(false);
        this.lastSQL = sql;
        if (sql == null || sql.trim().length() == 0) {
            throw new IllegalArgumentException("sql cannot be null or empty");
        }
        if (this.currentLogger.isDebugEnabled()) {
            this.currentLogger.debug((Object)("executeQuery(sql=" + sql + ")"));
        }
        ResultSet rs = null;
        try {
            Statement stat = this.conn.createStatement();
            if (fetchSize > 0) {
                stat.setFetchSize(fetchSize);
                if (stat.getClass().getName().contains("mysql")) {
                    try {
                        stat.getClass().getMethod("enableStreamingResults", new Class[0]).invoke((Object)stat, new Object[0]);
                    }
                    catch (Exception e) {
                        this.currentLogger.warn((Object)e.getMessage());
                    }
                }
            }
            this.setCurrentOpenStatement(stat);
            rs = stat.executeQuery(sql);
            this.success = true;
            this.isQuery = true;
        }
        catch (SQLException sqle) {
            this.lastException = sqle;
            this.error("executeQuery=" + sql + " failed: " + sqle.getMessage(), sqle);
        }
        return rs;
    }

    public synchronized boolean execute(String sql) {
        this.checkUsage(true);
        if (sql == null || sql.trim().length() == 0) {
            throw new IllegalArgumentException("sql cannot be null or empty");
        }
        this.lastSQL = sql;
        if (this.currentLogger.isDebugEnabled()) {
            this.currentLogger.debug((Object)("execute(sql=" + sql + ")"));
        }
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
            if (this.desc.getDefaultFetchSize() != -1) {
                stat.setFetchSize(this.desc.getDefaultFetchSize());
            }
            this.isQuery = stat.execute(sql);
            if (this.isQuery) {
                this.setCurrentOpenStatement(stat);
            } else {
                stat.close();
            }
            this.success = true;
        }
        catch (SQLException sqle) {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.setCurrentOpenStatement(null);
            this.lastException = sqle;
            this.error("execute=" + sql + " failed: " + sqle.getMessage(), sqle);
        }
        return this.success;
    }

    public synchronized int executeUpdate(String sql) {
        this.checkUsage(true);
        if (sql == null || sql.trim().length() == 0) {
            throw new IllegalArgumentException("sql cannot be null or empty");
        }
        this.lastSQL = sql;
        if (this.currentLogger.isDebugEnabled()) {
            this.currentLogger.debug((Object)("executeUpdate(sql=" + sql + ")"));
        }
        int count = -1;
        Statement stat = null;
        try {
            this.isQuery = false;
            stat = this.conn.createStatement();
            count = stat.executeUpdate(sql);
            stat.close();
            this.success = true;
        }
        catch (SQLException sqle) {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.lastException = sqle;
            this.error("executeUpdate=" + sql + " failed: " + sqle.getMessage(), sqle);
        }
        return count;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public String getLastSQL() {
        return this.lastSQL;
    }

    public long getLastErrorTimestamp() {
        return this.lastErrorTimestamp;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void resetSuccessfulFlag() {
        this.success = true;
    }

    public void resetErrorStatus() {
        this.success = true;
        this.lastErrorTimestamp = 0L;
        this.lastErrorMessage = null;
        this.lastException = null;
    }

    public void debug(String message) {
        if (this.currentLogger.isDebugEnabled()) {
            this.currentLogger.debug((Object)message);
        }
    }

    private void createSessionID() {
        this.sessionID = ++lastSessionID;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String toString() {
        return this.getClass().getName() + ": sessionID=" + String.valueOf(this.sessionID) + " alias=" + this.aliasName + " url=" + this.desc.getUrl() + " user=" + this.desc.getUser();
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

