/*
 * Decompiled with CFR 0.152.
 */
package dbtools;

import dbtools.PreparedStatementDefinition;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public abstract class CallableStatementDefinition
extends PreparedStatementDefinition {
    private static final Logger logger = Logger.getLogger(CallableStatementDefinition.class);
    protected CallableStatement cs;
    private ArrayList<OutParameter> outParams = new ArrayList();

    public final void setCallableStatement(CallableStatement statement) throws SQLException {
        this.cs = statement;
        OutParameter outParam = null;
        for (int i = 0; i < this.outParams.size(); ++i) {
            outParam = this.outParams.get(i);
            this.cs.registerOutParameter(outParam.index, outParam.type);
        }
    }

    public final void registerOutParameter(int index, int type) {
        OutParameter outParam = new OutParameter();
        outParam.index = index;
        outParam.type = type;
        this.outParams.add(outParam);
        if (this.cs != null) {
            try {
                this.cs.registerOutParameter(outParam.index, outParam.type);
            }
            catch (SQLException e) {
                logger.error((Object)("registerOutParam: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public CallableStatement getCallableStatement() {
        return this.cs;
    }

    @Override
    public PreparedStatement getPreparedStatement() {
        return this.cs;
    }

    @Override
    public final String toString() {
        return this.sql;
    }

    static final class OutParameter {
        protected int index;
        protected int type;

        OutParameter() {
        }
    }
}

