/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.Datum;
import oracle.sql.Kotad;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public class TypeDescriptor
implements Serializable,
ORAData {
    public static boolean DEBUG_SERIALIZATION = false;
    static final long serialVersionUID = 2022598722047823723L;
    static final int KOIDFLEN = 16;
    static final short KOTA_TRN = 1;
    static final short KOTA_PDF = 2;
    static final short KOTA_ITOID = 4;
    static final short KOTA_LOB = 8;
    static final short KOTA_AD = 16;
    static final short KOTA_NMHSH = 32;
    static final short KOTA_TEV = 64;
    static final short KOTA_INH = 128;
    static final short KOTA_10I = 256;
    static final short KOTA_RBF = 512;
    static final short KOTA_HBF = 1024;
    static final int ANYTYPE_IMAGE_SIZE_TOID = 23;
    static final int ANYTYPE_IMAGE_SIZE_NO_TOID = 5;
    static final byte KOTTDOID = 1;
    static final byte KOTTBOID = 2;
    static final byte KOTADOID = 3;
    static final byte KOTREFOID = 4;
    static final byte KOTMDOID = 5;
    static final byte KOTMIOID = 6;
    static final byte KOTEXOID = 7;
    static final byte KOTDATOID = 8;
    static final byte KOTBYTOID = 9;
    static final byte KOTSHOOID = 10;
    static final byte KOTLONOID = 11;
    static final byte KOTREAOID = 12;
    static final byte KOTDOUOID = 13;
    static final byte KOTFLOOID = 14;
    static final byte KOTNUMOID = 15;
    static final byte KOTDECOID = 16;
    static final byte KOTUBYOID = 17;
    static final byte KOTUSHOID = 18;
    static final byte KOTULOOID = 19;
    static final byte KOTOCTOID = 20;
    static final byte KOTSMLOID = 21;
    static final byte KOTINTOID = 22;
    static final byte KOTRAWOID = 23;
    static final byte KOTPTROID = 24;
    static final byte KOTVSIOID = 25;
    static final byte KOTFSIOID = 26;
    static final byte KOTVSOOID = 27;
    static final byte KOTMLSOID = 28;
    static final byte KOTVAROID = 29;
    static final byte KOTMSTOID = 30;
    static final byte KOTNATOID = 31;
    static final byte KOTDOMOID = 32;
    static final byte KOTUND1OID = 33;
    static final byte KOTCLBOID = 34;
    static final byte KOTBLBOID = 35;
    static final byte KOTCFLOID = 36;
    static final byte KOTBFLOID = 37;
    static final byte KOTOIDOID = 38;
    static final byte KOTCAROID = 39;
    static final byte KOTCANOID = 40;
    static final byte KOTLPTOID = 41;
    static final byte KOTBRIOID = 42;
    static final byte KOTUCOOID = 43;
    static final byte KOTRECOID = 44;
    static final byte KOTRCUOID = 45;
    static final byte KOTBOOOID = 46;
    static final byte KOTRIDOID = 47;
    static final byte KOTPLOOID = 48;
    static final byte KOTPLROID = 49;
    static final byte KOTPBIOID = 50;
    static final byte KOTPINOID = 51;
    static final byte KOTPNAOID = 52;
    static final byte KOTPNNOID = 53;
    static final byte KOTPPOOID = 54;
    static final byte KOTPPNOID = 55;
    static final byte KOTPSTOID = 56;
    static final byte KOTEX1OID = 57;
    static final byte KOTOPQOID = 58;
    static final byte KOTTMOID = 59;
    static final byte KOTTMTZOID = 60;
    static final byte KOTTSOID = 61;
    static final byte KOTTSTZOID = 62;
    static final byte KOTIYMOID = 63;
    static final byte KOTIDSOID = 64;
    static final byte KOTTSIMPTZOID = 65;
    static final byte KOTTBXOID = 66;
    static final byte KOTADXOID = 67;
    static final byte KOTOIDBFLT = 68;
    static final byte KOTOIDBDBL = 69;
    static final byte KOTURDOID = 70;
    static final byte KOTLASTOID = 71;
    static final byte[] KOTTDEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1};
    static final byte[] KOTTBEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2};
    static final byte[] KOTADEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3};
    static final byte[] KOTMDEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4};
    static final byte[] KOTTBXEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 66};
    static final byte[] KOTADXEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 67};
    static final byte[] KOTTDTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    static final byte[] KOTTBTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    static final byte[] KOTADTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3};
    static final byte[] KOTMDTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5};
    static final byte[] KOTMITOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6};
    static final byte[] KOTEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7};
    static final byte[] KOTEX1TOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57};
    static final byte[] KOTTBXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66};
    static final byte[] KOTADXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67};
    public static final byte[] RAWTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23};
    public static final byte[] ANYTYPETOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 16};
    public static final byte[] ANYDATATOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 17};
    public static final byte[] ANYDATASETTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 18};
    static final short SQLT_NONE = 0;
    static final short SQLT_CHR = 1;
    static final short SQLT_NUM = 2;
    static final short SQLT_INT = 3;
    static final short SQLT_FLT = 4;
    static final short SQLT_STR = 5;
    static final short SQLT_VNU = 6;
    static final short SQLT_PDN = 7;
    static final short SQLT_LNG = 8;
    static final short SQLT_VCS = 9;
    static final short SQLT_NON = 10;
    static final short SQLT_RID = 11;
    static final short SQLT_DAT = 12;
    static final short SQLT_VBI = 15;
    static final short SQLT_BFLOAT = 21;
    static final short SQLT_BDOUBLE = 22;
    static final short SQLT_BIN = 23;
    static final short SQLT_LBI = 24;
    static final short SQLT_UIN = 68;
    static final short SQLT_SLS = 91;
    static final short SQLT_LVC = 94;
    static final short SQLT_LVB = 95;
    static final short SQLT_AFC = 96;
    static final short SQLT_AVC = 97;
    static final short SQLT_IBFLOAT = 100;
    static final short SQLT_IBDOUBLE = 101;
    static final short SQLT_CUR = 102;
    static final short SQLT_RDD = 104;
    static final short SQLT_LAB = 105;
    static final short SQLT_OSL = 106;
    static final short SQLT_NTY = 108;
    static final short SQLT_REF = 110;
    static final short SQLT_CLOB = 112;
    static final short SQLT_BLOB = 113;
    static final short SQLT_BFILEE = 114;
    static final short SQLT_FILE = 114;
    static final short SQLT_CFILEE = 115;
    static final short SQLT_RSET = 116;
    static final short SQLT_SVT = 118;
    static final short SQLT_NCO = 122;
    static final short SQLT_DTR = 152;
    static final short SQLT_DUN = 153;
    static final short SQLT_DOP = 154;
    static final short SQLT_VST = 155;
    static final short SQLT_ODT = 156;
    static final short SQLT_DOL = 172;
    static final short SQLT_DATE = 184;
    static final short SQLT_TIME = 185;
    static final short SQLT_TIME_TZ = 186;
    static final short SQLT_TIMESTAMP = 187;
    static final short SQLT_TIMESTAMP_TZ = 188;
    static final short SQLT_INTERVAL_YM = 189;
    static final short SQLT_INTERVAL_DS = 190;
    static final short SQLT_TIMESTAMP_LTZ = 232;
    static final short SQLT_PNTY = 241;
    static final short SQLT_CFILE = 115;
    static final short SQLT_BFILE = 114;
    static final short SQLT_REC = 250;
    static final short SQLT_TAB = 251;
    static final short SQLT_BOL = 252;
    static final short SQLCS_IMPLICIT = 1;
    static final short SQLCS_NCHAR = 2;
    static final short SQLCS_EXPLICIT = 3;
    static final short SQLCS_FLEXIBLE = 4;
    static final short SQLCS_LIT_NULL = 5;
    static final short SQLT_XDP = 103;
    static final short SQLT_OKO = 107;
    static final short SQLT_INTY = 109;
    static final short SQLT_IREF = 111;
    static final short SQLT_DCLOB = 195;
    public static final short TYPECODE_REF = 110;
    public static final short TYPECODE_DATE = 12;
    public static final short TYPECODE_SIGNED8 = 27;
    public static final short TYPECODE_SIGNED16 = 28;
    public static final short TYPECODE_SIGNED32 = 29;
    public static final short TYPECODE_REAL = 21;
    public static final short TYPECODE_DOUBLE = 22;
    public static final short TYPECODE_BFLOAT = 100;
    public static final short TYPECODE_BDOUBLE = 101;
    public static final short TYPECODE_FLOAT = 4;
    public static final short TYPECODE_NUMBER = 2;
    public static final short TYPECODE_DECIMAL = 7;
    public static final short TYPECODE_UNSIGNED8 = 23;
    public static final short TYPECODE_UNSIGNED16 = 25;
    public static final short TYPECODE_UNSIGNED32 = 26;
    public static final short TYPECODE_OCTET = 245;
    public static final short TYPECODE_SMALLINT = 246;
    public static final short TYPECODE_INTEGER = 3;
    public static final short TYPECODE_RAW = 95;
    public static final short TYPECODE_PTR = 32;
    public static final short TYPECODE_VARCHAR2 = 9;
    public static final short TYPECODE_CHAR = 96;
    public static final short TYPECODE_VARCHAR = 1;
    public static final short TYPECODE_MLSLABEL = 105;
    public static final short TYPECODE_VARRAY = 247;
    public static final short TYPECODE_TABLE = 248;
    public static final short TYPECODE_OBJECT = 108;
    public static final short TYPECODE_OPAQUE = 58;
    public static final short TYPECODE_NAMEDCOLLECTION = 122;
    public static final short TYPECODE_BLOB = 113;
    public static final short TYPECODE_BFILE = 114;
    public static final short TYPECODE_CLOB = 112;
    public static final short TYPECODE_CFILE = 115;
    public static final short TYPECODE_TIME = 185;
    public static final short TYPECODE_TIME_TZ = 186;
    public static final short TYPECODE_TIMESTAMP = 187;
    public static final short TYPECODE_TIMESTAMP_TZ = 188;
    public static final short TYPECODE_TIMESTAMP_LTZ = 232;
    public static final short TYPECODE_INTERVAL_YM = 189;
    public static final short TYPECODE_INTERVAL_DS = 190;
    public static final short TYPECODE_UROWID = 104;
    public static final short TYPECODE_OTMFIRST = 228;
    public static final short TYPECODE_OTMLAST = 320;
    public static final short TYPECODE_SYSFIRST = 228;
    public static final short TYPECODE_SYSLAST = 235;
    public static final short TYPECODE_PLS_INTEGER = 266;
    public static final short TYPECODE_ITABLE = 251;
    public static final short TYPECODE_RECORD = 250;
    public static final short TYPECODE_BOOLEAN = 252;
    public static final short TYPECODE_NCHAR = 286;
    public static final short TYPECODE_NVARCHAR2 = 287;
    public static final short TYPECODE_NCLOB = 288;
    public static final short TYPECODE_NONE = 0;
    public static final short TYPECODE_ERRHP = 283;
    public static final short TYPECODE_JDBC_JOBJECT = 2000;
    public static final short TYPECODE_JDBC_STRUCT = 2002;
    public static final short TYPECODE_JDBC_ARRAY = 2003;
    public static final short TYPECODE_JDBC_JOPAQUE = 2000;
    public static final short TYPECODE_JDBC_REF = 2006;
    public static final short TYPECODE_JDBC_JSTRUCT = 2008;
    private static final short TYPECODE_MAXVALUE = 2008;
    static final short[] OID_TO_TYPECODE = new short[71];
    SQLName sqlName;
    OracleNamedType pickler;
    transient OracleConnection connection;
    short internalTypeCode;
    boolean isTransient = false;
    byte[] toid = null;
    int toidVersion = 1;
    long precision;
    byte scale;
    byte[] transientImage = null;
    AttributeDescriptor[] attributesDescriptor = null;
    transient Boolean isInstanciable = null;
    transient String supertype = null;
    transient int numLocalAttrs = -1;
    transient String[] subtypes = null;
    transient String[] attrJavaNames = null;
    private static String[] typeCodeTypeNameMap;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:20_PDT_2008";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyDescriptor(TypeDescriptor src) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(src));
                OracleLog.recursiveTrace = false;
            }
            this.sqlName = src.sqlName;
            this.pickler = src.pickler;
            this.connection = src.connection;
            this.internalTypeCode = src.internalTypeCode;
            this.isTransient = src.isTransient;
            this.toid = src.toid;
            this.toidVersion = src.toidVersion;
            this.precision = src.precision;
            this.scale = src.scale;
            this.transientImage = src.transientImage;
            this.attributesDescriptor = src.attributesDescriptor;
            this.isInstanciable = src.isInstanciable;
            this.supertype = src.supertype;
            this.numLocalAttrs = src.numLocalAttrs;
            this.subtypes = src.subtypes;
            this.attrJavaNames = src.attrJavaNames;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeDescriptor(short _typeCode) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_typeCode));
                OracleLog.recursiveTrace = false;
            }
            this.internalTypeCode = _typeCode;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeDescriptor(short _typeCode, String name, Connection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_typeCode) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.internalTypeCode = _typeCode;
            if (name == null || conn == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.TypeDescriptor: Invalid arguments, 'name' should not be an empty string and conn should not be null. An exception is thrown.");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 60Invalid arguments");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            }
            this.setPhysicalConnectionOf(conn);
            this.sqlName = new SQLName(name, this.getInternalConnection());
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeDescriptor(short _typeCode, SQLName name, Connection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_typeCode) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.internalTypeCode = _typeCode;
            if (name == null || conn == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.TypeDescriptor: Invalid arguments, 'name' and  'conn'  should not be null. An exception is thrown.");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 60Invalid arguments");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            }
            this.sqlName = name;
            this.setPhysicalConnectionOf(conn);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeDescriptor(short _typeCode, SQLName name, OracleTypeADT type, Connection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_typeCode) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.internalTypeCode = _typeCode;
            if (name == null || type == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.TypeDescriptor: Invalid arguments, 'name', 'type' and 'conn'  should not be null. An exception is thrown.");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 60Invalid arguments");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            }
            this.sqlName = name;
            if (conn != null) {
                this.setPhysicalConnectionOf(conn);
            }
            this.pickler = type;
            this.pickler.setDescriptor(this);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeDescriptor(short _typeCode, OracleTypeADT type, Connection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_typeCode) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.internalTypeCode = _typeCode;
            if (type == null || conn == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.TypeDescriptor: Invalid arguments, 'type' and  'conn'  should not be null. An exception is thrown.");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 60Invalid arguments");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            }
            this.setPhysicalConnectionOf(conn);
            this.sqlName = null;
            this.pickler = type;
            this.pickler.setDescriptor(this);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            String string;
            block11: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.sqlName == null) {
                        this.initSQLName();
                    }
                    String ret = null;
                    if (this.sqlName != null) {
                        ret = this.sqlName.getName();
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                        OracleLog.recursiveTrace = false;
                    }
                    string = ret;
                    if (!TRACE || OracleLog.recursiveTrace) break block11;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                TypeDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLName getSQLName() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            SQLName sQLName;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.sqlName == null) {
                        this.initSQLName();
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.sqlName);
                        OracleLog.recursiveTrace = false;
                    }
                    sQLName = this.sqlName;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                TypeDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return sQLName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initSQLName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (!this.isTransient) {
                if (this.connection == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.initSQLName: Internal error. An exception is thrown.");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
                }
                if (this.pickler != null) {
                    this.sqlName = new SQLName(this.pickler.getFullName(), this.connection);
                } else if (this.toid != null) {
                    String typeName = OracleTypeADT.toid2typename(this.connection, this.toid);
                    this.sqlName = new SQLName(typeName, this.connection);
                    TypeDescriptor descriptorFromCache = null;
                    String qname = this.sqlName.getName();
                    descriptorFromCache = (TypeDescriptor)this.connection.getDescriptor(qname);
                    if (descriptorFromCache != null) {
                        this.copyDescriptor(descriptorFromCache);
                    }
                } else if (this.internalTypeCode == 108 || this.internalTypeCode == 122) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String ret = null;
            if (this.sqlName == null) {
                this.initSQLName();
            }
            if (this.sqlName != null) {
                ret = this.sqlName.getSchema();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTypeName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String ret = null;
            if (this.sqlName == null) {
                this.initSQLName();
            }
            if (this.sqlName != null) {
                ret = this.sqlName.getSimpleName();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleNamedType getPickler() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.pickler);
                OracleLog.recursiveTrace = false;
            }
            OracleNamedType oracleNamedType = this.pickler;
            return oracleNamedType;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnection getInternalConnection() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = this.connection;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalConnectionOf(Connection conn) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.connection = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeCode() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.internalTypeCode);
                OracleLog.recursiveTrace = false;
            }
            short s2 = this.internalTypeCode;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public String getTypeCodeName() throws SQLException {
        return TypeDescriptor.getTypeCodeTypeNameMap()[this.getTypeCode()];
    }

    private static String[] getTypeCodeTypeNameMap() throws SQLException {
        if (typeCodeTypeNameMap == null) {
            String[] typeCodeTypeNameMap_local = new String[2009];
            Class<?> typeDescriptorClass = null;
            try {
                typeDescriptorClass = Class.forName("oracle.sql.TypeDescriptor");
            }
            catch (ClassNotFoundException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 1TypeDescriptor.getTypeCodeName: got a ClassNotFoundException: " + ex.getMessage());
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 1, "TypeDescriptor.getTypeCodeName: got a ClassNotFoundException: " + ex.getMessage());
            }
            Field[] publicTypeCodeFields = typeDescriptorClass.getFields();
            for (int i2 = 0; i2 < publicTypeCodeFields.length; ++i2) {
                if (!publicTypeCodeFields[i2].getName().startsWith("TYPECODE_")) continue;
                try {
                    typeCodeTypeNameMap_local[publicTypeCodeFields[i2].getInt(null)] = publicTypeCodeFields[i2].getName();
                    continue;
                }
                catch (Exception ex) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 1TypeDescriptor.getTypeCodeName: " + ex.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 1, "TypeDescriptor.getTypeCodeName: " + ex.getMessage());
                }
            }
            typeCodeTypeNameMap = typeCodeTypeNameMap_local;
        }
        return typeCodeTypeNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getInternalTypeCode() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.internalTypeCode);
                OracleLog.recursiveTrace = false;
            }
            short s2 = this.internalTypeCode;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeDescriptor getTypeDescriptor(String name, oracle.jdbc.OracleConnection conn) throws SQLException {
        TypeDescriptor typeDescriptor;
        block19: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                    OracleLog.recursiveTrace = false;
                }
                TypeDescriptor descriptor = null;
                try {
                    SQLName sqlName = new SQLName(name, conn);
                    String qname = sqlName.getName();
                    descriptor = (TypeDescriptor)conn.getDescriptor(qname);
                    if (descriptor == null) {
                        OracleTypeADT otype = new OracleTypeADT(qname, conn);
                        OracleConnection iconn = (OracleConnection)conn;
                        otype.init(iconn);
                        OracleNamedType realType = otype.cleanup();
                        switch (realType.getTypeCode()) {
                            case 2002: 
                            case 2008: {
                                descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                                break;
                            }
                            case 2003: {
                                descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                                break;
                            }
                            case 2007: {
                                descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                                break;
                            }
                            default: {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.getTypeDescriptor: The real type should be either STRUCT, JAVA_STRUCT, ARRAY or OPAQUE. An exception is thrown.");
                                    OracleLog.recursiveTrace = false;
                                }
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(null, 1);
                            }
                        }
                        conn.putDescriptor(qname, descriptor);
                        realType.setDescriptor(descriptor);
                    }
                }
                catch (Exception e2) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.getTypeDescriptor: Exception caught and thrown." + e2.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                    if (e2 instanceof SQLException) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: " + (SQLException)e2 + 60 + "Unable to resolve type \"" + name + "\"");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(null, (SQLException)e2, 60, "Unable to resolve type \"" + name + "\"");
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 60Unable to resolve type \"" + name + "\"");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 60, "Unable to resolve type \"" + name + "\"");
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + descriptor);
                    OracleLog.recursiveTrace = false;
                }
                typeDescriptor = descriptor;
                if (!TRACE || OracleLog.recursiveTrace) break block19;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            TypeDescriptor.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return typeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeDescriptor getTypeDescriptor(String qualifiedName, oracle.jdbc.OracleConnection conn, byte[] image, long offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(qualifiedName) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(image) + ", " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            TypeDescriptor descriptor = null;
            byte[][] hashKey = new byte[1][];
            String qname = TypeDescriptor.getSubtypeName(conn, image, offset);
            if (qname == null) {
                qname = qualifiedName;
            }
            if ((descriptor = (TypeDescriptor)conn.getDescriptor(qname)) == null) {
                SQLName sqlName = new SQLName(qname, conn);
                OracleTypeADT otype = new OracleTypeADT(qname, conn);
                OracleConnection iconn = (OracleConnection)conn;
                otype.init(iconn);
                OracleNamedType realType = otype.cleanup();
                switch (realType.getTypeCode()) {
                    case 2002: 
                    case 2008: {
                        descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                        break;
                    }
                    case 2003: {
                        descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                        break;
                    }
                    case 2007: {
                        descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                        break;
                    }
                    default: {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.getTypeDescriptor: The real type should be either STRUCT, JAVA_STRUCT, ARRAY or OPAQUE. An exception is thrown.");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(null, 1);
                    }
                }
                conn.putDescriptor(qname, descriptor);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + descriptor);
                OracleLog.recursiveTrace = false;
            }
            TypeDescriptor typeDescriptor = descriptor;
            return typeDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Connection c2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            this.connection = (OracleConnection)c2;
            OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.ANYTYPE", c2);
            byte[] image = new byte[this.getOpaqueImageTypeSize()];
            this.pickleOpaqueTypeImage(image, 0, false);
            OPAQUE opq = new OPAQUE(desc, this.connection, image);
            opq.setShareBytes(opq.toBytes());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + opq);
                OracleLog.recursiveTrace = false;
            }
            OPAQUE oPAQUE = opq;
            return oPAQUE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeDescriptor unpickleOpaqueTypeImage(PickleContext context, Connection connection, short[] rdbmsTypeCodeArr) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(connection));
                OracleLog.recursiveTrace = false;
            }
            byte[] toid = null;
            TypeDescriptor ret = null;
            int offsetBegin = context.offset();
            byte[] image = context.image();
            context.skipBytes(1);
            short flag = (short)context.readUB2();
            rdbmsTypeCodeArr[0] = (short)context.readUB2();
            if ((flag & 0x20) != 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: Export/Import of persistent type isn't supported.");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 178");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 178);
            } else if ((flag & 1) == 0) {
                if ((flag & 2) == 0 || rdbmsTypeCodeArr[0] == 110) {
                    toid = context.readDataValue(16);
                    int toidVersion = context.readUB2();
                    String typeName = (String)((OracleConnection)connection).getDescriptor(toid);
                    ret = (TypeDescriptor)((OracleConnection)connection).getDescriptor(typeName);
                    if (ret == null) {
                        if (rdbmsTypeCodeArr[0] == 122) {
                            ret = new ArrayDescriptor(toid, toidVersion, connection);
                        } else if (rdbmsTypeCodeArr[0] == 108 || rdbmsTypeCodeArr[0] == 110) {
                            ret = new StructDescriptor(toid, toidVersion, connection);
                        } else if (rdbmsTypeCodeArr[0] == 58) {
                            ret = new OpaqueDescriptor(toid, toidVersion, connection);
                        } else {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 178");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(null, 178);
                        }
                    }
                } else {
                    ret = new TypeDescriptor(rdbmsTypeCodeArr[0]);
                }
                ret.setTransient(false);
            } else {
                int numattrs = (int)context.readUB4();
                if (rdbmsTypeCodeArr[0] == 108) {
                    AttributeDescriptor[] ados = null;
                    if (numattrs > 0) {
                        ados = new AttributeDescriptor[numattrs];
                        for (int i2 = 0; i2 < numattrs; ++i2) {
                            byte adeFlag = context.readByte();
                            ados[i2] = Kotad.unpickleAttributeImage(adeFlag == 2, context);
                            if (adeFlag == 2) continue;
                            short[] attrRdbmsTypeCode = new short[1];
                            ados[i2].setTypeDescriptor(TypeDescriptor.unpickleOpaqueTypeImage(context, connection, attrRdbmsTypeCode));
                        }
                    }
                    ret = new StructDescriptor(ados, connection);
                } else if (numattrs == 1) {
                    byte adeFlag = context.readByte();
                    ret = Kotad.unpickleTypeDescriptorImage(context);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 178");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 178);
                }
                ret.setTransient(true);
            }
            if (ret.isTransient()) {
                int offsetEnd = context.offset();
                byte[] transientTypeImage = new byte[offsetEnd - offsetBegin];
                System.arraycopy(image, offsetBegin, transientTypeImage, 0, transientTypeImage.length);
                ret.setTransientImage(transientTypeImage);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            TypeDescriptor typeDescriptor = ret;
            return typeDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransientImage(byte[] _transientImage) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_transientImage));
                OracleLog.recursiveTrace = false;
            }
            this.transientImage = _transientImage;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransient(boolean _isTransient) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_isTransient));
                OracleLog.recursiveTrace = false;
            }
            this.isTransient = _isTransient;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransient() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.isTransient);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = this.isTransient;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOpaqueImageTypeSize() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int ret = 0;
            if (this.isTransient) {
                ret = this.transientImage.length;
            } else {
                ret = 5;
                if (this.toid != null && this.toid.length == 16) {
                    ret = 23;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int pickleOpaqueTypeImage(byte[] buffer, int offset, boolean isREF) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            if (this.isTransient) {
                System.arraycopy(this.transientImage, 0, buffer, offset, this.transientImage.length);
                offset += this.transientImage.length;
            } else {
                boolean includeToid = false;
                if (this.toid != null && this.toid.length == 16) {
                    includeToid = true;
                }
                buffer[offset++] = 1;
                int rdbmsTypeCode = this.internalTypeCode;
                if (isREF) {
                    rdbmsTypeCode = 110;
                }
                int flag = 512;
                if (rdbmsTypeCode != 108 && rdbmsTypeCode != 122) {
                    flag |= 2;
                }
                if (includeToid && rdbmsTypeCode != 110) {
                    flag |= 4;
                }
                buffer[offset++] = (byte)((flag & 0xFF00) >> 8 & 0xFF);
                buffer[offset++] = (byte)(flag & 0xFF);
                buffer[offset++] = (byte)((rdbmsTypeCode & 0xFF00) >> 8 & 0xFF);
                buffer[offset++] = (byte)(rdbmsTypeCode & 0xFF);
                if (includeToid) {
                    System.arraycopy(this.toid, 0, buffer, offset, this.toid.length);
                    offset += this.toid.length;
                    buffer[offset++] = (byte)((this.toidVersion & 0xFF00) >> 8 & 0xFF);
                    buffer[offset++] = (byte)(this.toidVersion & 0xFF);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + offset);
                OracleLog.recursiveTrace = false;
            }
            int n2 = offset;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrecision(long _precision) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_precision));
                OracleLog.recursiveTrace = false;
            }
            this.precision = _precision;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPrecision() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.precision);
                OracleLog.recursiveTrace = false;
            }
            long l2 = this.precision;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(byte _scale) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_scale));
                OracleLog.recursiveTrace = false;
            }
            this.scale = _scale;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getScale() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.scale);
                OracleLog.recursiveTrace = false;
            }
            byte by = this.scale;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(checkThisName));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(out));
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.sqlName == null) {
                    this.initSQLName();
                }
            }
            catch (SQLException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(OracleLog.TRACE_20, "Debug: TypeDescriptor.writeObject: Exception caught and thrown." + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(Level.SEVERE, "Throwing java.io.IOException: " + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
                throw new IOException(e2.getMessage());
            }
            out.writeObject(this.sqlName);
            out.writeObject(this.pickler);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in));
                OracleLog.recursiveTrace = false;
            }
            this.sqlName = (SQLName)in.readObject();
            this.pickler = (OracleNamedType)in.readObject();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(Connection connection) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(connection));
                OracleLog.recursiveTrace = false;
            }
            this.setPhysicalConnectionOf(connection);
            this.pickler.setConnection(this.getInternalConnection());
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSubtypeName(oracle.jdbc.OracleConnection conn, byte[] image, long offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(image) + ", " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            if (image == null || image.length == 0 || conn == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TypeDescriptor.logger().log(Level.SEVERE, "Throwing SQLException: 68 'image' should not be empty and 'conn' should not be null. ");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 68, " 'image' should not be empty and 'conn' should not be null. ");
            }
            String ret = OracleTypeADT.getSubtypeName(conn, image, offset);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMetadataRecursively() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.pickler != null) {
                this.pickler.initMetadataRecursively();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initNamesRecursively() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.pickler != null) {
                this.pickler.initNamesRecursively();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixupConnection(OracleConnection fixupConn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(fixupConn));
                OracleLog.recursiveTrace = false;
            }
            if (this.connection == null) {
                this.connection = fixupConn;
            }
            if (this.pickler != null) {
                this.pickler.fixupConnection(fixupConn);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXMLString() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "return: " + this.toXMLString(false));
                OracleLog.recursiveTrace = false;
            }
            String string = this.toXMLString(false);
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXMLString(boolean fetchAllMetaDataAsNeeded) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(fetchAllMetaDataAsNeeded));
                OracleLog.recursiveTrace = false;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.printXMLHeader(pw);
            this.printXML(pw, 0, fetchAllMetaDataAsNeeded);
            String __result__ = sw.getBuffer().substring(0);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printXML(PrintStream s2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2));
                OracleLog.recursiveTrace = false;
            }
            this.printXML(s2, false);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printXML(PrintStream stream, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stream));
                OracleLog.recursiveTrace = false;
            }
            PrintWriter pw = new PrintWriter(stream, true);
            this.printXMLHeader(pw);
            this.printXML(pw, 0, fetchAllMetaDataAsNeeded);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pw) + ", " + OracleLog.argument(indent) + ", " + OracleLog.argument(fetchAllMetaDataAsNeeded));
                OracleLog.recursiveTrace = false;
            }
            String tagname = this.tagName();
            pw.println("<" + tagname + " sqlName=\"" + this.sqlName + "\" >");
            if (this.pickler != null) {
                this.pickler.printXML(pw, indent + 1, fetchAllMetaDataAsNeeded);
            }
            pw.println("</" + tagname + ">");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String tagName() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "return: TypeDescriptor");
                OracleLog.recursiveTrace = false;
            }
            String string = "TypeDescriptor";
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printXMLHeader(PrintWriter pw) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pw));
                OracleLog.recursiveTrace = false;
            }
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = this.connection;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TypeDescriptor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        TypeDescriptor.OID_TO_TYPECODE[8] = 12;
        TypeDescriptor.OID_TO_TYPECODE[9] = 27;
        TypeDescriptor.OID_TO_TYPECODE[10] = 28;
        TypeDescriptor.OID_TO_TYPECODE[11] = 29;
        TypeDescriptor.OID_TO_TYPECODE[12] = 21;
        TypeDescriptor.OID_TO_TYPECODE[13] = 22;
        TypeDescriptor.OID_TO_TYPECODE[14] = 4;
        TypeDescriptor.OID_TO_TYPECODE[15] = 2;
        TypeDescriptor.OID_TO_TYPECODE[16] = 7;
        TypeDescriptor.OID_TO_TYPECODE[17] = 23;
        TypeDescriptor.OID_TO_TYPECODE[18] = 25;
        TypeDescriptor.OID_TO_TYPECODE[19] = 26;
        TypeDescriptor.OID_TO_TYPECODE[20] = 245;
        TypeDescriptor.OID_TO_TYPECODE[21] = 246;
        TypeDescriptor.OID_TO_TYPECODE[22] = 3;
        TypeDescriptor.OID_TO_TYPECODE[23] = 95;
        TypeDescriptor.OID_TO_TYPECODE[24] = 32;
        TypeDescriptor.OID_TO_TYPECODE[25] = 9;
        TypeDescriptor.OID_TO_TYPECODE[26] = 96;
        TypeDescriptor.OID_TO_TYPECODE[27] = 1;
        TypeDescriptor.OID_TO_TYPECODE[28] = 105;
        TypeDescriptor.OID_TO_TYPECODE[29] = 247;
        TypeDescriptor.OID_TO_TYPECODE[30] = 248;
        TypeDescriptor.OID_TO_TYPECODE[31] = 108;
        TypeDescriptor.OID_TO_TYPECODE[32] = 0;
        TypeDescriptor.OID_TO_TYPECODE[33] = 0;
        TypeDescriptor.OID_TO_TYPECODE[34] = 112;
        TypeDescriptor.OID_TO_TYPECODE[35] = 113;
        TypeDescriptor.OID_TO_TYPECODE[36] = 115;
        TypeDescriptor.OID_TO_TYPECODE[37] = 114;
        TypeDescriptor.OID_TO_TYPECODE[38] = 0;
        TypeDescriptor.OID_TO_TYPECODE[39] = 0;
        TypeDescriptor.OID_TO_TYPECODE[40] = 0;
        TypeDescriptor.OID_TO_TYPECODE[41] = 0;
        TypeDescriptor.OID_TO_TYPECODE[42] = 0;
        TypeDescriptor.OID_TO_TYPECODE[43] = 0;
        TypeDescriptor.OID_TO_TYPECODE[44] = 0;
        TypeDescriptor.OID_TO_TYPECODE[45] = 0;
        TypeDescriptor.OID_TO_TYPECODE[46] = 0;
        TypeDescriptor.OID_TO_TYPECODE[47] = 0;
        TypeDescriptor.OID_TO_TYPECODE[48] = 0;
        TypeDescriptor.OID_TO_TYPECODE[49] = 0;
        TypeDescriptor.OID_TO_TYPECODE[50] = 0;
        TypeDescriptor.OID_TO_TYPECODE[51] = 0;
        TypeDescriptor.OID_TO_TYPECODE[52] = 0;
        TypeDescriptor.OID_TO_TYPECODE[53] = 0;
        TypeDescriptor.OID_TO_TYPECODE[54] = 0;
        TypeDescriptor.OID_TO_TYPECODE[55] = 0;
        TypeDescriptor.OID_TO_TYPECODE[56] = 0;
        TypeDescriptor.OID_TO_TYPECODE[57] = 0;
        TypeDescriptor.OID_TO_TYPECODE[58] = 58;
        TypeDescriptor.OID_TO_TYPECODE[59] = 185;
        TypeDescriptor.OID_TO_TYPECODE[60] = 186;
        TypeDescriptor.OID_TO_TYPECODE[61] = 187;
        TypeDescriptor.OID_TO_TYPECODE[62] = 188;
        TypeDescriptor.OID_TO_TYPECODE[63] = 189;
        TypeDescriptor.OID_TO_TYPECODE[64] = 190;
        TypeDescriptor.OID_TO_TYPECODE[65] = 232;
        TypeDescriptor.OID_TO_TYPECODE[66] = 0;
        TypeDescriptor.OID_TO_TYPECODE[67] = 0;
        TypeDescriptor.OID_TO_TYPECODE[68] = 100;
        TypeDescriptor.OID_TO_TYPECODE[69] = 101;
        TypeDescriptor.OID_TO_TYPECODE[70] = 104;
        typeCodeTypeNameMap = null;
        try {
            TypeDescriptor.getTypeCodeTypeNameMap();
        }
        catch (Exception ignoreexception) {
            // empty catch block
        }
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.TypeDescriptor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

