/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetUTF;
import oracle.sql.CharacterWalker;

class CharacterSetByte
extends CharacterSet
implements CharacterRepConstants {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:19_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetByte(int id) {
        super(id);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(id));
                OracleLog.recursiveTrace = false;
            }
            this.rep = 1;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLossyFrom(CharacterSet from) {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(from));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = from.rep != 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(source));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = source.rep <= 1024;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(byte[] bytes, int offset, int count, char replacement) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(replacement));
                OracleLog.recursiveTrace = false;
            }
            try {
                String __result__ = new String(bytes, offset, count, "ASCII");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                String string = __result__;
                return string;
            }
            catch (UnsupportedEncodingException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(Level.SEVERE, "Throwing SQLException: 183");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 183);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                String string = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return string;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            try {
                String __result__ = this.toString(bytes, offset, count, '?');
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                String string = __result__;
                return string;
            }
            catch (SQLException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(Level.SEVERE, "Throwing Error: CharacterSetByte.toString");
                    OracleLog.recursiveTrace = false;
                }
                throw new Error("CharacterSetByte.toString");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.toString(bytes, offset, count, '\u0000');
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(String s2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2));
                OracleLog.recursiveTrace = false;
            }
            int sLength = s2.length();
            char[] chars = new char[s2.length()];
            s2.getChars(0, sLength, chars, 0);
            byte[] __result__ = CharacterSetByte.charsToBytes(chars, (byte)0);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convertWithReplacement(String s2) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2));
                OracleLog.recursiveTrace = false;
            }
            int sLength = s2.length();
            char[] chars = new char[s2.length()];
            s2.getChars(0, sLength, chars, 0);
            try {
                byte[] __result__ = CharacterSetByte.charsToBytes(chars, (byte)63);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = __result__;
                return byArray;
            }
            catch (SQLException ex) {
                byte[] __result__ = new byte[]{};
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return byArray;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        try {
            byte[] result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(from) + ", " + OracleLog.argument(source) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            if (from.rep == 1) {
                result = CharacterSetByte.useOrCopy(source, offset, count);
            } else if (from.rep == 2) {
                char[] chars = CharacterSetUTF.UTFToJavaChar(source, offset, count);
                result = CharacterSetByte.charsToBytes(chars, (byte)0);
            } else {
                String s2 = from.toString(source, offset, count);
                char[] chars = s2.toCharArray();
                result = CharacterSetByte.charsToBytes(chars, (byte)0);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(walker));
                OracleLog.recursiveTrace = false;
            }
            int c2 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_30, "return: " + c2);
                OracleLog.recursiveTrace = false;
            }
            int n2 = c2;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            CharacterSetByte.need(buffer, 1);
            if (c2 < 256) {
                buffer.bytes[buffer.next] = (byte)c2;
                ++buffer.next;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] charsToBytes(char[] chars, byte replacement) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(replacement));
                OracleLog.recursiveTrace = false;
            }
            byte[] bytes = new byte[chars.length];
            for (int x = 0; x < chars.length; ++x) {
                if (chars[x] > '\u00ff') {
                    bytes[x] = replacement;
                    if (replacement != 0) continue;
                    CharacterSetByte.failCharacterConversion(CharacterSet.make(31));
                    continue;
                }
                bytes[x] = (byte)chars[x];
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "return: " + bytes);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetByte.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetByte"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

