/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSet2ByteFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter2ByteFixed";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static final short CHARLENGTH = 2;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:18_PDT_2008";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSet2ByteFixed(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSet2ByteFixed getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
            if (charConverter.getGroupId() == 6) {
                CharacterSet2ByteFixed __result__ = new CharacterSet2ByteFixed(oracleId, charConverter);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSet2ByteFixed characterSet2ByteFixed = __result__;
                return characterSet2ByteFixed;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            CharacterSet2ByteFixed characterSet2ByteFixed = null;
            return characterSet2ByteFixed;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(walker));
                OracleLog.recursiveTrace = false;
            }
            int c2 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (walker.bytes.length > walker.next) {
                c2 = c2 << 8 | walker.bytes[walker.next];
                ++walker.next;
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSet2ByteFixed.logger().log(Level.SEVERE, "Throwing SQLException: 182");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 182);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_30, "return: " + c2);
                OracleLog.recursiveTrace = false;
            }
            int n2 = c2;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            CharacterSet2ByteFixed.need(buffer, 2);
            buffer.bytes[buffer.next++] = (byte)(c2 >> 8 & 0xFF);
            buffer.bytes[buffer.next++] = (byte)(c2 & 0xFF);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSet2ByteFixed.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSet2ByteFixed"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

