/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    private String osuser;
    public Vector cOpts = new Vector(10, 10);

    public ConnStrategy(Properties up) {
        this.osuser = up.getProperty("oracle.jdbc.v$session.osuser");
        this.createSocketOptions(up);
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public void createSocketOptions(Properties up) {
        String propertyKey = null;
        String propertyValue = null;
        boolean tcpNoDelayParam = false;
        Enumeration<Object> e2 = up.keys();
        while (e2.hasMoreElements()) {
            propertyKey = (String)e2.nextElement();
            if (propertyKey.equalsIgnoreCase("TCP.NODELAY")) {
                tcpNoDelayParam = true;
                propertyValue = up.getProperty("TCP.NODELAY").toUpperCase();
                if (propertyValue.equals("NO")) {
                    this.socketOptions.put(new Integer(0), "NO");
                    continue;
                }
                this.socketOptions.put(new Integer(0), "YES");
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.READ_TIMEOUT");
                this.socketOptions.put(new Integer(3), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.CONNECT_TIMEOUT");
                this.socketOptions.put(new Integer(2), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                propertyValue = up.getProperty("oracle.net.ssl_server_dn_match");
                this.socketOptions.put(new Integer(4), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_location")) {
                propertyValue = up.getProperty("oracle.net.wallet_location");
                this.socketOptions.put(new Integer(5), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_password")) {
                propertyValue = up.getProperty("oracle.net.wallet_password");
                this.socketOptions.put(new Integer(16), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_version")) {
                propertyValue = up.getProperty("oracle.net.ssl_version");
                this.socketOptions.put(new Integer(6), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                propertyValue = up.getProperty("oracle.net.ssl_cipher_suites");
                this.socketOptions.put(new Integer(7), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStore");
                this.socketOptions.put(new Integer(8), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStoreType");
                this.socketOptions.put(new Integer(9), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStorePassword");
                this.socketOptions.put(new Integer(10), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStore");
                this.socketOptions.put(new Integer(11), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStoreType");
                this.socketOptions.put(new Integer(12), propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStorePassword");
                this.socketOptions.put(new Integer(13), propertyValue);
                continue;
            }
            if (!propertyKey.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) continue;
            propertyValue = up.getProperty("ssl.keyManagerFactory.algorithm");
            this.socketOptions.put(new Integer(14), propertyValue);
        }
        if (!tcpNoDelayParam && !this.reuseOpt) {
            this.socketOptions.put(new Integer(0), "YES");
        }
    }

    public void addSocketOptions(boolean keepAlive) {
        if (keepAlive) {
            this.socketOptions.put(new Integer(1), "YES");
        } else if (!this.reuseOpt) {
            this.socketOptions.put(new Integer(1), "NO");
        }
    }

    public void addOption(ConnOption cOption) {
        this.cOpts.addElement(cOption);
    }

    public boolean hasMoreOptions() {
        return this.nextOptToTry < this.cOpts.size();
    }

    public ConnOption execute() throws NetException {
        IOException causeException = null;
        while (this.nextOptToTry < this.cOpts.size()) {
            try {
                this.copt = (ConnOption)this.cOpts.elementAt(this.nextOptToTry);
                this.copt.connect(this.socketOptions);
                this.copt.sdu = this.sdu;
                this.copt.tdu = this.tdu;
                this.optFound = true;
                ++this.nextOptToTry;
                return this.copt;
            }
            catch (IOException err) {
                ++this.nextOptToTry;
                causeException = err;
            }
        }
        if (causeException == null) {
            throw new NetException(20);
        }
        throw (NetException)new NetException(20).initCause(causeException);
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public void clearElements() {
        this.cOpts.removeAllElements();
    }

    public ConnOption getOption() {
        return this.copt;
    }
}

