/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;

public class SessionAtts
implements SQLnetDef {
    private int sdu;
    private int tdu;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;
    int negotiatedOptions;

    public SessionAtts(int sdu, int tdu) {
        this.sdu = sdu;
        this.tdu = tdu;
    }

    public void setSDU(int sdu) {
        this.sdu = sdu <= 0 ? 2048 : (sdu > Short.MAX_VALUE ? Short.MAX_VALUE : (sdu < 512 ? 512 : sdu));
    }

    public int getSDU() {
        return this.sdu;
    }

    public void setTDU(int tdu) {
        this.tdu = tdu <= 0 ? Short.MAX_VALUE : (tdu > Short.MAX_VALUE ? Short.MAX_VALUE : (tdu < 255 ? 255 : tdu));
    }

    public int getTDU() {
        return this.tdu;
    }

    public NTAdapter getNTAdapter() {
        return this.nt;
    }

    public void print() {
        System.out.println("Session Attributes: ");
        System.out.println("sdu            : " + this.sdu);
        System.out.println("tdu            : " + this.tdu);
        System.out.println("nt             : " + this.nt);
        System.out.println("ntInputStream  : " + this.ntInputStream);
        System.out.println("ntOutputStream : " + this.ntOutputStream);
        System.out.println("nsInputStream  : " + this.nsInputStream);
        System.out.println("nsOutputStream : " + this.nsOutputStream);
        System.out.println("profile        : " + this.profile);
        System.out.println("cOption        : " + this.cOption);
        System.out.println("onBreakReset   : " + this.onBreakReset);
        System.out.println("dataEOF        : " + this.dataEOF);
        System.out.println("negotiatedOptions: 0x" + Integer.toHexString(this.negotiatedOptions));
        System.out.println("connected      : " + this.connected);
    }

    public void turnEncryptionOn(NetInputStream anoIn, NetOutputStream anoOut) throws NetException {
        if (anoIn == null || anoOut == null) {
            throw new NetException(300);
        }
        this.nsInputStream = anoIn;
        this.nsOutputStream = anoOut;
    }

    public int getANOFlags() {
        int flags = 1;
        if (this.ano != null) {
            flags = this.ano.getNAFlags();
        }
        return flags;
    }

    public OutputStream getOutputStream() {
        return this.nsOutputStream;
    }

    public InputStream getInputStream() {
        return this.nsInputStream;
    }

    public void setNegotiatedOptions(int value) {
        this.negotiatedOptions = value;
    }
}

