/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ClientProfile
extends Properties {
    private static final String profile_name = "ora-net-profile";
    private static final String shared_profile_name = "ora-shared-profile";

    public ClientProfile() {
    }

    public ClientProfile(Properties up) {
        if (up.containsKey("oracle.net.profile")) {
            this.put("oracle.net.profile", up.getProperty("oracle.net.profile"));
        }
        this.put("oracle.net.authentication_services", up.getProperty("oracle.net.authentication_services", "()"));
        this.put("oracle.net.encryption_client", up.getProperty("oracle.net.encryption_client", "ACCEPTED"));
        this.put("oracle.net.encryption_types_client", up.getProperty("oracle.net.encryption_types_client", "()"));
        this.put("oracle.net.crypto_checksum_client", up.getProperty("oracle.net.crypto_checksum_client", "ACCEPTED"));
        this.put("oracle.net.crypto_checksum_types_client", up.getProperty("oracle.net.crypto_checksum_types_client", "()"));
        this.put("oracle.net.crypto_seed", up.getProperty("oracle.net.crypto_seed", ""));
        this.put("oracle.net.kerberos5_mutual_authentication", up.getProperty("oracle.net.kerberos5_mutual_authentication", "false"));
        if (up.getProperty("oracle.net.kerberos5_cc_name") != null) {
            this.put("oracle.net.kerberos5_cc_name", up.getProperty("oracle.net.kerberos5_cc_name"));
        }
    }

    public String[] getAuthenticationServices() {
        return this.getServices((String)this.get("oracle.net.authentication_services"));
    }

    public String[] getEncryptionServices() {
        return this.getServices((String)this.get("oracle.net.encryption_types_client"));
    }

    public String[] getDataIntegrityServices() {
        return this.getServices((String)this.get("oracle.net.crypto_checksum_types_client"));
    }

    public String getEncryptionLevel() {
        return (String)this.get("oracle.net.encryption_client");
    }

    public int getEncryptionLevelNum() {
        return this.translateAnoValue(this.getEncryptionLevel());
    }

    public String getDataIntegrityLevel() {
        return (String)this.get("oracle.net.crypto_checksum_client");
    }

    public int getDataIntegrityLevelNum() {
        return this.translateAnoValue(this.getDataIntegrityLevel());
    }

    public void print() {
        System.out.println(" ----------------------------------------");
        System.out.println(" Displaying the content of ClientProfile ");
        System.out.println(" List:");
        this.list(System.out);
        Enumeration<?> en = this.propertyNames();
        System.out.println("Enumeration has elements ? " + en.hasMoreElements());
        int i2 = 0;
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            System.out.println("Key " + i2 + " = " + key);
            System.out.println("Value = " + this.getProperty(key));
            ++i2;
        }
        System.out.println(" ----------------------------------------");
    }

    private String[] getServices(String services) {
        String mainString = this.removeParenths(services);
        StringTokenizer st = new StringTokenizer(mainString, ",");
        int tokens = st.countTokens();
        String[] items = new String[tokens];
        for (int i2 = 0; i2 < tokens; ++i2) {
            items[i2] = st.nextToken().trim();
        }
        return items;
    }

    private String removeParenths(String str) {
        int beginParenth = str.indexOf(40);
        int beginOffset = beginParenth == -1 ? 0 : beginParenth + 1;
        int endParenth = str.lastIndexOf(41);
        int endOffset = endParenth == -1 ? str.length() : endParenth;
        String result = str.substring(beginOffset, endOffset);
        return result.trim();
    }

    private int translateAnoValue(String level) {
        int levelNum = 0;
        if (level.equalsIgnoreCase("ACCEPTED")) {
            levelNum = 0;
        } else if (level.equalsIgnoreCase("REQUESTED")) {
            levelNum = 2;
        } else if (level.equalsIgnoreCase("REQUIRED")) {
            levelNum = 3;
        } else if (level.equalsIgnoreCase("REJECTED")) {
            levelNum = 1;
        }
        return levelNum;
    }
}

