/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid;
    private String xaOpenString;
    private static boolean libraryLoaded = false;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa11";
    private static final char atSignChar = '@';
    private static int rmidSeed = 0;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString;
    private String oldTnsEntry;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:37_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXADataSource() throws SQLException {
        block4: {
            this.rmid = -1;
            this.xaOpenString = null;
            this.driverCharSetIdString = null;
            this.oldTnsEntry = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.isOracleDataSource = true;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAConnection getXAConnection() throws SQLException {
        XAConnection xAConnection;
        block9: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Properties prop = new Properties(this.connectionProperties);
                if (this.user == null || this.password == null) {
                    if (this.connectionProperties == null || this.connectionProperties.get("user") == null || this.connectionProperties.get("password") == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXADataSource.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    }
                } else {
                    prop.setProperty("user", this.user);
                    prop.setProperty("password", this.password);
                }
                XAConnection __result__ = this.getXAConnection(prop);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                xAConnection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block9;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return xAConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAConnection getXAConnection(String userName, String passwd) throws SQLException {
        XAConnection xAConnection;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(userName) + ", " + OracleLog.argument(passwd));
                    OracleLog.recursiveTrace = false;
                }
                Properties prop = new Properties(this.connectionProperties);
                if (userName != null && passwd != null) {
                    prop.setProperty("user", userName);
                    prop.setProperty("password", passwd);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXADataSource.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                }
                XAConnection __result__ = this.getXAConnection(prop);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                xAConnection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return xAConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAConnection getXAConnection(Properties prop) throws SQLException {
        XAConnection xAConnection;
        block9: {
            block7: {
                XAConnection xAConnection2;
                block8: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXADataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(prop));
                            OracleLog.recursiveTrace = false;
                        }
                        if (!this.connCachingEnabled) break block7;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXADataSource.logger().log(Level.SEVERE, "Throwing SQLException: 163");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 163);
                        xAConnection2 = null;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return xAConnection2;
            }
            XAConnection __result__ = (XAConnection)this.getPooledConnection(prop);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            xAConnection = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return xAConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection(String userName, String passwd) throws SQLException {
        PooledConnection pooledConnection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(userName) + ", " + OracleLog.argument(passwd));
                    OracleLog.recursiveTrace = false;
                }
                Properties prop = new Properties();
                prop.setProperty("user", userName);
                prop.setProperty("password", passwd);
                PooledConnection __result__ = this.getPooledConnection(prop);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                pooledConnection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return pooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public PooledConnection getPooledConnection(Properties info) throws SQLException {
        OracleXAConnection oracleXAConnection;
        block65: {
            String passwd;
            String userName;
            block63: {
                T4CXAConnection t4CXAConnection;
                block64: {
                    String url;
                    block61: {
                        OracleXAHeteroConnection oracleXAHeteroConnection;
                        block62: {
                            int status;
                            Class<?> clazz;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleXADataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(info));
                                OracleLog.recursiveTrace = false;
                            }
                            url = this.getURL();
                            userName = info.getProperty("user");
                            passwd = info.getProperty("password");
                            String rmName = null;
                            String xaclsstr = null;
                            String localXaOpenString = null;
                            int localRmid = 0;
                            if (!this.useNativeXA || !url.startsWith("jdbc:oracle:oci8") && !url.startsWith("jdbc:oracle:oci")) break block61;
                            long[] ociHandles = new long[]{0L, 0L};
                            String tnsentry = null;
                            String propNlsLangBackdoor = null;
                            OracleXADataSource oracleXADataSource = this;
                            synchronized (oracleXADataSource) {
                                tnsentry = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(url);
                                if (tnsentry != null && tnsentry.length() == 0 || tnsentry.startsWith("(DESCRIPTION")) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        OracleXADataSource.logger().log(Level.SEVERE, "Throwing SQLException: 207");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 207);
                                }
                                if (!libraryLoaded) {
                                    clazz = this.getClass();
                                    synchronized (clazz) {
                                        if (!libraryLoaded) {
                                            try {
                                                System.loadLibrary(dllName);
                                                libraryLoaded = true;
                                            }
                                            catch (Error exc) {
                                                if (TRACE && !OracleLog.recursiveTrace) {
                                                    OracleLog.recursiveTrace = true;
                                                    OracleXADataSource.logger().log(OracleLog.TRACE_20, "Debug: ------ JNI JDBC XA lib not loaded properly. ------");
                                                    OracleLog.recursiveTrace = false;
                                                }
                                                libraryLoaded = false;
                                                throw exc;
                                            }
                                        }
                                    }
                                }
                                if (this.connectionProperties != null) {
                                    propNlsLangBackdoor = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                                }
                            }
                            if (propNlsLangBackdoor != null && propNlsLangBackdoor.equalsIgnoreCase("true")) {
                                short driverCharSetId = T2CConnection.getDriverCharSetIdFromNLS_LANG(null);
                                this.driverCharSetIdString = Integer.toString(driverCharSetId);
                            } else if (!tnsentry.equals(this.oldTnsEntry)) {
                                short driverCharSetId = T2CConnection.getClientCharSetId();
                                this.driverCharSetIdString = Integer.toString(driverCharSetId);
                                this.oldTnsEntry = tnsentry;
                            }
                            OracleXADataSource driverCharSetId = this;
                            synchronized (driverCharSetId) {
                                rmName = this.databaseName + dbSuffix + rmidSeed;
                                this.rmid = localRmid = rmidSeed;
                                clazz = this.getClass();
                                synchronized (clazz) {
                                    rmidSeed = (rmidSeed + 1) % 65536;
                                }
                                int trcLevel = 0;
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    trcLevel = 7;
                                    OracleXADataSource.logger().log(OracleLog.TRACE_20, "Debug: getXAConnection(user, pwd): trcLevel = " + trcLevel);
                                    OracleLog.recursiveTrace = false;
                                }
                                String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                                this.xaOpenString = localXaOpenString = this.generateXAOpenString(rmName, tnsentry, userName, passwd, 60, 2000, true, true, ".", trcLevel, false, l_xaLoose != null && l_xaLoose.equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                                xaclsstr = this.generateXACloseString(rmName, false);
                            }
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleXADataSource.logger().log(OracleLog.TRACE_20, "Debug: getPooledConnection(user, pwd): before t2cDoXaOpen()");
                                OracleLog.recursiveTrace = false;
                            }
                            if ((status = this.t2cDoXaOpen(localXaOpenString, localRmid, 0, 0)) != 0) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleXADataSource.logger().log(Level.SEVERE, "Throwing SQLException: " + -1 * status);
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), -1 * status);
                            }
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleXADataSource.logger().log(OracleLog.TRACE_20, "Debug: getPooledConnection(user, pwd): before t2cConvertOciHandles()");
                                OracleLog.recursiveTrace = false;
                            }
                            if ((status = this.t2cConvertOciHandles(rmName, ociHandles)) != 0) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleXADataSource.logger().log(Level.SEVERE, "Throwing SQLException: " + -1 * status);
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), -1 * status);
                            }
                            info.put("OCISvcCtxHandle", String.valueOf(ociHandles[0]));
                            info.put("OCIEnvHandle", String.valueOf(ociHandles[1]));
                            info.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                            if (this.loginTimeout != 0) {
                                info.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                            }
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleXADataSource.logger().log(OracleLog.TRACE_20, "Debug: getPooledConnection(user, pwd): before getConnection(url, info)");
                                OracleLog.recursiveTrace = false;
                            }
                            Connection conn = this.driver.connect(this.getURL(), info);
                            OracleXAHeteroConnection xaconn = new OracleXAHeteroConnection(conn);
                            xaconn.setUserName(userName, passwd);
                            xaconn.setRmid(localRmid);
                            xaconn.setXaCloseString(xaclsstr);
                            xaconn.registerCloseCallback(new OracleXAHeteroCloseCallback(), xaconn);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleXADataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + xaconn);
                                OracleLog.recursiveTrace = false;
                            }
                            oracleXAHeteroConnection = xaconn;
                            if (!TRACE || OracleLog.recursiveTrace) break block62;
                            OracleLog.recursiveTrace = true;
                            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        return oracleXAHeteroConnection;
                    }
                    if (!this.thinUseNativeXA || !url.startsWith("jdbc:oracle:thin")) break block63;
                    Properties prop = new Properties();
                    OracleXADataSource tnsentry = this;
                    synchronized (tnsentry) {
                        Class<?> propNlsLangBackdoor = this.getClass();
                        synchronized (propNlsLangBackdoor) {
                            rmidSeed = (rmidSeed + 1) % 65536;
                        }
                        this.rmid = rmidSeed;
                        if (this.connectionProperties == null) {
                            this.connectionProperties = new Properties();
                        }
                        this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                        if (userName != null) {
                            prop.setProperty("user", userName);
                        }
                        if (passwd != null) {
                            prop.setProperty("password", passwd);
                        }
                        prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                        prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                        prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                        prop.setProperty("LoginTimeout", "" + this.loginTimeout);
                    }
                    T4CXAConnection conn = new T4CXAConnection(super.getPhysicalConnection(prop));
                    conn.setUserName(userName, passwd);
                    String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                    boolean bl = conn.isXAResourceTransLoose = l_xaLoose != null && (l_xaLoose.equals("true") || l_xaLoose.equalsIgnoreCase("true"));
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXADataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + conn);
                        OracleLog.recursiveTrace = false;
                    }
                    t4CXAConnection = conn;
                    if (!TRACE || OracleLog.recursiveTrace) break block64;
                    OracleLog.recursiveTrace = true;
                    OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return t4CXAConnection;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_20, "Debug: OracleXADataSource.getPooledConnection(user, pwd) return: non-oci");
                OracleLog.recursiveTrace = false;
            }
            Properties prop = new Properties();
            OracleXADataSource conn = this;
            synchronized (conn) {
                if (userName != null) {
                    prop.setProperty("user", userName);
                }
                if (passwd != null) {
                    prop.setProperty("password", passwd);
                }
                prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                prop.setProperty("LoginTimeout", "" + this.loginTimeout);
            }
            OracleXAConnection l_xaconn = new OracleXAConnection(super.getPhysicalConnection(prop));
            l_xaconn.setUserName(userName, passwd);
            String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            boolean bl = l_xaconn.isXAResourceTransLoose = l_xaLoose != null && (l_xaLoose.equals("true") || l_xaLoose.equalsIgnoreCase("true"));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + l_xaconn);
                OracleLog.recursiveTrace = false;
            }
            oracleXAConnection = l_xaconn;
            if (!TRACE || OracleLog.recursiveTrace) break block65;
            OracleLog.recursiveTrace = true;
            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleXAConnection;
        {
            catch (XAException xae) {
                PooledConnection pooledConnection;
                block66: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXADataSource.logger().log(OracleLog.TRACE_20, "Debug: getPooledConnection(user, pwd): XAException at end " + xae);
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXADataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                            OracleLog.recursiveTrace = false;
                        }
                        pooledConnection = null;
                        if (!TRACE || OracleLog.recursiveTrace) break block66;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleXADataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return pooledConnection;
            }
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setRmid(int rmid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rmid));
                OracleLog.recursiveTrace = false;
            }
            this.rmid = rmid;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int getRmid() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(this.rmid));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "return: " + this.rmid);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.rmid;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setXaOpenString(String xaOpenString) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xaOpenString));
                OracleLog.recursiveTrace = false;
            }
            this.xaOpenString = xaOpenString;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String getXaOpenString() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "return: " + this.xaOpenString);
                OracleLog.recursiveTrace = false;
            }
            String string = this.xaOpenString;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateXAOpenString(String rmName, String connectString, String userName, String passwd, int lockTimeout, int sessionTimeout, boolean threadFlag, boolean objectFlag, String logDir, int traceLevel, boolean cacheFlag, boolean isLoose, String dbCsId, String dbNCharCsId) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rmName) + ", " + OracleLog.argument(connectString) + ", " + OracleLog.argument(userName) + ", " + OracleLog.argument(passwd) + ", " + OracleLog.argument(lockTimeout) + ", " + OracleLog.argument(sessionTimeout) + ", " + OracleLog.argument(threadFlag) + ", " + OracleLog.argument(objectFlag) + ", " + OracleLog.argument(logDir) + ", " + OracleLog.argument(traceLevel) + ", " + OracleLog.argument(cacheFlag) + ", " + OracleLog.argument(isLoose) + ", " + OracleLog.argument(dbCsId) + ", " + OracleLog.argument(dbNCharCsId));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = new String("ORACLE_XA+DB=" + rmName + "+ACC=P/" + userName + "/" + passwd + "+SESTM=" + sessionTimeout + "+SESWT=" + lockTimeout + "+LOGDIR=" + logDir + "+SQLNET=" + connectString + (threadFlag ? "+THREADS=true" : "") + (objectFlag ? "+OBJECTS=true" : "") + "+DBGFL=0x" + traceLevel + (cacheFlag ? "+CONNCACHE=t" : "+CONNCACHE=f") + (isLoose ? "+Loose_Coupling=t" : "") + "+CharSet=" + dbCsId + "+NCharSet=" + dbNCharCsId);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateXACloseString(String rmName, boolean cacheFlag) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rmName) + ", " + OracleLog.argument(cacheFlag));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = new String("ORACLE_XA+DB=" + rmName + (cacheFlag ? "+CONNCACHE=t" : "+CONNCACHE=f"));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTNSEntryFromUrl(String url) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(url));
                OracleLog.recursiveTrace = false;
            }
            int at_sign = url.indexOf(64);
            String __result__ = url.substring(at_sign + 1);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXADataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXADataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

