/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public class OracleMultiPhaseArgs {
    int action;
    int nsites;
    Vector dbLinks;
    Vector xids;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:37_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs() {
        block4: {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs(int _action, int _nsites, Vector _xids, Vector _dbLinks) {
        block10: {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(_action) + ", " + OracleLog.argument(_nsites) + ", " + OracleLog.argument(_xids) + ", " + OracleLog.argument(_dbLinks));
                    OracleLog.recursiveTrace = false;
                }
                if (_nsites <= 1) {
                    this.action = 0;
                    this.nsites = 0;
                    this.dbLinks = null;
                    this.xids = null;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug: OracleMultiPhaseArgs(_, _nsites, _, _): _nsites <= 1");
                        OracleLog.recursiveTrace = false;
                    }
                } else if (_xids.isEmpty() || _dbLinks.isEmpty() || _dbLinks.size() != _nsites || _xids.size() != 3 * _nsites) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug: OracleMultiPhaseArgs(_, _, _, _): invalid parameters");
                        OracleLog.recursiveTrace = false;
                    }
                } else {
                    this.action = _action;
                    this.nsites = _nsites;
                    this.xids = _xids;
                    this.dbLinks = _dbLinks;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs(byte[] inBytes) {
        block9: {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(inBytes));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug: OracleMultiPhaseArgs(inBytes.length = " + inBytes.length + ")");
                    OracleLog.recursiveTrace = false;
                }
                ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(inBytes);
                DataInputStream dataIS = new DataInputStream(byteArrayIS);
                this.xids = new Vector();
                this.dbLinks = new Vector();
                try {
                    this.action = dataIS.readInt();
                    this.nsites = dataIS.readInt();
                    int fmtid = dataIS.readInt();
                    int gtridLen = dataIS.readInt();
                    byte[] gtrid = new byte[gtridLen];
                    int gtridRead = dataIS.read(gtrid, 0, gtridLen);
                    for (int i2 = 0; i2 < this.nsites; ++i2) {
                        int bqualLen = dataIS.readInt();
                        byte[] bqual = new byte[bqualLen];
                        int bqualRead = dataIS.read(bqual, 0, bqualLen);
                        this.xids.addElement(new Integer(fmtid));
                        this.xids.addElement(gtrid);
                        this.xids.addElement(bqual);
                        String dblink = dataIS.readUTF();
                        this.dbLinks.addElement(dblink);
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    this.printMPArgs();
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block9;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        byte[] byArray;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                byte[] __result__ = this.toByteArrayOS().toByteArray();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byArray = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream toByteArrayOS() {
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            byte[] gtridCommon = null;
            int fmtidCommon = 0;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
                DataOutputStream dataOS = new DataOutputStream(byteArrayOS);
                try {
                    dataOS.writeInt(this.action);
                    dataOS.writeInt(this.nsites);
                    for (int i2 = 0; i2 < this.nsites; ++i2) {
                        String dblink = (String)this.dbLinks.elementAt(i2);
                        int fmtid = (Integer)this.xids.elementAt(i2 * 3);
                        byte[] gtrid = (byte[])this.xids.elementAt(i2 * 3 + 1);
                        byte[] bqual = (byte[])this.xids.elementAt(i2 * 3 + 2);
                        if (i2 == 0) {
                            fmtidCommon = fmtid;
                            gtridCommon = gtrid;
                            dataOS.writeInt(fmtid);
                            dataOS.writeInt(gtrid.length);
                            dataOS.write(gtrid, 0, gtrid.length);
                        }
                        dataOS.writeInt(bqual.length);
                        dataOS.write(bqual, 0, bqual.length);
                        dataOS.writeUTF(dblink);
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    this.printMPArgs();
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + byteArrayOS);
                    OracleLog.recursiveTrace = false;
                }
                byteArrayOutputStream = byteArrayOS;
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAction() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.action);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.action;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getnsite() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.nsites);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.nsites;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getdbLinks() {
        Vector vector;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.dbLinks);
                    OracleLog.recursiveTrace = false;
                }
                vector = this.dbLinks;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getXids() {
        Vector vector;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.xids);
                    OracleLog.recursiveTrace = false;
                }
                vector = this.xids;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleMultiPhaseArgs.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMPArgs() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug: -------printMPArgs entry-------");
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug:   action = " + this.action);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug:   nsites = " + this.nsites);
                OracleLog.recursiveTrace = false;
            }
            for (int i2 = 0; i2 < this.nsites; ++i2) {
                String dblink = (String)this.dbLinks.elementAt(i2);
                int fmtid = (Integer)this.xids.elementAt(i2 * 3);
                byte[] gtrid = (byte[])this.xids.elementAt(i2 * 3 + 1);
                byte[] bqual = (byte[])this.xids.elementAt(i2 * 3 + 2);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug:   fmtid  [" + i2 + "] = " + fmtid);
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug:   gtrid  [" + i2 + "] = ");
                    OracleLog.recursiveTrace = false;
                }
                this.printByteArray(gtrid);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug:   bqual  [" + i2 + "] = ");
                    OracleLog.recursiveTrace = false;
                }
                this.printByteArray(bqual);
                if (!TRACE || OracleLog.recursiveTrace) continue;
                OracleLog.recursiveTrace = true;
                OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug:   dblink [" + i2 + "] = " + dblink);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, "Debug: -------printMPArgs return-------");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private void printByteArray(byte[] bArray) {
        StringBuffer _buf = new StringBuffer();
        for (int i2 = 0; i2 < bArray.length; ++i2) {
            _buf.append(bArray[i2] + " ");
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleMultiPhaseArgs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

