/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;

public class OracleCachedRowSetReader
implements RowSetReader,
Serializable {
    static final long serialVersionUID = -3565405169674271176L;
    static final transient int SETUNICODESTREAM_INTLENGTH = 1;
    static final transient int SETBINARYSTREAM_INTLENGTH = 2;
    static final transient int SETASCIISTREAM_INTLENGTH = 3;
    static final transient int SETCHARACTERSTREAM_INTLENGTH = 4;
    static final transient int SETBINARYSTREAM = 5;
    static final transient int SETBINARYSTREAM_LONGLENGTH = 6;
    static final transient int SETASCIISTREAM = 7;
    static final transient int SETASCIISTREAM_LONGLENGTH = 8;
    static final transient int SETCHARACTERSTREAM = 9;
    static final transient int SETCHARACTERSTREAM_LONGLENGTH = 10;
    static final transient int SETNCHARACTERSTREAM = 11;
    static final transient int SETNCHARACTERSTREAM_LONGLENGTH = 12;
    static final transient int SETBLOB_STREAM = 13;
    static final transient int SETBLOB_STREAM_LONG = 14;
    static final transient int SETCLOB_READER = 15;
    static final transient int SETCLOB_READER_LONG = 16;
    static final transient int SETNCLOB_READER = 17;
    static final transient int SETNCLOB_READER_LONG = 18;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:39_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleCachedRowSetReader() {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleCachedRowSetReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(RowSetInternal rowsetInternal) throws SQLException {
        try {
            Connection con;
            block25: {
                Connection rowsetConnection;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowsetInternal));
                    OracleLog.recursiveTrace = false;
                }
                con = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.getConnection(RowSetInternal),con=" + con);
                    OracleLog.recursiveTrace = false;
                }
                if ((rowsetConnection = rowsetInternal.getConnection()) != null && !rowsetConnection.isClosed()) {
                    con = rowsetConnection;
                } else if (((RowSet)((Object)rowsetInternal)).getDataSourceName() != null) {
                    try {
                        InitialContext initialcontext = null;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.getConnection(), initialcontext=" + initialcontext);
                            OracleLog.recursiveTrace = false;
                        }
                        try {
                            Properties props = System.getProperties();
                            initialcontext = new InitialContext(props);
                        }
                        catch (SecurityException ea) {
                            // empty catch block
                        }
                        if (initialcontext == null) {
                            initialcontext = new InitialContext();
                        }
                        DataSource datasource = (DataSource)initialcontext.lookup(((RowSet)((Object)rowsetInternal)).getDataSourceName());
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.getConnection(),datasource=" + datasource);
                            OracleLog.recursiveTrace = false;
                        }
                        String userName = ((RowSet)((Object)rowsetInternal)).getUsername();
                        String password = ((RowSet)((Object)rowsetInternal)).getPassword();
                        if (userName == null && password == null) {
                            con = datasource.getConnection();
                            break block25;
                        }
                        con = datasource.getConnection(userName, password);
                    }
                    catch (NamingException ea) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 300" + ea.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 300, ea.getMessage());
                    }
                } else if (((RowSet)((Object)rowsetInternal)).getUrl() != null) {
                    if (!driverManagerInitialized) {
                        DriverManager.registerDriver(new OracleDriver());
                        driverManagerInitialized = true;
                    }
                    String url = ((RowSet)((Object)rowsetInternal)).getUrl();
                    String userName = ((RowSet)((Object)rowsetInternal)).getUsername();
                    String password = ((RowSet)((Object)rowsetInternal)).getPassword();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.getConnection(): url = " + url + ", userName = " + userName + ", password = " + password);
                        OracleLog.recursiveTrace = false;
                    }
                    if (url.equals("") || userName.equals("") || password.equals("")) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 301");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 301);
                    }
                    con = DriverManager.getConnection(url, userName, password);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetReader.logger().log(OracleLog.TRACE_16, "return: " + con);
                OracleLog.recursiveTrace = false;
            }
            Connection connection = con;
            return connection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParams(Object[] paramObject, PreparedStatement preparedStatement) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramObject) + ", " + OracleLog.argument(preparedStatement));
                OracleLog.recursiveTrace = false;
            }
            for (int j2 = 0; j2 < paramObject.length; ++j2) {
                int i2 = 0;
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.setParams(Object[], PreparedStatement), inside for-loop, i=" + i2);
                        OracleLog.recursiveTrace = false;
                    }
                    i2 = Array.getLength(paramObject[j2]);
                }
                catch (IllegalArgumentException ex) {
                    preparedStatement.setObject(j2 + 1, paramObject[j2]);
                    continue;
                }
                Object[] tmpParmObj = (Object[])paramObject[j2];
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.setParams(Object[], PreparedStatement), inside for-loop, Object tmpParmObj=" + tmpParmObj);
                    OracleLog.recursiveTrace = false;
                }
                if (i2 == 2) {
                    if (tmpParmObj[0] == null) {
                        preparedStatement.setNull(j2 + 1, (Integer)tmpParmObj[1]);
                        continue;
                    }
                    if (tmpParmObj[0] instanceof Date || tmpParmObj[0] instanceof Time || tmpParmObj[0] instanceof Timestamp) {
                        if (tmpParmObj[1] instanceof Calendar) {
                            preparedStatement.setDate(j2 + 1, (Date)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                            continue;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 323");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
                        continue;
                    }
                    if (tmpParmObj[0] instanceof Reader) {
                        switch ((Integer)tmpParmObj[1]) {
                            case 9: {
                                preparedStatement.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0]);
                                break;
                            }
                            case 11: {
                                preparedStatement.setNCharacterStream(j2 + 1, (Reader)tmpParmObj[0]);
                                break;
                            }
                            case 15: {
                                preparedStatement.setClob(j2 + 1, (Reader)tmpParmObj[0]);
                                break;
                            }
                            case 17: {
                                preparedStatement.setNClob(j2 + 1, (Reader)tmpParmObj[0]);
                                break;
                            }
                            default: {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 323");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
                                break;
                            }
                        }
                        continue;
                    }
                    if (tmpParmObj[0] instanceof InputStream) {
                        switch ((Integer)tmpParmObj[1]) {
                            case 7: {
                                preparedStatement.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0]);
                                break;
                            }
                            case 5: {
                                preparedStatement.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0]);
                                break;
                            }
                            case 13: {
                                preparedStatement.setBlob(j2 + 1, (InputStream)tmpParmObj[0]);
                                break;
                            }
                            default: {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 323");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
                                break;
                            }
                        }
                        continue;
                    }
                    if (!(tmpParmObj[1] instanceof Integer)) continue;
                    preparedStatement.setObject(j2 + 1, tmpParmObj[0], (Integer)tmpParmObj[1]);
                    continue;
                }
                if (i2 != 3) continue;
                if (tmpParmObj[0] == null) {
                    preparedStatement.setNull(j2 + 1, (Integer)tmpParmObj[1], (String)tmpParmObj[2]);
                    continue;
                }
                if (tmpParmObj[0] instanceof Reader) {
                    switch ((Integer)tmpParmObj[2]) {
                        case 4: {
                            preparedStatement.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            break;
                        }
                        case 10: {
                            preparedStatement.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                            break;
                        }
                        case 12: {
                            preparedStatement.setNCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                            break;
                        }
                        case 16: {
                            preparedStatement.setClob(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                            break;
                        }
                        case 18: {
                            preparedStatement.setNClob(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                            break;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 323");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
                            break;
                        }
                    }
                    continue;
                }
                if (tmpParmObj[0] instanceof InputStream) {
                    switch ((Integer)tmpParmObj[2]) {
                        case 1: {
                            preparedStatement.setUnicodeStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            break;
                        }
                        case 2: {
                            preparedStatement.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            break;
                        }
                        case 3: {
                            preparedStatement.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            break;
                        }
                        case 6: {
                            preparedStatement.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            break;
                        }
                        case 8: {
                            preparedStatement.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            break;
                        }
                        case 14: {
                            preparedStatement.setBlob(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            break;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 323");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
                            break;
                        }
                    }
                    continue;
                }
                if (tmpParmObj[1] instanceof Integer && tmpParmObj[2] instanceof Integer) {
                    preparedStatement.setObject(j2 + 1, tmpParmObj[0], (Integer)tmpParmObj[1], (int)((Integer)tmpParmObj[2]));
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 323");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void readData(RowSetInternal rowsetInternal) throws SQLException {
        block16: {
            try {
                Connection connection;
                OracleCachedRowSet rowset;
                block15: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rowsetInternal));
                        OracleLog.recursiveTrace = false;
                    }
                    rowset = (OracleCachedRowSet)rowsetInternal;
                    connection = this.getConnection(rowsetInternal);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.readData(), connection=" + connection);
                        OracleLog.recursiveTrace = false;
                    }
                    if (connection == null || rowset.getCommand() == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, "Throwing SQLException: 342");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 342);
                    }
                    try {
                        connection.setTransactionIsolation(rowset.getTransactionIsolation());
                    }
                    catch (Exception ex) {
                        if (!TRACE || OracleLog.recursiveTrace) break block15;
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.readData(), setTransactionIsolation() throws exception: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                }
                PreparedStatement preparedStatement = connection.prepareStatement(rowset.getCommand());
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetReader.readData(), preparedStatement=" + preparedStatement);
                    OracleLog.recursiveTrace = false;
                }
                this.setParams(rowsetInternal.getParams(), preparedStatement);
                try {
                    preparedStatement.setMaxRows(rowset.getMaxRows());
                    preparedStatement.setMaxFieldSize(rowset.getMaxFieldSize());
                    preparedStatement.setEscapeProcessing(rowset.getEscapeProcessing());
                    preparedStatement.setQueryTimeout(rowset.getQueryTimeout());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ResultSet resultset = preparedStatement.executeQuery();
                rowset.populate(resultset);
                resultset.close();
                preparedStatement.close();
                try {
                    connection.commit();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                if (!rowset.isConnectionStayingOpen()) {
                    connection.close();
                }
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleCachedRowSetReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetReader.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSetReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

