/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;

class OracleFailoverEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:36_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleFailoverEventHandlerThread() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Subscriber sub = null;
            String eventStr = "(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")";
            while (this.cacheManager.failoverEnabledCacheExists()) {
                block16: {
                    block15: {
                        try {
                            sub = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() {
                                    try {
                                        return new Subscriber("(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")", "", 30000L);
                                    }
                                    catch (SubscriptionException e2) {
                                        if (TRACE && !OracleLog.recursiveTrace) {
                                            OracleLog.recursiveTrace = true;
                                            OracleFailoverEventHandlerThread.logger().log(Level.WARNING, "Warning:  exception " + e2.getMessage());
                                            OracleLog.recursiveTrace = false;
                                        }
                                        return null;
                                    }
                                }
                            });
                        }
                        catch (PrivilegedActionException e2) {
                            if (!TRACE || OracleLog.recursiveTrace) break block15;
                            OracleLog.recursiveTrace = true;
                            OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_10, "Event: OracleFailoverEventHandlerThread.run()- PrivilegedActionException: " + e2.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                    if (sub != null) {
                        try {
                            while (this.cacheManager.failoverEnabledCacheExists()) {
                                this.event = sub.receive(true);
                                if (this.event == null) continue;
                                this.handleEvent(this.event);
                            }
                        }
                        catch (ONSException e3) {
                            sub.close();
                            if (!TRACE || OracleLog.recursiveTrace) break block16;
                            OracleLog.recursiveTrace = true;
                            OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_10, "Event: OracleFailoverEventHandlerThread.run() - ONS Exception :" + e3.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ea) {
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_20, "Debug: OracleFailoverEventHandlerThread.run()- Got an InterruptedException:" + ea.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEvent(Notification event) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(event));
                OracleLog.recursiveTrace = false;
            }
            try {
                int eventType = 0;
                if (event.type().equalsIgnoreCase("database/event/service")) {
                    eventType = 256;
                } else if (event.type().equalsIgnoreCase("database/event/host")) {
                    eventType = 512;
                }
                if (eventType != 0) {
                    this.cacheManager.verifyAndHandleEvent(eventType, event.body());
                }
            }
            catch (SQLException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_20, "Debug: OracleFailoverEventHandlerThread.handleEvent() - SQLException:" + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverEventHandlerThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleFailoverEventHandlerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

