/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

class OracleConnectionCacheEventListener
implements ConnectionEventListener,
Serializable {
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    protected OracleImplicitConnectionCache implicitCache;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:36_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnectionCacheEventListener() {
        block4: {
            this(null);
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheEventListener.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheEventListener.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheEventListener.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnectionCacheEventListener(OracleImplicitConnectionCache icc) {
        block4: {
            this.implicitCache = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheEventListener.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(icc));
                    OracleLog.recursiveTrace = false;
                }
                this.implicitCache = icc;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheEventListener.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheEventListener.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connectionClosed(ConnectionEvent ce) {
        block8: {
            try {
                block7: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheEventListener.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(ce));
                        OracleLog.recursiveTrace = false;
                    }
                    try {
                        if (this.implicitCache != null) {
                            this.implicitCache.reusePooledConnection((PooledConnection)ce.getSource());
                        }
                    }
                    catch (SQLException se) {
                        if (!TRACE || OracleLog.recursiveTrace) break block7;
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheEventListener.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheEventListener:connectionClosed() - Exception Occurred : " + se.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheEventListener.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheEventListener.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent ce) {
        block8: {
            try {
                block7: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheEventListener.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(ce));
                        OracleLog.recursiveTrace = false;
                    }
                    try {
                        if (this.implicitCache != null) {
                            this.implicitCache.closePooledConnection((PooledConnection)ce.getSource());
                        }
                    }
                    catch (SQLException se) {
                        if (!TRACE || OracleLog.recursiveTrace) break block7;
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheEventListener.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheEventListener:connectionErrorOccurred() - Exception Occurred : " + se.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheEventListener.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheEventListener.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCachEventListener"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

