/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleOutputStream;

public final class PickleContext {
    private PickleOutputStream outStream;
    byte[] image;
    int imageOffset;
    private byte[] lengthBuffer;
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:22_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PickleContext() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.lengthBuffer = new byte[5];
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PickleContext(byte[] pickled_bytes) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pickled_bytes));
                OracleLog.recursiveTrace = false;
            }
            this.lengthBuffer = new byte[5];
            this.image = pickled_bytes;
            this.imageOffset = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PickleContext(byte[] pickled_bytes, long offset) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            this.lengthBuffer = new byte[5];
            this.image = pickled_bytes;
            this.imageOffset = (int)offset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initStream(int imglen) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.outStream = new PickleOutputStream(imglen);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initStream() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.outStream = new PickleOutputStream();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lengthInBytes(int v) {
        try {
            int __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(v));
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__ = v <= KOPI20_LN_MAXV ? 1 : 5;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeElementNull() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.outStream.write(KOPI20_LN_ELNL);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: 1");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 1;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeAtomicNull() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.outStream.write(KOPI20_LN_ATMN);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: 1");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 1;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeImmediatelyEmbeddedElementNull(byte null_adtno) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.lengthBuffer[0] = (byte)KOPI20_LN_IEMN;
            this.lengthBuffer[1] = null_adtno;
            this.outStream.write(this.lengthBuffer, 0, 2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: 2");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 2;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeSB2(int len) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(len));
                OracleLog.recursiveTrace = false;
            }
            this.lengthBuffer[0] = (byte)(len >> 8 & 0xFF);
            this.lengthBuffer[1] = (byte)(len & 0xFF);
            this.outStream.write(this.lengthBuffer, 0, 2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: 2");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 2;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeLength(int len) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(len));
                OracleLog.recursiveTrace = false;
            }
            if (len <= KOPI20_LN_MAXV) {
                this.outStream.write((byte)len);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: 1");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 1;
                return n2;
            }
            this.lengthBuffer[0] = (byte)KOPI20_LN_5BLN;
            this.lengthBuffer[1] = (byte)(len >> 24);
            this.lengthBuffer[2] = (byte)((len &= 0xFFFFFF) >> 16);
            this.lengthBuffer[3] = (byte)((len &= 0xFFFF) >> 8);
            this.lengthBuffer[4] = (byte)(len &= 0xFF);
            try {
                this.outStream.write(this.lengthBuffer);
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    PickleContext.logger().log(OracleLog.TRACE_32, "Debug: OracleTypeADT.writeLength_pctx " + ex.toString() + sw.toString());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: 5");
                OracleLog.recursiveTrace = false;
            }
            int n3 = 5;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeLength(int datalen, boolean include) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(datalen) + ", " + OracleLog.argument(include));
                OracleLog.recursiveTrace = false;
            }
            if (!include) {
                int __result__ = this.writeLength(datalen);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                return n2;
            }
            if (datalen <= KOPI20_LN_MAXV - 1) {
                this.outStream.write((byte)datalen + 1);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: 1");
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = 1;
                return __result__;
            }
            this.lengthBuffer[0] = (byte)KOPI20_LN_5BLN;
            this.lengthBuffer[1] = (byte)((datalen += 5) >> 24);
            this.lengthBuffer[2] = (byte)((datalen &= 0xFFFFFF) >> 16);
            this.lengthBuffer[3] = (byte)((datalen &= 0xFFFF) >> 8);
            this.lengthBuffer[4] = (byte)(datalen &= 0xFF);
            try {
                this.outStream.write(this.lengthBuffer);
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    PickleContext.logger().log(OracleLog.TRACE_32, "Debug: OracleTypeADT.writeLength_pctx " + ex.toString() + sw.toString());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: 5");
                OracleLog.recursiveTrace = false;
            }
            int n3 = 5;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] to5bLengthBytes_pctx(int len) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(len));
                OracleLog.recursiveTrace = false;
            }
            this.lengthBuffer[0] = (byte)KOPI20_LN_5BLN;
            this.lengthBuffer[1] = (byte)(len >> 24);
            this.lengthBuffer[2] = (byte)((len &= 0xFFFFFF) >> 16);
            this.lengthBuffer[3] = (byte)((len &= 0xFFFF) >> 8);
            this.lengthBuffer[4] = (byte)(len &= 0xFF);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + this.lengthBuffer);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = this.lengthBuffer;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeData(byte b2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(b2));
                OracleLog.recursiveTrace = false;
            }
            this.outStream.write(b2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: 1");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 1;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public int writeData(byte[] b2) throws SQLException {
        try {
            this.outStream.write(b2);
        }
        catch (IOException ex) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
        }
        return b2.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchImageLen(int offset, int image_length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(offset) + ", " + OracleLog.argument(image_length));
                OracleLog.recursiveTrace = false;
            }
            byte[] lenbuf = this.to5bLengthBytes_pctx(image_length);
            this.outStream.overwrite(offset, lenbuf, 0, lenbuf.length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeImageHeader(boolean withPrefix) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(withPrefix));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.writeImageHeader(KOPI20_LN_MAXV + 1, withPrefix);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeOpaqueImageHeader(int data_length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(data_length));
                OracleLog.recursiveTrace = false;
            }
            int count = 2;
            this.lengthBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
            this.lengthBuffer[1] = (byte)KOPI20_VERSION;
            this.outStream.write(this.lengthBuffer, 0, 2);
            count += this.writeLength(data_length + 2, true);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + count);
                OracleLog.recursiveTrace = false;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeImageHeader(int image_length, boolean withPrefix) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(image_length) + ", " + OracleLog.argument(withPrefix));
                OracleLog.recursiveTrace = false;
            }
            int count = 2;
            this.lengthBuffer[0] = withPrefix ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
            this.lengthBuffer[1] = (byte)KOPI20_VERSION;
            this.outStream.write(this.lengthBuffer, 0, 2);
            count += this.writeLength(image_length);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + count);
                OracleLog.recursiveTrace = false;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeCollImageHeader(int num_collection_items, int typeVersion) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(num_collection_items) + ", " + OracleLog.argument(typeVersion));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.writeCollImageHeader(KOPI20_LN_MAXV + 1, num_collection_items, typeVersion);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeCollImageHeader(int image_length, int num_collection_items, int typeVersion) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(image_length) + ", " + OracleLog.argument(num_collection_items) + ", " + OracleLog.argument(typeVersion));
                OracleLog.recursiveTrace = false;
            }
            int count = 5;
            this.lengthBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
            this.lengthBuffer[1] = (byte)KOPI20_VERSION;
            this.outStream.write(this.lengthBuffer, 0, 2);
            count += this.writeLength(image_length);
            this.lengthBuffer[0] = 1;
            this.lengthBuffer[1] = 17;
            if (typeVersion > KOPI20_LN_MAXV) {
                this.lengthBuffer[0] = (byte)(this.lengthBuffer[0] + 5);
                count += 5;
                this.outStream.write(this.lengthBuffer, 0, 2);
                this.writeLength(typeVersion);
            } else {
                this.lengthBuffer[0] = (byte)(this.lengthBuffer[0] + 2);
                count += 2;
                this.outStream.write(this.lengthBuffer, 0, 2);
                this.writeSB2(typeVersion);
            }
            this.lengthBuffer[0] = 0;
            this.outStream.write(this.lengthBuffer, 0, 1);
            count += this.writeLength(num_collection_items);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + count);
                OracleLog.recursiveTrace = false;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeCollImageHeader(byte[] prefix_segment) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(prefix_segment));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.writeCollImageHeader(KOPI20_LN_MAXV + 1, prefix_segment);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeCollImageHeader(int image_length, byte[] prefix_segment) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(image_length) + ", " + OracleLog.argument(prefix_segment));
                OracleLog.recursiveTrace = false;
            }
            int psegLen = prefix_segment.length;
            int count = 3 + psegLen;
            this.lengthBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
            this.lengthBuffer[1] = (byte)KOPI20_VERSION;
            this.outStream.write(this.lengthBuffer, 0, 2);
            count += this.writeLength(image_length);
            count += this.writeLength(psegLen + 1);
            this.lengthBuffer[0] = 0;
            this.outStream.write(this.lengthBuffer, 0, 1);
            this.outStream.write(prefix_segment, 0, psegLen);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + count);
                OracleLog.recursiveTrace = false;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] stream2Bytes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte[] __result__ = this.outStream.toByteArray();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                byte __result__ = this.image[this.imageOffset];
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte by = __result__;
                ++this.imageOffset;
                return by;
            }
            catch (Throwable throwable) {
                ++this.imageOffset;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readAndCheckVersion() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                boolean __result__;
                boolean bl = __result__ = (this.image[this.imageOffset] & 0xFF) <= KOPI20_VERSION;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__;
                ++this.imageOffset;
                return bl2;
            }
            catch (Throwable throwable) {
                ++this.imageOffset;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readLength() throws SQLException {
        try {
            int len;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if ((len = this.image[this.imageOffset] & 0xFF) > KOPI20_LN_MAXV) {
                if (len == KOPI20_LN_ELNL) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PickleContext.logger().log(Level.SEVERE, "Throwing SQLException: 1Invalid null flag read");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid null flag read");
                }
                len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
                this.imageOffset += 5;
            } else {
                ++this.imageOffset;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + len);
                OracleLog.recursiveTrace = false;
            }
            int n2 = len;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipLength() throws SQLException {
        try {
            int len;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.imageOffset = (len = this.image[this.imageOffset] & 0xFF) > KOPI20_LN_MAXV ? (this.imageOffset += 5) : ++this.imageOffset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readRestOfLength(byte len) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(len));
                OracleLog.recursiveTrace = false;
            }
            if ((len & 0xFF) != KOPI20_LN_5BLN) {
                int __result__ = len & 0xFF;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                return n2;
            }
            try {
                int __result__ = (((this.image[this.imageOffset] & 0xFF) * 256 + (this.image[this.imageOffset + 1] & 0xFF)) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n3 = __result__;
                this.imageOffset += 4;
                return n3;
            }
            catch (Throwable throwable) {
                this.imageOffset += 4;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipRestOfLength(byte len) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(len));
                OracleLog.recursiveTrace = false;
            }
            if ((len & 0xFF) > KOPI20_LN_MAXV) {
                if ((len & 0xFF) == KOPI20_LN_5BLN) {
                    this.imageOffset += 4;
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PickleContext.logger().log(Level.SEVERE, "Throwing SQLException: 1Invalid first length byte");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid first length byte");
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readLength(boolean exclude) throws SQLException {
        try {
            int len;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(exclude));
                OracleLog.recursiveTrace = false;
            }
            if ((len = this.image[this.imageOffset] & 0xFF) > KOPI20_LN_MAXV) {
                len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
                if (exclude) {
                    len -= 5;
                }
                this.imageOffset += 5;
            } else {
                if (exclude) {
                    --len;
                }
                ++this.imageOffset;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + len);
                OracleLog.recursiveTrace = false;
            }
            int n2 = len;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPrefixSegment() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = new byte[this.readLength()];
            System.arraycopy(this.image, this.imageOffset, b2, 0, b2.length);
            this.imageOffset += b2.length;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + b2);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = b2;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readDataValue() throws SQLException {
        try {
            int len;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if ((len = this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
                ++this.imageOffset;
                byte[] __result__ = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = __result__;
                return byArray;
            }
            if (len > KOPI20_LN_MAXV) {
                len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
                this.imageOffset += 5;
            } else {
                ++this.imageOffset;
            }
            byte[] b2 = new byte[len];
            System.arraycopy(this.image, this.imageOffset, b2, 0, b2.length);
            this.imageOffset += b2.length;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + b2);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = b2;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = new byte[length];
            System.arraycopy(this.image, this.imageOffset, b2, 0, length);
            this.imageOffset += length;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + b2);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = b2;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read1ByteDataValue() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
                byte[] __result__ = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = __result__;
                return byArray;
            }
            byte[] b2 = new byte[this.image[this.imageOffset] & 0xFF];
            System.arraycopy(this.image, this.imageOffset + 1, b2, 0, b2.length);
            this.imageOffset += b2.length + 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + b2);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = b2;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readDataValue(byte byte1) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(byte1));
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = new byte[this.readRestOfLength(byte1)];
            System.arraycopy(this.image, this.imageOffset, b2, 0, b2.length);
            this.imageOffset += b2.length;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + b2);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = b2;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readDataValue(int len) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(len));
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = new byte[len];
            System.arraycopy(this.image, this.imageOffset, b2, 0, len);
            this.imageOffset += len;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + b2);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = b2;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readUB4() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            long ret = (long)this.image[this.imageOffset++] << 24 & 0xFFFFFFFFFF000000L | (long)this.image[this.imageOffset++] << 16 & 0xFF0000L | (long)this.image[this.imageOffset++] << 8 & 0xFF00L | (long)this.image[this.imageOffset++] & 0xFFL;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            long l2 = ret;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readUB2() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int ret = this.image[this.imageOffset++] << 8 & 0xFF00 | this.image[this.imageOffset++] & 0xFF;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipDataValue() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
                ++this.imageOffset;
            } else {
                this.skipBytes(this.readLength());
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipDataValue(byte b2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.skipBytes(this.readRestOfLength(b2));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipBytes(int b2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(b2));
                OracleLog.recursiveTrace = false;
            }
            if (b2 > 0) {
                this.imageOffset += b2;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int offset() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.outStream != null) {
                int __result__ = this.outStream.offset();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                return n2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + this.imageOffset);
                OracleLog.recursiveTrace = false;
            }
            int n3 = this.imageOffset;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int absoluteOffset() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + this.imageOffset);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.imageOffset;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipTo(long offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (offset > (long)this.imageOffset) {
                this.imageOffset = (int)offset;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] image() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + this.image);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = this.image;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean is81format(byte flag) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = (flag & 0xFF & KOPI20_IF_IS81) != 0;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCollectionImage_pctx(byte flag) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = (flag & 0xFF & KOPI20_IF_COLL) != 0;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDegenerateImage_pctx(byte flag) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = (flag & 0xFF & KOPI20_IF_DEGN) != 0;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasPrefix(byte flag) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = (flag & 0xFF & KOPI20_IF_NOPS) == 0;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAtomicNull(byte flag) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = (flag & 0xFF) == KOPI20_LN_ATMN;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isImmediatelyEmbeddedNull(byte flag) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = (flag & 0xFF) == KOPI20_LN_IEMN;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isElementNull(byte flag) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = (flag & 0xFF) == KOPI20_LN_ELNL;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PickleContext.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.PickleContext"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

