/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.Datum;

public class OracleTypeBINARY_DOUBLE
extends OracleType
implements Serializable {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:22_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleTypeBINARY_DOUBLE() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            BINARY_DOUBLE datum = null;
            if (value != null) {
                if (value instanceof BINARY_DOUBLE) {
                    datum = (BINARY_DOUBLE)value;
                } else if (value instanceof Double) {
                    datum = new BINARY_DOUBLE((Double)value);
                } else if (value instanceof byte[]) {
                    datum = new BINARY_DOUBLE((byte[])value);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeBINARY_DOUBLE.logger().log(Level.SEVERE, "Throwing SQLException: 59" + value);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, value);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "return: " + datum);
                OracleLog.recursiveTrace = false;
            }
            BINARY_DOUBLE bINARY_DOUBLE = datum;
            return bINARY_DOUBLE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray = null;
            if (obj != null && obj instanceof Object[]) {
                Object[] objArray = (Object[])obj;
                int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                for (int i2 = 0; i2 < length; ++i2) {
                    Object o2 = objArray[(int)beginIdx + i2 - 1];
                    if (o2 != null) {
                        if (o2 instanceof Double) {
                            datumArray[i2] = new BINARY_DOUBLE((double)((Double)o2));
                            continue;
                        }
                        if (o2 instanceof BINARY_DOUBLE) {
                            datumArray[i2] = (BINARY_DOUBLE)o2;
                            continue;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleTypeBINARY_DOUBLE.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                        continue;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeBINARY_DOUBLE.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "return: " + datumArray);
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray2 = datumArray;
            return datumArray2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeCode() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "return: 101");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 101;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            if (bytes == null || bytes.length == 0) {
                Object __result__ = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Object var5_9 = __result__;
                return var5_9;
            }
            if (type == 1) {
                BINARY_DOUBLE __result__ = new BINARY_DOUBLE(bytes);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                BINARY_DOUBLE bINARY_DOUBLE = __result__;
                return bINARY_DOUBLE;
            }
            if (type == 2) {
                Object __result__ = new BINARY_DOUBLE(bytes).toJdbc();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Object object = __result__;
                return object;
            }
            if (type == 3) {
                byte[] __result__ = bytes;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = __result__;
                return byArray;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(Level.SEVERE, "Throwing SQLException: 59" + bytes);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, bytes);
            Object __result__ = null;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Object var5_13 = __result__;
            return var5_13;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeBINARY_DOUBLE.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleBINARY_DOUBLE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

