/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.KeywordValueI;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4CTTIoxsscs
extends T4CTTIfun {
    T4CConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:34_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIoxsscs(T4CMAREngine _mrengine, T4CTTIoer _oer, T4CConnection _conn) throws SQLException {
        super((byte)3, 0, (short)155);
        this.oer = _oer;
        this.setMarshalingEngine(_mrengine);
        this.connection = _conn;
    }

    void marshal(String userName, KeywordValue[] inKV, int inFlags) throws IOException, SQLException {
        super.marshalFunHeader();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        boolean sendUserName = false;
        byte[] userNameArr = null;
        if (userName != null && userName.length() > 0) {
            sendUserName = true;
            userNameArr = this.meg.conv.StringToCharBytes(userName);
            this.meg.marshalPTR();
            this.meg.marshalSB4(userNameArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        boolean sendInKV = false;
        if (inKV != null && inKV.length > 0) {
            sendInKV = true;
            this.meg.marshalPTR();
            this.meg.marshalSB4(inKV.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        this.meg.marshalUB4(inFlags);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (sendUserName) {
            this.meg.marshalCHR(userNameArr);
        }
        if (sendInKV) {
            for (int i2 = 0; i2 < inKV.length; ++i2) {
                ((KeywordValueI)inKV[i2]).marshal(this.meg);
            }
        }
    }

    void receive(byte[][] sessionId, KeywordValue[][] outKV, int[] outFlags) throws SQLException, IOException {
        block9: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            int sessionIdLength = (int)this.meg.unmarshalUB4();
                            sessionId[0] = this.meg.unmarshalNBytes(sessionIdLength);
                            int xsscsovn = (int)this.meg.unmarshalUB4();
                            outKV[0] = new KeywordValue[xsscsovn];
                            for (int i2 = 0; i2 < xsscsovn; ++i2) {
                                outKV[0][i2] = KeywordValueI.unmarshal(this.meg);
                            }
                            outFlags[0] = (int)this.meg.unmarshalUB4();
                            break;
                        }
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block9;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block9;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block9;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CTTIoxsscs.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoxsscs.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoxsscs.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoxsscs.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoxsscs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

