/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4CTTIk2rpc
extends T4CTTIfun {
    T4CConnection connection;
    static final int K2RPClogon = 1;
    static final int K2RPCbegin = 2;
    static final int K2RPCend = 3;
    static final int K2RPCrecover = 4;
    static final int K2RPCsession = 5;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:34_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIk2rpc(T4CMAREngine _mrengine, T4CTTIoer _oer, T4CConnection _conn) throws SQLException {
        super((byte)3, 0, (short)67);
        this.oer = _oer;
        this.setMarshalingEngine(_mrengine);
        this.connection = _conn;
    }

    void marshal(int k2rpctyp, int command) throws IOException, SQLException {
        super.marshalFunHeader();
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(k2rpctyp);
        this.meg.marshalPTR();
        this.meg.marshalUB4(3L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalPTR();
        this.meg.marshalUB4(3L);
        this.meg.marshalPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(command);
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(0L);
    }

    void receive() throws SQLException, IOException {
        block6: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block6;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block6;
                        }
                        case 8: {
                            int k2rpco4l = this.meg.unmarshalUB2();
                            int i2 = 0;
                            while (true) {
                                if (i2 >= k2rpco4l) continue block6;
                                this.meg.unmarshalUB4();
                                ++i2;
                            }
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CTTIk2rpc.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                        }
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIk2rpc.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIk2rpc.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIk2rpc.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIk2rpc"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

