/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4C8TTIuds;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIdcb
extends T4CTTIMsg {
    T4C8TTIuds[] uds;
    int numuds;
    String[] colnames;
    int colOffset;
    byte[] ignoreBuff;
    StringBuffer colNameSB = null;
    OracleStatement statement = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:34_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIdcb(T4CMAREngine _mrengine) throws IOException, SQLException {
        super((byte)16);
        this.setMarshalingEngine(_mrengine);
        this.ignoreBuff = new byte[40];
    }

    void init(OracleStatement stmt, int _offset) {
        this.statement = stmt;
        this.colOffset = _offset;
    }

    Accessor[] receive(Accessor[] accessors) throws SQLException, IOException {
        short length = this.meg.unmarshalUB1();
        if (this.ignoreBuff.length < length) {
            this.ignoreBuff = new byte[length];
        }
        this.meg.unmarshalNBytes(this.ignoreBuff, 0, length);
        int maxSizeOfOneRow = (int)this.meg.unmarshalUB4();
        accessors = this.receiveCommon(accessors, false);
        return accessors;
    }

    Accessor[] receiveFromRefCursor(Accessor[] accessors) throws SQLException, IOException {
        short ignore1 = this.meg.unmarshalUB1();
        int ignore2 = (int)this.meg.unmarshalUB4();
        accessors = this.receiveCommon(accessors, false);
        return accessors;
    }

    Accessor[] receiveCommon(Accessor[] accessors, boolean fromOdny) throws SQLException, IOException {
        if (fromOdny) {
            this.numuds = this.meg.unmarshalUB2();
        } else {
            this.numuds = (int)this.meg.unmarshalUB4();
            if (this.numuds > 0) {
                short ignore = this.meg.unmarshalUB1();
            }
        }
        this.uds = new T4C8TTIuds[this.numuds];
        this.colnames = new String[this.numuds];
        for (int i2 = 0; i2 < this.numuds; ++i2) {
            this.uds[i2] = new T4C8TTIuds(this.meg);
            this.uds[i2].unmarshal();
            this.colnames[i2] = this.meg.conv.CharBytesToString(this.uds[i2].getColumName(), this.uds[i2].getColumNameByteLength());
        }
        if (!fromOdny) {
            byte[] dcbdat = this.meg.unmarshalDALC();
            if (this.meg.versionNumber >= 10000) {
                int dcbflg = (int)this.meg.unmarshalUB4();
                int dcbmdbz = (int)this.meg.unmarshalUB4();
                if (this.meg.versionNumber >= 10200) {
                    int dcbmnpr = (int)this.meg.unmarshalUB4();
                    int dcbmxpr = (int)this.meg.unmarshalUB4();
                }
            }
        }
        if (this.statement.needToPrepareDefineBuffer) {
            if (accessors == null || accessors.length != this.numuds + this.colOffset) {
                Accessor[] newAccessors = new Accessor[this.numuds + this.colOffset];
                if (accessors != null && accessors.length == this.colOffset) {
                    System.arraycopy(accessors, 0, newAccessors, 0, this.colOffset);
                }
                accessors = newAccessors;
            }
            this.fillupAccessors(accessors, this.colOffset);
            if (!fromOdny) {
                this.statement.describedWithNames = true;
                this.statement.described = true;
                this.statement.numberOfDefinePositions = this.numuds;
                this.statement.accessors = accessors;
                this.statement.prepareAccessors();
                this.statement.allocateTmpByteArray();
            }
        }
        return accessors;
    }

    void fillupAccessors(Accessor[] accessors, int column_offset) throws SQLException {
        int[] definedColumnTypes = this.statement.definedColumnType;
        int[] definedColumnSizes = this.statement.definedColumnSize;
        int[] definedColumnFormOfUses = this.statement.definedColumnFormOfUse;
        int beginColumnIndex = this.statement.sqlObject.includeRowid ? 1 : 0;
        String sql_name = null;
        String schema_name = null;
        String type_name = null;
        int accessorIndex = column_offset;
        for (int i2 = 0; i2 < this.numuds; ++i2) {
            accessorIndex = column_offset + i2;
            int definedColumnType = 0;
            int definedColumnSize = 0;
            int definedColumnFormOfUse = 0;
            if (accessorIndex >= beginColumnIndex) {
                int defineColumnIndex = accessorIndex - beginColumnIndex;
                if (definedColumnTypes != null && definedColumnTypes.length > defineColumnIndex && definedColumnTypes[defineColumnIndex] != 0) {
                    definedColumnType = definedColumnTypes[defineColumnIndex];
                }
                if (definedColumnSizes != null && definedColumnSizes.length > defineColumnIndex && definedColumnSizes[defineColumnIndex] > 0) {
                    definedColumnSize = definedColumnSizes[defineColumnIndex];
                }
                if (definedColumnFormOfUses != null && definedColumnFormOfUses.length > defineColumnIndex && definedColumnFormOfUses[defineColumnIndex] > 0) {
                    definedColumnFormOfUse = definedColumnFormOfUses[defineColumnIndex];
                }
            }
            T4C8TTIuds ud = this.uds[i2];
            int max_len = ud.udsoac.oacmxl;
            switch (ud.udsoac.oacdty) {
                case 96: {
                    if (ud.udsoac.oacmxlc != 0 && ud.udsoac.oacmxlc < max_len) {
                        max_len = 2 * ud.udsoac.oacmxlc;
                    }
                    int nbOfCharToAllocate = max_len;
                    if ((definedColumnType == 1 || definedColumnType == 12) && definedColumnSize > 0 && definedColumnSize < max_len) {
                        nbOfCharToAllocate = definedColumnSize;
                    }
                    accessors[accessorIndex] = new T4CCharAccessor(this.statement, nbOfCharToAllocate, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, max_len, definedColumnType, definedColumnSize, this.meg);
                    if ((ud.udsoac.oacfl2 & 0x1000) != 4096 && ud.udsoac.oacmxlc == 0) break;
                    accessors[this.colOffset + i2].setDisplaySize(ud.udsoac.oacmxlc);
                    break;
                }
                case 2: {
                    accessors[accessorIndex] = new T4CNumberAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 1: {
                    if (ud.udsoac.oacmxlc != 0 && ud.udsoac.oacmxlc < max_len) {
                        max_len = 2 * ud.udsoac.oacmxlc;
                    }
                    int nbOfCharToAllocate = max_len;
                    if ((definedColumnType == 1 || definedColumnType == 12) && definedColumnSize > 0 && definedColumnSize < max_len) {
                        nbOfCharToAllocate = definedColumnSize;
                    }
                    accessors[accessorIndex] = new T4CVarcharAccessor(this.statement, nbOfCharToAllocate, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, max_len, definedColumnType, definedColumnSize, this.meg);
                    if ((ud.udsoac.oacfl2 & 0x1000) != 4096 && ud.udsoac.oacmxlc == 0) break;
                    accessors[this.colOffset + i2].setDisplaySize(ud.udsoac.oacmxlc);
                    break;
                }
                case 8: {
                    int nbOfCharToAllocate;
                    if ((definedColumnType == 1 || definedColumnType == 12) && this.meg.versionNumber >= 9000 && definedColumnSize < 4001) {
                        nbOfCharToAllocate = definedColumnSize > 0 ? definedColumnSize : 4000;
                        max_len = -1;
                        accessors[accessorIndex] = new T4CVarcharAccessor(this.statement, nbOfCharToAllocate, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, max_len, definedColumnType, definedColumnSize, this.meg);
                        accessors[accessorIndex].describeType = 8;
                        break;
                    }
                    max_len = 0;
                    accessors[accessorIndex] = new T4CLongAccessor(this.statement, accessorIndex + 1, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 6: {
                    accessors[accessorIndex] = new T4CVarnumAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 100: {
                    accessors[accessorIndex] = new T4CBinaryFloatAccessor(this.statement, 4, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 101: {
                    accessors[accessorIndex] = new T4CBinaryDoubleAccessor(this.statement, 8, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 23: {
                    accessors[accessorIndex] = new T4CRawAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 24: {
                    if (definedColumnType == -2 && definedColumnSize < 2001 && this.meg.versionNumber >= 9000) {
                        max_len = -1;
                        accessors[accessorIndex] = new T4CRawAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                        accessors[accessorIndex].describeType = 24;
                        break;
                    }
                    accessors[accessorIndex] = new T4CLongRawAccessor(this.statement, accessorIndex + 1, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 104: 
                case 208: {
                    accessors[accessorIndex] = new T4CRowidAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    if (ud.udsoac.oacdty != 208) break;
                    accessors[i2].describeType = ud.udsoac.oacdty;
                    break;
                }
                case 102: {
                    accessors[accessorIndex] = new T4CResultSetAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 12: {
                    accessors[accessorIndex] = new T4CDateAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 113: {
                    if (definedColumnType == -4 && this.meg.versionNumber >= 9000) {
                        accessors[accessorIndex] = new T4CLongRawAccessor(this.statement, accessorIndex + 1, Integer.MAX_VALUE, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                        accessors[accessorIndex].describeType = 113;
                        break;
                    }
                    if (definedColumnType == -3 && this.meg.versionNumber >= 9000) {
                        accessors[accessorIndex] = new T4CRawAccessor(this.statement, 4000, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                        accessors[accessorIndex].describeType = 113;
                        break;
                    }
                    accessors[accessorIndex] = new T4CBlobAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 112: {
                    int nbOfCharToAllocate;
                    short formOfUse = 1;
                    if (definedColumnFormOfUse != 0) {
                        formOfUse = (short)definedColumnFormOfUse;
                    }
                    if (definedColumnType == -1 && this.meg.versionNumber >= 9000) {
                        max_len = 0;
                        accessors[accessorIndex] = new T4CLongAccessor(this.statement, accessorIndex + 1, Integer.MAX_VALUE, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, formOfUse, definedColumnType, definedColumnSize, this.meg);
                        accessors[accessorIndex].describeType = 112;
                        break;
                    }
                    if ((definedColumnType == 12 || definedColumnType == 1) && this.meg.versionNumber >= 9000) {
                        nbOfCharToAllocate = 4000;
                        if (definedColumnSize > 0 && definedColumnSize < nbOfCharToAllocate) {
                            nbOfCharToAllocate = definedColumnSize;
                        }
                        accessors[accessorIndex] = new T4CVarcharAccessor(this.statement, nbOfCharToAllocate, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, formOfUse, 4000, definedColumnType, definedColumnSize, this.meg);
                        accessors[accessorIndex].describeType = 112;
                        break;
                    }
                    accessors[accessorIndex] = new T4CClobAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 114: {
                    accessors[accessorIndex] = new T4CBfileAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 109: {
                    sql_name = this.meg.conv.CharBytesToString(this.uds[i2].getTypeName(), this.uds[i2].getTypeCharLength());
                    schema_name = this.meg.conv.CharBytesToString(this.uds[i2].getSchemaName(), this.uds[i2].getSchemaCharLength());
                    type_name = schema_name + "." + sql_name;
                    accessors[accessorIndex] = new T4CNamedTypeAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, type_name, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 111: {
                    sql_name = this.meg.conv.CharBytesToString(this.uds[i2].getTypeName(), this.uds[i2].getTypeCharLength());
                    schema_name = this.meg.conv.CharBytesToString(this.uds[i2].getSchemaName(), this.uds[i2].getSchemaCharLength());
                    type_name = schema_name + "." + sql_name;
                    accessors[accessorIndex] = new T4CRefTypeAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, type_name, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 180: {
                    accessors[accessorIndex] = new T4CTimestampAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 181: {
                    accessors[accessorIndex] = new T4CTimestamptzAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 231: {
                    accessors[accessorIndex] = new T4CTimestampltzAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 182: {
                    accessors[accessorIndex] = new T4CIntervalymAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                case 183: {
                    accessors[accessorIndex] = new T4CIntervaldsAccessor(this.statement, max_len, ud.udsnull, ud.udsoac.oacflg, ud.udsoac.oacpre, ud.udsoac.oacscl, ud.udsoac.oacfl2, ud.udsoac.oacmal, ud.udsoac.formOfUse, definedColumnType, definedColumnSize, this.meg);
                    break;
                }
                default: {
                    accessors[accessorIndex] = null;
                }
            }
            accessors[accessorIndex].internalOtype = ud.udsoac.oactoid.length > 0 ? new OracleTypeADT(ud.udsoac.oactoid, ud.udsoac.oacvsn, ud.udsoac.ncs, ud.udsoac.formOfUse, schema_name + "." + sql_name) : null;
            accessors[accessorIndex].columnName = this.colnames[i2];
            if (this.uds[i2].udsoac.oacmxl != 0) continue;
            accessors[i2].isNullByDescribe = true;
        }
        this.colNameSB = null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIdcb"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

