/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.sql.BLOB;
import oracle.sql.Datum;

class T4C8TTIBlob
extends T4C8TTILob {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:32_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4C8TTIBlob(T4CMAREngine mengine, T4CTTIoer _oer) {
        super(mengine, _oer);
    }

    @Override
    Datum createTemporaryLob(Connection conn, boolean cache, int duration) throws SQLException, IOException {
        if (duration == 12) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4C8TTIBlob.logger().log(Level.SEVERE, "Throwing SQLException: 158");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 158);
        }
        BLOB blob = null;
        this.initializeLobdef();
        this.lobops = 272L;
        this.sourceLobLocator = new byte[86];
        this.sourceLobLocator[1] = 84;
        this.characterSet = 1;
        this.lobamt = duration;
        this.sendLobamt = true;
        this.destinationOffset = 113L;
        this.nullO2U = true;
        if (this.meg.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = cache ? 1 : 0;
            this.lobscnl = 1;
        }
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        if (this.sourceLobLocator != null) {
            blob = new BLOB((OracleConnection)conn, this.sourceLobLocator);
        }
        return blob;
    }

    @Override
    boolean open(byte[] lobLocator, int mode) throws SQLException, IOException {
        boolean wasOpened = false;
        int kokl_mode = 2;
        if (mode == 0) {
            kokl_mode = 1;
        }
        wasOpened = this._open(lobLocator, kokl_mode, 32768);
        return wasOpened;
    }

    @Override
    boolean close(byte[] lobLocator) throws SQLException, IOException {
        boolean wasClosed = false;
        wasClosed = this._close(lobLocator, 65536);
        return wasClosed;
    }

    @Override
    boolean isOpen(byte[] lobLocator) throws SQLException, IOException {
        boolean open = false;
        open = this._isOpen(lobLocator, 69632);
        return open;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8TTIBlob"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

