/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CError;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.NCLOB;
import oracle.sql.SQLName;
import oracle.sql.converter.CharacterSetMetaData;

public class T2CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    short[] queryMetaData1 = null;
    byte[] queryMetaData2 = null;
    int queryMetaData1Offset = 0;
    int queryMetaData2Offset = 0;
    private String password;
    int fatalErrorNumber = 0;
    String fatalErrorMessage = null;
    static final int QMD_dbtype = 0;
    static final int QMD_dbsize = 1;
    static final int QMD_nullok = 2;
    static final int QMD_precision = 3;
    static final int QMD_scale = 4;
    static final int QMD_formOfUse = 5;
    static final int QMD_columnNameLength = 6;
    static final int QMD_tdo0 = 7;
    static final int QMD_tdo1 = 8;
    static final int QMD_tdo2 = 9;
    static final int QMD_tdo3 = 10;
    static final int QMD_charLength = 11;
    static final int QMD_typeNameLength = 12;
    static final int T2C_LOCATOR_MAX_LEN = 16;
    static final int T2C_LINEARIZED_LOCATOR_MAX_LEN = 4000;
    static final int T2C_LINEARIZED_BFILE_LOCATOR_MAX_LEN = 530;
    static final int METADATA1_INDICES_PER_COLUMN = 13;
    protected static final int SIZEOF_QUERYMETADATA2 = 8;
    int queryMetaData1Size = 100;
    int queryMetaData2Size = 800;
    long m_nativeState;
    short m_clientCharacterSet;
    byte byteAlign;
    private static final int EOJ_SUCCESS = 0;
    private static final int EOJ_ERROR = -1;
    private static final int EOJ_WARNING = 1;
    private static final int EOJ_GET_STORAGE_ERROR = -4;
    private static final String OCILIBRARY = "ocijdbc11";
    private int logon_mode = 0;
    static final int LOGON_MODE_DEFAULT = 0;
    static final int LOGON_MODE_SYSDBA = 2;
    static final int LOGON_MODE_SYSOPER = 4;
    static final int LOGON_MODE_SYSASM = 32768;
    static final int LOGON_MODE_CONNECTION_POOL = 5;
    static final int LOGON_MODE_CONNPOOL_CONNECTION = 6;
    static final int LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    static final int LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int T2C_PROXYTYPE_NONE = 0;
    static final int T2C_PROXYTYPE_USER_NAME = 1;
    static final int T2C_PROXYTYPE_DISTINGUISHED_NAME = 2;
    static final int T2C_PROXYTYPE_CERTIFICATE = 3;
    private static boolean isLibraryLoaded;
    OracleOCIFailover appCallback = null;
    Object appCallbackObject = null;
    private Properties nativeInfo;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:31_PDT_2008";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T2CConnection(String ur, Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, info, ext);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ur) + ", " + OracleLog.argument(info) + ", " + OracleLog.argument(ext));
                OracleLog.recursiveTrace = false;
            }
            this.initialize();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void initializePassword(String p2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(p2));
                OracleLog.recursiveTrace = false;
            }
            this.password = p2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.allocQueryMetaDataBuffers();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocQueryMetaDataBuffers() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.queryMetaData1Offset = 0;
            this.queryMetaData1 = new short[this.queryMetaData1Size * 13];
            this.queryMetaData2Offset = 0;
            this.queryMetaData2 = new byte[this.queryMetaData2Size];
            this.namedTypeAccessorByteLen = 0;
            this.refTypeAccessorByteLen = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reallocateQueryMetaData(int numColumns, int charSize) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(numColumns) + ", " + OracleLog.argument(charSize));
                OracleLog.recursiveTrace = false;
            }
            this.queryMetaData1 = null;
            this.queryMetaData2 = null;
            this.queryMetaData1Size = Math.max(numColumns, this.queryMetaData1Size);
            this.queryMetaData2Size = Math.max(charSize, this.queryMetaData2Size);
            this.allocQueryMetaDataBuffers();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void logon() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.database == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 64");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 64);
            }
            if (!isLibraryLoaded) {
                T2CConnection.loadNativeLibrary(this.ocidll);
            }
            if (this.ociConnectionPoolIsPooling) {
                this.processOCIConnectionPooling();
            } else {
                byte[] nlsterritory;
                long OCISvcCtxHandle = this.ociSvcCtxHandle;
                long OCIEnvHandle = this.ociEnvHandle;
                long OCIErrHandle = this.ociErrHandle;
                if (OCISvcCtxHandle != 0L && OCIEnvHandle != 0L) {
                    if (this.ociDriverCharset != null) {
                        this.m_clientCharacterSet = new Integer(this.ociDriverCharset).shortValue();
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 89");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89);
                    }
                    this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                    short[] csids = new short[3];
                    this.sqlWarning = this.checkError(this.t2cUseConnection(this.m_nativeState, OCIEnvHandle, OCISvcCtxHandle, OCIErrHandle, csids), this.sqlWarning);
                    this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
                    this.byteAlign = (byte)(csids[2] & 0xFF);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
                if (this.internalLogon == null) {
                    this.logon_mode = 0;
                } else if (this.internalLogon.equalsIgnoreCase("SYSDBA")) {
                    this.logon_mode = 2;
                } else if (this.internalLogon.equalsIgnoreCase("SYSOPER")) {
                    this.logon_mode = 4;
                } else if (this.internalLogon.equalsIgnoreCase("SYSASM")) {
                    this.logon_mode = 32768;
                }
                byte[] l_userName = null;
                byte[] l_proxyClientName = null;
                byte[] l_password = null;
                String newPassword = this.setNewPassword;
                byte[] newPasswordBytes = new byte[]{};
                this.m_clientCharacterSet = this.nlsLangBackdoor ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.ocidll) : T2CConnection.getClientCharSetId();
                if (newPassword != null) {
                    newPasswordBytes = DBConversion.stringToDriverCharBytes(newPassword, this.m_clientCharacterSet);
                }
                l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                l_proxyClientName = this.proxyClientName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.proxyClientName, this.m_clientCharacterSet);
                l_password = this.password == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.password, this.m_clientCharacterSet);
                byte[] l_database = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
                short[] csids = new short[3];
                String s2 = null;
                s2 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault());
                byte[] nlslanguage = s2 != null ? s2.getBytes() : null;
                s2 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault());
                byte[] byArray = nlsterritory = s2 != null ? s2.getBytes() : null;
                if (nlslanguage == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 176");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 176);
                }
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                this.sqlWarning = this.m_nativeState == 0L ? this.checkError(this.t2cCreateState(l_userName, l_userName.length, l_proxyClientName, l_proxyClientName.length, l_password, l_password.length, newPasswordBytes, newPasswordBytes.length, l_database, l_database.length, this.m_clientCharacterSet, this.logon_mode, csids, nlslanguage, nlsterritory, this.prelimAuth), this.sqlWarning) : this.checkError(this.t2cLogon(this.m_nativeState, l_userName, l_userName.length, l_proxyClientName, l_proxyClientName.length, l_password, l_password.length, newPasswordBytes, newPasswordBytes.length, l_database, l_database.length, this.logon_mode, csids, nlslanguage, nlsterritory, this.prelimAuth), this.sqlWarning);
                this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
                this.byteAlign = (byte)(csids[2] & 0xFF);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void logoff() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.m_nativeState != 0L) {
                    this.checkError(this.t2cLogoff(this.m_nativeState));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(OracleStatement stmt) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt));
                OracleLog.recursiveTrace = false;
            }
            byte[] l_sqlString = stmt.sqlObject.getSql(stmt.processEscapes, stmt.convertNcharLiterals).getBytes();
            this.checkError(this.t2cCreateStatement(this.m_nativeState, 0L, l_sqlString, l_sqlString.length, stmt, false, stmt.rowPrefetch));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void cancelOperationOnServer() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cCancel(this.m_nativeState));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    native int t2cAbort(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doAbort() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cAbort(this.m_nativeState));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(autoCommit));
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cSetAutoCommit(this.m_nativeState, autoCommit));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(int flags) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flags));
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cCommit(this.m_nativeState, flags));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRollback() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cRollback(this.m_nativeState));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized int doPingDatabase() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.t2cPingDatabase(this.m_nativeState) == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: -1");
                OracleLog.recursiveTrace = false;
            }
            int n3 = -1;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doGetDatabaseProductVersion() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte[] l_version = this.t2cGetProductionVersion(this.m_nativeState);
            String __result__ = this.conversion.CharBytesToString(l_version, l_version.length);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected short doGetVersionNumber() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            short version_num = 0;
            try {
                String ver_str = this.doGetDatabaseProductVersion();
                StringTokenizer st = new StringTokenizer(ver_str.trim(), " .", false);
                String tk = null;
                int ct = 0;
                short num = 0;
                while (st.hasMoreTokens()) {
                    tk = st.nextToken();
                    try {
                        num = Integer.decode(tk).shortValue();
                        version_num = (short)(version_num * 10 + num);
                        if (++ct != 4) continue;
                        break;
                    }
                    catch (NumberFormatException nfe) {
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (version_num == -1) {
                version_num = 0;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + version_num);
                OracleLog.recursiveTrace = false;
            }
            short s2 = version_num;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClobDBAccess createClobDBAccess() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            T2CConnection t2CConnection = this;
            return t2CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobDBAccess createBlobDBAccess() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            T2CConnection t2CConnection = this;
            return t2CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BfileDBAccess createBfileDBAccess() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            T2CConnection t2CConnection = this;
            return t2CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB createClob(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator_bytes));
                OracleLog.recursiveTrace = false;
            }
            CLOB __result__ = new CLOB(this, locator_bytes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB createClob(byte[] locator_bytes, short csform) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator_bytes) + ", " + OracleLog.argument(csform));
                OracleLog.recursiveTrace = false;
            }
            CLOB __result__ = new CLOB(this, locator_bytes, csform);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB createBlob(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator_bytes));
                OracleLog.recursiveTrace = false;
            }
            BLOB __result__ = new BLOB(this, locator_bytes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            BLOB bLOB = __result__;
            return bLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE createBfile(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator_bytes));
                OracleLog.recursiveTrace = false;
            }
            BFILE __result__ = new BFILE(this, locator_bytes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            BFILE bFILE = __result__;
            return bFILE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLWarning checkError(int errStatus) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(errStatus));
                OracleLog.recursiveTrace = false;
            }
            SQLWarning __result__ = this.checkError(errStatus, null);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            SQLWarning sQLWarning = __result__;
            return sQLWarning;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLWarning checkError(int errStatus, SQLWarning warning) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(errStatus) + ", " + OracleLog.argument(warning));
                OracleLog.recursiveTrace = false;
            }
            switch (errStatus) {
                case 0: {
                    break;
                }
                case -1: 
                case 1: {
                    T2CError l_error = new T2CError();
                    int l_status = -1;
                    if (this.m_nativeState != 0L) {
                        l_status = this.t2cDescribeError(this.m_nativeState, l_error, l_error.m_errorMessage);
                    } else if (this.fatalErrorNumber != 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + this.fatalErrorMessage + l_error.m_errorNumber);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), this.fatalErrorMessage, l_error.m_errorNumber);
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                    }
                    String l_reason = null;
                    if (l_status != -1) {
                        int msgLength;
                        for (msgLength = 0; msgLength < l_error.m_errorMessage.length && l_error.m_errorMessage[msgLength] != 0; ++msgLength) {
                        }
                        l_reason = this.conversion.CharBytesToString(l_error.m_errorMessage, msgLength, true);
                    }
                    switch (l_error.m_errorNumber) {
                        case 28: 
                        case 600: 
                        case 1012: 
                        case 1041: {
                            this.internalClose();
                            break;
                        }
                        case 3113: 
                        case 3114: {
                            this.close();
                        }
                    }
                    if (l_status == -1) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 1Fetch error message failed!");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fetch error message failed!");
                    }
                    if (errStatus == -1) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + l_reason + l_error.m_errorNumber);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), l_reason, l_error.m_errorNumber);
                        break;
                    }
                    warning = DatabaseError.addSqlWarning(warning, l_reason, l_error.m_errorNumber);
                    break;
                }
                case -4: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 254");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 254);
                    break;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + warning);
                OracleLog.recursiveTrace = false;
            }
            SQLWarning sQLWarning = warning;
            return sQLWarning;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement RefCursorBytesToStatement(byte[] bytes, OracleStatement parent) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(parent));
                OracleLog.recursiveTrace = false;
            }
            T2CStatement stmt = new T2CStatement(this, 1, this.defaultRowPrefetch, -1, -1);
            stmt.needToParse = false;
            stmt.serverCursor = true;
            stmt.isOpen = true;
            stmt.processEscapes = false;
            stmt.prepareForNewResults(true, false);
            stmt.sqlObject.initialize("select unknown as ref cursor from whatever");
            stmt.sqlKind = 0;
            this.checkError(this.t2cCreateStatement(this.m_nativeState, parent.c_state, bytes, bytes.length, stmt, true, this.defaultRowPrefetch));
            parent.addChild(stmt);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + stmt);
                OracleLog.recursiveTrace = false;
            }
            T2CStatement t2CStatement = stmt;
            return t2CStatement;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(otypeADT) + ", " + OracleLog.argument(otype) + ", " + OracleLog.argument(attrIndex));
                OracleLog.recursiveTrace = false;
            }
            boolean value = false;
            if (otype != null) {
                String[] schema = new String[1];
                String[] type = new String[1];
                SQLName.parse(otypeADT.getFullName(), schema, type, true);
                String fullname = "\"" + schema[0] + "\".\"" + type[0] + "\"";
                byte[] utf8bytes = this.conversion.StringToCharBytes(fullname);
                int formOfUse = this.t2cGetFormOfUse(this.m_nativeState, otype, utf8bytes, utf8bytes.length, attrIndex);
                if (formOfUse < 0) {
                    this.checkError(formOfUse);
                }
                otype.setForm(formOfUse);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTdoCState(String schemaName, String typeName) throws SQLException {
        try {
            int[] err;
            String fullNameWithQuotes;
            byte[] dbcsbytes;
            long tdoCState;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(schemaName) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if ((tdoCState = this.t2cGetTDO(this.m_nativeState, dbcsbytes = this.conversion.StringToCharBytes(fullNameWithQuotes = "\"" + schemaName + "\".\"" + typeName + "\""), dbcsbytes.length, err = new int[1])) == 0L) {
                this.checkError(err[0]);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + tdoCState);
                OracleLog.recursiveTrace = false;
            }
            long l2 = tdoCState;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getDBAccessProperties() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Properties __result__ = this.getOCIHandles();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Properties properties = __result__;
            return properties;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Properties getOCIHandles() throws SQLException {
        Properties properties;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                if (this.nativeInfo == null) {
                    long[] handles = new long[3];
                    this.checkError(this.t2cGetHandles(this.m_nativeState, handles));
                    this.nativeInfo = new Properties();
                    this.nativeInfo.put("OCIEnvHandle", String.valueOf(handles[0]));
                    this.nativeInfo.put("OCISvcCtxHandle", String.valueOf(handles[1]));
                    this.nativeInfo.put("OCIErrHandle", String.valueOf(handles[2]));
                    this.nativeInfo.put("ClientCharSet", String.valueOf(this.m_clientCharacterSet));
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.nativeInfo);
                    OracleLog.recursiveTrace = false;
                }
                properties = this.nativeInfo;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            T2CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getServerSessionInfo() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.lifecycle != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
            }
            if (this.sessionProperties == null) {
                this.sessionProperties = new Properties();
            }
            if (this.getVersionNumber() < 10200) {
                this.queryFCFProperties(this.sessionProperties);
            } else {
                this.checkError(T2CConnection.t2cGetServerSessionInfo(this.m_nativeState, this.sessionProperties));
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + this.sessionProperties);
                OracleLog.recursiveTrace = false;
            }
            Properties properties = this.sessionProperties;
            return properties;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte ret = 0;
            if (whatProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
                ret = this.t2cGetAsmVolProperty(this.m_nativeState);
            } else if (whatProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
                ret = this.t2cGetInstanceType(this.m_nativeState);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            byte by = ret;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConnectionPoolInfo() throws SQLException {
        Properties properties;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                Properties info = new Properties();
                this.checkError(this.t2cGetConnPoolInfo(this.m_nativeState, info));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + info);
                    OracleLog.recursiveTrace = false;
                }
                properties = info;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            T2CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionPoolInfo(int cpool_min, int cpool_max, int cpool_incr, int cpool_timeout, int cpool_nowait, int cpool_dist_txn) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cpool_min) + ", " + OracleLog.argument(cpool_max) + ", " + OracleLog.argument(cpool_incr) + ", " + OracleLog.argument(cpool_timeout) + ", " + OracleLog.argument(cpool_nowait) + ", " + OracleLog.argument(cpool_dist_txn));
                    OracleLog.recursiveTrace = false;
                }
                this.checkError(this.t2cSetConnPoolInfo(this.m_nativeState, cpool_min, cpool_max, cpool_incr, cpool_timeout, cpool_nowait, cpool_dist_txn));
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            T2CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ociPasswordChange(String user, String oldPassword, String newPassword) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(oldPassword) + ", " + OracleLog.argument(newPassword));
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                byte[] l_userName = user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(user, this.m_clientCharacterSet);
                byte[] l_oldPwd = oldPassword == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(oldPassword, this.m_clientCharacterSet);
                byte[] l_newPwd = newPassword == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(newPassword, this.m_clientCharacterSet);
                this.sqlWarning = this.checkError(this.t2cPasswordChange(this.m_nativeState, l_userName, l_userName.length, l_oldPwd, l_oldPwd.length, l_newPwd, l_newPwd.length), this.sqlWarning);
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            T2CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOCIConnectionPooling() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.lifecycle != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
            }
            T2CConnection m_conn_pool = null;
            if (this.ociConnectionPoolLogonMode == "connection_pool") {
                this.m_clientCharacterSet = this.nlsLangBackdoor ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.ocidll) : T2CConnection.getClientCharSetId();
            } else {
                m_conn_pool = (T2CConnection)this.ociConnectionPoolObject;
                this.m_clientCharacterSet = m_conn_pool.m_clientCharacterSet;
            }
            byte[] l_userName = null;
            byte[] l_password = this.password == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.password, this.m_clientCharacterSet);
            byte[] l_database = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
            byte[] nlslanguage = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
            byte[] nlsterritory = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
            short[] csids = new short[3];
            if (this.ociConnectionPoolLogonMode == "connection_pool") {
                l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                this.logon_mode = 5;
                if (this.m_nativeState == 0L) {
                    int[] p2 = new int[6];
                    OracleOCIConnectionPool.readPoolConfig(this.ociConnectionPoolMinLimit, this.ociConnectionPoolMaxLimit, this.ociConnectionPoolIncrement, this.ociConnectionPoolTimeout, this.ociConnectionPoolNoWait, this.ociConnectionPoolTransactionDistributed, p2);
                    this.sqlWarning = this.checkError(this.t2cCreateConnPool(l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.m_clientCharacterSet, this.logon_mode, p2[0], p2[1], p2[2], p2[3], p2[4], p2[5]), this.sqlWarning);
                    this.versionNumber = (short)10000;
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 0Internal Error: ");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 0, "Internal Error: ");
                }
            } else if (this.ociConnectionPoolLogonMode == "connpool_connection") {
                this.logon_mode = 6;
                l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, null, 0, csids, nlslanguage, nlsterritory), this.sqlWarning);
            } else if (this.ociConnectionPoolLogonMode == "connpool_alias_connection") {
                this.logon_mode = 8;
                byte[] connection_id = null;
                connection_id = (byte[])this.ociConnectionPoolConnID;
                l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, connection_id, connection_id == null ? 0 : connection_id.length, csids, nlslanguage, nlsterritory), this.sqlWarning);
            } else if (this.ociConnectionPoolLogonMode == "connpool_proxy_connection") {
                this.logon_mode = 7;
                String proxyType = this.ociConnectionPoolProxyType;
                int num_proxy_roles = this.ociConnectionPoolProxyNumRoles;
                String[] proxy_roles = null;
                if (num_proxy_roles > 0) {
                    proxy_roles = (String[])this.ociConnectionPoolProxyRoles;
                }
                byte[] proxy_un = null;
                byte[] proxy_pd = null;
                byte[] proxy_dn = null;
                byte[] proxy_cf = null;
                int proxy_type = 0;
                if (proxyType == "proxytype_user_name") {
                    proxy_type = 1;
                    String p3 = this.ociConnectionPoolProxyUserName;
                    if (p3 != null) {
                        proxy_un = p3.getBytes();
                    }
                    if ((p3 = this.ociConnectionPoolProxyPassword) != null) {
                        proxy_pd = p3.getBytes();
                    }
                } else if (proxyType == "proxytype_distinguished_name") {
                    proxy_type = 2;
                    String p4 = this.ociConnectionPoolProxyDistinguishedName;
                    if (p4 != null) {
                        proxy_dn = p4.getBytes();
                    }
                } else if (proxyType == "proxytype_certificate") {
                    proxy_type = 3;
                    proxy_cf = (byte[])this.ociConnectionPoolProxyCertificate;
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 107");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 107);
                }
                l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.logon_mode, proxy_type, num_proxy_roles, proxy_roles, proxy_un, proxy_un == null ? 0 : proxy_un.length, proxy_pd, proxy_pd == null ? 0 : proxy_pd.length, proxy_dn, proxy_dn == null ? 0 : proxy_dn.length, proxy_cf, proxy_cf == null ? 0 : proxy_cf.length, null, 0, csids, nlslanguage, nlsterritory), this.sqlWarning);
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23connection-pool-logon");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "connection-pool-logon");
            }
            this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
            this.byteAlign = (byte)(csids[2] & 0xFF);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDescriptorSharable(OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            T2CConnection c1 = this;
            PhysicalConnection c2 = (PhysicalConnection)conn.getPhysicalConnection();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + (c1 == c2));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = c1 == c2;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    native int t2cBlobRead(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9);

    native int t2cClobRead(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, boolean var10);

    native int t2cBlobWrite(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, byte[][] var10);

    native int t2cClobWrite(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, byte[][] var10, boolean var11);

    native long t2cLobGetLength(long var1, byte[] var3, int var4);

    native int t2cBfileOpen(long var1, byte[] var3, int var4, byte[][] var5);

    native int t2cBfileIsOpen(long var1, byte[] var3, int var4, boolean[] var5);

    native int t2cBfileExists(long var1, byte[] var3, int var4, boolean[] var5);

    native String t2cBfileGetName(long var1, byte[] var3, int var4);

    native String t2cBfileGetDirAlias(long var1, byte[] var3, int var4);

    native int t2cBfileClose(long var1, byte[] var3, int var4, byte[][] var5);

    native int t2cLobGetChunkSize(long var1, byte[] var3, int var4);

    native int t2cLobTrim(long var1, int var3, long var4, byte[] var6, int var7, byte[][] var8);

    native int t2cLobCreateTemporary(long var1, int var3, boolean var4, int var5, short var6, byte[][] var7);

    native int t2cLobFreeTemporary(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    native int t2cLobIsTemporary(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int t2cLobOpen(long var1, int var3, byte[] var4, int var5, int var6, byte[][] var7);

    native int t2cLobIsOpen(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int t2cLobClose(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lobLength(byte[] locator) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator));
                OracleLog.recursiveTrace = false;
            }
            long result = 0L;
            result = this.t2cLobGetLength(this.m_nativeState, locator, locator.length);
            this.checkError((int)result);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l2 = result;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int blobRead(byte[] locator, long offset, int amount, byte[] buffer) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(amount) + ", " + OracleLog.argument(buffer));
                OracleLog.recursiveTrace = false;
            }
            int result = 0;
            result = this.t2cBlobRead(this.m_nativeState, locator, locator.length, offset, amount, buffer, buffer.length);
            this.checkError(result);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int blobWrite(byte[] locator, long offset, byte[] buffer, byte[][] newLocatorHolder, int bytesOffset, int amount) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(buffer) + ", " + OracleLog.argument(newLocatorHolder) + ", " + OracleLog.argument(bytesOffset) + ", " + OracleLog.argument(amount));
                OracleLog.recursiveTrace = false;
            }
            int result = 0;
            result = this.t2cBlobWrite(this.m_nativeState, locator, locator.length, offset, amount, buffer, bytesOffset, newLocatorHolder);
            this.checkError(result);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int clobWrite(byte[] locator, long offset, char[] buffer, byte[][] newLocatorHolder, boolean isNclob, int charsOffset, int amount) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(buffer) + ", " + OracleLog.argument(newLocatorHolder) + ", " + OracleLog.argument(isNclob) + ", " + OracleLog.argument(charsOffset) + ", " + OracleLog.argument(amount));
                OracleLog.recursiveTrace = false;
            }
            int result = 0;
            result = this.t2cClobWrite(this.m_nativeState, locator, locator.length, offset, amount, buffer, charsOffset, newLocatorHolder, isNclob);
            this.checkError(result);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lobGetChunkSize(byte[] locator) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator));
                OracleLog.recursiveTrace = false;
            }
            int result = 0;
            result = this.t2cLobGetChunkSize(this.m_nativeState, locator, locator.length);
            this.checkError(result);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            long __result__ = this.lobLength(locator);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BFILE bfile, byte[] pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.hasPattern(bfile, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BFILE bfile, BFILE pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.isSubLob(bfile, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(BFILE bfile, long offset, int amount, byte[] buffer) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(amount) + ", " + OracleLog.argument(buffer));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            if (amount <= 0 || buffer == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            if (amount > buffer.length) {
                amount = buffer.length;
            }
            int __result__ = this.blobRead(locator, offset, amount, buffer);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            String fileName = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            fileName = this.t2cBfileGetName(this.m_nativeState, locator, locator.length);
            this.checkError(fileName.length());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + fileName);
                OracleLog.recursiveTrace = false;
            }
            String string = fileName;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDirAlias(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            String aliasName = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            aliasName = this.t2cBfileGetDirAlias(this.m_nativeState, locator, locator.length);
            this.checkError(aliasName.length());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + aliasName);
                OracleLog.recursiveTrace = false;
            }
            String string = aliasName;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cBfileOpen(this.m_nativeState, locator, locator.length, newLocatorHolder));
            bfile.setLocator(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileOpen(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cBfileIsOpen(this.m_nativeState, locator, locator.length, flagHolder));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + flagHolder[0]);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = flagHolder[0];
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fileExists(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cBfileExists(this.m_nativeState, locator, locator.length, flagHolder));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + flagHolder[0]);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = flagHolder[0];
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cBfileClose(this.m_nativeState, locator, locator.length, newLocatorHolder));
            bfile.setLocator(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(BFILE lob, int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob) + ", " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 114, locator, locator.length, mode, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(BFILE lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 114, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen(BFILE lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 114, locator, locator.length, flagHolder));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + flagHolder[0]);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = flagHolder[0];
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(BFILE bfile, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleBlobInputStream __result__ = new OracleBlobInputStream(bfile, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleBlobInputStream oracleBlobInputStream = __result__;
                return oracleBlobInputStream;
            }
            OracleBlobInputStream __result__ = new OracleBlobInputStream(bfile, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleBlobInputStream oracleBlobInputStream = __result__;
            return oracleBlobInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newConversionInputStream(BFILE bfile, int conversionType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(conversionType));
                OracleLog.recursiveTrace = false;
            }
            this.checkTrue(bfile != null && bfile.shareBytes() != null, 54);
            OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, bfile.getBinaryStream(), conversionType);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream oracleConversionInputStream = result;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newConversionReader(BFILE bfile, int conversionType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(conversionType));
                OracleLog.recursiveTrace = false;
            }
            this.checkTrue(bfile != null && bfile.shareBytes() != null, 54);
            OracleConversionReader result = new OracleConversionReader(this.conversion, bfile.getBinaryStream(), conversionType);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionReader oracleConversionReader = result;
            return oracleConversionReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length(BLOB blob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            long __result__ = this.lobLength(locator);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BLOB blob, byte[] pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.hasPattern(blob, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BLOB blob, BLOB pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            this.checkTrue(pattern != null && pattern.shareBytes() != null, 54);
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.isSubLob(blob, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(BLOB blob, long offset, int amount, byte[] buffer) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(amount) + ", " + OracleLog.argument(buffer));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            if (amount <= 0 || buffer == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            if (amount > buffer.length) {
                amount = buffer.length;
            }
            int __result__ = this.blobRead(locator, offset, amount, buffer);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putBytes(BLOB blob, long offset, byte[] buffer, int bytesOffset, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(buffer) + ", " + OracleLog.argument(bytesOffset) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.checkTrue(offset >= 0L, 68);
            int ret = 0;
            if (buffer == null || buffer.length == 0 || length <= 0) {
                ret = 0;
            } else {
                byte[] locator = null;
                this.checkTrue(this.m_nativeState != 0L, 8);
                this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
                if (buffer == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                        OracleLog.recursiveTrace = false;
                    }
                    int n2 = 0;
                    return n2;
                }
                byte[][] newLocatorHolder = new byte[1][];
                ret = this.blobWrite(locator, offset, buffer, newLocatorHolder, bytesOffset, length);
                blob.setLocator(newLocatorHolder[0]);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            int n3 = ret;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChunkSize(BLOB blob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            int __result__ = this.lobGetChunkSize(locator);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trim(BLOB lob, long newlen) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(newlen));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobTrim(this.m_nativeState, 113, newlen, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration));
                OracleLog.recursiveTrace = false;
            }
            BLOB lob = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            lob = new BLOB((PhysicalConnection)conn);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobCreateTemporary(this.m_nativeState, 113, cache, duration, (short)0, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + lob);
                OracleLog.recursiveTrace = false;
            }
            BLOB bLOB = lob;
            return bLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTemporary(BLOB temp_lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(temp_lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(temp_lob != null && (locator = temp_lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobFreeTemporary(this.m_nativeState, 113, locator, locator.length, newLocatorHolder));
            temp_lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary(BLOB lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsTemporary(this.m_nativeState, 113, locator, locator.length, flagHolder));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + flagHolder[0]);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = flagHolder[0];
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(BLOB blob, int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(blob != null && (locator = blob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 113, locator, locator.length, mode, newLocatorHolder));
            blob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(BLOB lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 113, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen(BLOB lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 113, locator, locator.length, flagHolder));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + flagHolder[0]);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = flagHolder[0];
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleBlobInputStream oracleBlobInputStream = __result__;
                return oracleBlobInputStream;
            }
            OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleBlobInputStream oracleBlobInputStream = __result__;
            return oracleBlobInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(BLOB blob, int chunkSize, long pos, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize, pos, length);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleBlobInputStream oracleBlobInputStream = __result__;
            return oracleBlobInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream newOutputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleBlobOutputStream __result__ = new OracleBlobOutputStream(blob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleBlobOutputStream oracleBlobOutputStream = __result__;
                return oracleBlobOutputStream;
            }
            OracleBlobOutputStream __result__ = new OracleBlobOutputStream(blob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleBlobOutputStream oracleBlobOutputStream = __result__;
            return oracleBlobOutputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newConversionInputStream(BLOB blob, int conversionType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(conversionType));
                OracleLog.recursiveTrace = false;
            }
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, blob.getBinaryStream(), conversionType);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream oracleConversionInputStream = result;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newConversionReader(BLOB blob, int conversionType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(conversionType));
                OracleLog.recursiveTrace = false;
            }
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            OracleConversionReader result = new OracleConversionReader(this.conversion, blob.getBinaryStream(), conversionType);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionReader oracleConversionReader = result;
            return oracleConversionReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length(CLOB clob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            long __result__ = this.lobLength(locator);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(CLOB clob, String pattern, long start) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            if (pattern == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(clob != null && clob.shareBytes() != null, 54);
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            char[] chars = new char[pattern.length()];
            pattern.getChars(0, chars.length, chars, 0);
            long result = LobPlsqlUtil.hasPattern(clob, chars, start);
            long l2 = result = result == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(CLOB clob, CLOB pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(clob != null && clob.shareBytes() != null, 54);
            this.checkTrue(pattern != null && pattern.shareBytes() != null, 54);
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.isSubLob(clob, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChars(CLOB clob, long offset, int amount, char[] buffer) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(amount) + ", " + OracleLog.argument(buffer));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            if (amount <= 0 || buffer == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            if (amount > buffer.length) {
                amount = buffer.length;
            }
            int result = 0;
            result = this.t2cClobRead(this.m_nativeState, locator, locator.length, offset, amount, buffer, buffer.length, clob.isNCLOB());
            this.checkError(result);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int n3 = result;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putChars(CLOB clob, long offset, char[] buffer, int charsOffset, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(buffer) + ", " + OracleLog.argument(charsOffset) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(offset >= 0L, 68);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            if (buffer == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            byte[][] newLocatorHolder = new byte[1][];
            int result = this.clobWrite(locator, offset, buffer, newLocatorHolder, clob.isNCLOB(), charsOffset, length);
            clob.setLocator(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int n3 = result;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChunkSize(CLOB clob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            int __result__ = this.lobGetChunkSize(locator);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trim(CLOB clob, long newlen) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(newlen));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(clob != null && (locator = clob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobTrim(this.m_nativeState, 112, newlen, locator, locator.length, newLocatorHolder));
            clob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration) + ", " + OracleLog.argument(form_of_use));
                OracleLog.recursiveTrace = false;
            }
            CLOB lob = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            lob = form_of_use == 1 ? new CLOB((PhysicalConnection)conn) : new NCLOB((PhysicalConnection)conn);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobCreateTemporary(this.m_nativeState, 112, cache, duration, form_of_use, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + lob);
                OracleLog.recursiveTrace = false;
            }
            CLOB cLOB = lob;
            return cLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTemporary(CLOB temp_lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(temp_lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(temp_lob != null && (locator = temp_lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobFreeTemporary(this.m_nativeState, 112, locator, locator.length, newLocatorHolder));
            temp_lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary(CLOB lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsTemporary(this.m_nativeState, 112, locator, locator.length, flagHolder));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + flagHolder[0]);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = flagHolder[0];
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(CLOB lob, int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob) + ", " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 112, locator, locator.length, mode, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(CLOB lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 112, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen(CLOB lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 112, locator, locator.length, flagHolder));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + flagHolder[0]);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = flagHolder[0];
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleClobInputStream __result__ = new OracleClobInputStream(clob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleClobInputStream oracleClobInputStream = __result__;
                return oracleClobInputStream;
            }
            OracleClobInputStream __result__ = new OracleClobInputStream(clob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobInputStream oracleClobInputStream = __result__;
            return oracleClobInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream newOutputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleClobOutputStream __result__ = new OracleClobOutputStream(clob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleClobOutputStream oracleClobOutputStream = __result__;
                return oracleClobOutputStream;
            }
            OracleClobOutputStream __result__ = new OracleClobOutputStream(clob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobOutputStream oracleClobOutputStream = __result__;
            return oracleClobOutputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newReader(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleClobReader __result__ = new OracleClobReader(clob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleClobReader oracleClobReader = __result__;
                return oracleClobReader;
            }
            OracleClobReader __result__ = new OracleClobReader(clob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobReader oracleClobReader = __result__;
            return oracleClobReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newReader(CLOB clob, int chunkSize, long pos, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            OracleClobReader __result__ = new OracleClobReader(clob, chunkSize, pos, length);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobReader oracleClobReader = __result__;
            return oracleClobReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer newWriter(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleClobWriter __result__ = new OracleClobWriter(clob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleClobWriter oracleClobWriter = __result__;
                return oracleClobWriter;
            }
            OracleClobWriter __result__ = new OracleClobWriter(clob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobWriter oracleClobWriter = __result__;
            return oracleClobWriter;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(cbk) + ", " + OracleLog.argument(obj));
                OracleLog.recursiveTrace = false;
            }
            this.appCallback = cbk;
            this.appCallbackObject = obj;
            this.checkError(this.t2cRegisterTAFCallback(this.m_nativeState));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int callTAFCallbackMethod(int type, int event) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(event));
                OracleLog.recursiveTrace = false;
            }
            int retCode = 0;
            if (this.appCallback != null) {
                retCode = this.appCallback.callbackFn(this, this.appCallbackObject, type, event);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + retCode);
                OracleLog.recursiveTrace = false;
            }
            int n2 = retCode;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeapAllocSize() throws SQLException {
        try {
            int size;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.lifecycle != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
            }
            if ((size = this.t2cGetHeapAllocSize(this.m_nativeState)) < 0) {
                if (size == -999) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 89");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + size);
                OracleLog.recursiveTrace = false;
            }
            int n2 = size;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOCIEnvHeapAllocSize() throws SQLException {
        try {
            int size;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.lifecycle != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
            }
            if ((size = this.t2cGetOciEnvHeapAllocSize(this.m_nativeState)) < 0) {
                if (size == -999) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                } else {
                    this.checkError(size);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 89");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + size);
                OracleLog.recursiveTrace = false;
            }
            int n2 = size;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final short getClientCharSetId() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            short __result__ = 871;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getDriverCharSetIdFromNLS_LANG(String _ocidll) throws SQLException {
        try {
            short driverCharSetId;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_ocidll));
                OracleLog.recursiveTrace = false;
            }
            if (!isLibraryLoaded) {
                T2CConnection.loadNativeLibrary(_ocidll);
            }
            if ((driverCharSetId = T2CConnection.t2cGetDriverCharSetFromNlsLang()) < 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 8);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + driverCharSetId);
                OracleLog.recursiveTrace = false;
            }
            short s2 = driverCharSetId;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doProxySession(int type, Properties prop) throws SQLException {
        try {
            byte[] cfBytes;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(prop));
                OracleLog.recursiveTrace = false;
            }
            Object roles = null;
            int numProxyRoles = 0;
            this.savedUser = this.userName;
            this.userName = null;
            byte[] dnBytes = cfBytes = new byte[0];
            byte[] pwdBytes = cfBytes;
            byte[] userBytes = cfBytes;
            switch (type) {
                case 1: {
                    this.userName = prop.getProperty("PROXY_USER_NAME");
                    String pwd = prop.getProperty("PROXY_USER_PASSWORD");
                    if (this.userName != null) {
                        userBytes = DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                    }
                    if (pwd == null) break;
                    pwdBytes = DBConversion.stringToDriverCharBytes(pwd, this.m_clientCharacterSet);
                    break;
                }
                case 2: {
                    String distName = prop.getProperty("PROXY_DISTINGUISHED_NAME");
                    if (distName == null) break;
                    dnBytes = DBConversion.stringToDriverCharBytes(distName, this.m_clientCharacterSet);
                    break;
                }
                case 3: {
                    Object certif = prop.get("PROXY_CERTIFICATE");
                    cfBytes = (byte[])certif;
                }
            }
            String[] strRoles = (String[])prop.get("PROXY_ROLES");
            if (strRoles != null) {
                numProxyRoles = strRoles.length;
                roles = new byte[numProxyRoles][];
                for (int i2 = 0; i2 < numProxyRoles; ++i2) {
                    if (strRoles[i2] == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 150");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 150);
                    }
                    roles[i2] = DBConversion.stringToDriverCharBytes(strRoles[i2], this.m_clientCharacterSet);
                }
            }
            this.sqlWarning = this.checkError(this.t2cDoProxySession(this.m_nativeState, type, userBytes, userBytes.length, pwdBytes, pwdBytes.length, dnBytes, dnBytes.length, cfBytes, cfBytes.length, numProxyRoles, (byte[][])roles), this.sqlWarning);
            this.isProxy = true;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeProxySession() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cCloseProxySession(this.m_nativeState));
            this.userName = this.savedUser;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        try {
            int numColumns;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            String tableName = info.getTableName();
            byte[] bytesTableName = DBConversion.stringToDriverCharBytes(tableName, this.m_clientCharacterSet);
            boolean tryAgain = false;
            do {
                if ((numColumns = T2CConnection.t2cDescribeTable(this.m_nativeState, bytesTableName, bytesTableName.length, this.queryMetaData1, this.queryMetaData2, this.queryMetaData1Offset, this.queryMetaData2Offset, this.queryMetaData1Size, this.queryMetaData2Size)) == -1) {
                    this.checkError(numColumns);
                }
                if (numColumns != T2CStatement.T2C_EXTEND_BUFFER) continue;
                tryAgain = true;
                this.reallocateQueryMetaData(this.queryMetaData1Size * 2, this.queryMetaData2Size * 2);
            } while (tryAgain);
            this.processDescribeTableData(numColumns, info);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDescribeTableData(int numColumns, AutoKeyInfo info) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(numColumns) + ", " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            short[] s2 = this.queryMetaData1;
            byte[] c2 = this.queryMetaData2;
            int currentShort = this.queryMetaData1Offset;
            int currentChar = this.queryMetaData2Offset;
            info.allocateSpaceForDescribedData(numColumns);
            for (int i2 = 0; i2 < numColumns; ++i2) {
                short type = s2[currentShort + 0];
                short columnNameLen = s2[currentShort + 6];
                String columnName = T2CConnection.bytes2String(c2, currentChar, columnNameLen, this.conversion);
                short maxLength = s2[currentShort + 1];
                short maxCharLength = s2[currentShort + 11];
                boolean nullable = s2[currentShort + 2] != 0;
                short formOfUse = s2[currentShort + 5];
                short precision = s2[currentShort + 3];
                short scale = s2[currentShort + 4];
                short typeNameLen = s2[currentShort + 12];
                currentChar += columnNameLen;
                currentShort += 13;
                String typeName = null;
                if (typeNameLen > 0) {
                    typeName = T2CConnection.bytes2String(c2, currentChar, typeNameLen, this.conversion);
                    currentChar += typeNameLen;
                }
                info.fillDescribedData(i2, columnName, type, maxCharLength > 0 ? maxCharLength : maxLength, nullable, formOfUse, precision, scale, typeName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(nameSpace) + ", " + OracleLog.argument(attribute) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cSetApplicationContext(this.m_nativeState, nameSpace, attribute, value));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(nameSpace));
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cClearAllApplicationContext(this.m_nativeState, nameSpace));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doStartup(int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cStartupDatabase(this.m_nativeState, mode));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doShutdown(int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cShutdownDatabase(this.m_nativeState, mode));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void loadNativeLibrary(String dll_str) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(dll_str));
                OracleLog.recursiveTrace = false;
            }
            if (dll_str == null || dll_str.equals(OCILIBRARY)) {
                Class<T2CConnection> clazz = T2CConnection.class;
                synchronized (T2CConnection.class) {
                    if (isLibraryLoaded) return;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.loadLibrary(T2CConnection.OCILIBRARY);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                                OracleLog.recursiveTrace = false;
                            }
                            return null;
                        }
                    });
                    isLibraryLoaded = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            Class<T2CConnection> clazz = T2CConnection.class;
            synchronized (T2CConnection.class) {
                try {
                    System.loadLibrary(dll_str);
                    isLibraryLoaded = true;
                }
                catch (SecurityException e2) {
                    if (isLibraryLoaded) return;
                    System.loadLibrary(dll_str);
                    isLibraryLoaded = true;
                }
                return;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkTrue(boolean assertion, int errCode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(assertion) + ", " + OracleLog.argument(errCode));
                OracleLog.recursiveTrace = false;
            }
            if (!assertion) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + errCode);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), errCode);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean useLittleEndianSetCHARBinder() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean __result__ = this.t2cPlatformIsLittleEndian(this.m_nativeState);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pc));
                OracleLog.recursiveTrace = false;
            }
            super.getPropertyForPooledConnection(pc, this.password);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final char[] getCharArray(String s2) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2));
                OracleLog.recursiveTrace = false;
            }
            char[] r2 = null;
            if (s2 == null) {
                r2 = new char[]{};
            } else {
                r2 = new char[s2.length()];
                s2.getChars(0, s2.length(), r2, 0);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + r2);
                OracleLog.recursiveTrace = false;
            }
            char[] cArray = r2;
            return cArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String bytes2String(byte[] bytes, int offset, int size, DBConversion conversion) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(conversion));
                OracleLog.recursiveTrace = false;
            }
            byte[] tmp = new byte[size];
            System.arraycopy(bytes, offset, tmp, 0, size);
            String __result__ = conversion.CharBytesToString(tmp, size);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    static native short t2cGetServerSessionInfo(long var0, Properties var2);

    static native short t2cGetDriverCharSetFromNlsLang();

    native int t2cDescribeError(long var1, T2CError var3, byte[] var4);

    native int t2cCreateState(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, short var11, int var12, short[] var13, byte[] var14, byte[] var15, boolean var16);

    native int t2cLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, int var13, short[] var14, byte[] var15, byte[] var16, boolean var17);

    private native int t2cLogoff(long var1);

    private native int t2cCancel(long var1);

    private native byte t2cGetAsmVolProperty(long var1);

    private native byte t2cGetInstanceType(long var1);

    private native int t2cCreateStatement(long var1, long var3, byte[] var5, int var6, OracleStatement var7, boolean var8, int var9);

    private native int t2cSetAutoCommit(long var1, boolean var3);

    private native int t2cCommit(long var1, int var3);

    private native int t2cRollback(long var1);

    private native int t2cPingDatabase(long var1);

    private native byte[] t2cGetProductionVersion(long var1);

    private native int t2cGetVersionNumber(long var1);

    private native int t2cGetDefaultStreamChunkSize(long var1);

    native int t2cGetFormOfUse(long var1, OracleTypeCLOB var3, byte[] var4, int var5, int var6);

    native long t2cGetTDO(long var1, byte[] var3, int var4, int[] var5);

    native int t2cCreateConnPool(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, short var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native int t2cConnPoolLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9, int var10, int var11, String[] var12, byte[] var13, int var14, byte[] var15, int var16, byte[] var17, int var18, byte[] var19, int var20, byte[] var21, int var22, short[] var23, byte[] var24, byte[] var25);

    native int t2cGetConnPoolInfo(long var1, Properties var3);

    native int t2cSetConnPoolInfo(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    native int t2cPasswordChange(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    protected native byte[] t2cGetConnectionId(long var1);

    native int t2cGetHandles(long var1, long[] var3);

    native int t2cUseConnection(long var1, long var3, long var5, long var7, short[] var9);

    native boolean t2cPlatformIsLittleEndian(long var1);

    native int t2cRegisterTAFCallback(long var1);

    native int t2cGetHeapAllocSize(long var1);

    native int t2cGetOciEnvHeapAllocSize(long var1);

    native int t2cDoProxySession(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, byte[] var10, int var11, int var12, byte[][] var13);

    native int t2cCloseProxySession(long var1);

    static native int t2cDescribeTable(long var0, byte[] var2, int var3, short[] var4, byte[] var5, int var6, int var7, int var8, int var9);

    native int t2cSetApplicationContext(long var1, String var3, String var4, String var5);

    native int t2cClearAllApplicationContext(long var1, String var3);

    native int t2cStartupDatabase(long var1, int var3);

    native int t2cShutdownDatabase(long var1, int var3);

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

