/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.sql.Datum;

class PlsqlIbtBinder
extends Binder {
    Binder thePlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:29_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlsqlIbtBinder() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            PlsqlIbtBinder.init(this);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(Binder x) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            x.type = (short)998;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            PlsqlIbtBindInfo bindInfo = stmt.parameterPlsqlIbt[rank][bindPosition];
            if (clearPriorBindValues) {
                stmt.parameterPlsqlIbt[rank][bindPosition] = null;
            }
            int offset = bindInfo.ibtValueIndex;
            switch (bindInfo.element_internal_type) {
                case 9: {
                    for (int i2 = 0; i2 < bindInfo.curLen; ++i2) {
                        int len = 0;
                        String s2 = (String)bindInfo.arrayData[i2];
                        if (s2 != null) {
                            len = s2.length();
                            if (len > bindInfo.elemMaxLen - 1) {
                                len = bindInfo.elemMaxLen - 1;
                            }
                            s2.getChars(0, len, stmt.ibtBindChars, offset + 1);
                            stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i2] = 0;
                            stmt.ibtBindChars[offset] = (char)(len <<= 1);
                            stmt.ibtBindIndicators[bindInfo.ibtLengthIndex + i2] = (short)(len == 0 ? 3 : (short)(len + 2));
                        } else {
                            stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i2] = -1;
                        }
                        offset += bindInfo.elemMaxLen;
                    }
                    break;
                }
                case 6: {
                    for (int i3 = 0; i3 < bindInfo.curLen; ++i3) {
                        byte[] bytes = null;
                        if (bindInfo.arrayData[i3] != null) {
                            bytes = ((Datum)bindInfo.arrayData[i3]).getBytes();
                        }
                        if (bytes == null) {
                            stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i3] = -1;
                        } else {
                            stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i3] = 0;
                            stmt.ibtBindIndicators[bindInfo.ibtLengthIndex + i3] = (short)(bytes.length + 1);
                            stmt.ibtBindBytes[offset] = (byte)bytes.length;
                            System.arraycopy(bytes, 0, stmt.ibtBindBytes, offset + 1, bytes.length);
                        }
                        offset += bindInfo.elemMaxLen;
                    }
                    break;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PlsqlIbtBinder.logger().log(Level.SEVERE, "Throwing SQLException: 97");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 97);
                    break;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Binder copyingBinder() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, "return: " + this.thePlsqlIbtCopyingBinder);
                OracleLog.recursiveTrace = false;
            }
            Binder binder = this.thePlsqlIbtCopyingBinder;
            return binder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PlsqlIbtBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

