/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFDCNQueryChanges;
import oracle.jdbc.driver.NTFDCNTableChanges;
import oracle.jdbc.driver.OracleLog;

class NTFDCNEvent
extends DatabaseChangeEvent {
    private int notifVersion = 0;
    private int notifRegid = 0;
    private DatabaseChangeEvent.EventType eventType;
    private String databaseName = null;
    private byte[] notifXid = new byte[8];
    private int notifScn1 = 0;
    private int notifScn2 = 0;
    private int numberOfTables = 0;
    private NTFDCNTableChanges[] tcdesc = null;
    private int numberOfQueries = 0;
    private NTFDCNQueryChanges[] qdesc = null;
    private int registrationId;
    private NTFConnection conn;
    private int csid;
    private boolean isReady = false;
    private ByteBuffer dataBuffer;
    private boolean isDeregistrationEvent = false;
    private short databaseVersion;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:27_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFDCNEvent(NTFConnection _conn, short _databaseVersion) throws IOException {
        super(_conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_conn));
                OracleLog.recursiveTrace = false;
            }
            this.conn = _conn;
            this.csid = this.conn.charset.getOracleId();
            int lengthDataHandle = this.conn.readInt();
            byte[] data = new byte[lengthDataHandle];
            this.conn.readBuffer(data, 0, lengthDataHandle);
            this.dataBuffer = ByteBuffer.wrap(data);
            this.databaseVersion = _databaseVersion;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEvent() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte registrationType = this.dataBuffer.get();
            int registrationLength = this.dataBuffer.getInt();
            byte[] registrationBuffer = new byte[registrationLength];
            this.dataBuffer.get(registrationBuffer, 0, registrationLength);
            String registrationString = null;
            try {
                registrationString = new String(registrationBuffer, "UTF-8");
            }
            catch (Exception ex1) {
                // empty catch block
            }
            registrationString = registrationString.replaceFirst("CHNF", "");
            this.registrationId = Integer.parseInt(registrationString);
            byte namespaceType = this.dataBuffer.get();
            int namespaceLength = this.dataBuffer.getInt();
            byte[] namespaceBuffer = new byte[namespaceLength];
            this.dataBuffer.get(namespaceBuffer, 0, namespaceLength);
            byte notificationType = this.dataBuffer.get();
            int notificationLength = this.dataBuffer.getInt();
            if (this.dataBuffer.hasRemaining()) {
                this.notifVersion = this.dataBuffer.getShort();
                this.notifRegid = this.dataBuffer.getInt();
                this.eventType = DatabaseChangeEvent.EventType.getEventType(this.dataBuffer.getInt());
                short notifDatabaseNameLength = this.dataBuffer.getShort();
                byte[] notifDatabaseNameBuffer = new byte[notifDatabaseNameLength];
                this.dataBuffer.get(notifDatabaseNameBuffer, 0, notifDatabaseNameLength);
                try {
                    this.databaseName = new String(notifDatabaseNameBuffer, "UTF-8");
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                this.dataBuffer.get(this.notifXid);
                this.notifScn1 = this.dataBuffer.getInt();
                this.notifScn2 = this.dataBuffer.getShort();
                if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
                    this.numberOfTables = this.dataBuffer.getShort();
                    this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
                    for (int i2 = 0; i2 < this.tcdesc.length; ++i2) {
                        this.tcdesc[i2] = new NTFDCNTableChanges(this.dataBuffer, this.csid);
                    }
                } else if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE) {
                    this.numberOfQueries = this.dataBuffer.getShort();
                    this.qdesc = new NTFDCNQueryChanges[this.numberOfQueries];
                    for (int i3 = 0; i3 < this.numberOfQueries; ++i3) {
                        this.qdesc[i3] = new NTFDCNQueryChanges(this.dataBuffer, this.csid);
                    }
                }
            }
            this.isReady = true;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseName() {
        String string;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.databaseName);
                    OracleLog.recursiveTrace = false;
                }
                string = this.databaseName;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        TableChangeDescription[] tableChangeDescriptionArray;
        block10: {
            block8: {
                TableChangeDescription[] tableChangeDescriptionArray2;
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (!this.isReady) {
                            this.initEvent();
                        }
                        if (this.eventType != DatabaseChangeEvent.EventType.OBJCHANGE) break block8;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.tcdesc);
                            OracleLog.recursiveTrace = false;
                        }
                        tableChangeDescriptionArray2 = this.tcdesc;
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return tableChangeDescriptionArray2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            tableChangeDescriptionArray = null;
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tableChangeDescriptionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryChangeDescription[] getQueryChangeDescription() {
        QueryChangeDescription[] queryChangeDescriptionArray;
        block10: {
            block8: {
                QueryChangeDescription[] queryChangeDescriptionArray2;
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (!this.isReady) {
                            this.initEvent();
                        }
                        if (this.eventType != DatabaseChangeEvent.EventType.QUERYCHANGE) break block8;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.qdesc);
                            OracleLog.recursiveTrace = false;
                        }
                        queryChangeDescriptionArray2 = this.qdesc;
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return queryChangeDescriptionArray2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            queryChangeDescriptionArray = null;
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return queryChangeDescriptionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getTransactionId() {
        byte[] byArray;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.notifXid);
                    OracleLog.recursiveTrace = false;
                }
                byArray = this.notifXid;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTransactionId(boolean isLittleEndian) {
        String string;
        block8: {
            try {
                long xid_seq;
                int xid_slot;
                int xid_undo_seg;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (!isLittleEndian) {
                    xid_undo_seg = (this.notifXid[0] & 0xFF) << 8 | this.notifXid[1] & 0xFF;
                    xid_slot = (this.notifXid[2] & 0xFF) << 8 | this.notifXid[3] & 0xFF;
                    xid_seq = ((this.notifXid[4] & 0xFF) << 24 | (this.notifXid[5] & 0xFF) << 16 | (this.notifXid[6] & 0xFF) << 8 | this.notifXid[7] & 0xFF) & 0xFFFFFFFF;
                } else {
                    xid_undo_seg = (this.notifXid[1] & 0xFF) << 8 | this.notifXid[0] & 0xFF;
                    xid_slot = (this.notifXid[3] & 0xFF) << 8 | this.notifXid[2] & 0xFF;
                    xid_seq = ((this.notifXid[7] & 0xFF) << 24 | (this.notifXid[6] & 0xFF) << 16 | (this.notifXid[5] & 0xFF) << 8 | this.notifXid[4] & 0xFF) & 0xFFFFFFFF;
                }
                String ret = "" + xid_undo_seg + "." + xid_slot + "." + xid_seq;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                string = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEventType(DatabaseChangeEvent.EventType _type) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument((Object)_type));
                OracleLog.recursiveTrace = false;
            }
            if (!this.isReady) {
                this.initEvent();
            }
            this.eventType = _type;
            if (this.eventType == DatabaseChangeEvent.EventType.DEREG) {
                this.isDeregistrationEvent = true;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseChangeEvent.EventType getEventType() {
        DatabaseChangeEvent.EventType eventType;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (Object)((Object)this.eventType));
                    OracleLog.recursiveTrace = false;
                }
                eventType = this.eventType;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeregistrationEvent() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "return: " + this.isDeregistrationEvent);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = this.isDeregistrationEvent;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionInformation() {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.conn.connectionDescription);
                    OracleLog.recursiveTrace = false;
                }
                string = this.conn.connectionDescription;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRegistrationId() {
        int n2;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.registrationId);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.registrationId;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String string;
        block10: {
            try {
                QueryChangeDescription[] qcd;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                StringBuffer sb = new StringBuffer();
                sb.append("Connection information  : " + this.conn.connectionDescription + "\n");
                sb.append("Registration ID         : " + this.registrationId + "\n");
                sb.append("Notification version    : " + this.notifVersion + "\n");
                sb.append("Event type              : " + (Object)((Object)this.eventType) + "\n");
                sb.append("Database name           : " + this.databaseName + "\n");
                TableChangeDescription[] tcd = this.getTableChangeDescription();
                if (tcd != null) {
                    sb.append("Table Change Description (length=" + this.numberOfTables + ")\n");
                    for (int i2 = 0; i2 < tcd.length; ++i2) {
                        sb.append(tcd[i2].toString());
                    }
                }
                if ((qcd = this.getQueryChangeDescription()) != null) {
                    sb.append("Query Change Description (length=" + this.numberOfQueries + ")\n");
                    for (int i3 = 0; i3 < qcd.length; ++i3) {
                        sb.append(qcd[i3].toString());
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + sb.toString());
                    OracleLog.recursiveTrace = false;
                }
                string = sb.toString();
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFDCNEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFDCNEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

