/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.DATE;

abstract class DateTimeCommonAccessor
extends Accessor {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    static final int ORACLE_CENTURY = 0;
    static final int ORACLE_YEAR = 1;
    static final int ORACLE_MONTH = 2;
    static final int ORACLE_DAY = 3;
    static final int ORACLE_HOUR = 4;
    static final int ORACLE_MIN = 5;
    static final int ORACLE_SEC = 6;
    static final int ORACLE_NANO1 = 7;
    static final int ORACLE_NANO2 = 8;
    static final int ORACLE_NANO3 = 9;
    static final int ORACLE_NANO4 = 10;
    static final int ORACLE_TZ1 = 11;
    static final int ORACLE_TZ2 = 12;
    static final int SIZE_DATE = 7;
    static final int MAX_TIMESTAMP_LENGTH = 11;
    static TimeZone epochTimeZone;
    static long epochTimeZoneOffset;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:26_PDT_2008";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    DateTimeCommonAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Time getTime(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            Time result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int off = this.columnIndex + this.byteLength * currentRow;
                TimeZone zone = this.statement.getDefaultTimeZone();
                if (zone != epochTimeZone) {
                    epochTimeZoneOffset = DateTimeCommonAccessor.calculateEpochOffset(zone);
                    epochTimeZone = zone;
                }
                result = new Time((long)this.oracleTime(off) - epochTimeZoneOffset);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Time time = result;
            return time;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Date getDate(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            Date __result__ = this.getDate(currentRow, this.statement.getDefaultCalendar());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Date date = __result__;
            return date;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Date getDate(int currentRow, Calendar cal) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(cal));
                OracleLog.recursiveTrace = false;
            }
            if (cal == null) {
                Date __result__ = this.getDate(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Date date = __result__;
                return date;
            }
            Date result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int off = this.columnIndex + this.byteLength * currentRow;
                int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(year, this.oracleMonth(off), this.oracleDay(off), 0, 0, 0);
                cal.set(14, 0);
                if (year > 0 && cal.isSet(0)) {
                    cal.set(0, 1);
                }
                result = new Date(cal.getTimeInMillis());
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Date date = result;
            return date;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Time getTime(int currentRow, Calendar cal) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(cal));
                OracleLog.recursiveTrace = false;
            }
            if (cal == null) {
                Time __result__ = this.getTime(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Time time = __result__;
                return time;
            }
            Time result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int off = this.columnIndex + this.byteLength * currentRow;
                int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(1, 1970);
                cal.set(2, 0);
                cal.set(5, 1);
                cal.set(11, this.oracleHour(off));
                cal.set(12, this.oracleMin(off));
                cal.set(13, this.oracleSec(off));
                cal.set(14, 0);
                if (year > 0 && cal.isSet(0)) {
                    cal.set(0, 1);
                }
                result = new Time(cal.getTimeInMillis());
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Time time = result;
            return time;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            Timestamp __result__ = this.getTimestamp(currentRow, this.statement.getDefaultCalendar());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Timestamp timestamp = __result__;
            return timestamp;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Timestamp getTimestamp(int currentRow, Calendar cal) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(cal));
                OracleLog.recursiveTrace = false;
            }
            if (cal == null) {
                Timestamp __result__ = this.getTimestamp(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Timestamp timestamp = __result__;
                return timestamp;
            }
            Timestamp result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int off = this.columnIndex + this.byteLength * currentRow;
                int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(year, this.oracleMonth(off), this.oracleDay(off), this.oracleHour(off), this.oracleMin(off), this.oracleSec(off));
                cal.set(14, 0);
                if (year > 0 && cal.isSet(0)) {
                    cal.set(0, 1);
                }
                result = new Timestamp(cal.getTimeInMillis());
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                if (len >= 11) {
                    result.setNanos(this.oracleNanos(off));
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DATE getDATE(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            DATE result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int off = this.columnIndex + this.byteLength * currentRow;
                byte[] data = new byte[7];
                System.arraycopy(this.rowSpaceByte, off, data, 0, 7);
                result = new DATE(data);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            DATE dATE = result;
            return dATE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleYear(int off) {
        try {
            int year;
            int __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__ = (year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100) <= 0 ? year + 1 : year;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleMonth(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.rowSpaceByte[2 + off] - 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleDay(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            byte __result__ = this.rowSpaceByte[3 + off];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleHour(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.rowSpaceByte[4 + off] - 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleMin(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.rowSpaceByte[5 + off] - 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleSec(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.rowSpaceByte[6 + off] - 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleTZ1(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            byte __result__ = this.rowSpaceByte[11 + off];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleTZ2(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            byte __result__ = this.rowSpaceByte[12 + off];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleTime(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            int millisInDay = this.oracleHour(off);
            millisInDay *= 60;
            millisInDay += this.oracleMin(off);
            millisInDay *= 60;
            millisInDay += this.oracleSec(off);
            millisInDay *= 1000;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + millisInDay);
                OracleLog.recursiveTrace = false;
            }
            int n2 = millisInDay;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int oracleNanos(int off) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(off));
                OracleLog.recursiveTrace = false;
            }
            int nanos = (this.rowSpaceByte[7 + off] & 0xFF) << 24;
            nanos |= (this.rowSpaceByte[8 + off] & 0xFF) << 16;
            nanos |= (this.rowSpaceByte[9 + off] & 0xFF) << 8;
            nanos |= this.rowSpaceByte[10 + off] & 0xFF & 0xFF;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + nanos);
                OracleLog.recursiveTrace = false;
            }
            int n2 = nanos;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long computeJulianDay(boolean isGregorian, int year, int month, int date) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(isGregorian) + ", " + OracleLog.argument(year) + ", " + OracleLog.argument(month) + ", " + OracleLog.argument(date));
                OracleLog.recursiveTrace = false;
            }
            boolean isLeap = year % 4 == 0;
            int y = year - 1;
            long julianDay = 365L * (long)y + DateTimeCommonAccessor.floorDivide(y, 4L) + 1721423L;
            if (isGregorian) {
                isLeap = isLeap && (year % 100 != 0 || year % 400 == 0);
                julianDay += DateTimeCommonAccessor.floorDivide(y, 400L) - DateTimeCommonAccessor.floorDivide(y, 100L) + 2L;
            }
            long __result__ = julianDay + (long)date + (long)(isLeap ? LEAP_NUM_DAYS[month] : NUM_DAYS[month]);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long floorDivide(long numerator, long denominator) {
        try {
            long __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(numerator) + ", " + OracleLog.argument(denominator));
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__ = numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l3 = __result__;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long julianDayToMillis(long julian) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(julian));
                OracleLog.recursiveTrace = false;
            }
            long __result__ = (julian - 2440588L) * 86400000L;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long zoneOffset(TimeZone zone, int year, int month, int day, int dow, int millisInDay) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(zone) + ", " + OracleLog.argument(year) + ", " + OracleLog.argument(month) + ", " + OracleLog.argument(day) + ", " + OracleLog.argument(dow) + ", " + OracleLog.argument(millisInDay));
                OracleLog.recursiveTrace = false;
            }
            long __result__ = zone.getOffset(year < 0 ? 0 : 1, year, month, day, dow, millisInDay);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getMillis(int year, int month, int day, int millisInDay, TimeZone zone) {
        try {
            long julianDay;
            long millis;
            boolean isGregorian;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(year) + ", " + OracleLog.argument(month) + ", " + OracleLog.argument(day) + ", " + OracleLog.argument(millisInDay) + ", " + OracleLog.argument(zone));
                OracleLog.recursiveTrace = false;
            }
            if ((isGregorian = year >= 1582) != (millis = ((julianDay = DateTimeCommonAccessor.computeJulianDay(isGregorian, year, month, day)) - 2440588L) * 86400000L) >= -12219292800000L) {
                julianDay = DateTimeCommonAccessor.computeJulianDay(!isGregorian, year, month, day);
                millis = (julianDay - 2440588L) * 86400000L;
            }
            long __result__ = (millis += (long)millisInDay) - DateTimeCommonAccessor.zoneOffset(zone, year, month, day, DateTimeCommonAccessor.julianDayToDayOfWeek(julianDay), millisInDay);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int julianDayToDayOfWeek(long julian) {
        try {
            int dayOfWeek;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(julian));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = dayOfWeek + ((dayOfWeek = (int)((julian + 1L) % 7L)) < 0 ? 8 : 1);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long calculateEpochOffset(TimeZone zone) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(zone));
                OracleLog.recursiveTrace = false;
            }
            long __result__ = DateTimeCommonAccessor.zoneOffset(zone, 1970, 0, 1, 5, 0);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateTimeCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.DateTimeCommonAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

