/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dcn;

import java.util.EventObject;
import java.util.logging.Logger;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.OracleLog;

public abstract class DatabaseChangeEvent
extends EventObject {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:24_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseChangeEvent(Object source) {
        super(source);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatabaseChangeEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(source));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatabaseChangeEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public abstract EventType getEventType();

    public abstract TableChangeDescription[] getTableChangeDescription();

    public abstract QueryChangeDescription[] getQueryChangeDescription();

    public abstract String getConnectionInformation();

    public abstract String getDatabaseName();

    public abstract int getRegistrationId();

    public abstract byte[] getTransactionId();

    public abstract String getTransactionId(boolean var1);

    @Override
    public abstract String toString();

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.dcn");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.dcn.DatabaseChangeEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum EventType {
        NONE(0),
        STARTUP(1),
        SHUTDOWN(2),
        SHUTDOWN_ANY(3),
        DEREG(5),
        OBJCHANGE(6),
        QUERYCHANGE(7);

        private final int code;

        private EventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final EventType getEventType(int code) {
            if (code == STARTUP.getCode()) {
                return STARTUP;
            }
            if (code == SHUTDOWN.getCode()) {
                return SHUTDOWN;
            }
            if (code == SHUTDOWN_ANY.getCode()) {
                return SHUTDOWN_ANY;
            }
            if (code == DEREG.getCode()) {
                return DEREG;
            }
            if (code == OBJCHANGE.getCode()) {
                return OBJCHANGE;
            }
            if (code == QUERYCHANGE.getCode()) {
                return QUERYCHANGE;
            }
            return NONE;
        }
    }
}

