/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.sql.SQLException;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnectionMetaData;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.OracleLog;

public class OracleManagedConnectionMetaData
implements ManagedConnectionMetaData {
    private OracleManagedConnection managedConnection = null;
    private OracleDatabaseMetaData databaseMetaData = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:41_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleManagedConnectionMetaData(OracleManagedConnection omc) throws ResourceException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(omc));
                OracleLog.recursiveTrace = false;
            }
            try {
                this.managedConnection = omc;
                OracleConnection conn = (OracleConnection)omc.getPhysicalConnection();
                this.databaseMetaData = (OracleDatabaseMetaData)conn.getMetaData();
            }
            catch (Exception exc) {
                EISSystemException rexc = new EISSystemException("Exception: " + exc.getMessage());
                rexc.setLinkedException(exc);
                throw rexc;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getEISProductName() throws ResourceException {
        String string;
        block8: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.databaseMetaData.getDatabaseProductName();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            string = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block8;
            OracleLog.recursiveTrace = true;
            OracleManagedConnectionMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
        {
            catch (SQLException exc) {
                try {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    throw rexc;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleManagedConnectionMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getEISProductVersion() throws ResourceException {
        String string;
        block8: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.databaseMetaData.getDatabaseProductVersion();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            string = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block8;
            OracleLog.recursiveTrace = true;
            OracleManagedConnectionMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
        {
            catch (Exception exc) {
                try {
                    EISSystemException rexc = new EISSystemException("Exception: " + exc.getMessage());
                    rexc.setLinkedException(exc);
                    throw rexc;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleManagedConnectionMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public int getMaxConnections() throws ResourceException {
        int n2;
        block8: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.databaseMetaData.getMaxConnections();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            n2 = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block8;
            OracleLog.recursiveTrace = true;
            OracleManagedConnectionMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
        {
            catch (SQLException exc) {
                try {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    throw rexc;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleManagedConnectionMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getUserName() throws ResourceException {
        String string;
        block8: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.databaseMetaData.getUserName();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionMetaData.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            string = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block8;
            OracleLog.recursiveTrace = true;
            OracleManagedConnectionMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
        {
            catch (SQLException exc) {
                try {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    throw rexc;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleManagedConnectionMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.connector");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleManagedConnectionMetaData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

