/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.xml;

import dbtools.DatabaseSession;
import dbtools.SQLPSParam;
import dbtools.SQLStatement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import sqlrunner.base64.Base64;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.generator.SQLCodeGenerator;
import sqlrunner.xml.ImportDescription;
import sqlrunner.xml.SAXStoppedException;

public class TableImportHandler
extends DefaultHandler {
    private static final Logger staticLogger = Logger.getLogger(TableImportHandler.class);
    private Logger logger = staticLogger;
    private ImportDescription impDesc;
    private DatabaseSession session;
    private SQLStatement sqlPsCount;
    private SQLStatement sqlPsInsert;
    private SQLStatement sqlPsUpdate;
    private PreparedStatement psCount;
    private PreparedStatement psInsert;
    private PreparedStatement psUpdate;
    private String tableName;
    private String columnName;
    private String columnCode;
    private final StringBuffer value = new StringBuffer();
    private boolean isFirstElement = true;
    private boolean inRow = false;
    private final HashMap<String, ValueDesc> valueMap = new HashMap();
    private boolean updateEnabled;
    private boolean tableHasPrimaryKey;
    private long countAll;
    private long countCurrDatasets;
    private long countDatasetInserted;
    private long countDatasetUpdated;
    private Timer timer;
    private Locator locator;
    private boolean testOnly = false;
    private int status = -1;
    public static final int COUNT_DS_UNTIL_COMMIT = 100;
    private int countUntilCommit = 0;
    private boolean tableAlreadyDeletedBefore = false;

    TableImportHandler(DatabaseSession session, ImportDescription impDesc, boolean updateEnabled, boolean tableAlreadyDeletedBefore, boolean testOnly) {
        this.session = session;
        this.impDesc = impDesc;
        this.tableName = impDesc.getTable().getName().toLowerCase();
        this.updateEnabled = updateEnabled;
        this.tableHasPrimaryKey = impDesc.getTable().hasPrimaryKeyFields();
        this.testOnly = testOnly;
        this.tableAlreadyDeletedBefore = tableAlreadyDeletedBefore;
        this.logger.debug((Object)("import handler for " + impDesc.toString() + " created..."));
    }

    public void setLogger(Logger instanceLogger) {
        if (instanceLogger == null) {
            throw new IllegalArgumentException("instanceLogger cannot be null");
        }
        this.logger = instanceLogger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void resetToStaticLogger() {
        this.logger = staticLogger;
        if (this.session != null) {
            this.session.resetLoggerToStaticClassLogger();
        }
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXStoppedException("stopped");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("startDocument() - import file " + this.impDesc.getXmlFile().getAbsolutePath()));
        }
        if (this.testOnly) {
            this.logger.info((Object)"import in test only mode");
        }
        if (this.locator == null) {
            this.logger.info((Object)"no xml locator are available");
        }
        try {
            this.sqlPsInsert = SQLCodeGenerator.buildPSInsertSQLStatement(this.impDesc.getTable(), true);
            this.psInsert = this.session.createPreparedStatement(this.sqlPsInsert.getSQL());
            if (this.tableHasPrimaryKey) {
                if (!(this.tableAlreadyDeletedBefore && !this.updateEnabled)) {
                    this.sqlPsCount = SQLCodeGenerator.buildPSCountSQLStatement(this.impDesc.getTable(), true);
                    if (this.sqlPsCount.isSqlCodeValid()) {
                        this.psCount = this.session.createPreparedStatement(this.sqlPsCount.getSQL());
                    } else {
                        this.logger.warn((Object)("no valid count statement (count disabled):" + this.sqlPsCount.getSQL()));
                    }
                }
                this.sqlPsUpdate = SQLCodeGenerator.buildPSUpdateSQLStatement(this.impDesc.getTable(), true);
                if (this.sqlPsUpdate.isSqlCodeValid()) {
                    this.psUpdate = this.session.createPreparedStatement(this.sqlPsUpdate.getSQL());
                } else {
                    this.status = 1;
                    this.logger.warn((Object)("no valid update statement (update disabled):" + this.sqlPsUpdate.getSQL()));
                }
            }
        }
        catch (SQLException e) {
            this.status = 2;
            this.logger.error((Object)("startDocument():" + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (!this.testOnly) {
                this.commit();
            }
            if (this.psInsert != null) {
                this.psInsert.close();
            }
            if (this.psCount != null) {
                this.psCount.close();
            }
            if (this.psUpdate != null) {
                this.psUpdate.close();
            }
        }
        catch (SQLException e) {
            this.status = 2;
            this.logger.error((Object)("endDocument():" + e.getMessage()), (Throwable)e);
            throw new SAXException(e);
        }
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.logger.info((Object)("import finished: " + this.countCurrDatasets + " proceeded, " + this.countDatasetInserted + " inserted, " + this.countDatasetUpdated + " udated, " + (this.countCurrDatasets - this.countDatasetInserted - this.countDatasetUpdated) + " ignored."));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXStoppedException("stopped");
        }
        if (this.isFirstElement) {
            this.isFirstElement = false;
            if (qName.equals("table")) {
                this.logger.info((Object)"parsing import file by generic tag names");
                if (!attributes.getValue("name").equals(this.tableName)) {
                    throw new SAXException("wrong table found in attribute name=" + attributes.getValue("name") + " : " + this.tableName + " expected!");
                }
            } else {
                if (!qName.equals(this.tableName)) {
                    throw new SAXException("wrong table tag found: " + qName + ", tag " + this.tableName + " expected!");
                }
                this.logger.info((Object)"parsing import file by table name as tag name");
            }
        } else {
            this.value.setLength(0);
            if (qName.equals("row")) {
                this.inRow = true;
                this.valueMap.clear();
            } else if (qName.equals("column")) {
                this.columnName = attributes.getValue("name");
                this.columnCode = attributes.getValue("code");
            } else {
                this.columnName = qName;
                this.columnCode = attributes.getValue("code");
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0 && ch != null) {
            this.value.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXStoppedException("stopped");
        }
        if (this.inRow) {
            if (qName.equals("row")) {
                this.storeDataset();
                this.inRow = false;
            } else {
                ValueDesc valueDesc = new ValueDesc();
                valueDesc.code = this.columnCode;
                valueDesc.value = this.value.toString().trim();
                this.valueMap.put(this.columnName.trim(), valueDesc);
            }
        }
    }

    private int countDatasets() {
        int count = -1;
        if (this.sqlPsCount != null && this.sqlPsCount.isSqlCodeValid()) {
            SQLPSParam psParam = null;
            ValueDesc valueDesc = null;
            for (int i = 0; i < this.sqlPsCount.getParams().size(); ++i) {
                psParam = this.sqlPsCount.getParams().get(i);
                valueDesc = this.valueMap.get(psParam.getName().toLowerCase());
                if (valueDesc == null) continue;
                psParam.setValue(valueDesc.value);
                psParam.setValueCode(valueDesc.code);
            }
            if (this.setupParameterValues(this.psCount, this.sqlPsCount)) {
                try {
                    ResultSet rs = this.psCount.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                    rs.close();
                }
                catch (SQLException sqle) {
                    this.status = 2;
                    this.logger.error((Object)("countDatasets() - countDatasets failed: " + sqle.getMessage()), (Throwable)sqle);
                }
            }
        }
        return count;
    }

    private int getCurrentLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return 0;
    }

    private boolean insertDataset() {
        boolean ok = false;
        if (this.sqlPsInsert != null) {
            SQLPSParam psParam = null;
            ValueDesc valueDesc = null;
            for (int i = 0; i < this.sqlPsInsert.getParams().size(); ++i) {
                psParam = this.sqlPsInsert.getParams().get(i);
                valueDesc = this.valueMap.get(psParam.getName().toLowerCase());
                if (valueDesc != null) {
                    psParam.setValue(valueDesc.value);
                    psParam.setValueCode(valueDesc.code);
                    continue;
                }
                psParam.setValue(null);
                psParam.setValueCode(null);
            }
            if (this.setupParameterValues(this.psInsert, this.sqlPsInsert)) {
                try {
                    if (!this.testOnly) {
                        this.psInsert.executeUpdate();
                    }
                    ok = true;
                }
                catch (SQLException sqle) {
                    this.status = 2;
                    this.logger.error((Object)("insertDataset in " + this.tableName + ".xml at line=" + this.locator.getLineNumber() + " failed: " + sqle.getMessage()), (Throwable)sqle);
                }
            }
        }
        return ok;
    }

    private boolean updateDataset() {
        boolean ok = false;
        if (this.sqlPsUpdate != null && this.sqlPsUpdate.isSqlCodeValid()) {
            SQLPSParam psParam = null;
            ValueDesc valueDesc = null;
            for (int i = 0; i < this.sqlPsUpdate.getParams().size(); ++i) {
                psParam = this.sqlPsUpdate.getParams().get(i);
                valueDesc = this.valueMap.get(psParam.getName().toLowerCase());
                if (valueDesc != null) {
                    psParam.setValue(valueDesc.value);
                    psParam.setValueCode(valueDesc.code);
                    continue;
                }
                psParam.setValue(null);
                psParam.setValueCode(null);
            }
            if (this.setupParameterValues(this.psUpdate, this.sqlPsUpdate)) {
                try {
                    if (!this.testOnly) {
                        this.psUpdate.executeUpdate();
                    }
                    ok = true;
                }
                catch (SQLException sqle) {
                    this.status = 2;
                    this.logger.error((Object)("updateDataset in " + this.tableName + ".xml at line=" + this.locator.getLineNumber() + " failed: " + sqle.getMessage()), (Throwable)sqle);
                }
            }
        }
        return ok;
    }

    private void storeDataset() {
        int count = this.countDatasets();
        if (count != -1 && this.updateEnabled && this.tableHasPrimaryKey) {
            if (count == 1) {
                if (this.updateDataset()) {
                    ++this.countDatasetUpdated;
                }
            } else if (count == 0) {
                if (this.insertDataset()) {
                    ++this.countDatasetInserted;
                }
            } else {
                this.status = 2;
                this.logger.error((Object)"storeDataset() - primary key invalid ! more then ONE dataset found for pk condition !", null);
            }
        } else if (count < 1 && this.insertDataset()) {
            ++this.countDatasetInserted;
        }
        ++this.countCurrDatasets;
        if (this.countUntilCommit == 100) {
            if (!this.testOnly) {
                this.commit();
            }
            this.countUntilCommit = -1;
        }
        ++this.countUntilCommit;
    }

    private void commit() {
        this.session.commit();
    }

    private String convertBase64ToText(String base64String) throws UnsupportedEncodingException {
        return Base64.getText(base64String, "UTF-16");
    }

    private byte[] convertBase64ToByteArray(String base64String) throws UnsupportedEncodingException {
        return Base64.decodeFromBase64String(base64String);
    }

    private boolean setupParameterValues(PreparedStatement ps, SQLStatement sqlps) {
        boolean ok = true;
        for (int i = 0; i < sqlps.getParams().size(); ++i) {
            SQLPSParam parameter = sqlps.getParams().get(i);
            String paramValue = parameter.getValue();
            try {
                if (parameter.getBasicType() == BasicDataType.CHARACTER.getId()) {
                    if (paramValue != null && paramValue.length() > 0) {
                        if ("base64".equals(parameter.getValueCode())) {
                            paramValue = this.convertBase64ToText(paramValue);
                        }
                        ps.setString(parameter.getIndex(), paramValue);
                        continue;
                    }
                    ps.setNull(parameter.getIndex(), 12);
                    continue;
                }
                if (BasicDataType.isNumberType(parameter.getBasicType())) {
                    if (paramValue != null && paramValue.length() > 0) {
                        try {
                            ps.setDouble(parameter.getIndex(), Double.parseDouble(paramValue.trim()));
                        }
                        catch (NumberFormatException nfe) {
                            ok = false;
                            this.status = 1;
                            this.logger.error((Object)("error while interpreting value as number " + nfe.getMessage() + " in linenumber " + this.getCurrentLineNumber()));
                        }
                        continue;
                    }
                    ps.setNull(parameter.getIndex(), 2);
                    continue;
                }
                if (BasicDataType.isBooleanType(parameter.getBasicType())) {
                    if (paramValue != null && paramValue.length() > 0) {
                        ps.setBoolean(parameter.getIndex(), Boolean.parseBoolean(paramValue.trim()));
                        continue;
                    }
                    ps.setNull(parameter.getIndex(), 16);
                    continue;
                }
                if (BasicDataType.isDateType(parameter.getBasicType())) {
                    if (paramValue != null) {
                        if (paramValue.length() <= 0) continue;
                        if (parameter.getValueCode() != null && !"string".equals(parameter.getValueCode())) {
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat(parameter.getValueCode());
                                Date d = sdf.parse(paramValue);
                                ps.setTimestamp(parameter.getIndex(), new Timestamp(d.getTime()));
                            }
                            catch (Exception e) {
                                this.logger.error((Object)("invalid date format code=" + parameter.getValueCode() + " in linenumber " + this.getCurrentLineNumber()));
                            }
                            continue;
                        }
                        try {
                            ps.setTimestamp(parameter.getIndex(), new Timestamp(Long.parseLong(paramValue)));
                        }
                        catch (NumberFormatException e) {
                            this.status = 1;
                            this.logger.error((Object)("invalid number format " + e.getMessage() + " in linenumber " + this.getCurrentLineNumber()));
                            ok = false;
                        }
                        continue;
                    }
                    ps.setNull(parameter.getIndex(), 91);
                    continue;
                }
                if (parameter.getBasicType() == BasicDataType.CLOB.getId()) {
                    if (paramValue != null && paramValue.length() > 0) {
                        if ("base64".equals(parameter.getValueCode())) {
                            paramValue = this.convertBase64ToText(paramValue);
                        }
                        ps.setCharacterStream(parameter.getIndex(), (Reader)new StringReader(paramValue), paramValue.length());
                        continue;
                    }
                    ps.setNull(parameter.getIndex(), 2005);
                    continue;
                }
                if (parameter.getBasicType() != BasicDataType.BINARY.getId()) continue;
                if (paramValue != null && paramValue.length() > 0) {
                    if ("base64".equals(parameter.getValueCode())) {
                        byte[] binaryValue = this.convertBase64ToByteArray(paramValue);
                        ps.setBytes(parameter.getIndex(), binaryValue);
                        continue;
                    }
                    try {
                        File f = new File(paramValue);
                        ps.setBinaryStream(parameter.getIndex(), (InputStream)new FileInputStream(f), (int)f.length());
                    }
                    catch (FileNotFoundException fnfe) {
                        this.status = 1;
                        this.logger.error((Object)("setupParameterValues " + fnfe.getMessage()), (Throwable)fnfe);
                        ok = false;
                    }
                    continue;
                }
                ps.setNull(parameter.getIndex(), -4);
                continue;
            }
            catch (SQLException sqle) {
                this.status = 1;
                this.logger.error((Object)("set parameter=" + parameter + "value=" + paramValue + " failed: " + sqle.getMessage() + " in linenumber " + this.getCurrentLineNumber()), (Throwable)sqle);
                ok = false;
                continue;
            }
            catch (UnsupportedEncodingException e) {
                this.status = 1;
                this.logger.error((Object)("set parameter=" + parameter + "value=" + paramValue + " failed: " + e.getMessage() + " in linenumber " + this.getCurrentLineNumber()), (Throwable)e);
                ok = false;
            }
        }
        return ok;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.logger.error((Object)("xml error in line=" + e.getLineNumber() + " column=" + e.getColumnNumber()));
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.logger.error((Object)("xml fatalError in line=" + e.getLineNumber() + " column=" + e.getColumnNumber()));
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn((Object)("xml warning in line=" + e.getLineNumber() + " column=" + e.getColumnNumber()));
    }

    public void setCountAll(long count) {
        this.countAll = count;
    }

    public long getCountAll() {
        return this.countAll;
    }

    public long getCountCurrDatasets() {
        return this.countCurrDatasets;
    }

    public long getCountDatasetInserted() {
        return this.countDatasetInserted;
    }

    public long getCountDatasetUpdated() {
        return this.countDatasetUpdated;
    }

    static class ValueDesc {
        public String value;
        public String code;

        ValueDesc() {
        }
    }
}

