/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.xml;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sqlrunner.LongRunningAction;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.dbext.DatabaseExtension;
import sqlrunner.dbext.DatabaseExtensionFactory;
import sqlrunner.flatfileimport.Importer;
import sqlrunner.flatfileimport.gui.ImportProgressPanel;
import sqlrunner.resources.ApplicationIcons;
import sqlrunner.swinghelper.WindowHelper;
import sqlrunner.xml.ImportDescription;
import sqlrunner.xml.Messages;
import sqlrunner.xml.SAXStoppedException;
import sqlrunner.xml.TableCountImportHandler;
import sqlrunner.xml.TableImportHandler;

public final class ImporterFrame
extends JFrame
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ImporterFrame.class);
    private static final long serialVersionUID = 1L;
    private JTabbedPane jTabbedPane = null;
    private JPanel mainPanel = null;
    private ImportProgressPanel importProgressPanel = null;
    private JPanel panelSchema = null;
    private JLabel labelSchema = null;
    private JTextField jTextFieldSchema = null;
    private JPanel jContentPane = null;
    private transient TableTableModel tableModel = null;
    private JTable jTable = null;
    private JScrollPane scrollPaneList = null;
    private JPanel panelTop = null;
    private JPanel panelTableButtons = null;
    private JPanel panelTables = null;
    private final JButton buttonReload = new JButton();
    private final JButton buttonRemove = new JButton();
    private final JButton buttonUp = new JButton();
    private final JButton buttonDown = new JButton();
    private JPanel panelFile = null;
    private final JTextField textFieldTargetDirectory = new JTextField();
    private final JButton buttonOpenFile = new JButton();
    private final JCheckBox checkBoxDeleteBefore = new JCheckBox();
    private final JCheckBox checkBoxUpdateEnabled = new JCheckBox();
    private final JCheckBox checkBoxTestOnly = new JCheckBox();
    private final JLabel jLabelFile = new JLabel();
    private JPanel panelButton = null;
    private final JButton buttonStart = new JButton();
    private final JButton buttonInterrupt = new JButton();
    private final JButton buttonClose = new JButton();
    private final StatusBar status = new StatusBar();
    private transient DatabaseSession session = null;
    private ConnectionDescription cd;
    private transient XMLImporter importer = null;
    static final String fileSeparator = System.getProperty("file.separator");
    private transient SQLDataModel sqlDataModel;

    public ImporterFrame(MainFrame mainFrame) {
        logger.debug((Object)"ImporterFrame is opening...");
        this.initialize();
        this.pack();
        this.session = new DatabaseSession();
        this.cd = mainFrame.getDatabase().getDatabaseSession().getConnectionDescription();
        this.session.setConnectionDescription(this.cd);
        this.session.connect();
        if (this.session.isConnected()) {
            this.status.infoActionLabel.setText("CONN");
            this.status.infoActionLabel.setToolTipText(this.cd.toString());
        }
        DatabaseExtension ext = DatabaseExtensionFactory.getDatabaseExtension(this.cd);
        this.jTextFieldSchema.setText(ext.getLoginSchema(this.cd));
        this.sqlDataModel = new SQLDataModel(this.cd);
        this.setTitle(Messages.getString("ImporterFrame.title") + " " + this.cd.toString());
        WindowHelper.locateWindowAtMiddle(mainFrame, this);
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("ImporterFrame.title"));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.gridx = 0;
            gb.gridy = 0;
            gb.fill = 1;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
            this.jContentPane.add((Component)this.getJTabbedPane(), gb);
            gb.gridx = 0;
            gb.gridy = 1;
            gb.fill = 2;
            gb.weightx = 1.0;
            gb.weighty = 0.0;
            gb.anchor = 15;
            this.jContentPane.add((Component)this.status, gb);
        }
        return this.jContentPane;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.add(Messages.getString("ImporterFrame.mainpanel"), this.getMainPanel());
            this.jTabbedPane.add(Messages.getString("ImporterFrame.progresspanel"), this.getImportProgressPanel());
        }
        return this.jTabbedPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.gridx = 0;
            gb.gridy = 0;
            gb.fill = 1;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
            this.mainPanel.add((Component)this.getPanelTop(), gb);
            gb.gridx = 0;
            gb.gridy = 10;
            gb.fill = 2;
            gb.weightx = 1.0;
            gb.weighty = 0.0;
            this.mainPanel.add((Component)this.getPanelButton(), gb);
        }
        return this.mainPanel;
    }

    private ImportProgressPanel getImportProgressPanel() {
        if (this.importProgressPanel == null) {
            this.importProgressPanel = new ImportProgressPanel();
        }
        return this.importProgressPanel;
    }

    private JPanel getPanelButton() {
        if (this.panelButton == null) {
            this.panelButton = new JPanel();
            this.buttonStart.setText(Messages.getString("ImporterFrame.start"));
            this.buttonStart.addActionListener(this);
            this.checkBoxTestOnly.setText(Messages.getString("ImporterFrame.testonly"));
            this.buttonInterrupt.setText(Messages.getString("ImporterFrame.cancel"));
            this.buttonInterrupt.addActionListener(this);
            this.buttonInterrupt.setEnabled(false);
            this.buttonClose.setText(Messages.getString("ImporterFrame.close"));
            this.buttonClose.addActionListener(this);
            this.panelButton.add(this.buttonStart);
            this.panelButton.add(this.checkBoxTestOnly);
            this.panelButton.add(this.buttonInterrupt);
            this.panelButton.add(this.buttonClose);
        }
        return this.panelButton;
    }

    private JPanel getPanelFile() {
        if (this.panelFile == null) {
            this.panelFile = new JPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridx = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridwidth = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.gridx = 0;
            this.buttonOpenFile.addActionListener(this);
            this.buttonOpenFile.setIcon(ApplicationIcons.OPEN_GIF);
            this.checkBoxDeleteBefore.setText(Messages.getString("ImporterFrame.deletedatasetsbefore"));
            this.checkBoxUpdateEnabled.setText(Messages.getString("ImporterFrame.updateenabled"));
            this.jLabelFile.setHorizontalAlignment(2);
            this.jLabelFile.setText(Messages.getString("ImporterFrame.directory"));
            this.panelFile.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Messages.getString("ImporterFrame.sourcedir")));
            this.panelFile.setLayout(new GridBagLayout());
            this.panelFile.add((Component)this.textFieldTargetDirectory, gridBagConstraints);
            this.panelFile.add((Component)this.buttonOpenFile, gridBagConstraints1);
            this.panelFile.add((Component)this.checkBoxDeleteBefore, gridBagConstraints2);
            this.panelFile.add((Component)this.checkBoxUpdateEnabled, gridBagConstraints3);
            this.panelFile.add((Component)this.jLabelFile, gridBagConstraints4);
        }
        return this.panelFile;
    }

    private JPanel getPanelTop() {
        if (this.panelTop == null) {
            this.panelTop = new JPanel();
            this.panelTop.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.gridx = 0;
            gb.gridy = 0;
            gb.fill = 2;
            gb.weightx = 1.0;
            this.panelTop.add((Component)this.getPanelSchema(), gb);
            gb.gridy = 1;
            this.panelTop.add((Component)this.getPanelFile(), gb);
            gb.gridy = 2;
            gb.fill = 1;
            gb.weighty = 1.0;
            this.panelTop.add((Component)this.getPanelTables(), gb);
        }
        return this.panelTop;
    }

    private JPanel getPanelSchema() {
        if (this.panelSchema == null) {
            this.panelSchema = new JPanel();
            this.panelSchema.setLayout(new GridBagLayout());
            GridBagConstraints constraint1 = new GridBagConstraints();
            constraint1.anchor = 13;
            constraint1.gridx = 0;
            constraint1.gridy = 0;
            constraint1.insets = new Insets(5, 5, 2, 2);
            GridBagConstraints constraint2 = new GridBagConstraints();
            constraint2.anchor = 10;
            constraint2.gridx = 1;
            constraint2.gridy = 0;
            constraint2.fill = 2;
            constraint2.weightx = 1.0;
            constraint2.insets = new Insets(5, 2, 2, 5);
            this.labelSchema = new JLabel();
            this.labelSchema.setText("Schema");
            this.jTextFieldSchema = new JTextField();
            this.panelSchema.add((Component)this.labelSchema, constraint1);
            this.panelSchema.add((Component)this.jTextFieldSchema, constraint2);
        }
        return this.panelSchema;
    }

    private JPanel getPanelTables() {
        if (this.panelTables == null) {
            this.panelTables = new JPanel();
            this.panelTables.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.gridx = 0;
            gb.gridy = 0;
            gb.fill = 1;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
            this.panelTables.add((Component)this.getScrollPaneList(), gb);
            gb.gridx = 1;
            gb.gridy = 0;
            gb.fill = 0;
            gb.weightx = 0.0;
            gb.weighty = 0.0;
            this.panelTables.add((Component)this.getPanelTableButtons(), gb);
            this.panelTables.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Messages.getString("ImporterFrame.tables")));
        }
        return this.panelTables;
    }

    private JScrollPane getScrollPaneList() {
        if (this.scrollPaneList == null) {
            this.scrollPaneList = new JScrollPane();
            this.scrollPaneList.setViewportView(this.getJTable());
        }
        return this.scrollPaneList;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setSelectionMode(0);
            this.jTable.setModel(this.getTableModel());
        }
        return this.jTable;
    }

    private TableTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new TableTableModel();
        }
        return this.tableModel;
    }

    private JPanel getPanelTableButtons() {
        if (this.panelTableButtons == null) {
            this.panelTableButtons = new JPanel();
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridy = 3;
            gridBagConstraints41.anchor = 17;
            gridBagConstraints41.fill = 2;
            gridBagConstraints41.gridx = 0;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridy = 2;
            gridBagConstraints31.anchor = 17;
            gridBagConstraints31.fill = 2;
            gridBagConstraints31.gridx = 0;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridy = 1;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridx = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridx = 0;
            this.buttonReload.setText(Messages.getString("ImporterFrame.loadtables"));
            this.buttonReload.addActionListener(this);
            this.buttonRemove.setText(Messages.getString("ImporterFrame.remove"));
            this.buttonRemove.addActionListener(this);
            this.buttonUp.setIcon(ApplicationIcons.UP_GIF);
            this.buttonUp.addActionListener(this);
            this.buttonDown.setIcon(ApplicationIcons.DOWN_GIF);
            this.buttonDown.addActionListener(this);
            this.panelTableButtons.setLayout(new GridBagLayout());
            this.panelTableButtons.add((Component)this.buttonReload, gridBagConstraints11);
            this.panelTableButtons.add((Component)this.buttonRemove, gridBagConstraints21);
            this.panelTableButtons.add((Component)this.buttonUp, gridBagConstraints31);
            this.panelTableButtons.add((Component)this.buttonDown, gridBagConstraints41);
        }
        return this.panelTableButtons;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOpenFile) {
            JFileChooser chooser = new JFileChooser();
            String directory = Main.getUserProperty("IMPORT_DATAFILE_DIR", System.getProperty("user.home"));
            File previousDir = new File(directory);
            File parentDir = previousDir.getParentFile();
            if (parentDir != null) {
                chooser.setCurrentDirectory(parentDir);
                chooser.setSelectedFile(previousDir);
            }
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Messages.getString("ImporterFrame.choosesourcedir"));
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                Main.setUserProperty("IMPORT_DATAFILE_DIR", f.toString());
                this.textFieldTargetDirectory.setText(f.getAbsolutePath());
                if (this.tableModel.getRowCount() > 0) {
                    this.status.messageLabel.setText(Messages.getString("ImporterFrame.findmatchingxmlfiles"));
                    this.lookupXmlFiles();
                    this.status.messageLabel.setText(Messages.getString("ImporterFrame.ready"));
                }
            }
        } else if (e.getSource() == this.buttonInterrupt) {
            if (this.importer != null && this.importer.isAlive()) {
                this.importer.interrupt();
            }
        } else if (e.getSource() == this.buttonStart) {
            if (this.textFieldTargetDirectory.getText() != null && this.textFieldTargetDirectory.getText().trim().length() > 0) {
                this.importer = new XMLImporter(this.session, this.textFieldTargetDirectory.getText().trim());
                this.jTabbedPane.setSelectedIndex(1);
                this.getImportProgressPanel().setImporter(this.importer);
                this.getImportProgressPanel().startMonitoring();
                this.importer.start();
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("ImporterFrame.choosesourcedir"), Messages.getString("ImporterFrame.startimport"), 1);
            }
        } else if (e.getSource() == this.buttonReload) {
            MetaDataLoader loader = new MetaDataLoader(this.sqlDataModel, this.tableModel, this.jTextFieldSchema.getText());
            loader.start();
        } else if (e.getSource() == this.buttonRemove) {
            this.tableModel.removeSelected();
        } else if (e.getSource() == this.buttonUp) {
            this.tableModel.moveUp(this.jTable.getSelectedRow());
        } else if (e.getSource() == this.buttonDown) {
            this.tableModel.moveDown(this.jTable.getSelectedRow());
        } else if (e.getSource() == this.buttonClose) {
            this.close();
        }
    }

    public boolean close() {
        if (this.importer != null && this.importer.isRunning()) {
            int answer = JOptionPane.showConfirmDialog(this, Messages.getString("ImporterFrame.continueclosequestion"), Messages.getString("MainFrame.closequestiontitle"), 0, 1);
            if (answer == 0) {
                this.importer.abort();
            } else {
                return false;
            }
        }
        if (this.session != null) {
            this.session.close();
        }
        this.dispose();
        return true;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                if (!this.close()) break;
            }
            default: {
                super.processWindowEvent(e);
            }
        }
    }

    private void lookupXmlFiles() {
        ImportDescription conf = null;
        String directory = this.textFieldTargetDirectory.getText();
        File xmlFile = null;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            conf = this.tableModel.getImportDescriptionAt(i);
            xmlFile = new File(directory + fileSeparator + conf.getTable().getName() + ".xml");
            if (!xmlFile.exists()) continue;
            conf.setXmlFile(xmlFile);
        }
        this.tableModel.fireTableRowsUpdated(0, this.tableModel.getRowCount());
    }

    public void scrollTableToCell(int row) {
        final int y = row * this.jTable.getRowHeight();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImporterFrame.this.scrollPaneList.getVerticalScrollBar().setValue(y);
            }
        });
    }

    private final class XMLImporter
    extends Thread
    implements Importer {
        private Logger importLogger = null;
        private DatabaseSession session;
        private TableImportHandler importHandle = null;
        private String currentAction = null;
        private long countAll = 0L;
        private long startTime;
        private long stopTime;
        private int statusCode = -1;
        private String logFileName = null;
        private FileAppender fileAppender = null;
        private String sourceFileBaseDir = null;

        public XMLImporter(DatabaseSession session, String sourceFileBaseDir) {
            this.session = session;
            this.sourceFileBaseDir = sourceFileBaseDir;
        }

        private FileAppender createFileAppender(String baseDir) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("createFileAppender fileName=" + baseDir));
            }
            SimpleDateFormat sdfLocal = new SimpleDateFormat("yyyy.MM.dd_HH_mm_ss");
            this.logFileName = baseDir + "/xml-import-" + sdfLocal.format(new Date()) + ".log";
            FileAppender appender = new FileAppender();
            appender.setFile(this.logFileName, false, true, 8000);
            PatternLayout layout = new PatternLayout();
            layout.setConversionPattern("%d %-5p %m%n");
            appender.setLayout((Layout)layout);
            appender.setImmediateFlush(true);
            return appender;
        }

        private void closeFileAppender() {
            if (this.fileAppender != null) {
                this.fileAppender.close();
                if (this.importLogger != null) {
                    this.importLogger.removeAppender((Appender)this.fileAppender);
                }
            }
        }

        private void setupLocalLoggerWithFileAppender(String baseDir) throws IOException {
            this.fileAppender = this.createFileAppender(baseDir);
            this.setupLocalLogger(baseDir).addAppender((Appender)this.fileAppender);
        }

        private Logger setupLocalLogger(String baseDir) {
            File f = new File(baseDir);
            this.importLogger = Logger.getLogger((String)(this.getClass().getName() + "-" + f.getName()));
            return this.importLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImporterFrame.this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
            logger.debug((Object)"xml import is starting...");
            this.reset();
            try {
                this.setupLocalLoggerWithFileAppender(this.sourceFileBaseDir);
                this.session.setLogger(this.importLogger);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            ImporterFrame.this.disableEvents(64L);
            LongRunningAction lra = new LongRunningAction(){

                @Override
                public String getName() {
                    return "XML Import";
                }

                @Override
                public void cancel() {
                }

                @Override
                public boolean canBeCanceled() {
                    return false;
                }
            };
            MainFrame.addLongRunningAction(lra);
            try {
                File xmlFile;
                ImportDescription impDesc;
                int i;
                ImporterFrame.this.buttonStart.setEnabled(false);
                ImporterFrame.this.buttonInterrupt.setEnabled(true);
                ImporterFrame.this.buttonClose.setEnabled(false);
                ImporterFrame.this.checkBoxUpdateEnabled.setEnabled(false);
                ImporterFrame.this.checkBoxDeleteBefore.setEnabled(false);
                ImporterFrame.this.checkBoxTestOnly.setEnabled(false);
                ((ImporterFrame)ImporterFrame.this).status.infoActionLabel.setBackground(Color.red);
                if (ImporterFrame.this.checkBoxDeleteBefore.isSelected()) {
                    for (i = ImporterFrame.this.tableModel.getRowCount() - 1; i >= 0 && !this.isInterrupted(); --i) {
                        impDesc = ImporterFrame.this.tableModel.getImportDescriptionAt(i);
                        xmlFile = impDesc.getXmlFile();
                        if (xmlFile == null || !xmlFile.exists()) continue;
                        if (!ImporterFrame.this.checkBoxTestOnly.isSelected()) {
                            this.currentAction = Messages.getString("ImporterFrame.statusdelete") + impDesc.getTable().getName() + "...";
                            this.importLogger.info((Object)("delete datasets from table " + impDesc.getTable().getName()));
                            this.session.executeUpdate("delete from " + impDesc.getTable().getName());
                            if (!this.session.isSuccessful()) {
                                this.session.rollback();
                                this.importLogger.error((Object)("delete all datasets for table " + impDesc.getTable().getName() + " failed:" + this.session.getLastErrorMessage()));
                                continue;
                            }
                            this.session.commit();
                            continue;
                        }
                        this.currentAction = Messages.getString("ImporterFrame.testOnly") + ' ' + impDesc.getTable().getName();
                    }
                }
                for (i = 0; !(i >= ImporterFrame.this.tableModel.getRowCount() || this.isInterrupted() || (xmlFile = (impDesc = ImporterFrame.this.tableModel.getImportDescriptionAt(i)).getXmlFile()) != null && xmlFile.exists() && !this.processImport(impDesc)); ++i) {
                }
                ImporterFrame.this.buttonStart.setEnabled(true);
                ImporterFrame.this.buttonInterrupt.setEnabled(false);
                ImporterFrame.this.buttonClose.setEnabled(true);
                ImporterFrame.this.checkBoxUpdateEnabled.setEnabled(true);
                ImporterFrame.this.checkBoxDeleteBefore.setEnabled(true);
                ImporterFrame.this.checkBoxTestOnly.setEnabled(true);
                ((ImporterFrame)ImporterFrame.this).status.infoActionLabel.setBackground(Color.lightGray);
            }
            finally {
                MainFrame.removeLongRunningAction(lra);
            }
            ImporterFrame.this.enableEvents(64L);
            logger.debug((Object)"xml import are finished");
            this.closeFileAppender();
            ImporterFrame.this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
        }

        public boolean processImport(ImportDescription impDesc) {
            this.stopTime = 0L;
            this.countAll = 0L;
            boolean ok = true;
            this.importLogger.info((Object)("#### import file " + impDesc.getXmlFile().getAbsolutePath() + " in table " + impDesc.getTable()));
            try {
                SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
                TableCountImportHandler counterHandle = new TableCountImportHandler(impDesc);
                counterHandle.setLogger(this.importLogger);
                this.importHandle = new TableImportHandler(this.session, impDesc, ImporterFrame.this.checkBoxUpdateEnabled.isSelected(), ImporterFrame.this.checkBoxDeleteBefore.isSelected(), ImporterFrame.this.checkBoxTestOnly.isSelected());
                this.importHandle.setLogger(this.importLogger);
                if (impDesc.getXmlFile() != null) {
                    if (!ImporterFrame.this.importProgressPanel.isMonitorRunning()) {
                        ImporterFrame.this.importProgressPanel.startMonitoring();
                    }
                    this.currentAction = Messages.getString("ImporterFrame.countdatasets") + " " + impDesc.getTable().getName();
                    BufferedInputStream is1 = new BufferedInputStream(new FileInputStream(impDesc.getXmlFile()), 100000);
                    saxParser.parse((InputStream)is1, (DefaultHandler)counterHandle);
                    is1.close();
                    this.countAll = counterHandle.getCountCurrDatasets();
                    this.importLogger.info((Object)("file contains " + this.countAll + " datasets"));
                    this.currentAction = Messages.getString("ImporterFrame.startimport") + " " + impDesc.getTable().getName();
                    this.startTime = System.currentTimeMillis();
                    BufferedInputStream is2 = new BufferedInputStream(new FileInputStream(impDesc.getXmlFile()), 100000);
                    saxParser.parse((InputStream)is2, (DefaultHandler)this.importHandle);
                    is2.close();
                }
            }
            catch (IOException e1) {
                ok = false;
                this.statusCode = 2;
                this.importLogger.error((Object)e1);
            }
            catch (ParserConfigurationException e) {
                ok = false;
                this.statusCode = 2;
                this.importLogger.error((Object)e);
            }
            catch (SAXStoppedException e) {
                this.importLogger.info((Object)("stop performed " + e.getMessage()));
                this.statusCode = 2;
                ok = false;
            }
            catch (SAXException e) {
                ok = false;
                this.statusCode = 2;
                this.importLogger.error((Object)e);
            }
            catch (FactoryConfigurationError e) {
                ok = false;
                this.statusCode = 2;
                this.importLogger.error((Object)e);
            }
            this.stopTime = System.currentTimeMillis();
            return ok;
        }

        @Override
        public long getCountMaxInput() {
            return this.countAll;
        }

        @Override
        public long getCountCurrInput() {
            if (this.importHandle != null) {
                return this.importHandle.getCountCurrDatasets();
            }
            return 0L;
        }

        @Override
        public long getCountInserts() {
            if (this.importHandle != null) {
                return this.importHandle.getCountDatasetInserted();
            }
            return 0L;
        }

        @Override
        public long getCountUpdates() {
            if (this.importHandle != null) {
                return this.importHandle.getCountDatasetUpdated();
            }
            return 0L;
        }

        @Override
        public long getCountIgnored() {
            if (this.importHandle != null) {
                return this.importHandle.getCountCurrDatasets() - this.importHandle.getCountDatasetInserted() - this.importHandle.getCountDatasetUpdated();
            }
            return 0L;
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public long getStopTime() {
            return this.stopTime;
        }

        @Override
        public boolean isStopped() {
            return this.stopTime > 0L;
        }

        @Override
        public boolean isRunning() {
            return this.stopTime == 0L;
        }

        @Override
        public int getStatusCode() {
            if (this.importHandle != null) {
                return this.importHandle.getStatus();
            }
            return this.statusCode;
        }

        @Override
        public void abort() {
            logger.info((Object)"abort");
            this.interrupt();
        }

        @Override
        public String getLogFileName() {
            return null;
        }

        @Override
        public String getCurrentAction() {
            return this.currentAction;
        }

        public void reset() {
            this.importHandle = null;
            this.startTime = 0L;
            this.stopTime = 0L;
            this.countAll = 0L;
            this.currentAction = null;
            this.statusCode = -1;
        }

        @Override
        public Object getLastValue(String columnName) {
            return null;
        }
    }

    private class MetaDataLoader
    extends Thread {
        private SQLDataModel sqlDataModel;
        private TableTableModel tableModel;
        private String currSchemaName;

        MetaDataLoader(SQLDataModel sqlDataModel, TableTableModel tableModel, String currSchemaName) {
            this.sqlDataModel = sqlDataModel;
            this.tableModel = tableModel;
            this.currSchemaName = currSchemaName;
        }

        @Override
        public void run() {
            logger.info((Object)"load metadata...");
            ((ImporterFrame)ImporterFrame.this).status.infoActionLabel.setBackground(Color.red);
            ((ImporterFrame)ImporterFrame.this).status.messageLabel.setText(Messages.getString("ImporterFrame.deleteoldlist"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"clear previous list...");
            }
            this.tableModel.clear();
            ((ImporterFrame)ImporterFrame.this).status.messageLabel.setText(Messages.getString("ImporterFrame.loadschemas"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"load schemas...");
            }
            this.sqlDataModel.loadSchemas();
            ((ImporterFrame)ImporterFrame.this).status.messageLabel.setText(Messages.getString("ImporterFrame.38"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"load tables...");
            }
            SQLSchema sqlSchema = this.sqlDataModel.getSchema(this.currSchemaName);
            this.sqlDataModel.loadTables(sqlSchema);
            SQLTable sqlTable = null;
            ImportDescription impDesc = null;
            for (int i = 0; i < sqlSchema.getTableCount(); ++i) {
                sqlTable = sqlSchema.getTableAt(i);
                if (sqlTable.getType().equals("VIEW")) continue;
                impDesc = new ImportDescription();
                impDesc.setTable(sqlTable);
                this.tableModel.add(impDesc);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("add table " + impDesc));
            }
            if (ImporterFrame.this.textFieldTargetDirectory.getText() != null && ImporterFrame.this.textFieldTargetDirectory.getText().length() > 1) {
                ((ImporterFrame)ImporterFrame.this).status.messageLabel.setText(Messages.getString("ImporterFrame.findmatchingxmlfiles"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"find matching XML files...");
                }
                ImporterFrame.this.lookupXmlFiles();
            }
            ((ImporterFrame)ImporterFrame.this).status.messageLabel.setText(Messages.getString("ImporterFrame.ready"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ready");
            }
            ((ImporterFrame)ImporterFrame.this).status.infoActionLabel.setBackground(Color.lightGray);
        }
    }

    private class TableTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final Vector<ImportDescription> impDescs = new Vector();

        private TableTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.impDescs.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Messages.getString("ImporterFrame.table");
                }
                case 1: {
                    return Messages.getString("ImporterFrame.xmlfile");
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                default: 
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ImportDescription impDesc = this.impDescs.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return impDesc.getTable().getName();
                }
                case 1: {
                    if (impDesc.getXmlFile() != null) {
                        return impDesc.getXmlFile().getName();
                    }
                    return "";
                }
            }
            return null;
        }

        public ImportDescription getImportDescriptionAt(int rowIndex) {
            return this.impDescs.get(rowIndex);
        }

        public void add(ImportDescription desc) {
            this.impDescs.add(desc);
            this.fireTableRowsInserted(this.impDescs.size(), this.impDescs.size());
        }

        public void add(int pos, ImportDescription desc) {
            this.impDescs.add(pos, desc);
            this.fireTableRowsInserted(pos, pos);
        }

        public void moveUp(int currPos) {
            if (currPos != -1) {
                ImportDescription desc = this.impDescs.get(currPos);
                if (currPos > 0) {
                    this.removeAt(currPos);
                    this.add(--currPos, desc);
                    ImporterFrame.this.jTable.setRowSelectionInterval(currPos, currPos);
                    ImporterFrame.this.scrollTableToCell(currPos);
                }
            }
        }

        public void moveDown(int currPos) {
            if (currPos != -1) {
                ImportDescription desc = this.impDescs.get(currPos);
                if (currPos < this.impDescs.size() - 1) {
                    this.removeAt(currPos);
                    this.add(++currPos, desc);
                    ImporterFrame.this.jTable.setRowSelectionInterval(currPos, currPos);
                    ImporterFrame.this.scrollTableToCell(currPos);
                }
            }
        }

        public void removeAt(int index) {
            this.impDescs.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void removeSelected() {
            int[] indexArray = ImporterFrame.this.jTable.getSelectedRows();
            for (int i = 0; i < indexArray.length; ++i) {
                this.removeAt(indexArray[i]);
            }
        }

        public void clear() {
            int size = this.impDescs.size();
            this.impDescs.clear();
            this.fireTableRowsDeleted(0, size);
        }
    }

    static class StatusBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JLabel messageLabel = new FixedLabel();
        public JLabel infoActionLabel = new FixedLabel();
        static final int INFO_ACTION_WIDTH = 60;
        static final int STATUS_HEIGHT = 25;

        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
            this.messageLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.messageLabel.setForeground(Color.black);
            this.infoActionLabel.setPreferredSize(new Dimension(60, 25));
            this.infoActionLabel.setOpaque(true);
            this.infoActionLabel.setText("DISC");
            this.infoActionLabel.setToolTipText(Messages.getString("ImporterFrame.notconnected"));
            this.infoActionLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.infoActionLabel.setForeground(Color.black);
            this.add(this.messageLabel);
            this.add(this.infoActionLabel);
            this.messageLabel.addPropertyChangeListener(new MeldungPropertyChangeListener());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int meldungBreite = this.getWidth() - 60;
            this.messageLabel.setPreferredSize(new Dimension(meldungBreite, 25));
            this.remove(this.messageLabel);
            this.add(this.messageLabel, null, 0);
            this.doLayout();
        }

        private class MeldungPropertyChangeListener
        implements PropertyChangeListener {
            private MeldungPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StatusBar.this.messageLabel.setToolTipText(StatusBar.this.messageLabel.getText());
            }
        }

        private static class FixedLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        }
    }
}

