/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.talend;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sqlrunner.FileOpenChooserPanel;
import sqlrunner.flatfileimport.DatasetProvider;
import sqlrunner.flatfileimport.FieldTokenizer;
import sqlrunner.flatfileimport.FileImporter;
import sqlrunner.swinghelper.WindowHelper;
import sqlrunner.talend.Column;
import sqlrunner.talend.Messages;
import sqlrunner.talend.SchemaUtil;

public class SchemaImportFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(SchemaImportFrame.class);
    private static final long serialVersionUID = 1L;
    private FileOpenChooserPanel sourceFileChooser;
    private FileOpenChooserPanel targetFileChooser;
    private JButton buttonStart;
    private JButton buttonCancel;
    private transient Thread converterThread = null;
    private JLabel labelStatus = new JLabel();

    public SchemaImportFrame() {
        this.initialize();
        this.pack();
        WindowHelper.checkAndCorrectWindowBounds(this);
        this.setDefaultCloseOperation(2);
    }

    private void initialize() {
        this.setTitle(Messages.getString("SchemaImportFrame.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.getContentPane().add((Component)new JLabel(Messages.getString("SchemaImportFrame.sourceFile")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.getSourceFileChooser(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.getContentPane().add((Component)new JLabel(Messages.getString("SchemaImportFrame.targetFile")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.getTargetFileChooser(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.getPanelButtons(), gbc);
    }

    private FileOpenChooserPanel getSourceFileChooser() {
        if (this.sourceFileChooser == null) {
            this.sourceFileChooser = new FileOpenChooserPanel(Messages.getString("SchemaImportFrame.sourceFile"));
            this.sourceFileChooser.setAsOpenFileChooser();
        }
        return this.sourceFileChooser;
    }

    private FileOpenChooserPanel getTargetFileChooser() {
        if (this.targetFileChooser == null) {
            this.targetFileChooser = new FileOpenChooserPanel(Messages.getString("SchemaImportFrame.targetFile"));
            this.targetFileChooser.setAsSaveFileChooser();
        }
        return this.targetFileChooser;
    }

    private JPanel getPanelButtons() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(400, 50));
        panel.setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 10;
        panel.add((Component)this.getLabelStatus(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.getButtonStart(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.getButtonCancel(), gbc);
        return panel;
    }

    private JLabel getLabelStatus() {
        if (this.labelStatus == null) {
            this.labelStatus = new JLabel();
            this.labelStatus.setHorizontalAlignment(0);
            this.labelStatus.setText("not started");
        }
        return this.labelStatus;
    }

    private JButton getButtonStart() {
        if (this.buttonStart == null) {
            this.buttonStart = new JButton();
            this.buttonStart.setText(Messages.getString("SchemaImportFrame.start"));
            this.buttonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SchemaImportFrame.this.startConversion();
                    SchemaImportFrame.this.buttonCancel.setEnabled(true);
                    SchemaImportFrame.this.buttonStart.setEnabled(false);
                }
            });
        }
        return this.buttonStart;
    }

    private JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new JButton();
            this.buttonCancel.setEnabled(false);
            this.buttonCancel.setText(Messages.getString("SchemaImportFrame.cancel"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SchemaImportFrame.this.cancelConversion();
                    SchemaImportFrame.this.buttonCancel.setEnabled(false);
                    SchemaImportFrame.this.buttonStart.setEnabled(true);
                }
            });
        }
        return this.buttonCancel;
    }

    private void cancelConversion() {
        if (this.converterThread != null) {
            this.converterThread.interrupt();
        }
    }

    private Properties loadImportConfig() {
        Properties importConfig = new Properties();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"load look and feels from archive");
            }
            Object dummy = new Object();
            String res = "/" + SchemaImportFrame.class.getPackage().getName().replace(".", "/") + "/talend_schema.importconfig";
            logger.debug((Object)("Load import config from:" + res));
            InputStream is = dummy.getClass().getResourceAsStream(res);
            importConfig.load(is);
            is.close();
        }
        catch (Exception e) {
            logger.error((Object)("loadImportConfig: " + e.getMessage()), (Throwable)e);
        }
        return importConfig;
    }

    private Column buildColumn(FieldTokenizer ft) throws Exception {
        Column column = new Column();
        Object value = null;
        int index = -1;
        try {
            value = ft.getData(++index);
            column.setName((String)value);
            value = ft.getData(++index);
            if (value != null) {
                column.setKey((Boolean)value);
            }
            if ((value = ft.getData(++index)) != null) {
                column.setNullable((Boolean)value);
            }
            value = ft.getData(++index);
            column.setDataType((String)value);
            value = ft.getData(++index);
            if (value != null) {
                column.setLength(((Number)value).intValue());
            }
            if ((value = ft.getData(++index)) != null) {
                column.setPrecision(((Number)value).intValue());
            }
            value = ft.getData(++index);
            column.setPattern((String)value);
            value = ft.getData(++index);
            column.setDbType((String)value);
            value = ft.getData(++index);
            column.setComment((String)value);
        }
        catch (Throwable t) {
            throw new Exception("Failed to extract field index:" + index + " value:" + value + " failure:" + t.getMessage(), t);
        }
        return column;
    }

    private void startConversion() {
        if (this.converterThread != null) {
            this.converterThread.interrupt();
        }
        final File source = this.sourceFileChooser.getSelectedFile();
        final File target = this.targetFileChooser.getSelectedFile();
        if (source != null && source.canRead() && target != null) {
            this.converterThread = new Thread(){

                @Override
                public void run() {
                    int lineNumber = 0;
                    try {
                        FileImporter fi = new FileImporter();
                        fi.setupLoggerAsStaticClassLogger();
                        fi.initConfig(SchemaImportFrame.this.loadImportConfig());
                        final DatasetProvider dp = fi.createDatasetProvider(source, true, "xls", fi.getImportAttributes());
                        FieldTokenizer ft = dp.createParser();
                        ft.setFieldDescriptions(fi.getFieldDescriptions());
                        ArrayList<Column> list = new ArrayList<Column>();
                        Timer timer = new Timer();
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SchemaImportFrame.this.labelStatus.setText(Messages.getString("SchemaImportFrame.convert") + (dp != null ? dp.getCurrentRowNum() : 0L));
                                    }
                                });
                            }
                        }, 0L, 1000L);
                        boolean firstLoop = true;
                        long currentRowsToSkip = fi.getImportAttributes().getCountSkipRows();
                        while (true) {
                            ++lineNumber;
                            Object rawdata = dp.getNextDataset();
                            if (fi.getImportAttributes().getCountSkipRows() > 0L && currentRowsToSkip > 0L) {
                                --currentRowsToSkip;
                                continue;
                            }
                            if (fi.getImportAttributes().isSkipFirstRow() && firstLoop) {
                                firstLoop = false;
                                continue;
                            }
                            if (rawdata == null || Thread.currentThread().isInterrupted() || !ft.parseRawData(rawdata)) break;
                            list.add(SchemaImportFrame.this.buildColumn(ft));
                        }
                        timer.cancel();
                        SchemaUtil su = new SchemaUtil();
                        su.writeSchemaFile(target, list);
                    }
                    catch (Exception e) {
                        String message = "Import Schema file in line:" + lineNumber + " failed:" + e.getMessage();
                        logger.error((Object)message, (Throwable)e);
                        JOptionPane.showMessageDialog(SchemaImportFrame.this.getContentPane(), message, Messages.getString("SchemaImportFrame.title"), 0);
                    }
                    SchemaImportFrame.this.labelStatus.setText(Messages.getString("SchemaImportFrame.finished"));
                    SchemaImportFrame.this.buttonStart.setEnabled(true);
                    SchemaImportFrame.this.buttonCancel.setEnabled(false);
                }
            };
            this.converterThread.start();
        }
    }
}

