/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.swinghelper;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WindowHelper {
    private static Rectangle virtualScreenBounds = null;
    private static boolean enableWindowPositioning = true;
    private static int desktopPanelHeight = 30;
    private static ArrayList<Rectangle> listScreens = new ArrayList();

    private WindowHelper() {
    }

    public static void enableWindowPositioning(boolean enable) {
        enableWindowPositioning = enable;
        if (enable) {
            System.setProperty("java.awt.Window.locationByPlatform", "false");
        } else {
            System.setProperty("java.awt.Window.locationByPlatform", "true");
        }
    }

    public static boolean isWindowPositioningEnabled() {
        return enableWindowPositioning;
    }

    public static void init() {
        virtualScreenBounds = WindowHelper.retrieveVirtualGraphicsInfo();
    }

    private static void checkState() {
        if (virtualScreenBounds == null) {
            WindowHelper.init();
        }
    }

    public static Rectangle retrieveVirtualGraphicsInfo() {
        Rectangle bounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsDevice gd = null;
        for (int j = 0; j < gs.length; ++j) {
            gd = gs[j];
            Rectangle gdBounds = gd.getDefaultConfiguration().getBounds();
            bounds = bounds.union(gdBounds);
            listScreens.add(gdBounds);
        }
        return bounds;
    }

    public static int getAllScreenWidth() {
        WindowHelper.checkState();
        return WindowHelper.virtualScreenBounds.width;
    }

    public static int getAllScreenHeight() {
        WindowHelper.checkState();
        return WindowHelper.virtualScreenBounds.height;
    }

    public static Rectangle getCurrentScreenBounds(Window window) {
        WindowHelper.checkState();
        for (Rectangle r : listScreens) {
            if (!r.contains(window.getLocation())) continue;
            return r;
        }
        return null;
    }

    public static void locateAtRightSideOfScreen(Rectangle r, Window window) {
        int x = r.x + r.width - window.getWidth();
        int y = r.y;
        int height = r.height;
        int width = window.getWidth();
        window.setBounds(x, y, width, height);
    }

    public static void locateAtLeftSideOfScreen(Rectangle r, Window window) {
        int x = r.x;
        int y = r.y;
        int height = r.height;
        int width = window.getWidth();
        window.setBounds(x, y, width, height);
    }

    public static void checkAndCorrectWindowBounds(Window window) {
        WindowHelper.checkState();
        boolean mustCorrectWindow = false;
        Point windowLocation = window.getLocation();
        if (WindowHelper.checkLocation(windowLocation)) {
            mustCorrectWindow = true;
        }
        int newHeight = window.getHeight();
        if (window.getHeight() + Math.abs(windowLocation.y) > WindowHelper.virtualScreenBounds.height) {
            newHeight = WindowHelper.virtualScreenBounds.height - windowLocation.y - desktopPanelHeight;
            mustCorrectWindow = true;
        }
        int newWidth = window.getWidth();
        if (window.getWidth() + Math.abs(windowLocation.x) > WindowHelper.virtualScreenBounds.width) {
            newWidth = WindowHelper.virtualScreenBounds.width - windowLocation.x;
            mustCorrectWindow = true;
        }
        if (mustCorrectWindow) {
            window.setBounds(windowLocation.x, windowLocation.y, newWidth, newHeight);
        }
    }

    public static void arrangeWindowsHorizontal(List<? extends Window> listWindows) {
        int count = listWindows.size();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int windowHeight = screen.height / count;
        for (int i = 0; i < count; ++i) {
            Window window = listWindows.get(i);
            window.setBounds(0, windowHeight * i, screen.width, windowHeight);
            window.validate();
        }
    }

    public static void arrangeWindowsVertical(List<? extends Window> listWindows) {
        int count = listWindows.size();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int windowWidth = screen.width / count;
        for (int i = 0; i < count; ++i) {
            Window window = listWindows.get(i);
            window.setBounds(windowWidth * i, 0, windowWidth, screen.height);
            WindowHelper.checkAndCorrectWindowBounds(window);
            window.validate();
        }
    }

    public static void arrangeWindowsOverlapped(List<? extends Window> listWindows, Window topWindow, int defWidth, int defHeight) {
        int i;
        Window window = null;
        for (i = 0; i < listWindows.size(); ++i) {
            window = listWindows.get(i);
            if (window == topWindow) continue;
            window.setBounds(i * 50, i * 20, defWidth, defHeight);
            WindowHelper.checkAndCorrectWindowBounds(window);
            window.validate();
            window.requestFocus();
        }
        topWindow.setBounds(++i * 50, i * 20, defWidth, defHeight);
    }

    public static void locateWindowAtRightSide(Window parent, Window window) {
        WindowHelper.checkState();
        if (enableWindowPositioning) {
            int deltaY;
            int x = parent.getBounds().x + parent.getBounds().width;
            int y = parent.getBounds().y;
            int deltaX = WindowHelper.virtualScreenBounds.width - x + WindowHelper.virtualScreenBounds.x - window.getWidth();
            if (deltaX < 0) {
                x += deltaX;
            }
            if ((deltaY = WindowHelper.virtualScreenBounds.height - y + WindowHelper.virtualScreenBounds.y - window.getHeight() + desktopPanelHeight) < 0) {
                y += deltaY;
            }
            int width = window.getSize().width;
            int height = parent.getHeight();
            window.setBounds(x, y, width, height);
            WindowHelper.checkAndCorrectWindowBounds(window);
        }
    }

    public static void locateWindowAtRightSideWithin(Window parent, Window window, int xOffset) {
        WindowHelper.checkState();
        if (enableWindowPositioning) {
            int deltaY;
            int x = parent.getBounds().x + parent.getBounds().width - window.getWidth() + xOffset;
            int y = parent.getBounds().y;
            int deltaX = WindowHelper.virtualScreenBounds.width - x + WindowHelper.virtualScreenBounds.x - window.getWidth();
            if (deltaX < 0) {
                x += deltaX;
            }
            if ((deltaY = WindowHelper.virtualScreenBounds.height - y + WindowHelper.virtualScreenBounds.y - window.getHeight() + desktopPanelHeight) < 0) {
                y += deltaY;
            }
            int width = window.getSize().width;
            int height = parent.getHeight();
            window.setBounds(x, y, width, height);
            WindowHelper.checkAndCorrectWindowBounds(window);
        }
    }

    public static void locateWindowAtLeftSideWithin(Window parent, Window window, int xOffset) {
        WindowHelper.checkState();
        if (enableWindowPositioning) {
            int deltaY;
            int x = parent.getBounds().x - (parent.getBounds().width + xOffset);
            int y = parent.getBounds().y;
            int deltaX = WindowHelper.virtualScreenBounds.width - x + WindowHelper.virtualScreenBounds.x - window.getWidth();
            if (deltaX < 0) {
                x += deltaX;
            }
            if ((deltaY = WindowHelper.virtualScreenBounds.height - y + WindowHelper.virtualScreenBounds.y - window.getHeight() + desktopPanelHeight) < 0) {
                y += deltaY;
            }
            int width = window.getSize().width;
            int height = parent.getHeight();
            window.setBounds(x, y, width, height);
            WindowHelper.checkAndCorrectWindowBounds(window);
        }
    }

    public static void locateWindowAtMiddle(Window parent, Window window) {
        WindowHelper.checkState();
        if (enableWindowPositioning) {
            int deltaY;
            int x = parent.getX() + (parent.getWidth() >> 1) - (window.getWidth() >> 1);
            int y = parent.getY() + (parent.getHeight() >> 1) - (window.getHeight() >> 1);
            int deltaX = WindowHelper.virtualScreenBounds.width - x + WindowHelper.virtualScreenBounds.x - window.getWidth();
            if (deltaX < 0) {
                x += deltaX;
            }
            if ((deltaY = WindowHelper.virtualScreenBounds.height - y + WindowHelper.virtualScreenBounds.y - window.getHeight() + desktopPanelHeight) < 0) {
                y += deltaY;
            }
            window.setLocation(x, y);
            WindowHelper.checkAndCorrectWindowBounds(window);
        }
    }

    public static void locateWindowAtMiddleOfDefaultScreen(Window window) {
        WindowHelper.checkState();
        if (enableWindowPositioning) {
            int deltaY;
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension defaultScreenDim = tk.getScreenSize();
            int x = (defaultScreenDim.width >> 1) - (window.getWidth() >> 1);
            int y = (defaultScreenDim.height >> 1) - (window.getHeight() >> 1);
            int deltaX = WindowHelper.virtualScreenBounds.width - x + WindowHelper.virtualScreenBounds.x - window.getWidth();
            if (deltaX < 0) {
                x += deltaX;
            }
            if ((deltaY = WindowHelper.virtualScreenBounds.height - y + WindowHelper.virtualScreenBounds.y - window.getHeight() + desktopPanelHeight) < 0) {
                y += deltaY;
            }
            window.setLocation(x, y);
            WindowHelper.checkAndCorrectWindowBounds(window);
        }
    }

    public static boolean checkLocation(Point location) {
        boolean changed = true;
        for (Rectangle r : listScreens) {
            if (!r.contains(location)) continue;
            changed = false;
            break;
        }
        if (changed) {
            location.x = 0;
            location.y = 10;
        }
        return changed;
    }

    public static int getScreenCount() {
        return listScreens.size();
    }

    public static Rectangle[] getScreensBounds() {
        Rectangle[] rects = new Rectangle[listScreens.size()];
        int i = 0;
        Iterator<Rectangle> i$ = listScreens.iterator();
        while (i$.hasNext()) {
            Rectangle r;
            rects[i] = r = i$.next();
            ++i;
        }
        return rects;
    }
}

