/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.FieldDescription;
import sqlrunner.flatfileimport.FieldTokenizer;

public class DescriptionTableModel
implements TableModel {
    private static Logger logger = Logger.getLogger(DescriptionTableModel.class);
    private FieldTokenizer tokenizer;
    private ArrayList<FieldDescription> listDescriptions = new ArrayList();
    private static final String[] columnNames = new String[]{"enabled", "unique", "not null", "table column", "position", "test dataset"};
    protected EventListenerList listenerList = new EventListenerList();

    public void setTokenizer(FieldTokenizer tokenizer_loc) {
        this.tokenizer = tokenizer_loc;
        this.fireTableRowsUpdated(0, this.listDescriptions.size() - 1);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.listDescriptions.size() <= row || row < 0) {
            throw new IllegalArgumentException("row=" + row + " equals/greater than rowCount=" + this.listDescriptions.size() + " !");
        }
        Object cellContent = null;
        FieldDescription fd = this.listDescriptions.get(row);
        if (fd == null) {
            throw new IllegalArgumentException("row=" + row + "out of list bounds=" + this.listDescriptions.size() + " !");
        }
        switch (col) {
            case 0: {
                cellContent = fd.isEnabled();
                break;
            }
            case 1: {
                cellContent = fd.isPartOfPrimaryKey();
                break;
            }
            case 2: {
                cellContent = !fd.isNullEnabled();
                break;
            }
            case 3: {
                cellContent = fd.getName();
                break;
            }
            case 4: {
                cellContent = fd.getExtractionDescription();
                break;
            }
            case 5: {
                cellContent = this.tokenizer == null ? "" : this.tokenizer.getData(row);
            }
        }
        return cellContent;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.listDescriptions.size();
    }

    public void sort() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"sort()");
        }
        Object[] temp = this.listDescriptions.toArray();
        this.removeAllFieldDescriptions();
        Arrays.sort(temp);
        for (int i = 0; i < temp.length; ++i) {
            this.listDescriptions.add((FieldDescription)temp[i]);
        }
        this.fireTableRowsUpdated(0, this.listDescriptions.size() - 1);
    }

    public ArrayList<FieldDescription> getDescriptions() {
        return this.listDescriptions;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public synchronized void removeAllFieldDescriptions() {
        int oldSize = this.listDescriptions.size();
        if (oldSize > 0) {
            this.listDescriptions.clear();
            this.fireTableRowsDeleted(0, oldSize - 1);
        }
    }

    public FieldDescription getFieldDescription(int row) {
        return this.listDescriptions.get(row);
    }

    public boolean addFieldDescription(FieldDescription fd) {
        if (!this.existsFieldDescription(fd)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("addFieldDescription fd=" + fd));
            }
            this.listDescriptions.add(fd);
            this.fireTableRowsInserted(this.listDescriptions.size() - 1, this.listDescriptions.size() - 1);
            return true;
        }
        return false;
    }

    private boolean existsFieldDescription(FieldDescription newField) {
        FieldDescription temp = null;
        for (int i = 0; i < this.listDescriptions.size(); ++i) {
            temp = this.listDescriptions.get(i);
            if (temp.getDelimPos() != newField.getDelimPos()) continue;
            if (newField.getName().startsWith("#")) {
                return true;
            }
            if (temp.getName().startsWith("#")) {
                this.listDescriptions.remove(i);
            }
            return false;
        }
        return false;
    }

    public void sortBy(Comparator<FieldDescription> comparator) {
        Collections.sort(this.listDescriptions, comparator);
        this.fireTableRowsUpdated(0, this.listDescriptions.size() - 1);
    }

    public void createTestFieldDescriptions(int count) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createTestFieldDescriptions count=" + count));
        }
        int lastCountFields = this.listDescriptions.size();
        for (int i = 0; i < count; ++i) {
            FieldDescription fd = new FieldDescription();
            fd.setEnabled(false);
            fd.setPositionType(2);
            fd.setDelimPos(i);
            fd.setBasicTypeId(BasicDataType.CHARACTER.getId());
            if (this.existsFieldDescription(fd)) continue;
            this.listDescriptions.add(fd);
        }
        this.fireTableRowsInserted(lastCountFields - 1, this.listDescriptions.size() - 1);
    }

    public void removeTestFieldDescriptions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeTestFieldDescriptions");
        }
        for (int i = 0; i < this.listDescriptions.size(); ++i) {
            if (!this.listDescriptions.get(i).isDummy()) continue;
            this.removeFieldDescriptionAt(i);
            --i;
        }
    }

    public void insertFieldDescriptionAt(FieldDescription object, int row) {
        this.listDescriptions.add(row, object);
        this.fireTableRowsInserted(row, row);
    }

    public void removeFieldDescriptionAt(int index) {
        this.listDescriptions.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void setFieldDescriptions(List<FieldDescription> source) {
        this.removeAllFieldDescriptions();
        for (int i = 0; i < source.size(); ++i) {
            this.addFieldDescription(source.get(i));
        }
    }

    public int getRowIndex(FieldDescription fd) {
        return this.listDescriptions.indexOf(fd);
    }

    public void setupFieldDescriptionIndex() {
        int i = 0;
        for (FieldDescription fd : this.listDescriptions) {
            if (fd.isDummy()) continue;
            fd.setIndex(i++);
        }
    }
}

