/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.fileconverter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import sqlrunner.FileOpenChooserPanel;
import sqlrunner.fileconverter.Messages;
import sqlrunner.fileconverter.TextFileConverter;
import sqlrunner.swinghelper.WindowHelper;

public class TextFileConverterFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private FileOpenChooserPanel sourceFileChooser;
    private FileOpenChooserPanel targetFileChooser;
    private JTextField textFieldMaxLinesPerFile;
    private JComboBox comboBoxSourceEncoding;
    private JComboBox comboBoxTargetEncoding;
    private JComboBox comboBoxTargetLineSeparator;
    private JButton buttonStart;
    private JButton buttonCancel;
    private TextFileConverter converter = new TextFileConverter();
    private transient Thread converterThread = null;
    private JLabel labelStatus = new JLabel();

    public TextFileConverterFrame() {
        this.initialize();
        this.pack();
        WindowHelper.checkAndCorrectWindowBounds(this);
        this.setDefaultCloseOperation(2);
    }

    private void initialize() {
        this.setTitle(Messages.getString("TextFileConverter.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.getContentPane().add((Component)new JLabel(Messages.getString("TextFileConverter.sourceFile")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.getSourceFileChooser(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.getContentPane().add((Component)new JLabel(Messages.getString("TextFileConverter.encoding")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.getSourceEncodingComboBox(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.getContentPane().add((Component)new JLabel(Messages.getString("TextFileConverter.targetFile")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.getTargetFileChooser(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.getContentPane().add((Component)new JLabel(Messages.getString("TextFileConverter.maxlines")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.getTextFieldMaxLinesPerFile(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.getContentPane().add((Component)new JLabel(Messages.getString("TextFileConverter.encoding")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.getTargetEncodingComboBox(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.getContentPane().add((Component)new JLabel(Messages.getString("TextFileConverter.targetLineSeparator")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.getTargetLineSeparatorComboBox(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.getPanelButtons(), gbc);
    }

    private FileOpenChooserPanel getSourceFileChooser() {
        if (this.sourceFileChooser == null) {
            this.sourceFileChooser = new FileOpenChooserPanel(Messages.getString("TextFileConverter.sourceFile"));
            this.sourceFileChooser.setAsOpenFileChooser();
        }
        return this.sourceFileChooser;
    }

    private FileOpenChooserPanel getTargetFileChooser() {
        if (this.targetFileChooser == null) {
            this.targetFileChooser = new FileOpenChooserPanel(Messages.getString("TextFileConverter.targetFile"));
            this.targetFileChooser.setAsSaveFileChooser();
        }
        return this.targetFileChooser;
    }

    private JComboBox getSourceEncodingComboBox() {
        if (this.comboBoxSourceEncoding == null) {
            this.comboBoxSourceEncoding = new JComboBox();
            this.comboBoxSourceEncoding.setEditable(true);
            this.comboBoxSourceEncoding.addItem("UTF-8");
            this.comboBoxSourceEncoding.addItem("UTF-16");
            this.comboBoxSourceEncoding.addItem("Cp1252");
            this.comboBoxSourceEncoding.addItem("ISO-8859-1");
            this.comboBoxSourceEncoding.addItem("ISO-8859-2");
            this.comboBoxSourceEncoding.addItem("ISO-8859-3");
            this.comboBoxSourceEncoding.addItem("ISO-8859-15");
            this.comboBoxSourceEncoding.addItem("ASCII");
            this.comboBoxSourceEncoding.addItem("MacRoman");
        }
        return this.comboBoxSourceEncoding;
    }

    private JComboBox getTargetEncodingComboBox() {
        if (this.comboBoxTargetEncoding == null) {
            this.comboBoxTargetEncoding = new JComboBox();
            this.comboBoxTargetEncoding.setEditable(true);
            this.comboBoxTargetEncoding.addItem("UTF-8");
            this.comboBoxTargetEncoding.addItem("UTF-16");
            this.comboBoxTargetEncoding.addItem("Cp1252");
            this.comboBoxTargetEncoding.addItem("ISO-8859-1");
            this.comboBoxTargetEncoding.addItem("ISO-8859-2");
            this.comboBoxTargetEncoding.addItem("ISO-8859-3");
            this.comboBoxTargetEncoding.addItem("ISO-8859-15");
            this.comboBoxTargetEncoding.addItem("ASCII");
            this.comboBoxTargetEncoding.addItem("MacRoman");
        }
        return this.comboBoxTargetEncoding;
    }

    private JComboBox getTargetLineSeparatorComboBox() {
        if (this.comboBoxTargetLineSeparator == null) {
            this.comboBoxTargetLineSeparator = new JComboBox();
            this.comboBoxTargetLineSeparator.setEditable(false);
            this.comboBoxTargetLineSeparator.addItem(TextFileConverter.LineSeparator.UNIX);
            this.comboBoxTargetLineSeparator.addItem(TextFileConverter.LineSeparator.WINDOWS);
        }
        return this.comboBoxTargetLineSeparator;
    }

    private JPanel getPanelButtons() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(400, 50));
        panel.setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 10;
        panel.add((Component)this.getLabelStatus(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.getButtonStart(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.getButtonCancel(), gbc);
        return panel;
    }

    private JLabel getLabelStatus() {
        if (this.labelStatus == null) {
            this.labelStatus = new JLabel();
            this.labelStatus.setHorizontalAlignment(0);
            this.labelStatus.setText("not started");
        }
        return this.labelStatus;
    }

    private JTextField getTextFieldMaxLinesPerFile() {
        if (this.textFieldMaxLinesPerFile == null) {
            this.textFieldMaxLinesPerFile = new JTextField();
        }
        return this.textFieldMaxLinesPerFile;
    }

    private long getMaxLineNumberPerFile() {
        String text = this.textFieldMaxLinesPerFile.getText();
        if (text != null) {
            text = text.trim();
            try {
                return Long.parseLong(text);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Line number invalid", "Check max lines per file", 0);
                return -1L;
            }
        }
        return 0L;
    }

    private JButton getButtonStart() {
        if (this.buttonStart == null) {
            this.buttonStart = new JButton();
            this.buttonStart.setText(Messages.getString("TextFileConverter.start"));
            this.buttonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextFileConverterFrame.this.startConversion();
                    TextFileConverterFrame.this.buttonCancel.setEnabled(true);
                    TextFileConverterFrame.this.buttonStart.setEnabled(false);
                }
            });
        }
        return this.buttonStart;
    }

    private JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new JButton();
            this.buttonCancel.setEnabled(false);
            this.buttonCancel.setText(Messages.getString("TextFileConverter.cancel"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextFileConverterFrame.this.cancelConversion();
                    TextFileConverterFrame.this.buttonCancel.setEnabled(false);
                    TextFileConverterFrame.this.buttonStart.setEnabled(true);
                }
            });
        }
        return this.buttonCancel;
    }

    private void cancelConversion() {
        if (this.converterThread != null) {
            this.converterThread.interrupt();
        }
    }

    private void startConversion() {
        if (this.converterThread != null) {
            this.converterThread.interrupt();
        }
        final File source = this.sourceFileChooser.getSelectedFile();
        final File target = this.targetFileChooser.getSelectedFile();
        final String sourceEncoding = (String)this.getSourceEncodingComboBox().getSelectedItem();
        final String targetEncoding = (String)this.getTargetEncodingComboBox().getSelectedItem();
        final String targetLineSeparator = ((TextFileConverter.LineSeparator)((Object)this.getTargetLineSeparatorComboBox().getSelectedItem())).getSeparator();
        this.converterThread = new Thread(){

            @Override
            public void run() {
                TextFileConverterFrame.this.converter.reset();
                long maxLinesPerFile = TextFileConverterFrame.this.getMaxLineNumberPerFile();
                if (maxLinesPerFile < 0L) {
                    return;
                }
                TextFileConverterFrame.this.converter.setMaxLinesPerFile(maxLinesPerFile);
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TextFileConverterFrame.this.labelStatus.setText(Messages.getString("TextFileConverter.convert") + TextFileConverterFrame.this.converter.getCurrentLineNumber());
                            }
                        });
                    }
                }, 0L, 1000L);
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextFileConverterFrame.this.labelStatus.setText(Messages.getString("TextFileConverter.convert") + 0);
                        }
                    });
                    TextFileConverterFrame.this.converter.convert(source, sourceEncoding, target, targetEncoding, targetLineSeparator);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextFileConverterFrame.this.labelStatus.setText(Messages.getString("TextFileConverter.convert") + TextFileConverterFrame.this.converter.getCurrentLineNumber());
                        }
                    });
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(TextFileConverterFrame.this.getContentPane(), e.getMessage(), Messages.getString("TextFileConverter.title"), 0);
                }
                timer.cancel();
                TextFileConverterFrame.this.labelStatus.setText(Messages.getString("TextFileConverter.finished"));
                TextFileConverterFrame.this.buttonStart.setEnabled(true);
                TextFileConverterFrame.this.buttonCancel.setEnabled(false);
            }
        };
        this.converterThread.start();
    }
}

