/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import sqlrunner.export.Messages;
import sqlrunner.flatfileimport.gui.DelimiterConfigPanel;

public class ExportFormatPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton rbInsertExport = null;
    private JTextField textFieldDateFormat = null;
    private JRadioButton rbFlatFileExport = null;
    private JCheckBox checkBoxHeader = null;
    private JCheckBox checkBoxComma = null;
    private DelimiterConfigPanel delimiterConfigPanel = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private ArrayList<ActionListener> listeners = new ArrayList();
    public static final String FLAT_FILE_SELECTED = "flat";
    public static final String INSERT_SQL_SELECTED = "inserts";

    public ExportFormatPanel() {
        this.initialize();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.rbInsertExport.setEnabled(enabled);
        if (this.rbInsertExport.isSelected()) {
            this.textFieldDateFormat.setEditable(enabled);
        } else {
            this.checkBoxHeader.setEnabled(enabled);
            this.checkBoxComma.setEnabled(enabled);
            this.delimiterConfigPanel.setEnabled(enabled);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), Messages.getString("ExportFormatPanel.5"), 0, 0, null, null));
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 2);
        this.add((Component)this.getRbInsertExport(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 20, 2, 2);
        gbc.gridwidth = 2;
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("ExportFormatPanel.0"));
        this.add((Component)jLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = y++;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getTextFieldDateFormat(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.anchor = 17;
        gbc.insets = new Insets(15, 5, 2, 2);
        this.add((Component)this.getRbFlatFileExport(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.gridheight = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(15, 2, 2, 2);
        gbc.gridwidth = 2;
        this.add((Component)this.getDelimiterConfigPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.insets = new Insets(2, 15, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.getCheckBoxHeader(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 15, 2, 2);
        this.add((Component)this.getCheckBoxComma(), gbc);
        this.buttonGroup.add(this.getRbFlatFileExport());
        this.buttonGroup.add(this.getRbInsertExport());
    }

    private JRadioButton getRbInsertExport() {
        if (this.rbInsertExport == null) {
            this.rbInsertExport = new JRadioButton();
            this.rbInsertExport.setText(Messages.getString("ExportFormatPanel.1"));
            this.rbInsertExport.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExportFormatPanel.this.rbInsertExport.isSelected()) {
                        ExportFormatPanel.this.rbFlatFileExport.setSelected(false);
                        ExportFormatPanel.this.textFieldDateFormat.setEnabled(true);
                        ExportFormatPanel.this.checkBoxComma.setEnabled(false);
                        ExportFormatPanel.this.checkBoxHeader.setEnabled(false);
                        ExportFormatPanel.this.delimiterConfigPanel.setEnabled(false);
                    }
                    ExportFormatPanel.this.fireActionPerformed();
                }
            });
        }
        return this.rbInsertExport;
    }

    private JTextField getTextFieldDateFormat() {
        if (this.textFieldDateFormat == null) {
            this.textFieldDateFormat = new JTextField();
            this.textFieldDateFormat.setEnabled(false);
        }
        return this.textFieldDateFormat;
    }

    private JRadioButton getRbFlatFileExport() {
        if (this.rbFlatFileExport == null) {
            this.rbFlatFileExport = new JRadioButton();
            this.rbFlatFileExport.setText(Messages.getString("ExportFormatPanel.2"));
            this.rbFlatFileExport.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExportFormatPanel.this.rbFlatFileExport.isSelected()) {
                        ExportFormatPanel.this.rbInsertExport.setSelected(false);
                        ExportFormatPanel.this.textFieldDateFormat.setEnabled(false);
                        ExportFormatPanel.this.checkBoxComma.setEnabled(true);
                        ExportFormatPanel.this.checkBoxHeader.setEnabled(true);
                        ExportFormatPanel.this.delimiterConfigPanel.setEnabled(true);
                    }
                    ExportFormatPanel.this.fireActionPerformed();
                }
            });
        }
        return this.rbFlatFileExport;
    }

    private JCheckBox getCheckBoxHeader() {
        if (this.checkBoxHeader == null) {
            this.checkBoxHeader = new JCheckBox();
            this.checkBoxHeader.setText(Messages.getString("ExportFormatPanel.3"));
            this.checkBoxHeader.setEnabled(false);
        }
        return this.checkBoxHeader;
    }

    private JCheckBox getCheckBoxComma() {
        if (this.checkBoxComma == null) {
            this.checkBoxComma = new JCheckBox();
            this.checkBoxComma.setText(Messages.getString("ExportFormatPanel.4"));
            this.checkBoxComma.setEnabled(false);
        }
        return this.checkBoxComma;
    }

    private DelimiterConfigPanel getDelimiterConfigPanel() {
        if (this.delimiterConfigPanel == null) {
            this.delimiterConfigPanel = new DelimiterConfigPanel();
            this.delimiterConfigPanel.setEnabled(false);
        }
        return this.delimiterConfigPanel;
    }

    public boolean isExportInCSVFileSelected() {
        return this.rbFlatFileExport.isSelected();
    }

    public void setExportInCSVFileselected(boolean toFile) {
        if (toFile) {
            this.rbFlatFileExport.doClick();
        } else {
            this.rbInsertExport.doClick();
        }
    }

    public boolean isWithHeaderSelected() {
        return this.checkBoxHeader.isSelected();
    }

    public void setWithHeaderSelected(boolean withHeader) {
        this.checkBoxHeader.setSelected(withHeader);
    }

    public boolean isReplacePointWithCommaSelected() {
        return this.checkBoxComma.isSelected();
    }

    public void setReplaceWithCommaSelected(boolean withComma) {
        this.checkBoxComma.setSelected(withComma);
    }

    public String getDelimiter() {
        return this.delimiterConfigPanel.getDelimiter();
    }

    public String getDelimiterToken() {
        return this.delimiterConfigPanel.getDelimiterToken();
    }

    public String getEnclosure() {
        return this.delimiterConfigPanel.getEnclosure();
    }

    public String getDateSQLExpression() {
        return this.textFieldDateFormat.getText();
    }

    public void setDateSQLExpression(String sql) {
        this.textFieldDateFormat.setText(sql);
    }

    public void setDelimiterToken(String token) {
        this.delimiterConfigPanel.setDelimiterToken(token);
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    private void fireActionPerformed() {
        ActionEvent e = null;
        e = this.rbFlatFileExport.isSelected() ? new ActionEvent(this, 0, FLAT_FILE_SELECTED) : new ActionEvent(this, 0, INSERT_SQL_SELECTED);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).actionPerformed(e);
        }
    }
}

