/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import sqlrunner.editor.SyntaxScanner;

public final class SyntaxDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    boolean updateComments = false;
    private transient SyntaxScanner lexer = null;
    private boolean inBlockComment = false;

    public SyntaxDocument(SyntaxScanner lexer) {
        super(new GapContent(1024));
        this.lexer = lexer;
    }

    boolean testForUpdateIsNecessary(AbstractDocument.DefaultDocumentEvent chng) {
        boolean blockCommentEndFound;
        boolean blockCommentStartFound;
        boolean isNecessary = false;
        String s = "";
        try {
            s = this.getText(chng.getOffset(), chng.getLength());
        }
        catch (BadLocationException e) {
            System.err.println("SQLDocument.testForUpdateIsNecessary: error: " + e.getMessage());
        }
        boolean bl = blockCommentStartFound = s.indexOf(SyntaxScanner.blockCommentBegin.charAt(0)) != -1;
        if (blockCommentStartFound) {
            this.inBlockComment = true;
        }
        boolean bl2 = blockCommentEndFound = s.indexOf(SyntaxScanner.blockCommentEnd.charAt(0)) != -1;
        if (blockCommentEndFound) {
            this.inBlockComment = false;
        }
        if (blockCommentStartFound || blockCommentEndFound || s.indexOf(10) != -1 || s.indexOf(SyntaxScanner.stringLimiter) != -1) {
            isNecessary = true;
        } else {
            Element root = this.getDefaultRootElement();
            DocumentEvent.ElementChange ec = chng.getChange(root);
            if (ec != null) {
                isNecessary = true;
            }
        }
        return isNecessary;
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        if ((this.testForUpdateIsNecessary(chng) || this.inBlockComment) && this.lexer != null) {
            this.lexer.updateCommentAttributes(chng.getOffset(), chng.getLength());
        }
    }

    public void updateCommentAttributes() {
        this.writeLock();
        this.lexer.updateCommentAttributes(0, this.getLength() - 1);
        this.writeUnlock();
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
        this.updateComments = this.testForUpdateIsNecessary(chng);
    }

    @Override
    protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.postRemoveUpdate(chng);
        if (this.updateComments) {
            if (this.lexer != null) {
                this.lexer.updateCommentAttributes(chng.getOffset(), chng.getLength());
            }
            this.updateComments = false;
        }
    }
}

