/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import sqlrunner.Main;
import sqlrunner.editor.SyntaxScanner;

public class SyntaxContext
extends StyleContext
implements ViewFactory {
    private static final long serialVersionUID = 1L;
    private static boolean syntaxHighlighting = false;
    private transient SyntaxScanner lexer = null;
    private static boolean useAntiAliasing;
    private static FontMetrics fontMetrics;
    private Document doc;

    public SyntaxContext(SyntaxScanner lexer) {
        this.lexer = lexer;
        if (Main.getUserProperty("SYNTAX_HIGHLIGHT", "true").equals("true") && lexer != null) {
            SyntaxContext.setSyntaxHighlighting(true);
        } else {
            SyntaxContext.setSyntaxHighlighting(false);
        }
        SyntaxContext.setUseAntiAliasing(Boolean.valueOf(Main.getUserProperty("USE_FONT_ANTIALIASING", "false")));
        if (SyntaxContext.isUseAntiAliasing()) {
            System.out.println("use font antialiasing");
        }
    }

    @Override
    public View create(Element elem) {
        this.doc = elem.getDocument();
        if (!(this.lexer == null || this.lexer.getDocument() != null && this.lexer.getDocument().equals(this.doc))) {
            this.lexer.setDocument(this.doc);
        }
        return new SQLPlainView(elem);
    }

    public static final boolean isUseAntiAliasing() {
        return useAntiAliasing;
    }

    public static final void setUseAntiAliasing(boolean useAntiAliasing) {
        System.out.println("use font antialiasing: " + useAntiAliasing);
        SyntaxContext.useAntiAliasing = useAntiAliasing;
    }

    static void setSyntaxHighlighting(boolean syntaxHighlighting) {
        SyntaxContext.syntaxHighlighting = syntaxHighlighting;
    }

    static boolean isSyntaxHighlightingEnabled() {
        return syntaxHighlighting;
    }

    public static void setupTextFont() {
        fontMetrics = null;
    }

    class SQLPlainView
    extends PlainView {
        SQLPlainView(Element elem) {
            super(elem);
        }

        @Override
        protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            if (useAntiAliasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            if (fontMetrics == null) {
                fontMetrics = g.getFontMetrics(Main.textFont);
            }
            if (SyntaxContext.isSyntaxHighlightingEnabled() && p1 > p0) {
                int mark1 = p0;
                Color color = null;
                int highlighterWidth = 0;
                int highlighterHeigh = 0;
                while (p1 > mark1) {
                    Segment textSegment;
                    SyntaxContext.this.lexer.setRange(mark1, p1);
                    if (SyntaxContext.this.lexer.scanLine()) {
                        int mark2 = SyntaxContext.this.lexer.getStartOffset();
                        if (mark2 > mark1) {
                            g.setColor(Color.black);
                            g.setFont(Main.textFont);
                            textSegment = new Segment();
                            SyntaxContext.this.doc.getText(mark1, mark2 - mark1, textSegment);
                            x = Utilities.drawTabbedText(textSegment, x, y, g, (TabExpander)this, p0);
                            mark1 = mark2;
                        }
                        color = SyntaxContext.this.lexer.getColor();
                        g.setFont(SyntaxContext.this.lexer.getFont());
                    } else {
                        color = Color.black;
                        g.setFont(Main.textFont);
                    }
                    p0 = mark1;
                    mark1 = SyntaxContext.this.lexer.getEndOffset();
                    textSegment = new Segment();
                    SyntaxContext.this.doc.getText(p0, mark1 - p0, textSegment);
                    if (SyntaxContext.this.lexer.getBackgroundColor() != null) {
                        g.setColor(SyntaxContext.this.lexer.getBackgroundColor());
                        highlighterWidth = fontMetrics.charsWidth(textSegment.array, textSegment.offset, textSegment.count);
                        highlighterHeigh = fontMetrics.getHeight();
                        g.fillRect(x, y - highlighterHeigh + 3, highlighterWidth, highlighterHeigh);
                    }
                    g.setColor(color);
                    x = Utilities.drawTabbedText(textSegment, x, y, g, (TabExpander)this, mark1);
                }
            } else {
                g.setFont(Main.textFont);
                g.setColor(Color.black);
                Segment textSegment = new Segment();
                SyntaxContext.this.doc.getText(p0, p1 - p0, textSegment);
                x = Utilities.drawTabbedText(textSegment, x, y, g, (TabExpander)this, p0);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            return x;
        }
    }
}

