/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class LineHighlightPainter
extends LayeredHighlighter.LayerPainter {
    private Color color;
    private boolean enabled = true;
    static final Color DEFAULT_COLOR = new Color(235, 235, 255);

    public LineHighlightPainter(Color c) {
        this.color = c != null ? c : DEFAULT_COLOR;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        if (this.enabled) {
            try {
                TextUI mapper = c.getUI();
                Rectangle p0 = mapper.modelToView(c, offs0);
                Rectangle p1 = mapper.modelToView(c, offs1);
                if (this.getColor() == null) {
                    g.setColor(c.getSelectionColor());
                } else {
                    g.setColor(this.getColor());
                }
                Rectangle r = p0.union(p1);
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    @Override
    public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
        if (this.enabled) {
            if (this.getColor() == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(this.getColor());
            }
            try {
                Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                g.fillRect(r.x, r.y, c.getWidth(), r.height);
                return r;
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return null;
    }
}

