/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.ViewFactory;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.editor.ExtEditorPane;
import sqlrunner.editor.SyntaxContext;
import sqlrunner.editor.SyntaxDocument;

public class ExtEditorKit
extends DefaultEditorKit {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ExtEditorKit.class);
    private SyntaxContext preferences;
    private MainFrame mainFrame;
    private static int tabSize = 0;
    private static String tabErsatz = null;

    public ExtEditorKit(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        ExtEditorKit.setTabSize(Integer.parseInt(Main.getUserProperty("TAB_SPACE_MAPPING", "4")));
        if (tabErsatz == null) {
            tabErsatz = "";
            for (int i = 0; i < ExtEditorKit.getTabSize(); ++i) {
                tabErsatz = tabErsatz + " ";
            }
        }
    }

    public static void insertFormattedBreak(JTextComponent editor) {
        Document doc = editor.getDocument();
        int pos = editor.getCaretPosition();
        try {
            int a;
            int i;
            String s = doc.getText(0, pos);
            for (i = pos - 1; i >= 0; --i) {
                if (s.charAt(i) != '\n') continue;
                ++i;
                break;
            }
            if (i < 0) {
                i = 0;
            }
            for (a = i; a < pos && s.charAt(a) <= ' ' && s.charAt(a) != '\n'; ++a) {
            }
            s = s.substring(i, a);
            editor.replaceSelection("\n" + s);
            editor.setCaretPosition(pos + 1 + s.length());
        }
        catch (BadLocationException ble) {
            logger.error((Object)("InsertFormatedBreak: at pos: " + pos), (Throwable)ble);
        }
    }

    @Override
    public String getContentType() {
        return "text/SQL";
    }

    @Override
    public Document createDefaultDocument() {
        return new SyntaxDocument(this.mainFrame.getSyntaxScanner());
    }

    @Override
    public final ViewFactory getViewFactory() {
        if (this.preferences == null) {
            this.preferences = new SyntaxContext(this.mainFrame.getSyntaxScanner());
        }
        return this.preferences;
    }

    private static void setTabSize(int tabSize) {
        ExtEditorKit.tabSize = tabSize;
    }

    private static int getTabSize() {
        return tabSize;
    }

    public static class MoveBack
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public MoveBack() {
            super("block-move-left");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos1;
            JTextComponent comp = (JTextComponent)e.getSource();
            Document doc = comp.getDocument();
            int pos0 = comp.getSelectionStart();
            if (pos0 != (pos1 = comp.getSelectionEnd())) {
                Element root = comp.getDocument().getDefaultRootElement();
                int line0Index = root.getElementIndex(pos0);
                int line1Index = root.getElementIndex(pos1);
                if (root.getElement(line1Index).getStartOffset() >= pos1) {
                    --line1Index;
                }
                try {
                    for (int i = line0Index; i <= line1Index; ++i) {
                        int lineStart = root.getElement(i).getStartOffset();
                        char c = doc.getText(lineStart, 1).charAt(0);
                        if (c != ' ' && c != '\t') continue;
                        doc.remove(lineStart, 1);
                    }
                }
                catch (BadLocationException ble) {
                    logger.error((Object)"ExtEditorKit.MoveBack: error in doc", (Throwable)ble);
                }
            }
        }
    }

    public static class MoveOut
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public MoveOut() {
            super("block-move-right");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos1;
            JTextComponent comp = (JTextComponent)e.getSource();
            Document doc = comp.getDocument();
            int pos0 = comp.getSelectionStart();
            if (pos0 != (pos1 = comp.getSelectionEnd())) {
                Element root = comp.getDocument().getDefaultRootElement();
                int line0Index = root.getElementIndex(pos0);
                int line1Index = root.getElementIndex(pos1);
                if (root.getElement(line1Index).getStartOffset() >= pos1) {
                    --line1Index;
                }
                try {
                    for (int i = line0Index; i <= line1Index; ++i) {
                        int lineStart = root.getElement(i).getStartOffset();
                        if (doc.getText(lineStart, 1).equals(" ")) {
                            doc.insertString(lineStart + 1, " ", null);
                            continue;
                        }
                        doc.insertString(lineStart, " ", null);
                    }
                }
                catch (BadLocationException ble) {
                    logger.error((Object)"ExtEditorKit.MoveOut: error in doc", (Throwable)ble);
                }
            }
        }
    }

    public static class SetStatusOverWriteAction
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public SetStatusOverWriteAction() {
            super("set-overwrite-status");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtEditorPane comp = (ExtEditorPane)e.getSource();
            int pos = comp.getCaretPosition();
            if (comp.getSelectionStart() == comp.getSelectionEnd()) {
                if (comp.isOverWrite()) {
                    comp.setOverWrite(false);
                    comp.getMainFrame().status.setTextModeOverWrite(false);
                } else {
                    comp.setOverWrite(true);
                    comp.getMainFrame().status.setTextModeOverWrite(true);
                }
                comp.setCaretPosition(pos);
                comp.repaint();
            }
        }
    }

    public static class OverWriteDefaultKeyTyped
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public OverWriteDefaultKeyTyped() {
            super("default-key-overwrite");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtEditorPane target = (ExtEditorPane)this.getTextComponent(e);
            if (target != null && e != null) {
                char c;
                String content = e.getActionCommand();
                int mod = e.getModifiers();
                if (content != null && content.length() > 0 && (mod & 6) == 0 && (c = content.charAt(0)) >= ' ' && c != '\u007f') {
                    target.replaceSelection(content);
                    Document doc = target.getDocument();
                    int pos = target.getCaretPosition();
                    try {
                        if (pos < doc.getLength() && target.isOverWrite() && doc.getText(pos, 1).charAt(0) != '\n') {
                            doc.remove(pos, 1);
                        }
                    }
                    catch (BadLocationException ble) {
                        logger.error((Object)("OverWriteDefaultKeyTyped: error at pos:" + pos), (Throwable)ble);
                    }
                }
            }
        }
    }

    public static class SelectUntilDocEnd
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public SelectUntilDocEnd() {
            super("select-until-doc-end");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            Document doc = editor.getDocument();
            editor.moveCaretPosition(doc.getLength());
        }
    }

    public static class GotoDocEnd
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public GotoDocEnd() {
            super("goto-doc-end");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            Document doc = editor.getDocument();
            editor.setCaretPosition(doc.getLength());
        }
    }

    public static class SelectUntilDocTop
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public SelectUntilDocTop() {
            super("select-until-doc-top");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            editor.moveCaretPosition(0);
        }
    }

    public static class GotoDocTop
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public GotoDocTop() {
            super("goto-doc-top");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            editor.setCaretPosition(0);
        }
    }

    public static class SelectUntilLineEnd
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public SelectUntilLineEnd() {
            super("select-until-line-end");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            Document doc = editor.getDocument();
            Element elem = doc.getDefaultRootElement();
            int lineNum = elem.getElementIndex(editor.getCaretPosition());
            Element line = elem.getElement(lineNum);
            if (editor.getCaretPosition() < line.getEndOffset()) {
                editor.moveCaretPosition(line.getEndOffset() - 1);
            }
        }
    }

    public static class GotoLineEnd
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public GotoLineEnd() {
            super("goto-line-end");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            Document doc = editor.getDocument();
            Element elem = doc.getDefaultRootElement();
            int lineNum = elem.getElementIndex(editor.getCaretPosition());
            Element line = elem.getElement(lineNum);
            if (editor.getCaretPosition() < line.getEndOffset()) {
                editor.setCaretPosition(line.getEndOffset() - 1);
            }
        }
    }

    public static class SelectUntilLineStart
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public SelectUntilLineStart() {
            super("select-until-line-start");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            Document doc = editor.getDocument();
            Element elem = doc.getDefaultRootElement();
            int lineNum = elem.getElementIndex(editor.getCaretPosition());
            Element line = elem.getElement(lineNum);
            editor.moveCaretPosition(line.getStartOffset());
        }
    }

    public static class GotoLineStart
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public GotoLineStart() {
            super("goto-line-start");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            Document doc = editor.getDocument();
            Element elem = doc.getDefaultRootElement();
            int lineNum = elem.getElementIndex(editor.getCaretPosition());
            Element line = elem.getElement(lineNum);
            editor.setCaretPosition(line.getStartOffset());
        }
    }

    public static class Trim
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public Trim() {
            super("trim");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent editor = this.getTextComponent(e);
            Document doc = editor.getDocument();
            Element rootElement = doc.getDefaultRootElement();
            int elemCount = rootElement.getElementCount();
            Element elem = null;
            String lineText = null;
            int startOffset = 0;
            int endOffset = 0;
            for (int ec = 0; ec < elemCount; ++ec) {
                int i;
                elem = rootElement.getElement(ec);
                try {
                    lineText = doc.getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                char c = lineText.charAt(lineText.length() - 1);
                if (c == '\n') {
                    endOffset = elem.getEndOffset() - 1;
                    i = lineText.length() - 2;
                } else {
                    endOffset = elem.getEndOffset();
                    i = lineText.length() - 1;
                }
                startOffset = endOffset;
                while (i >= 0 && ((c = lineText.charAt(i)) == ' ' || c == '\t' || c == '\u0000')) {
                    --startOffset;
                    --i;
                }
                if (startOffset >= endOffset) continue;
                try {
                    doc.remove(startOffset, endOffset - startOffset);
                    continue;
                }
                catch (BadLocationException e2) {
                    logger.error((Object)("Trim failed: " + e2.getMessage()), (Throwable)e2);
                }
            }
        }
    }

    public static class InsertTab
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public InsertTab() {
            super("insert-tab-space");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos1;
            JTextComponent comp = (JTextComponent)e.getSource();
            Document doc = comp.getDocument();
            int pos0 = comp.getSelectionStart();
            if (pos0 != (pos1 = comp.getSelectionEnd())) {
                Element root = comp.getDocument().getDefaultRootElement();
                int line0Index = root.getElementIndex(pos0);
                int line1Index = root.getElementIndex(pos1);
                if (root.getElement(line1Index).getStartOffset() >= pos1) {
                    --line1Index;
                }
                try {
                    for (int i = line0Index; i <= line1Index; ++i) {
                        int lineStart = root.getElement(i).getStartOffset();
                        if (doc.getText(lineStart, 1).equals(" ")) {
                            doc.insertString(lineStart + 1, tabErsatz, null);
                            continue;
                        }
                        doc.insertString(lineStart, tabErsatz, null);
                    }
                }
                catch (BadLocationException ble) {
                    logger.error((Object)("MoveOut: " + ble.getMessage()), (Throwable)ble);
                }
            } else {
                comp.replaceSelection(tabErsatz);
            }
        }
    }

    public static class MoveBackTab
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public MoveBackTab() {
            super("block-move-left-tab");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos1;
            JTextComponent comp = (JTextComponent)e.getSource();
            Document doc = comp.getDocument();
            int pos0 = comp.getSelectionStart();
            if (pos0 != (pos1 = comp.getSelectionEnd())) {
                Element root = comp.getDocument().getDefaultRootElement();
                int line0Index = root.getElementIndex(pos0);
                int line1Index = root.getElementIndex(pos1);
                if (root.getElement(line1Index).getStartOffset() >= pos1) {
                    --line1Index;
                }
                try {
                    for (int i = line0Index; i <= line1Index; ++i) {
                        int lineStart;
                        char c;
                        int x = ExtEditorKit.getTabSize();
                        while (x > 0 && ((c = doc.getText(lineStart = root.getElement(i).getStartOffset(), 1).charAt(0)) == ' ' || c == '\t')) {
                            doc.remove(lineStart, 1);
                            if (c == ' ') {
                                --x;
                                continue;
                            }
                            x -= ExtEditorKit.getTabSize();
                        }
                    }
                }
                catch (BadLocationException ble) {
                    logger.error((Object)("MoveBack: " + ble.getMessage()), (Throwable)ble);
                }
            }
        }
    }

    public static class SelectCurrentLine
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public SelectCurrentLine() {
            super("select-current-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int end;
            int lineIndex;
            JTextComponent comp = this.getTextComponent(e);
            Document doc = comp.getDocument();
            Element root = doc.getDefaultRootElement();
            Element line = root.getElement(lineIndex = root.getElementIndex(comp.getCaret().getDot()));
            int start = line.getStartOffset();
            if (start < (end = line.getEndOffset())) {
                comp.select(start, end);
            }
        }
    }

    public static class ToggleLineComment
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public ToggleLineComment() {
            super("toggle-line-comment");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent comp = this.getTextComponent(e);
            Document doc = comp.getDocument();
            Element root = doc.getDefaultRootElement();
            int pos0 = comp.getSelectionStart();
            int pos1 = comp.getSelectionEnd();
            int line0Index = root.getElementIndex(pos0);
            int line1Index = root.getElementIndex(pos1);
            if (root.getElement(line1Index).getStartOffset() >= pos1 && --line1Index < line0Index) {
                line1Index = line0Index;
            }
            try {
                for (int i = line0Index; i <= line1Index; ++i) {
                    int lineStart = root.getElement(i).getStartOffset();
                    if (doc.getText(lineStart, 2).equals("--")) {
                        doc.remove(lineStart, 2);
                        continue;
                    }
                    doc.insertString(lineStart, "--", null);
                }
            }
            catch (BadLocationException ble) {
                logger.error((Object)("ToggleLineComment:" + ble.getMessage()), (Throwable)ble);
            }
        }
    }

    public static class InsertFormatedBreak
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public InsertFormatedBreak() {
            super("insert-break");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtEditorKit.insertFormattedBreak(this.getTextComponent(e));
        }
    }

    public static class ToLowerCase
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public ToLowerCase() {
            super("toLowerCase");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos1;
            JTextComponent editor = (JTextComponent)e.getSource();
            Document doc = editor.getDocument();
            int pos0 = editor.getSelectionStart();
            if (pos0 != (pos1 = editor.getSelectionEnd())) {
                try {
                    String selectedText = doc.getText(pos0, pos1 - pos0);
                    editor.replaceSelection(selectedText.toLowerCase());
                }
                catch (BadLocationException e1) {
                    logger.error((Object)("ToLowerCase failed: " + e1.getMessage()), (Throwable)e1);
                }
            }
        }
    }

    public static class ToUpperCase
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public ToUpperCase() {
            super("toUpperCase");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos1;
            JTextComponent editor = (JTextComponent)e.getSource();
            Document doc = editor.getDocument();
            int pos0 = editor.getSelectionStart();
            if (pos0 != (pos1 = editor.getSelectionEnd())) {
                try {
                    String selectedText = doc.getText(pos0, pos1 - pos0);
                    editor.replaceSelection(selectedText.toUpperCase());
                }
                catch (BadLocationException e1) {
                    logger.error((Object)("ToUpperCase failed: " + e1.getMessage()), (Throwable)e1);
                }
            }
        }
    }
}

