/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel.gui;

import java.awt.Cursor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import sqlrunner.datamodel.SQLCatalog;
import sqlrunner.datamodel.SQLConstraint;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLIndex;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.datamodel.gui.Messages;
import sqlrunner.datamodel.gui.SQLObjectTreeNode;

public final class SQLDataTreeTableModel
extends DefaultTreeModel
implements TableModel,
TreeSelectionListener,
TreeWillExpandListener,
ListSelectionListener {
    private static final Logger logger = Logger.getLogger(SQLDataTreeTableModel.class);
    private static final long serialVersionUID = 1L;
    private String errorMessage;
    private boolean hasSuccessfulLoaded = false;
    private List<SQLDataModel> listModels = new ArrayList<SQLDataModel>();
    private transient SQLDataModel currentSQLDataModel;
    private transient SQLSchema currentSQLSchema = null;
    private transient SQLCatalog currentSQLCatalog = null;
    private transient SQLSchema nextSelectedSchema = null;
    private transient SQLTable currentSQLTable = null;
    private transient SQLField currentSQLField = null;
    private transient SQLProcedure currentSQLProcedure = null;
    private transient SQLConstraint currentSQLConstraint = null;
    private transient SQLIndex currentSQLIndex = null;
    private Object currentUserObject;
    private DefaultMutableTreeNode currentNode;
    private DefaultMutableTreeNode currentFilterStartNode;
    private HashMap<SQLDataModel, Integer> counterMap = new HashMap();
    private boolean buildTreeNodesRecursive = false;
    private boolean stopBeforeColumns = false;
    private String objectFilter;

    public SQLDataTreeTableModel() {
        super(new SQLObjectTreeNode(Messages.getString("SQLDataTreeModel.rootnode")));
    }

    private SQLObjectTreeNode getRootNode() {
        return (SQLObjectTreeNode)this.getRoot();
    }

    public boolean addUniqueSQLDataModel(SQLDataModel sqlDataModel) {
        Integer counter = this.counterMap.get(sqlDataModel);
        if (counter == null || counter == 0) {
            counter = 0;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("addSQLdataModel " + sqlDataModel));
            }
            this.listModels.add(sqlDataModel);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sqlDataModel);
            this.insertNodeInto(newNode, this.getRootNode(), this.getRootNode().getChildCount());
        }
        counter = counter + 1;
        this.counterMap.put(sqlDataModel, counter);
        return counter == 1;
    }

    public void removeUniqueSQLDataModel(SQLDataModel sqlDataModel) {
        if (sqlDataModel != null) {
            Integer counter = this.counterMap.get(sqlDataModel);
            if (counter == null || counter < 2) {
                DefaultMutableTreeNode node;
                int index;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removeSQLdataModel " + sqlDataModel));
                }
                if ((index = this.listModels.indexOf(sqlDataModel)) != -1) {
                    this.listModels.remove(index);
                }
                if ((node = this.findTreeNodeByUserObject(sqlDataModel)) != null) {
                    this.removeNodeFromParent(node);
                }
                if (this.currentSQLDataModel != null && this.currentSQLDataModel.equals(sqlDataModel)) {
                    this.currentSQLDataModel = null;
                }
                if (this.currentSQLTable != null && sqlDataModel.equals(this.currentSQLTable.getModel())) {
                    this.currentSQLTable = null;
                    this.currentSQLField = null;
                    this.fireTableChanged();
                }
            }
            if (counter != null) {
                counter = counter - 1;
                this.counterMap.put(sqlDataModel, counter);
            }
        }
    }

    public int getModelCount() {
        return this.listModels.size();
    }

    public boolean isReady() {
        if (this.hasSuccessfulLoaded) {
            return true;
        }
        this.errorMessage = "NO metadata loaded";
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterCurrentNodeChildren() {
        if (this.currentFilterStartNode != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("filterCurrentNodeChildren currentFilterStartNode=" + this.currentFilterStartNode));
            }
            this.buildNodes(this.currentFilterStartNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(SQLDataModel sqlDataModel, DefaultMutableTreeNode dataModelNode) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refresh sqlDataModel=" + sqlDataModel));
        }
        sqlDataModel.loadSchemas();
        this.buildTreeNodesRecursive = true;
        try {
            this.buildNodes(dataModelNode);
        }
        finally {
            this.buildTreeNodesRecursive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(SQLSchema schema, DefaultMutableTreeNode schemaNode, boolean stopBeforeColumns) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refresh schema=" + schema));
        }
        schema.loadTables();
        schema.loadProcedures();
        this.buildTreeNodesRecursive = true;
        this.stopBeforeColumns = stopBeforeColumns;
        try {
            this.buildNodes(schemaNode);
        }
        finally {
            this.buildTreeNodesRecursive = false;
            this.stopBeforeColumns = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCurrentTable() {
        if (this.currentSQLTable != null) {
            this.buildTreeNodesRecursive = true;
            try {
                this.buildNodes(this.currentNode);
            }
            finally {
                this.buildTreeNodesRecursive = false;
            }
            if (this.currentSQLTable.getFieldCount() > 0) {
                this.fireTableRowsDeleted(0, this.currentSQLTable.getFieldCount() - 1);
            }
            this.currentSQLTable.loadColumns();
            if (this.currentSQLTable.getFieldCount() > 0) {
                this.fireTableRowsInserted(0, this.currentSQLTable.getFieldCount() - 1);
            }
        }
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode parentNode, Object userObject) {
        DefaultMutableTreeNode child = null;
        if (userObject != null) {
            for (int i = 0; i < parentNode.getChildCount() && !userObject.equals((child = (DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject()); ++i) {
                child = null;
            }
        }
        return child;
    }

    protected void buildNodesForDataModels() {
        this.setAsksAllowsChildren(true);
        for (int i = 0; i < this.listModels.size(); ++i) {
            SQLDataModel model = this.listModels.get(i);
            DefaultMutableTreeNode node = this.findNode(this.getRootNode(), model);
            if (node != null) continue;
            node = new DefaultMutableTreeNode(model);
            this.insertNodeInto(node, this.getRootNode(), this.getRootNode().getChildCount());
        }
    }

    public DefaultMutableTreeNode findTreeNodeByUserObject(Object userObject) {
        return this.findTreeNodeByUserObject((DefaultMutableTreeNode)this.root, userObject);
    }

    private DefaultMutableTreeNode findTreeNodeByUserObject(DefaultMutableTreeNode node, Object userObject) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("findTreeNodeByUserObject: node=" + node + " userObject=" + userObject));
        }
        if (node.getUserObject() != null && userObject.equals(node.getUserObject())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if ((child = this.findTreeNodeByUserObject(child, userObject)) == null) continue;
            return child;
        }
        return null;
    }

    public DefaultMutableTreeNode findAndCreateNode(Object userObject) {
        ArrayList<Object> path = this.collectObjectPath(userObject);
        DefaultMutableTreeNode node = this.findAndCreateNodeByPath(path);
        return node;
    }

    public DefaultMutableTreeNode findAndCreateNodeByPath(ArrayList<Object> userObjectPath) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("findAndCreateNodeByPath userObjectPath=" + userObjectPath));
        }
        DefaultMutableTreeNode node = null;
        for (Object userObject : userObjectPath) {
            node = this.findTreeNodeByUserObject(userObject);
            if (node == null || node.getChildCount() != 0) continue;
            this.buildNodes(node);
        }
        return node;
    }

    public String getLastErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int getRowCount() {
        if (this.currentUserObject != null) {
            if (this.currentUserObject == this.currentSQLTable) {
                return this.currentSQLTable.getFieldCount();
            }
            if (this.currentUserObject == this.currentSQLProcedure) {
                return this.currentSQLProcedure.getParameterCount();
            }
            if (this.currentUserObject == this.currentSQLConstraint) {
                return this.currentSQLConstraint.getColumnCount();
            }
            if (this.currentUserObject == this.currentSQLIndex) {
                return this.currentSQLIndex.getCountFields();
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Messages.getString("SQLDataTreeModel.146");
            }
            case 1: {
                return Messages.getString("SQLDataTreeModel.147");
            }
            case 2: {
                return Messages.getString("SQLDataTreeModel.148");
            }
            case 3: {
                return Messages.getString("SQLDataTreeModel.149");
            }
            case 4: {
                return Messages.getString("SQLDataTreeModel.150");
            }
        }
        return "";
    }

    public Class<String> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            default: 
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.currentUserObject != null) {
            if (this.currentUserObject == this.currentSQLTable) {
                return this.currentSQLTable.getFieldAt(rowIndex);
            }
            if (this.currentUserObject == this.currentSQLProcedure) {
                return this.currentSQLProcedure.getParameterAt(rowIndex);
            }
            if (this.currentUserObject == this.currentSQLConstraint) {
                if (columnIndex == 0) {
                    return this.currentSQLConstraint.getColumnAt(rowIndex);
                }
                return null;
            }
            if (this.currentUserObject == this.currentSQLIndex) {
                if (columnIndex == 0) {
                    return this.currentSQLIndex.getFieldAt(rowIndex);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(final TableModelEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doFireTableChanged(e);
        } else {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    SQLDataTreeTableModel.this.doFireTableChanged(e);
                }
            });
            t.start();
        }
    }

    private void doFireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        ListSelectionModel lsm = (ListSelectionModel)lse.getSource();
        if (lsm.isSelectionEmpty()) {
            this.currentSQLField = null;
        } else if (this.currentSQLTable != null) {
            this.currentSQLField = this.currentSQLTable.getFieldAt(lsm.getMinSelectionIndex());
        } else if (this.currentSQLProcedure != null) {
            this.currentSQLField = null;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        final JTree tree = (JTree)tse.getSource();
        TreePath[] selectedPaths = tree.getSelectionPaths();
        if (selectedPaths != null && selectedPaths.length > 0) {
            Object o = selectedPaths[0].getLastPathComponent();
            if (!(o instanceof SQLObjectTreeNode)) {
                return;
            }
            this.currentNode = (SQLObjectTreeNode)o;
            DefaultMutableTreeNode nextSelectedNode = null;
            Object nextSelectedUserObject = null;
            if (selectedPaths.length > 1) {
                nextSelectedNode = (DefaultMutableTreeNode)selectedPaths[1].getLastPathComponent();
            }
            this.nextSelectedSchema = null;
            if (nextSelectedNode != null) {
                nextSelectedUserObject = nextSelectedNode.getUserObject();
            }
            this.currentUserObject = this.currentNode.getUserObject();
            if (this.currentUserObject instanceof SQLTable) {
                if (this.currentSQLTable != null && this.currentSQLTable.getFieldCount() > 0) {
                    this.fireTableRowsDeleted(0, this.currentSQLTable.getFieldCount() - 1);
                }
                this.currentSQLConstraint = null;
                this.currentSQLTable = (SQLTable)this.currentUserObject;
                this.currentSQLSchema = this.currentSQLTable.getSchema();
                this.currentSQLCatalog = this.currentSQLSchema.getCatalog();
                this.currentSQLDataModel = this.currentSQLTable.getModel();
                final SQLTable table = this.currentSQLTable;
                if (!table.isFieldsLoaded()) {
                    new Thread(){

                        @Override
                        public void run() {
                            if (table != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        tree.setCursor(Cursor.getPredefinedCursor(3));
                                    }
                                });
                                table.loadColumns();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (table.getFieldCount() > 0) {
                                            SQLDataTreeTableModel.this.fireTableRowsInserted(0, table.getFieldCount() - 1);
                                        }
                                        tree.setCursor(Cursor.getPredefinedCursor(0));
                                    }
                                });
                            }
                        }
                    }.start();
                } else if (this.currentSQLTable.getFieldCount() > 0) {
                    this.fireTableRowsInserted(0, this.currentSQLTable.getFieldCount() - 1);
                }
            } else if (this.currentUserObject instanceof SQLConstraint) {
                this.currentSQLConstraint = (SQLConstraint)this.currentUserObject;
                this.currentSQLTable = this.currentSQLConstraint.getTable();
                this.currentSQLSchema = this.currentSQLTable.getSchema();
                this.currentSQLCatalog = this.currentSQLSchema.getCatalog();
                this.currentSQLDataModel = this.currentSQLConstraint.getModel();
                this.nextSelectedSchema = null;
                this.fireTableChanged();
            } else if (this.currentUserObject instanceof SQLIndex) {
                this.currentSQLIndex = (SQLIndex)this.currentUserObject;
                this.currentSQLTable = this.currentSQLIndex.getTable();
                this.currentSQLSchema = this.currentSQLTable.getSchema();
                this.currentSQLCatalog = this.currentSQLSchema.getCatalog();
                this.currentSQLDataModel = this.currentSQLIndex.getModel();
                this.nextSelectedSchema = null;
                this.fireTableChanged();
            } else if (this.currentUserObject instanceof SQLSchema) {
                this.currentSQLConstraint = null;
                this.currentSQLTable = null;
                this.currentSQLSchema = (SQLSchema)this.currentUserObject;
                this.currentSQLCatalog = this.currentSQLSchema.getCatalog();
                this.currentSQLDataModel = this.currentSQLSchema.getModel();
                this.fireTableChanged();
                this.nextSelectedSchema = nextSelectedUserObject instanceof SQLSchema ? (SQLSchema)nextSelectedUserObject : null;
            } else if (this.currentUserObject instanceof SQLCatalog) {
                this.currentSQLConstraint = null;
                this.currentSQLTable = null;
                this.currentSQLSchema = null;
                this.currentSQLCatalog = (SQLCatalog)this.currentUserObject;
                this.currentSQLDataModel = this.currentSQLCatalog.getModel();
                this.fireTableChanged();
            } else if (this.currentUserObject instanceof SQLProcedure) {
                this.currentSQLConstraint = null;
                this.currentSQLTable = null;
                this.currentSQLProcedure = (SQLProcedure)this.currentUserObject;
                this.currentSQLSchema = this.currentSQLProcedure.getSchema();
                this.currentSQLDataModel = this.currentSQLSchema.getModel();
                this.nextSelectedSchema = null;
                this.fireTableChanged();
            } else if (this.currentUserObject instanceof SQLDataModel) {
                this.currentSQLConstraint = null;
                this.currentSQLTable = null;
                this.currentSQLSchema = null;
                this.nextSelectedSchema = null;
                this.currentSQLDataModel = (SQLDataModel)this.currentUserObject;
                this.fireTableChanged();
            } else {
                this.currentSQLConstraint = null;
                this.currentSQLTable = null;
                this.currentSQLSchema = null;
                this.currentSQLDataModel = null;
                this.nextSelectedSchema = null;
                this.fireTableChanged();
            }
            this.setCurrentFilterNode(this.currentNode);
        }
    }

    private void setCurrentFilterNode(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        this.currentFilterStartNode = userObject instanceof SQLTable ? (DefaultMutableTreeNode)node.getParent() : (userObject instanceof SQLConstraint ? (DefaultMutableTreeNode)node.getParent() : (userObject instanceof SQLIndex ? (DefaultMutableTreeNode)node.getParent() : (userObject instanceof SQLSchema ? (DefaultMutableTreeNode)node.getParent() : (userObject instanceof SQLCatalog ? node : (userObject instanceof SQLProcedure ? (DefaultMutableTreeNode)node.getParent() : (userObject instanceof SQLDataModel ? node : (userObject instanceof Folder ? node : null)))))));
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(final TreeExpansionEvent event) throws ExpandVetoException {
        new Thread(){

            @Override
            public void run() {
                final JTree tree = (JTree)event.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tree.setCursor(Cursor.getPredefinedCursor(3));
                    }
                });
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                SQLDataTreeTableModel.this.currentNode = node;
                SQLDataTreeTableModel.this.buildNodes(node);
                SQLDataTreeTableModel.this.setCurrentFilterNode(SQLDataTreeTableModel.this.currentNode);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tree.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
            }
        }.start();
    }

    private ArrayList<Object> collectObjectPath(Object userObject) {
        ArrayList<Object> path = new ArrayList<Object>();
        if (userObject instanceof SQLDataModel) {
            path.add(userObject);
        } else if (userObject instanceof SQLCatalog) {
            SQLCatalog catalog = (SQLCatalog)userObject;
            path.add(catalog.getModel());
            path.add(catalog);
        } else if (userObject instanceof SQLSchema) {
            SQLSchema schema = (SQLSchema)userObject;
            path.add(schema.getModel());
            path.add(schema.getCatalog());
            path.add(schema);
        } else if (userObject instanceof SQLTable) {
            SQLTable table = (SQLTable)userObject;
            path.add(table.getModel());
            path.add(table.getSchema().getCatalog());
            path.add(table.getSchema());
            if (table.isView()) {
                path.add(new ViewFolder(table.getSchema()));
            } else {
                path.add(new TableFolder(table.getSchema()));
            }
            path.add(table);
        }
        return path;
    }

    private void buildNodes(DefaultMutableTreeNode parentNode) {
        SQLSchema schema;
        SQLTable table;
        Object userObject;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildNodes parentNode=" + parentNode + " class=" + parentNode.getUserObject().getClass()));
        }
        if ((userObject = parentNode.getUserObject()) instanceof SQLDataModel) {
            this.buildNodesForCatalogs((SQLDataModel)userObject, parentNode);
        } else if (userObject instanceof SQLCatalog) {
            this.buildNodesForSchemas((SQLCatalog)userObject, parentNode);
        } else if (userObject instanceof SQLSchema) {
            this.buildNodesForSchemaFolders((SQLSchema)userObject, parentNode);
        } else if (userObject instanceof SQLTable) {
            table = (SQLTable)userObject;
            this.buildNodesForTableSubFolders(table, parentNode);
            if (this.stopBeforeColumns) {
                return;
            }
        } else if (userObject instanceof TableConstraintsFolder) {
            table = ((TableConstraintsFolder)userObject).getTable();
            this.buildNodesForTableConstraints(table, parentNode);
        } else if (userObject instanceof TableIndexesFolder) {
            table = ((TableIndexesFolder)userObject).getTable();
            this.buildNodesForTableIndexes(table, parentNode);
        } else if (userObject instanceof TableFolder) {
            schema = ((Folder)userObject).getSchema();
            this.buildNodesForTables(schema, parentNode);
        } else if (userObject instanceof ViewFolder) {
            schema = ((Folder)userObject).getSchema();
            this.buildNodesForViews(schema, parentNode);
        } else if (userObject instanceof ProcedureFolder) {
            schema = ((Folder)userObject).getSchema();
            this.buildNodesForFunctions(schema, parentNode);
        } else {
            return;
        }
        if (this.buildTreeNodesRecursive) {
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                this.buildNodes((DefaultMutableTreeNode)parentNode.getChildAt(i));
            }
        }
    }

    private void buildNodes(final DefaultMutableTreeNode parentNode, final List<? extends Object> listUserObjects) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doBuildNodes(parentNode, listUserObjects);
        } else if (this.buildTreeNodesRecursive) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SQLDataTreeTableModel.this.doBuildNodes(parentNode, listUserObjects);
                    }
                });
            }
            catch (InterruptedException e) {
                logger.error((Object)("buildNodes interrupted:" + e.getMessage()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)("buildNodes failed:" + e.getMessage()), (Throwable)e);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLDataTreeTableModel.this.doBuildNodes(parentNode, listUserObjects);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void doBuildNodes(DefaultMutableTreeNode parentNode, List<? extends Object> newListOfChildUserObjects) {
        void var5_10;
        ArrayList<Object> currentNewChildren = new ArrayList<Object>();
        if (this.objectFilter != null) {
            currentNewChildren = new ArrayList();
            for (Object object : newListOfChildUserObjects) {
                if (object instanceof SQLTable || object instanceof SQLProcedure) {
                    if (!object.toString().toLowerCase().contains(this.objectFilter)) continue;
                    currentNewChildren.add(object);
                    continue;
                }
                currentNewChildren.add(object);
            }
        } else {
            for (Object object : newListOfChildUserObjects) {
                currentNewChildren.add(object);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("doBuildNodes parentNode=" + parentNode + " newListOfChildUserObjects=" + currentNewChildren));
        }
        int parentNodeChildCount = parentNode.getChildCount();
        boolean bl = false;
        while (var5_10 < currentNewChildren.size()) {
            Object newUserObject = currentNewChildren.get((int)var5_10);
            if (var5_10 < parentNodeChildCount) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt((int)var5_10);
                if (!newUserObject.equals(childNode.getUserObject())) {
                    childNode.setUserObject(newUserObject);
                    this.nodeChanged(childNode);
                }
            } else {
                SQLObjectTreeNode newNode = new SQLObjectTreeNode(newUserObject);
                this.insertNodeInto(newNode, parentNode, (int)var5_10);
            }
            ++var5_10;
        }
        if (parentNodeChildCount > currentNewChildren.size()) {
            void var5_12;
            int n = parentNodeChildCount - 1;
            while (var5_12 >= currentNewChildren.size()) {
                this.removeNodeFromParent((DefaultMutableTreeNode)parentNode.getChildAt((int)var5_12));
                --var5_12;
            }
        }
    }

    void buildNodesForCatalogs(SQLDataModel sqlDataModel, DefaultMutableTreeNode parentNode) {
        if (!sqlDataModel.isSchemaLoaded()) {
            sqlDataModel.loadSchemas();
        }
        this.buildNodes(parentNode, sqlDataModel.getCatalogs());
    }

    void buildNodesForSchemas(SQLCatalog catalog, DefaultMutableTreeNode parentNode) {
        this.buildNodes(parentNode, catalog.getSchemas());
    }

    private void buildNodesForTables(SQLSchema schema, DefaultMutableTreeNode tableFolderNode) {
        SQLTable table = null;
        ArrayList<SQLTable> list = new ArrayList<SQLTable>();
        for (int i = 0; i < schema.getTableCount(); ++i) {
            table = schema.getTableAt(i);
            if (table.isView()) continue;
            list.add(table);
        }
        this.buildNodes(tableFolderNode, list);
    }

    private void buildNodesForTableSubFolders(SQLTable table, DefaultMutableTreeNode tableNode) {
        ArrayList<Folder> listFolders = new ArrayList<Folder>();
        listFolders.add(new TableConstraintsFolder(table));
        listFolders.add(new TableIndexesFolder(table));
        this.buildNodes(tableNode, listFolders);
    }

    private void buildNodesForTableConstraints(SQLTable table, DefaultMutableTreeNode tableIndexFolderNode) {
        SQLConstraint constraint;
        int i;
        if (!table.isFieldsLoaded()) {
            table.loadColumns();
        }
        List<SQLConstraint> listConstraints = table.getConstraints();
        ArrayList<SQLConstraint> list = new ArrayList<SQLConstraint>();
        for (i = 0; i < listConstraints.size(); ++i) {
            constraint = listConstraints.get(i);
            if (constraint.getType() != 1) continue;
            list.add(constraint);
        }
        for (i = 0; i < listConstraints.size(); ++i) {
            constraint = listConstraints.get(i);
            if (constraint.getType() != 4) continue;
            list.add(constraint);
        }
        for (i = 0; i < listConstraints.size(); ++i) {
            constraint = listConstraints.get(i);
            if (constraint.getType() != 2) continue;
            list.add(constraint);
        }
        this.buildNodes(tableIndexFolderNode, list);
    }

    private void buildNodesForTableIndexes(SQLTable table, DefaultMutableTreeNode tableIndexFolderNode) {
        if (!table.isFieldsLoaded()) {
            table.loadColumns();
        }
        List<SQLIndex> list = table.getIndexes();
        this.buildNodes(tableIndexFolderNode, list);
    }

    private void buildNodesForViews(SQLSchema schema, DefaultMutableTreeNode viewFolderNode) {
        SQLTable table = null;
        ArrayList<SQLTable> list = new ArrayList<SQLTable>();
        for (int i = 0; i < schema.getTableCount(); ++i) {
            table = schema.getTableAt(i);
            if (!table.isView()) continue;
            list.add(table);
        }
        this.buildNodes(viewFolderNode, list);
    }

    private void buildNodesForFunctions(SQLSchema schema, DefaultMutableTreeNode functionFolderNode) {
        SQLProcedure proc = null;
        ArrayList<SQLProcedure> list = new ArrayList<SQLProcedure>();
        for (int i = 0; i < schema.getProcedureCount(); ++i) {
            proc = schema.getProcedureAt(i);
            list.add(proc);
        }
        this.buildNodes(functionFolderNode, list);
    }

    private void buildNodesForSchemaFolders(SQLSchema schema, DefaultMutableTreeNode schemaNode) {
        ArrayList<Folder> list = new ArrayList<Folder>();
        TableFolder tf = new TableFolder(schema);
        list.add(tf);
        ViewFolder vf = new ViewFolder(schema);
        list.add(vf);
        ProcedureFolder pf = new ProcedureFolder(schema);
        list.add(pf);
        this.buildNodes(schemaNode, list);
    }

    public SQLDataModel getCurrentSQLDataModel() {
        return this.currentSQLDataModel;
    }

    public SQLSchema getCurrentSQLSchema() {
        return this.currentSQLSchema;
    }

    public SQLCatalog getCurrentSQLCatalog() {
        return this.currentSQLCatalog;
    }

    public SQLSchema getNextSelectedSQLSchema() {
        return this.nextSelectedSchema;
    }

    public boolean isCurrentSchema(String schemaName) {
        if (this.currentSQLSchema != null) {
            return this.currentSQLSchema.getName().equalsIgnoreCase(schemaName);
        }
        return false;
    }

    public SQLTable getCurrentSQLTable() {
        return this.currentSQLTable;
    }

    public SQLField getCurrentSQLField() {
        return this.currentSQLField;
    }

    public SQLProcedure getCurrentSQLProcedure() {
        return this.currentSQLProcedure;
    }

    public SQLConstraint getCurrentSQLConstraint() {
        return this.currentSQLConstraint;
    }

    public SQLIndex getCurrentSQLIndex() {
        return this.currentSQLIndex;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.currentNode;
    }

    public Object getCurrentUserObject() {
        return this.currentUserObject;
    }

    public String getObjectFilter() {
        return this.objectFilter;
    }

    public void setObjectFilter(String objectFilter) {
        this.objectFilter = objectFilter == null || objectFilter.trim().isEmpty() ? null : objectFilter.trim().toLowerCase();
    }

    public static final class TableIndexesFolder
    extends Folder {
        public TableIndexesFolder(SQLTable table) {
            super(table);
        }

        public String toString() {
            return Messages.getString("SQLDataTreeModel.tableIndexesFolderName");
        }
    }

    public static final class TableConstraintsFolder
    extends Folder {
        public TableConstraintsFolder(SQLTable table) {
            super(table);
        }

        public String toString() {
            return Messages.getString("SQLDataTreeModel.tableConstraintsFolderName");
        }
    }

    public static final class ProcedureFolder
    extends Folder {
        public ProcedureFolder(SQLSchema schema) {
            super(schema);
        }

        public String toString() {
            return Messages.getString("SQLDataTreeModel.procedureFolderName");
        }
    }

    public static final class ViewFolder
    extends Folder {
        public ViewFolder(SQLSchema schema) {
            super(schema);
        }

        public String toString() {
            return Messages.getString("SQLDataTreeModel.viewFolderName");
        }
    }

    public static final class TableFolder
    extends Folder {
        public TableFolder(SQLSchema schema) {
            super(schema);
        }

        public String toString() {
            return Messages.getString("SQLDataTreeModel.tableFolderName");
        }
    }

    public static abstract class Folder {
        private SQLSchema schema;
        private SQLTable table;

        public Folder(SQLSchema schema) {
            this.schema = schema;
        }

        public Folder(SQLTable table) {
            this.table = table;
        }

        public SQLSchema getSchema() {
            return this.schema;
        }

        public SQLTable getTable() {
            return this.table;
        }

        public boolean equals(Object o) {
            if (this.getClass().isInstance(o)) {
                Folder of = (Folder)o;
                if (this.getTable() != null && this.getTable().equals(of.getTable())) {
                    return true;
                }
                return this.getSchema() != null && this.getSchema().equals(of.getSchema());
            }
            return false;
        }
    }
}

