/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.config.ConfigurationPanel;
import sqlrunner.config.Messages;

public class PanelConfigTableCell
extends JPanel
implements ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel labelWidthValue = new JLabel();
    private final JSlider sliderWidth = new JSlider();
    private final JLabel labelHeightValue = new JLabel();
    private final JSlider sliderHeight = new JSlider();
    private final JCheckBox jCheckBoxUseMonoSpacedFontInCells = new JCheckBox();
    private boolean isHeightChanged = false;
    private boolean isWidthChanged = false;
    private boolean fontChanged = false;
    private boolean hasMonospaceFont = false;
    private int oldWidth = 0;
    private int oldHeight = 0;
    private MainFrame mainFrame = null;

    public PanelConfigTableCell() {
        try {
            this.initComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() throws Exception {
        this.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), Messages.getString("PanelConfigTableCell.bordertitle")));
        this.setMinimumSize(this.getPreferredSize());
        this.setLayout(new GridBagLayout());
        this.sliderWidth.setMinimum(10);
        this.sliderWidth.setMaximum(500);
        this.mainFrame = Main.getActiveMainFrame();
        if (this.mainFrame != null && this.mainFrame.getDatabase() != null) {
            this.sliderWidth.setValue(this.mainFrame.getDatabase().getDefaultColumnWidth());
        }
        this.oldWidth = this.sliderWidth.getValue();
        this.sliderWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanelConfigTableCell.this.sliderWidth_stateChanged(e);
            }
        });
        this.sliderHeight.setMinimum(10);
        this.sliderHeight.setMaximum(500);
        if (this.mainFrame != null) {
            this.sliderHeight.setValue(this.mainFrame.resultTable.getRowHeight());
        }
        this.oldHeight = this.sliderHeight.getValue();
        this.sliderHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanelConfigTableCell.this.sliderHeight_stateChanged(e);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.anchor = 13;
        gbc.fill = 0;
        JLabel labelWidthText = new JLabel();
        labelWidthText.setText(Messages.getString("PanelConfigTableCell.columnwidth"));
        labelWidthText.setVerticalAlignment(1);
        labelWidthText.setVerticalTextPosition(1);
        this.add((Component)labelWidthText, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(2, 0, 2, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        this.labelWidthValue.setText(String.valueOf(this.sliderWidth.getValue()));
        this.labelWidthValue.setBorder(BorderFactory.createEtchedBorder());
        this.labelWidthValue.setHorizontalAlignment(0);
        this.add((Component)this.labelWidthValue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = new Insets(2, 5, 5, 5);
        gbc.anchor = 10;
        gbc.fill = 2;
        this.add((Component)this.sliderWidth, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.anchor = 10;
        gbc.fill = 0;
        JLabel labelHeightText = new JLabel();
        labelHeightText.setText(Messages.getString("PanelConfigTableCell.rowheight"));
        labelHeightText.setVerticalAlignment(1);
        labelHeightText.setVerticalTextPosition(1);
        this.add((Component)labelHeightText, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = new Insets(2, 0, 2, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        this.labelHeightValue.setText(String.valueOf(this.sliderHeight.getValue()));
        this.labelHeightValue.setBorder(BorderFactory.createEtchedBorder());
        this.labelHeightValue.setHorizontalAlignment(0);
        this.add((Component)this.labelHeightValue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.fill = 2;
        this.add((Component)this.sliderHeight, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 10;
        gbc.fill = 0;
        this.jCheckBoxUseMonoSpacedFontInCells.setText(Messages.getString("PanelConfigTableCell.monoSpacedFont"));
        this.jCheckBoxUseMonoSpacedFontInCells.setSelected(MainFrame.useMonospacedTableCellFont());
        this.hasMonospaceFont = this.jCheckBoxUseMonoSpacedFontInCells.isSelected();
        this.jCheckBoxUseMonoSpacedFontInCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelConfigTableCell.this.fontChanged = PanelConfigTableCell.this.hasMonospaceFont != PanelConfigTableCell.this.jCheckBoxUseMonoSpacedFontInCells.isSelected();
            }
        });
        this.add((Component)this.jCheckBoxUseMonoSpacedFontInCells, gbc);
    }

    @Override
    public boolean isChanged() {
        return this.isHeightChanged || this.isWidthChanged || this.fontChanged;
    }

    @Override
    public boolean performChanges() {
        this.oldWidth = this.sliderWidth.getValue();
        this.oldHeight = this.sliderHeight.getValue();
        this.hasMonospaceFont = this.jCheckBoxUseMonoSpacedFontInCells.isSelected();
        MainFrame.setUseMonospacedTableCellFont(this.jCheckBoxUseMonoSpacedFontInCells.isSelected());
        return true;
    }

    @Override
    public void cancel() {
        if (this.mainFrame.getDatabase() != null) {
            if (this.isWidthChanged) {
                this.mainFrame.getDatabase().setColumnWidthForAllColumns(this.oldWidth);
            }
            if (this.isHeightChanged) {
                this.mainFrame.resultTable.setRowHeight(this.oldHeight);
            }
        }
    }

    private void sliderWidth_stateChanged(ChangeEvent e) {
        if (this.mainFrame.getDatabase() != null) {
            this.mainFrame.getDatabase().setColumnWidthForAllColumns(this.sliderWidth.getValue());
            this.isWidthChanged = true;
            this.labelWidthValue.setText(String.valueOf(this.sliderWidth.getValue()));
        }
    }

    private void sliderHeight_stateChanged(ChangeEvent e) {
        this.mainFrame.resultTable.setRowHeight(this.sliderHeight.getValue());
        this.isHeightChanged = true;
        this.labelHeightValue.setText(String.valueOf(this.sliderHeight.getValue()));
    }
}

