/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sqlrunner.Main;
import sqlrunner.config.ConfigurationPanel;
import sqlrunner.config.Messages;

public class PanelConfigLineSeparator
extends JPanel
implements ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final JComboBox cbLineSeparator = new JComboBox();

    public PanelConfigLineSeparator() {
        try {
            this.initComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() throws Exception {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), Messages.getString("PanelConfigLineSeparator.bordertitle")));
        this.setMinimumSize(new Dimension(250, 60));
        this.setPreferredSize(new Dimension(250, 60));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.cbLineSeparator, gridBagConstraints);
        String currentLineSeparator = Main.getUserProperty("CURR_LINE_SEPARATOR", Main.currentLineSeparatorType);
        this.cbLineSeparator.addItem("Windows");
        this.cbLineSeparator.addItem("UNIX");
        this.cbLineSeparator.addItem("Mac OS (classic)");
        if (currentLineSeparator.equals("Windows")) {
            this.cbLineSeparator.setSelectedIndex(0);
        } else if (currentLineSeparator.equals("Mac OS (classic)")) {
            this.cbLineSeparator.setSelectedIndex(2);
        } else {
            this.cbLineSeparator.setSelectedIndex(1);
        }
    }

    @Override
    public boolean isChanged() {
        return true;
    }

    @Override
    public boolean performChanges() {
        Main.setLineSeparatorType(this.cbLineSeparator.getSelectedItem().toString());
        return true;
    }

    @Override
    public void cancel() {
    }
}

