/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sqlrunner.Main;
import sqlrunner.config.ConfigurationPanel;
import sqlrunner.config.Messages;

public class PanelConfigCharSets
extends JPanel
implements ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final JComboBox cbCharSets = new JComboBox();

    public PanelConfigCharSets() {
        try {
            this.initComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() throws Exception {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), Messages.getString("PanelConfigCharSets.bordertitle")));
        this.setMinimumSize(new Dimension(250, 60));
        this.setPreferredSize(new Dimension(250, 60));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.cbCharSets, gridBagConstraints);
        this.cbCharSets.getAccessibleContext().setAccessibleName(Messages.getString("PanelConfigCharSets.bordertitle"));
        String charSets = Main.getDefaultProperty("CHAR_SETS", "ISO-8859-1|ISO-8859-15|UTF-8|UTF-16|Cp1252|MacRoman");
        String currentCharSet = Main.getUserProperty("CURR_CHAR_SET");
        String systemCharSet = System.getProperty("file.encoding");
        StringTokenizer st = new StringTokenizer(charSets, "|");
        String charSet = null;
        while (st.hasMoreTokens()) {
            charSet = st.nextToken();
            this.cbCharSets.addItem(charSet);
            if (currentCharSet != null) {
                if (!charSet.equals(currentCharSet)) continue;
                this.cbCharSets.setSelectedItem(charSet);
                continue;
            }
            if (systemCharSet == null || !charSet.equals(systemCharSet)) continue;
            this.cbCharSets.setSelectedItem(charSet);
        }
    }

    @Override
    public boolean isChanged() {
        return true;
    }

    @Override
    public boolean performChanges() {
        Main.setFileEncoding(this.cbCharSets.getSelectedItem().toString());
        return true;
    }

    @Override
    public void cancel() {
    }
}

