/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSessionPool;
import dbtools.DatabaseType;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import sqlrunner.AdminStatement;
import sqlrunner.MacOSXAdapterInterface;
import sqlrunner.MainFrame;
import sqlrunner.datamodel.SQLField;
import sqlrunner.log4jpanel.LogPanel;
import sqlrunner.swinghelper.WindowHelper;

public final class Main {
    private static final Logger logger = Logger.getLogger(Main.class);
    static String script = null;
    static String programDirectory = null;
    static String cfgFileName = null;
    static String userCfgFileName = null;
    private static String highlighterFontCfgFileName = null;
    static String dbCfgFileName = null;
    static String adminCfgFileName = null;
    private static String sqlHistoryFileName = null;
    static String connectionListFileName = null;
    static int x = 9999;
    static int xt = 9999;
    static int y = 0;
    static int b = 0;
    static int h = 0;
    static int yt = 0;
    static int bt = 0;
    static int ht = 0;
    static boolean editorWindowParameterGiven = false;
    static boolean textWindowParameterGiven = false;
    static final int MIN_WIDTH = 800;
    static final int MIN_HEIGHT = 200;
    static final int DEF_WIDTH = 800;
    static final int DEF_HEIGHT = 600;
    static final int DEF_XLOC = 0;
    static final int DEF_YLOC = 0;
    public static String VERSION = null;
    public static final String CFG_FILE_NAME = "default.cfg";
    public static final String USER_CFG_FILE_NAME = "user.cfg";
    public static final String HIGHLIGHTER_FONT_CFG_FILE = "highlighter.cfg";
    public static final String KEYWORD_FILE = "wordfile.txt";
    public static final String DB_CFG_FILE_NAME = "dbtypes.cfg";
    public static final String DB_CFG_FILE_NAME_USER = "user_dbtypes.cfg";
    public static final String ADMIN_CFG_FILE_NAME = "dbadmin.cfg";
    static final String SQL_HISTORY_FILE = "sqlhistory.ini";
    static final String CONNECTION_LIST_FILE = "connection.lst";
    static final String LOOK_AND_FEEL_CFG_FILE = "lookandfeel.properties";
    static final String WORKING_DIR = ".sqlrunner";
    static final int MAX_FILES_ENTRIES = 10;
    static int maxFilenameLength = 0;
    private static final Properties defaultProp = new Properties();
    private static final Properties userprop = new Properties();
    public static final Properties lookAndFeels = new Properties();
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_FEED = System.getProperty("line.separator");
    public static Font textFont = null;
    public static final int CARET_BLINK_RATE = 500;
    static GregorianCalendar cal = new GregorianCalendar();
    static int heliosStatusHeight = 0;
    static String currentLookAndFeelAlias = null;
    private static final List<MainFrame> listMainFrames = new ArrayList<MainFrame>();
    static String codeBase = null;
    static String helpUrl = null;
    public static final Color info = new Color(250, 250, 220);
    private static String loginParamsAsURLElements = null;
    public static ConnectionDescription startUpCd = null;
    public static String currentCharSet = null;
    public static String currentLineSeparatorType = null;
    public static String currentLineSeparator = null;
    private static Properties log4jProperties = null;
    private static String[] commandLineArguments = null;
    private static String fileToLoad;
    private static boolean initializationFinished;
    public static final String OS_WINDOWS = "Windows";
    public static final String OS_MACOSX = "Mac OS X";
    public static final String OS_UNIX = "Unix";
    private static String osType;
    private static String customSqlTypeKeyMap;
    private static String customSqlTypeMappingEnabled;

    private static void setupCustomSqlTypeMapping() {
        boolean enabled = Boolean.parseBoolean(Main.getUserProperty(customSqlTypeMappingEnabled, "false"));
        if (enabled) {
            String map = Main.getUserProperty(customSqlTypeKeyMap, "");
            try {
                logger.info((Object)"setCustomSqlTypeMapping");
                SQLField.setCustomSqlTypeMapping(map);
                Set<Map.Entry<Integer, Integer>> set = SQLField.getCustomTypeMap();
                for (Map.Entry<Integer, Integer> entry : set) {
                    logger.info((Object)("sql type " + entry.getKey() + "->" + SQLField.getBasicTypeName(entry.getValue())));
                }
            }
            catch (Exception e) {
                logger.error((Object)("setupCustomSqlTypeMapping failed:" + e.getMessage()));
            }
        }
    }

    public static boolean startupFinished() {
        return initializationFinished;
    }

    public static void setStartupFile(String file) {
        logger.info((Object)("setStartupFile: " + file));
        fileToLoad = file;
    }

    public static String getStartupFile() {
        return fileToLoad;
    }

    public static String getCodebase() {
        return codeBase;
    }

    public static String getWorkDirectory() {
        return programDirectory;
    }

    public static String getFileNameForConnectionList() {
        return connectionListFileName;
    }

    public static String getCfgFileName() {
        return cfgFileName;
    }

    public static String getDbCfgFileName() {
        return dbCfgFileName;
    }

    public static String getAdminCfgFileName() {
        return adminCfgFileName;
    }

    static void setupProgramDirectories() {
        try {
            Main.createWorkingDir();
            programDirectory = System.getProperty("user.home") + FILE_SEPARATOR + WORKING_DIR + FILE_SEPARATOR;
        }
        catch (AccessControlException ace) {
            programDirectory = ".";
        }
        adminCfgFileName = programDirectory + ADMIN_CFG_FILE_NAME;
        cfgFileName = programDirectory + CFG_FILE_NAME;
        connectionListFileName = programDirectory + CONNECTION_LIST_FILE;
        dbCfgFileName = programDirectory + DB_CFG_FILE_NAME_USER;
        Main.setSqlHistoryFileName(programDirectory + SQL_HISTORY_FILE);
        Main.setHighlighterFontCfgFileName(programDirectory + HIGHLIGHTER_FONT_CFG_FILE);
        userCfgFileName = programDirectory + USER_CFG_FILE_NAME;
    }

    static void createWorkingDir() throws AccessControlException {
        File dir = new File(System.getProperty("user.home") + FILE_SEPARATOR + WORKING_DIR);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
            logger.error((Object)("couldn't create working directory " + dir.getAbsolutePath()));
        }
    }

    public static void setFileEncoding(String codeName) {
        currentCharSet = codeName;
        userprop.setProperty("CURR_CHAR_SET", codeName);
    }

    public static final String getFileEnoding() {
        return currentCharSet;
    }

    public static boolean isLineHighlightingEnabled() {
        return Boolean.parseBoolean(Main.getUserProperty("LINE_HIGHLIGHTING", "true"));
    }

    public static void enableLineHighlighting(boolean enable) {
        Main.setUserProperty("LINE_HIGHLIGHTING", String.valueOf(enable));
    }

    public static boolean isBracketContentHighlightingEnabled() {
        return Boolean.parseBoolean(Main.getUserProperty("BRACKET_CONTENT_HIGHLIGHTING", "false"));
    }

    public static void enableBracketContentHighlighting(boolean enable) {
        Main.setUserProperty("BRACKET_CONTENT_HIGHLIGHTING", String.valueOf(enable));
    }

    public static final void setUserProperty(String key, String value) {
        if (value != null) {
            userprop.put(key, value);
        } else {
            userprop.remove(key);
        }
    }

    public static final String getUserProperty(String key, String defaultValue) {
        return userprop.getProperty(key, defaultValue);
    }

    public static final String getUserProperty(String key) {
        return userprop.getProperty(key);
    }

    public static final String getDefaultProperty(String key, String defaultValue) {
        return userprop.getProperty(key, defaultValue);
    }

    public static final void setDefaultProperty(String key, String value) {
        if (value != null) {
            defaultProp.setProperty(key, value);
        } else {
            defaultProp.remove(key);
        }
    }

    public static final String getDefaultProperty(String key) {
        return defaultProp.getProperty(key);
    }

    public static String getCurrentLineSeparator() {
        return currentLineSeparator;
    }

    public static void setLineSeparatorType(String osName) {
        if ((osName = osName.toLowerCase().trim()).indexOf("windows") != -1) {
            currentLineSeparatorType = OS_WINDOWS;
            currentLineSeparator = "\r\n";
        } else if (osName.indexOf("mac") != -1) {
            currentLineSeparatorType = "Mac OS (classic)";
            currentLineSeparator = "\r";
        } else {
            currentLineSeparatorType = "UNIX";
            currentLineSeparator = "\n";
        }
        userprop.setProperty("CURR_LINE_SEPARATOR", currentLineSeparatorType);
    }

    static void initialize() {
        block32: {
            logger.info((Object)"start initialisation...");
            logger.info((Object)"register pool at platform JMX server...");
            try {
                DatabaseSessionPool.registerAtPlatformJMXServer();
            }
            catch (Exception e) {
                logger.warn((Object)("register failed: " + e.getMessage()), (Throwable)e);
            }
            try {
                MainFrame mainFrame;
                block31: {
                    WindowHelper.init();
                    Main.loadVersion();
                    Main.loadDefaultProperties();
                    Main.loadUserProperties();
                    Main.setupEditorFont();
                    Main.loadLookAndFeels();
                    Main.setupCustomSqlTypeMapping();
                    String osName = userprop.getProperty("CURR_LINE_SEPARATOR");
                    if (osName == null) {
                        osName = System.getProperty("os.name");
                    }
                    Main.setLineSeparatorType(osName);
                    String currentCharSet_loc = userprop.getProperty("CURR_CHAR_SET");
                    String systemCharSet = System.getProperty("file.encoding");
                    if (currentCharSet_loc != null) {
                        Main.setFileEncoding(currentCharSet_loc);
                    } else if (systemCharSet != null) {
                        Main.setFileEncoding(systemCharSet);
                    }
                    WindowHelper.enableWindowPositioning(userprop.getProperty("WM_FRAME_POSITIONING", "false").equals("false"));
                    if (!editorWindowParameterGiven) {
                        x = Integer.parseInt(userprop.getProperty("WINDOW_X_POS", "-1"));
                        y = Integer.parseInt(userprop.getProperty("WINDOW_Y_POS", "-1"));
                        h = Integer.parseInt(userprop.getProperty("WINDOW_HEIGHT", "-1"));
                        b = Integer.parseInt(userprop.getProperty("WINDOW_WIDTH", "-1"));
                        if (x == -1 || y == -1 || h == -1 || b == -1) {
                            Rectangle r = Main.createDefaultWindowParameters();
                            if (WindowHelper.isWindowPositioningEnabled()) {
                                x = r.x;
                                y = r.y;
                            } else {
                                x = 0;
                                y = 0;
                            }
                            b = r.width;
                            h = r.height;
                        }
                    }
                    if (x < 0) {
                        x = 0;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    try {
                        heliosStatusHeight = Integer.parseInt(defaultProp.getProperty("HELIOS_STATUS_HEIGHT", "30"));
                    }
                    catch (NumberFormatException nfe) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"invalid value in key HELIOS_STATUS_HEIGHT");
                        }
                        heliosStatusHeight = 30;
                    }
                    MainFrame.setFkNavigationFrameMode(Integer.parseInt(userprop.getProperty("FK_NAVIGATION_MODE", String.valueOf(2))));
                    if (defaultProp.getProperty("SYNTAX_HIGHLIGHT_ENABLED", "false").equals("true")) {
                        File f = new File(Main.getHighlighterFontCfgFileName());
                        if (!f.exists()) {
                            Main.createDefaultHLCfgFile();
                        }
                    } else {
                        userprop.setProperty("SYNTAX_HIGHLIGHT", "false");
                    }
                    logger.info((Object)"Start GUI...");
                    mainFrame = Main.createInstance(null);
                    currentLookAndFeelAlias = userprop.getProperty("LOOK&FEEL", "System");
                    Main.setLookAndFeel(currentLookAndFeelAlias);
                    File fdbc = new File(dbCfgFileName);
                    if (!fdbc.exists()) {
                        Main.createDefaultDbCfgFile();
                    }
                    Main.setDefaultDatabaseTypes();
                    Main.setUserDatabaseTypes(fdbc);
                    File fac = new File(adminCfgFileName);
                    if (!fac.exists()) {
                        Main.createDefaultAdminCfgFile();
                    }
                    AdminStatement.readAdminSQLs(fac);
                    try {
                        BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                        helpUrl = codeBase = bs.getCodeBase().toExternalForm();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("running as web-start application: use " + codeBase + " for codebase"));
                        }
                    }
                    catch (UnavailableServiceException use) {
                        codeBase = System.getProperty("user.dir");
                        helpUrl = "file://" + codeBase;
                        if (!logger.isDebugEnabled()) break block31;
                        logger.debug((Object)("running as standalone application: use " + codeBase + " for codebase"));
                    }
                }
                if (loginParamsAsURLElements != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"login at start...");
                    }
                    mainFrame.openLoginDialog(new ConnectionDescription(loginParamsAsURLElements));
                } else if (startUpCd != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"login at start...");
                    }
                    mainFrame.startConnect(startUpCd);
                }
                if (fileToLoad != null) {
                    mainFrame.handleFile(fileToLoad);
                    fileToLoad = null;
                }
            }
            catch (AccessControlException ae) {
                if (!logger.isDebugEnabled()) break block32;
                logger.debug((Object)("running in sandbox: " + ae.getMessage()));
            }
        }
        logger.info((Object)"initializing complete.");
        initializationFinished = true;
    }

    public static long getLastModified(File file) {
        return Main.getLastModified(file.getAbsolutePath());
    }

    public static long getLastModified(String file) {
        File f = new File(file);
        if (f.exists()) {
            return f.lastModified();
        }
        return 0L;
    }

    public static void setLookAndFeel(String alias) {
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("sun.awt.noerasebackground", "true");
        System.setProperty("apple.awt.window.position.forceSaveCreation", "true");
        System.setProperty("apple.awt.window.position.forceSaveProgrammaticPositioning", "true");
        System.setProperty("apple.awt.window.position.forceSaveUserPositioning", "true");
        String className = lookAndFeels.getProperty(alias, UIManager.getSystemLookAndFeelClassName());
        try {
            MainFrame frame;
            UIManager.put("JFileChooser.packageIsTraversable", "nerver");
            UIManager.setLookAndFeel(className);
            currentLookAndFeelAlias = alias;
            userprop.setProperty("LOOK&FEEL", alias);
            for (int i = 0; i < listMainFrames.size(); ++i) {
                frame = listMainFrames.get(i);
                frame.updateUI();
            }
            frame = null;
            if (MainFrame.sqlHistory != null) {
                SwingUtilities.updateComponentTreeUI(MainFrame.sqlHistory);
            }
            if (MainFrame.dmFrame != null) {
                SwingUtilities.updateComponentTreeUI(MainFrame.dmFrame);
            }
            SwingUtilities.updateComponentTreeUI(LogPanel.getInstance());
        }
        catch (Throwable e) {
            logger.warn((Object)("setLookAndFeel: error in initialization UIManager:" + e.toString()));
        }
    }

    public static String getCurrentLookAndFeelAlias() {
        return currentLookAndFeelAlias;
    }

    private static void setDefaultDatabaseTypes() {
        BufferedReader br = Main.getTextResource(DB_CFG_FILE_NAME);
        try {
            String paramStr;
            while ((paramStr = br.readLine()) != null) {
                if ((paramStr = paramStr.trim()).startsWith("#") || paramStr.length() <= 8) continue;
                ConnectionDescription.getDBTypes().add(new DatabaseType(paramStr));
            }
            br.close();
        }
        catch (IOException ioe) {
            logger.warn((Object)("setDefaultDatabaseTypes:" + ioe.toString() + " exception: " + ioe));
        }
    }

    private static synchronized void setUserDatabaseTypes(File f) {
        try {
            String paramStr;
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((paramStr = br.readLine()) != null) {
                if ((paramStr = paramStr.trim()).startsWith("#") || paramStr.length() <= 8) continue;
                DatabaseType dbType = new DatabaseType(paramStr);
                if (!Main.alreadyExists(dbType)) {
                    ConnectionDescription.getDBTypes().add(dbType);
                    continue;
                }
                logger.warn((Object)("user-db-type ignored: id=" + String.valueOf(dbType.getId()) + " is already used by default-type! -  : exception: " + null));
            }
            br.close();
        }
        catch (IOException ioe) {
            logger.warn((Object)("setUserDatabaseTypes:" + ioe.toString() + " exception: " + ioe));
        }
    }

    private static boolean alreadyExists(DatabaseType testType) {
        boolean exists = false;
        for (int i = 0; i < ConnectionDescription.getDBTypes().size(); ++i) {
            if (testType.getId() != ConnectionDescription.getDBTypes().get(i).getId()) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public static MainFrame findMainFrameByFile(File f) {
        MainFrame mfWithSameFile = null;
        for (MainFrame mf : listMainFrames) {
            if (mf.getCurrentFile() == null || !mf.getCurrentFile().equals(f)) continue;
            mfWithSameFile = mf;
            break;
        }
        return mfWithSameFile;
    }

    public static synchronized MainFrame createInstance(MainFrame currentFrame) {
        if (currentFrame != null) {
            x = currentFrame.getLocation().x;
            y = currentFrame.getLocation().y + 20;
            b = currentFrame.getWidth();
            h = currentFrame.getHeight();
            Main.refreshUserProperties(currentFrame);
        }
        final MainFrame mainFrame = new MainFrame(x, y, b, h);
        if (currentFrame == null) {
            if (script != null && script.trim().length() > 0) {
                mainFrame.handleFile(script);
            }
        } else if (currentFrame.getDatabase() != null && currentFrame.isConnected()) {
            mainFrame.startConnect(currentFrame.getDatabase().getDatabaseSession().getConnectionDescription());
        }
        if (SwingUtilities.isEventDispatchThread()) {
            mainFrame.validate();
            mainFrame.setVisible(true);
            mainFrame.toFront();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mainFrame.validate();
                    mainFrame.setVisible(true);
                    mainFrame.toFront();
                }
            });
        }
        listMainFrames.add(mainFrame);
        return mainFrame;
    }

    public static MainFrame getFrameForFKNavigation(MainFrame lastFrame) {
        MainFrame frame = null;
        boolean foundUsefulFrame = false;
        for (int i = 0; i < listMainFrames.size(); ++i) {
            frame = listMainFrames.get(i);
            if (!frame.isUsedForFKNavigation()) continue;
            foundUsefulFrame = true;
            break;
        }
        if (!foundUsefulFrame) {
            frame = Main.createInstance(lastFrame);
            frame.setUseForFKNavigation(true);
        }
        return frame;
    }

    public static void removeInstance(MainFrame mainFrame) {
        listMainFrames.remove(mainFrame);
    }

    public static void refreshUserProperties(MainFrame mainFrame) {
        userprop.setProperty("WINDOW_X_POS", String.valueOf(mainFrame.getLocation().x));
        userprop.setProperty("WINDOW_Y_POS", String.valueOf(mainFrame.getLocation().y));
        userprop.setProperty("WINDOW_HEIGHT", String.valueOf(mainFrame.getSize().height));
        userprop.setProperty("WINDOW_WIDTH", String.valueOf(mainFrame.getSize().width));
        userprop.setProperty("DIVIDER_LOCATION", String.valueOf(mainFrame.getDividerLocation()));
        userprop.setProperty("DATE_FORMAT", MainFrame.getDateFormatMask());
        if (MainFrame.dmFrame != null) {
            userprop.setProperty("DM_FRAME_SCRIPT_OVERWRITE", String.valueOf(MainFrame.dmFrame.isScriptOverwriteSelected()));
            userprop.setProperty("DM_FRAME_NEW_FRAME", String.valueOf(MainFrame.dmFrame.isSelectInNewFrameSelected()));
            userprop.setProperty("FULL_QUALIFIED_NAME", String.valueOf(MainFrame.dmFrame.isFullQualifiedNameSelected()));
            userprop.setProperty("DM_FRAME_START_IMMEDIATELY", String.valueOf(MainFrame.dmFrame.isStartImmediatelySelected()));
        }
        if (MainFrame.sqlHistory != null) {
            userprop.setProperty("HISTORY_NO_DOUBLE", String.valueOf(MainFrame.sqlHistory.isNoDoublesAllowed()));
            userprop.setProperty("HISTORY_FREESE", String.valueOf(MainFrame.sqlHistory.isFreesed()));
            userprop.setProperty("HISTORY_SCRIPT_WITH_COMMENTS", String.valueOf(MainFrame.sqlHistory.isCommentsInHistoryScriptEnabled()));
            userprop.setProperty("HISTORY_RUN_IMMIDATELY", String.valueOf(MainFrame.sqlHistory.isRunImmidatlyEnabled()));
        }
    }

    public static void close(MainFrame mainFrame) {
        listMainFrames.remove(mainFrame);
        if (listMainFrames.isEmpty()) {
            Main.refreshUserProperties(mainFrame);
            Main.saveUserProp();
            if (MainFrame.dmFrame != null) {
                MainFrame.dmFrame.dispose();
            }
            if (MainFrame.sqlHistory != null) {
                MainFrame.sqlHistory.saveList();
                MainFrame.sqlHistory.dispose();
            }
            mainFrame.dispose();
            mainFrame = null;
            logger.info((Object)"program finished.");
            System.exit(0);
        } else {
            mainFrame.dispose();
            mainFrame = listMainFrames.get(listMainFrames.size() - 1);
            mainFrame.toFront();
        }
    }

    public static List<MainFrame> getWindowList() {
        return listMainFrames;
    }

    public static void closeAllOther(MainFrame mainFrame) {
        int answer = 0;
        Object[] frames = listMainFrames.toArray();
        for (int i = 0; i < frames.length; ++i) {
            MainFrame frame = (MainFrame)frames[i];
            if (frame == mainFrame) continue;
            if (answer == 2) {
                frame.closeWithoutQuestion();
                continue;
            }
            if (!frame.close()) break;
            frame.dispose();
        }
    }

    public static void shutdown() {
        int answer = 0;
        Object[] frames = listMainFrames.toArray();
        for (int i = 0; i < frames.length; ++i) {
            MainFrame frame = (MainFrame)frames[i];
            if (answer == 2) {
                frame.closeWithoutQuestion();
                continue;
            }
            if (!frame.close()) break;
            frame.dispose();
        }
        DatabaseSessionPool.close();
    }

    public static boolean canShutdown() {
        for (MainFrame mf : listMainFrames) {
            if (!mf.isCloseActionDisabled()) continue;
            return false;
        }
        return true;
    }

    public static void arrangeWindowsHorizontal() {
        WindowHelper.arrangeWindowsHorizontal(listMainFrames);
    }

    public static void arrangeWindowsVertical() {
        WindowHelper.arrangeWindowsVertical(listMainFrames);
    }

    public static void arrangeWindowsOverlapped(MainFrame frame) {
        WindowHelper.arrangeWindowsOverlapped(listMainFrames, frame, 800, 600);
    }

    public static void panic(String message) {
        logger.fatal((Object)("panic: " + message));
        JOptionPane.showConfirmDialog(null, message + "\nprogram will be terminated!", "Program error ...", -1, 0);
        System.exit(1);
    }

    static void printUsage() {
        System.out.println("call: java -jar sql.jar [<SQL-Script>] [options] \n\noptions:\n  -h shows this help.\n     program will be finished.\n  -d switch on debug modus\n     -w<left-top-x>,<left-top-y>,<width>,<height>\n  -l<encrypted login-parameter> connect immediately \n  -i create new default configuration");
    }

    static void loadDefaultProperties() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"load defaults...");
            }
            try {
                FileInputStream inifileIn = new FileInputStream(cfgFileName);
                defaultProp.load(inifileIn);
                ((InputStream)inifileIn).close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"...loaded from user.home");
                }
            }
            catch (AccessControlException ae) {
                Main dummy = new Main();
                InputStream is = dummy.getClass().getResourceAsStream("/default.cfg");
                defaultProp.load(is);
                is.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"...loaded from archive");
                }
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadProperties: failed\ndefault configuration " + cfgFileName + " will be created"));
            }
            Main.createDefaultProp();
        }
    }

    public static void loadLookAndFeels() {
        Main dummy = new Main();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"load look and feels from archive");
            }
            InputStream is = dummy.getClass().getResourceAsStream("/lookandfeel.properties");
            lookAndFeels.load(is);
            is.close();
            lookAndFeels.setProperty("metal", UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            logger.warn((Object)("exception: " + e));
        }
    }

    private static void loadVersion() {
        try {
            Main dummy = new Main();
            InputStreamReader reader = new InputStreamReader(dummy.getClass().getResourceAsStream("/VERSION"));
            char[] buffer = new char[64];
            int len = reader.read(buffer);
            VERSION = new String(buffer, 0, len);
            reader.close();
        }
        catch (IOException e) {
            logger.error((Object)("loadVersion failed: " + e.getMessage()), (Throwable)e);
        }
    }

    static void loadUserProperties() {
        try {
            FileInputStream inifileIn = new FileInputStream(userCfgFileName);
            userprop.load(inifileIn);
            inifileIn.close();
            boolean debug = Boolean.valueOf(userprop.getProperty("DEBUG", "false"));
            Main.setDebug(debug);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadUserProperties: failed\ndefault configuration " + userCfgFileName + " will be created"));
            }
            Main.createDefaultUserProp();
        }
    }

    static void saveUserProp() {
        block3: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("save user properties in file " + userCfgFileName));
            }
            try {
                FileOutputStream inifileOut = new FileOutputStream(userCfgFileName);
                userprop.store(inifileOut, "SQLRunner user-config");
                inifileOut.close();
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("saveUserProp: write in file failed:" + userCfgFileName));
            }
        }
    }

    static boolean extractFileFromArchive(String zippedFileName, String outFileName) {
        Main dummy = new Main();
        boolean ok = true;
        try {
            int c;
            InputStream in = dummy.getClass().getResourceAsStream("/" + zippedFileName);
            FileOutputStream out = new FileOutputStream(outFileName);
            byte[] b_loc = new byte[4096];
            while ((c = in.read(b_loc)) != -1) {
                out.write(b_loc, 0, c);
            }
            in.close();
            out.close();
        }
        catch (NullPointerException npe) {
            ok = false;
            logger.warn((Object)("extractFileFromArchive: extraction failed\n   entry:      " + zippedFileName + "\n   File: " + outFileName));
        }
        catch (IOException ioe) {
            ok = false;
            logger.warn((Object)("extractFileFromArchive: extraction failed\n   entry:      " + zippedFileName + "\n   File: " + outFileName));
        }
        return ok;
    }

    public static BufferedReader getTextResource(String fileName) {
        Main dummy = new Main();
        try {
            return new BufferedReader(new InputStreamReader(dummy.getClass().getResourceAsStream("/" + fileName)));
        }
        catch (Exception e) {
            logger.warn((Object)("getTextResource(" + fileName + ") failed: " + e.toString()), (Throwable)e);
            return null;
        }
    }

    public static void createDefaultProp() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("erzeuge neue Standardkonfiguration: " + cfgFileName));
        }
        if (!Main.extractFileFromArchive(CFG_FILE_NAME, cfgFileName)) {
            Main.panic("Fehler beim Zugriff auf die Standardkonfiguration");
        }
        try {
            FileInputStream inifileIn = new FileInputStream(cfgFileName);
            defaultProp.load(inifileIn);
            inifileIn.close();
        }
        catch (Exception e) {
            logger.warn((Object)"createDefaultProp: read default configuration failed");
            Main.panic("error reading default configuration");
        }
    }

    public static void createDefaultDbCfgFile() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("create default database types: " + dbCfgFileName));
        }
        Main.extractFileFromArchive(DB_CFG_FILE_NAME_USER, dbCfgFileName);
    }

    public static void createDefaultAdminCfgFile() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("create default admin configuration: " + adminCfgFileName));
        }
        Main.extractFileFromArchive(ADMIN_CFG_FILE_NAME, adminCfgFileName);
    }

    public static void createDefaultHLCfgFile() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("create default higlighter configuration: " + Main.getHighlighterFontCfgFileName()));
        }
        Main.extractFileFromArchive(HIGHLIGHTER_FONT_CFG_FILE, Main.getHighlighterFontCfgFileName());
    }

    public static void createDefaultUserProp() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("erzeuge neue User-Standardkonfiguration: " + userCfgFileName));
        }
        userprop.setProperty("SYNTAX_HIGHLIGHT", "true");
        Main.saveUserProp();
    }

    public static String getName(File f) {
        String name = f.getPath();
        int beginOfName = name.lastIndexOf("/");
        beginOfName = beginOfName == -1 ? ((beginOfName = name.lastIndexOf("\\")) == -1 ? 0 : ++beginOfName) : ++beginOfName;
        name = f.getPath().substring(beginOfName, f.getPath().length());
        return name;
    }

    public static void setHighlighterFontCfgFileName(String highlighterFontCfgFileName) {
        Main.highlighterFontCfgFileName = highlighterFontCfgFileName;
    }

    public static String getHighlighterFontCfgFileName() {
        return highlighterFontCfgFileName;
    }

    public static void setSqlHistoryFileName(String sqlHistoryFileName) {
        Main.sqlHistoryFileName = sqlHistoryFileName;
    }

    public static String getSqlHistoryFileName() {
        return sqlHistoryFileName;
    }

    public static void removeAllFileProps() {
        int max = Integer.parseInt(defaultProp.getProperty("MAX_FILES_ENTRIES", "4"));
        for (int i = 0; i < max; ++i) {
            userprop.remove("FILE_" + i);
        }
        Main.refreshReopenItems();
    }

    static void refreshReopenItems() {
        for (MainFrame mainFrame : listMainFrames) {
            mainFrame.createReopenItems();
            mainFrame.validate();
        }
    }

    public static void addFileProp(File file) {
        int i;
        int i2;
        String filepath = file.getAbsolutePath();
        int max = Integer.parseInt(defaultProp.getProperty("MAX_FILES_ENTRIES", "4"));
        String[][] filePropArray = new String[max][2];
        for (i2 = 0; i2 < max; ++i2) {
            filePropArray[i2][0] = "FILE_" + i2;
            filePropArray[i2][1] = userprop.getProperty("FILE_" + i2);
        }
        for (i2 = 0; i2 < max; ++i2) {
            userprop.remove("FILE_" + i2);
        }
        for (i = 0; i < max; ++i) {
            String fileName = filePropArray[i][1];
            if (fileName != null && fileName.length() > 0) {
                if (fileName.equals(filepath)) {
                    filePropArray[i][0] = "";
                    filePropArray[i][1] = "";
                }
                for (int y_loc = i + 1; y_loc < max; ++y_loc) {
                    if (!fileName.equals(filePropArray[y_loc][1])) continue;
                    filePropArray[y_loc][0] = "";
                    filePropArray[y_loc][1] = "";
                }
                continue;
            }
            filePropArray[i][0] = "";
            filePropArray[i][1] = "";
        }
        block4: for (i = 0; i < max; ++i) {
            if (filePropArray[i][1].length() != 0) continue;
            for (int n = i + 1; n < max; ++n) {
                if (filePropArray[n][1].length() <= 0) continue;
                filePropArray[i][0] = filePropArray[n][0];
                filePropArray[i][1] = filePropArray[n][1];
                filePropArray[n][0] = "";
                filePropArray[n][1] = "";
                continue block4;
            }
        }
        for (i = max - 1; i > 0; --i) {
            if (filePropArray[i - 1][1].length() <= 0) continue;
            userprop.setProperty("FILE_" + i, filePropArray[i - 1][1]);
        }
        userprop.setProperty("FILE_0", filepath);
        Main.refreshReopenItems();
    }

    public static final void setDebug(boolean debug) {
        if (debug) {
            logger.info((Object)"set debug on");
            userprop.setProperty("DEBUG", "true");
            Logger rootLogger = Logger.getRootLogger();
            rootLogger.setLevel(Level.DEBUG);
        } else {
            logger.info((Object)"set debug off");
            userprop.setProperty("DEBUG", "false");
            Logger rootLogger = Logger.getRootLogger();
            rootLogger.setLevel(Level.INFO);
        }
    }

    static void setupLog4j() {
        System.out.println("setup log4j...");
        InputStream inifileIn = Main.class.getResourceAsStream("/log4j.properties");
        if (inifileIn != null) {
            try {
                log4jProperties = new Properties();
                log4jProperties.load(inifileIn);
                inifileIn.close();
                PropertyConfigurator.configure((Properties)log4jProperties);
                logger.info((Object)"log4j successful initiated");
            }
            catch (IOException ioe) {
                BasicConfigurator.configure();
                logger.error((Object)("setupLog4j load from resource failed:" + ioe.getMessage()), (Throwable)ioe);
            }
        } else {
            BasicConfigurator.configure();
            logger.info((Object)"setupLog4j: no log4j.properties found, use basic configuration");
        }
        logger.info((Object)" ready.");
        Logger.getRootLogger().addAppender(LogPanel.getInstance().getAppender());
    }

    public static final boolean isDebug() {
        Logger rootLogger = Logger.getRootLogger();
        return rootLogger.isDebugEnabled();
    }

    static void setupEditorFont() {
        try {
            int fontSize = Integer.parseInt(userprop.getProperty("EDITOR_FONT_SIZE", "12"));
            if (fontSize == 0) {
                fontSize = Integer.parseInt(defaultProp.getProperty("EDITOR_FONT_SIZE", "12"));
            }
            String fontFamily = userprop.getProperty("EDITOR_FONT_FAMILY", "Monospaced");
            textFont = new Font(fontFamily, 0, fontSize);
        }
        catch (NumberFormatException e) {
            logger.warn((Object)"defineFonts: invalid values", (Throwable)e);
        }
    }

    public static void redefineEditorFont() {
        Main.setupEditorFont();
        for (MainFrame mainFrame : listMainFrames) {
            mainFrame.setupEditorFont();
        }
    }

    public static void disconnect() {
        for (MainFrame mainFrame : listMainFrames) {
            mainFrame.startDisconnect();
        }
    }

    static Rectangle createDefaultWindowParameters() {
        Rectangle r = new Rectangle();
        try {
            r.x = Integer.parseInt(defaultProp.getProperty("DEF_XLOC"));
            r.y = Integer.parseInt(defaultProp.getProperty("DEF_YLOC"));
            r.width = Integer.parseInt(defaultProp.getProperty("DEF_WIDTH"));
            r.height = Integer.parseInt(defaultProp.getProperty("DEF_HEIGHT"));
        }
        catch (NumberFormatException e) {
            r.x = 0;
            r.y = 0;
            r.width = 800;
            r.height = 600;
            logger.warn((Object)("createDefaultWindowParameters: invalid or missing values: " + e.getMessage() + "\n   for keys DEF_XLOC ... DEF_HEIGHT in " + cfgFileName + "\n   use internal default values."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setDefaultWindowParameters: set default values: x=" + r.x + " ,y=" + r.y + " ,b=" + r.width + " ,h=" + r.height));
        }
        return r;
    }

    static Rectangle parseWindowParameters(String p) {
        Rectangle r = new Rectangle();
        try {
            int i1 = p.indexOf(44);
            r.x = Integer.parseInt(p.substring(0, i1));
            int i2 = p.indexOf(44, i1 + 1);
            r.y = Integer.parseInt(p.substring(i1 + 1, i2));
            int i3 = p.indexOf(44, i2 + 1);
            r.width = Integer.parseInt(p.substring(i2 + 1, i3));
            r.height = Integer.parseInt(p.substring(i3 + 1, p.length()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseWindowParameters: set window parameters: " + r.x + " ," + r.y + " ," + r.width + " ," + r.height));
            }
        }
        catch (NumberFormatException e) {
            logger.warn((Object)("parseWindowParameters: invalid values in window parameters: " + p + "\n set default values."));
            r = Main.createDefaultWindowParameters();
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.warn((Object)("parseWindowParameters: not enough or invalid values: " + p + "\n set internal default values"));
            r = Main.createDefaultWindowParameters();
        }
        return r;
    }

    public static int countCommandLineArgs() {
        if (commandLineArguments != null) {
            return commandLineArguments.length;
        }
        return 0;
    }

    public static String getCommandLineArguments() {
        if (commandLineArguments != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < commandLineArguments.length; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(commandLineArguments[i]);
            }
            return sb.toString();
        }
        return "";
    }

    public static String getCommandLineArgument(int index) {
        if (commandLineArguments == null) {
            throw new IllegalStateException("no command line args exists");
        }
        if (index > commandLineArguments.length - 1) {
            throw new IllegalArgumentException("index out of args array bounds");
        }
        return commandLineArguments[index];
    }

    public static MainFrame getActiveMainFrame() {
        MainFrame mf = null;
        for (int i = 0; i < listMainFrames.size() && !(mf = listMainFrames.get(i)).isActive(); ++i) {
            mf = null;
        }
        if (mf == null && listMainFrames.size() > 0) {
            mf = listMainFrames.get(0);
        }
        return mf;
    }

    private static void setupMacOSXApplicationListener() {
        try {
            MacOSXAdapterInterface adapter = (MacOSXAdapterInterface)Class.forName("sqlrunner.MacOSXAdapter").newInstance();
            adapter.setup();
        }
        catch (Exception e) {
            logger.error((Object)("Instantiation of MacOS X adapter failed: " + e.getMessage()), (Throwable)e);
        }
    }

    public static final boolean isMacOsX() {
        return osType.equals(OS_MACOSX);
    }

    public static void main(String[] args) {
        commandLineArguments = args;
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        String osname = System.getProperty("os.name");
        if (osname != null) {
            if (osname.toLowerCase().indexOf("mac") != -1) {
                osType = OS_MACOSX;
                Main.setupMacOSXApplicationListener();
            } else {
                osType = osname.toLowerCase().indexOf("win") != -1 ? OS_WINDOWS : OS_UNIX;
            }
        }
        logger.info((Object)"SQLRunner Application");
        Main.setupProgramDirectories();
        Main.setupLog4j();
        boolean openOption = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-open")) {
                openOption = true;
                continue;
            }
            if (openOption) {
                fileToLoad = args[i];
                continue;
            }
            if (args[i].charAt(0) == '-') {
                switch (args[i].charAt(1)) {
                    case '?': 
                    case 'h': {
                        Main.printUsage();
                        System.exit(0);
                        break;
                    }
                    case 'w': {
                        Rectangle r = Main.parseWindowParameters(args[i].substring(2, args[i].length()));
                        x = r.x;
                        y = r.y;
                        b = r.width;
                        h = r.height;
                        editorWindowParameterGiven = true;
                        break;
                    }
                    case 'i': {
                        Main.createDefaultProp();
                        Main.createDefaultHLCfgFile();
                        Main.createDefaultUserProp();
                        Main.createDefaultDbCfgFile();
                        Main.createDefaultAdminCfgFile();
                        break;
                    }
                    case 'd': {
                        Logger.getRootLogger().setLevel(Level.DEBUG);
                        break;
                    }
                    case 'l': {
                        loginParamsAsURLElements = args[i].substring(2, args[i].length());
                        break;
                    }
                    default: {
                        logger.warn((Object)("unknown option: " + args[i]));
                        Main.printUsage();
                        break;
                    }
                }
                continue;
            }
            if (script == null) {
                script = args[i];
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("unknown parameter: " + args[i]));
            }
            Main.printUsage();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.initialize();
            }
        });
    }

    static {
        initializationFinished = false;
        osType = null;
        customSqlTypeKeyMap = "customSqlTypeMap";
        customSqlTypeMappingEnabled = "customSqlTypeEnabled";
    }
}

